/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.jfree.chart.util.ParamChecks;

public class CompassFormat
extends NumberFormat {
    public final String[] directions;

    public CompassFormat() {
        this("N", "E", "S", "W");
    }

    public CompassFormat(String string, String string2, String string3, String string4) {
        this(new String[]{string, string + string + string2, string + string2, string2 + string + string2, string2, string2 + string3 + string2, string3 + string2, string3 + string3 + string2, string3, string3 + string3 + string4, string3 + string4, string4 + string3 + string4, string4, string4 + string + string4, string + string4, string + string + string4});
    }

    public CompassFormat(String[] stringArray) {
        ParamChecks.nullNotPermitted(stringArray, "directions");
        if (stringArray.length != 16) {
            throw new IllegalArgumentException("The 'directions' array must contain exactly 16 elements");
        }
        this.directions = stringArray;
    }

    public String getDirectionCode(double d2) {
        if ((d2 %= 360.0) < 0.0) {
            d2 += 360.0;
        }
        int n2 = ((int)Math.floor(d2 / 11.25) + 1) / 2;
        return this.directions[n2];
    }

    @Override
    public StringBuffer format(double d2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return stringBuffer.append(this.getDirectionCode(d2));
    }

    @Override
    public StringBuffer format(long l2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return stringBuffer.append(this.getDirectionCode(l2));
    }

    @Override
    public Number parse(String string, ParsePosition parsePosition) {
        return null;
    }
}

