/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import org.jfree.chart.util.ParamChecks;

public final class AxisLocation
implements Serializable {
    private static final long serialVersionUID = -3276922179323563410L;
    public static final AxisLocation TOP_OR_LEFT = new AxisLocation("AxisLocation.TOP_OR_LEFT");
    public static final AxisLocation TOP_OR_RIGHT = new AxisLocation("AxisLocation.TOP_OR_RIGHT");
    public static final AxisLocation BOTTOM_OR_LEFT = new AxisLocation("AxisLocation.BOTTOM_OR_LEFT");
    public static final AxisLocation BOTTOM_OR_RIGHT = new AxisLocation("AxisLocation.BOTTOM_OR_RIGHT");
    private String name;

    private AxisLocation(String string) {
        this.name = string;
    }

    public AxisLocation getOpposite() {
        return AxisLocation.getOpposite(this);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AxisLocation)) {
            return false;
        }
        AxisLocation axisLocation = (AxisLocation)object;
        return this.name.equals(axisLocation.toString());
    }

    public int hashCode() {
        int n2 = 5;
        n2 = 83 * n2 + this.name.hashCode();
        return n2;
    }

    public static AxisLocation getOpposite(AxisLocation axisLocation) {
        ParamChecks.nullNotPermitted(axisLocation, "location");
        AxisLocation axisLocation2 = null;
        if (axisLocation == TOP_OR_LEFT) {
            axisLocation2 = BOTTOM_OR_RIGHT;
        } else if (axisLocation == TOP_OR_RIGHT) {
            axisLocation2 = BOTTOM_OR_LEFT;
        } else if (axisLocation == BOTTOM_OR_LEFT) {
            axisLocation2 = TOP_OR_RIGHT;
        } else if (axisLocation == BOTTOM_OR_RIGHT) {
            axisLocation2 = TOP_OR_LEFT;
        } else {
            throw new IllegalStateException("AxisLocation not recognised.");
        }
        return axisLocation2;
    }

    private Object readResolve() {
        if (this.equals(TOP_OR_RIGHT)) {
            return TOP_OR_RIGHT;
        }
        if (this.equals(BOTTOM_OR_RIGHT)) {
            return BOTTOM_OR_RIGHT;
        }
        if (this.equals(TOP_OR_LEFT)) {
            return TOP_OR_LEFT;
        }
        if (this.equals(BOTTOM_OR_LEFT)) {
            return BOTTOM_OR_LEFT;
        }
        return null;
    }
}

