/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.AttributedString;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jfree.chart.axis.AxisLabelLocation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.entity.AxisEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.util.AttrStringUtils;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.AttributedStringUtilities;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;

public abstract class Axis
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7719289504573298271L;
    public static final boolean DEFAULT_AXIS_VISIBLE = true;
    public static final Font DEFAULT_AXIS_LABEL_FONT = new Font("SansSerif", 0, 12);
    public static final Paint DEFAULT_AXIS_LABEL_PAINT = Color.black;
    public static final RectangleInsets DEFAULT_AXIS_LABEL_INSETS = new RectangleInsets(3.0, 3.0, 3.0, 3.0);
    public static final Paint DEFAULT_AXIS_LINE_PAINT = Color.gray;
    public static final Stroke DEFAULT_AXIS_LINE_STROKE = new BasicStroke(0.5f);
    public static final boolean DEFAULT_TICK_LABELS_VISIBLE = true;
    public static final Font DEFAULT_TICK_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_TICK_LABEL_PAINT = Color.black;
    public static final RectangleInsets DEFAULT_TICK_LABEL_INSETS = new RectangleInsets(2.0, 4.0, 2.0, 4.0);
    public static final boolean DEFAULT_TICK_MARKS_VISIBLE = true;
    public static final Stroke DEFAULT_TICK_MARK_STROKE = new BasicStroke(0.5f);
    public static final Paint DEFAULT_TICK_MARK_PAINT = Color.gray;
    public static final float DEFAULT_TICK_MARK_INSIDE_LENGTH = 0.0f;
    public static final float DEFAULT_TICK_MARK_OUTSIDE_LENGTH = 2.0f;
    private boolean visible;
    private String label;
    private transient AttributedString attributedLabel;
    private Font labelFont;
    private transient Paint labelPaint;
    private RectangleInsets labelInsets;
    private double labelAngle;
    private AxisLabelLocation labelLocation;
    private boolean axisLineVisible;
    private transient Stroke axisLineStroke;
    private transient Paint axisLinePaint;
    private boolean tickLabelsVisible;
    private Font tickLabelFont;
    private transient Paint tickLabelPaint;
    private RectangleInsets tickLabelInsets;
    private boolean tickMarksVisible;
    private float tickMarkInsideLength;
    private float tickMarkOutsideLength;
    private boolean minorTickMarksVisible;
    private float minorTickMarkInsideLength;
    private float minorTickMarkOutsideLength;
    private transient Stroke tickMarkStroke;
    private transient Paint tickMarkPaint;
    private double fixedDimension;
    private transient Plot plot;
    private transient EventListenerList listenerList;

    protected Axis(String string) {
        this.label = string;
        this.visible = true;
        this.labelFont = DEFAULT_AXIS_LABEL_FONT;
        this.labelPaint = DEFAULT_AXIS_LABEL_PAINT;
        this.labelInsets = DEFAULT_AXIS_LABEL_INSETS;
        this.labelAngle = 0.0;
        this.labelLocation = AxisLabelLocation.MIDDLE;
        this.axisLineVisible = true;
        this.axisLinePaint = DEFAULT_AXIS_LINE_PAINT;
        this.axisLineStroke = DEFAULT_AXIS_LINE_STROKE;
        this.tickLabelsVisible = true;
        this.tickLabelFont = DEFAULT_TICK_LABEL_FONT;
        this.tickLabelPaint = DEFAULT_TICK_LABEL_PAINT;
        this.tickLabelInsets = DEFAULT_TICK_LABEL_INSETS;
        this.tickMarksVisible = true;
        this.tickMarkStroke = DEFAULT_TICK_MARK_STROKE;
        this.tickMarkPaint = DEFAULT_TICK_MARK_PAINT;
        this.tickMarkInsideLength = 0.0f;
        this.tickMarkOutsideLength = 2.0f;
        this.minorTickMarksVisible = false;
        this.minorTickMarkInsideLength = 0.0f;
        this.minorTickMarkOutsideLength = 2.0f;
        this.plot = null;
        this.listenerList = new EventListenerList();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl2) {
        if (bl2 != this.visible) {
            this.visible = bl2;
            this.fireChangeEvent();
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
        this.fireChangeEvent();
    }

    public AttributedString getAttributedLabel() {
        if (this.attributedLabel != null) {
            return new AttributedString(this.attributedLabel.getIterator());
        }
        return null;
    }

    public void setAttributedLabel(String string) {
        this.setAttributedLabel(this.createAttributedLabel(string));
    }

    public void setAttributedLabel(AttributedString attributedString) {
        this.attributedLabel = attributedString != null ? new AttributedString(attributedString.getIterator()) : null;
        this.fireChangeEvent();
    }

    public AttributedString createAttributedLabel(String string) {
        if (string == null) {
            return null;
        }
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttributes(this.labelFont.getAttributes(), 0, string.length());
        return attributedString;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        if (!this.labelFont.equals(font)) {
            this.labelFont = font;
            this.fireChangeEvent();
        }
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.labelPaint = paint;
        this.fireChangeEvent();
    }

    public RectangleInsets getLabelInsets() {
        return this.labelInsets;
    }

    public void setLabelInsets(RectangleInsets rectangleInsets) {
        this.setLabelInsets(rectangleInsets, true);
    }

    public void setLabelInsets(RectangleInsets rectangleInsets, boolean bl2) {
        ParamChecks.nullNotPermitted(rectangleInsets, "insets");
        if (!rectangleInsets.equals(this.labelInsets)) {
            this.labelInsets = rectangleInsets;
            if (bl2) {
                this.fireChangeEvent();
            }
        }
    }

    public double getLabelAngle() {
        return this.labelAngle;
    }

    public void setLabelAngle(double d2) {
        this.labelAngle = d2;
        this.fireChangeEvent();
    }

    public AxisLabelLocation getLabelLocation() {
        return this.labelLocation;
    }

    public void setLabelLocation(AxisLabelLocation axisLabelLocation) {
        ParamChecks.nullNotPermitted(axisLabelLocation, "location");
        this.labelLocation = axisLabelLocation;
        this.fireChangeEvent();
    }

    public boolean isAxisLineVisible() {
        return this.axisLineVisible;
    }

    public void setAxisLineVisible(boolean bl2) {
        this.axisLineVisible = bl2;
        this.fireChangeEvent();
    }

    public Paint getAxisLinePaint() {
        return this.axisLinePaint;
    }

    public void setAxisLinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.axisLinePaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getAxisLineStroke() {
        return this.axisLineStroke;
    }

    public void setAxisLineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.axisLineStroke = stroke;
        this.fireChangeEvent();
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean bl2) {
        if (bl2 != this.tickLabelsVisible) {
            this.tickLabelsVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public boolean isMinorTickMarksVisible() {
        return this.minorTickMarksVisible;
    }

    public void setMinorTickMarksVisible(boolean bl2) {
        if (bl2 != this.minorTickMarksVisible) {
            this.minorTickMarksVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        if (!this.tickLabelFont.equals(font)) {
            this.tickLabelFont = font;
            this.fireChangeEvent();
        }
    }

    public Paint getTickLabelPaint() {
        return this.tickLabelPaint;
    }

    public void setTickLabelPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.tickLabelPaint = paint;
        this.fireChangeEvent();
    }

    public RectangleInsets getTickLabelInsets() {
        return this.tickLabelInsets;
    }

    public void setTickLabelInsets(RectangleInsets rectangleInsets) {
        ParamChecks.nullNotPermitted(rectangleInsets, "insets");
        if (!this.tickLabelInsets.equals(rectangleInsets)) {
            this.tickLabelInsets = rectangleInsets;
            this.fireChangeEvent();
        }
    }

    public boolean isTickMarksVisible() {
        return this.tickMarksVisible;
    }

    public void setTickMarksVisible(boolean bl2) {
        if (bl2 != this.tickMarksVisible) {
            this.tickMarksVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public float getTickMarkInsideLength() {
        return this.tickMarkInsideLength;
    }

    public void setTickMarkInsideLength(float f2) {
        this.tickMarkInsideLength = f2;
        this.fireChangeEvent();
    }

    public float getTickMarkOutsideLength() {
        return this.tickMarkOutsideLength;
    }

    public void setTickMarkOutsideLength(float f2) {
        this.tickMarkOutsideLength = f2;
        this.fireChangeEvent();
    }

    public Stroke getTickMarkStroke() {
        return this.tickMarkStroke;
    }

    public void setTickMarkStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        if (!this.tickMarkStroke.equals(stroke)) {
            this.tickMarkStroke = stroke;
            this.fireChangeEvent();
        }
    }

    public Paint getTickMarkPaint() {
        return this.tickMarkPaint;
    }

    public void setTickMarkPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.tickMarkPaint = paint;
        this.fireChangeEvent();
    }

    public float getMinorTickMarkInsideLength() {
        return this.minorTickMarkInsideLength;
    }

    public void setMinorTickMarkInsideLength(float f2) {
        this.minorTickMarkInsideLength = f2;
        this.fireChangeEvent();
    }

    public float getMinorTickMarkOutsideLength() {
        return this.minorTickMarkOutsideLength;
    }

    public void setMinorTickMarkOutsideLength(float f2) {
        this.minorTickMarkOutsideLength = f2;
        this.fireChangeEvent();
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) {
        this.plot = plot;
        this.configure();
    }

    public double getFixedDimension() {
        return this.fixedDimension;
    }

    public void setFixedDimension(double d2) {
        this.fixedDimension = d2;
    }

    public abstract void configure();

    public abstract AxisSpace reserveSpace(Graphics2D var1, Plot var2, Rectangle2D var3, RectangleEdge var4, AxisSpace var5);

    public abstract AxisState draw(Graphics2D var1, double var2, Rectangle2D var4, Rectangle2D var5, RectangleEdge var6, PlotRenderingInfo var7);

    public abstract List refreshTicks(Graphics2D var1, AxisState var2, Rectangle2D var3, RectangleEdge var4);

    protected void createAndAddEntity(double d2, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        if (plotRenderingInfo == null || plotRenderingInfo.getOwner() == null) {
            return;
        }
        Rectangle2D.Double double_ = null;
        if (rectangleEdge.equals(RectangleEdge.TOP)) {
            double_ = new Rectangle2D.Double(rectangle2D.getX(), axisState.getCursor(), rectangle2D.getWidth(), d2 - axisState.getCursor());
        } else if (rectangleEdge.equals(RectangleEdge.BOTTOM)) {
            double_ = new Rectangle2D.Double(rectangle2D.getX(), d2, rectangle2D.getWidth(), axisState.getCursor() - d2);
        } else if (rectangleEdge.equals(RectangleEdge.LEFT)) {
            double_ = new Rectangle2D.Double(axisState.getCursor(), rectangle2D.getY(), d2 - axisState.getCursor(), rectangle2D.getHeight());
        } else if (rectangleEdge.equals(RectangleEdge.RIGHT)) {
            double_ = new Rectangle2D.Double(d2, rectangle2D.getY(), axisState.getCursor() - d2, rectangle2D.getHeight());
        }
        EntityCollection entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        if (entityCollection != null) {
            entityCollection.add(new AxisEntity((Shape)double_, this));
        }
    }

    public void addChangeListener(AxisChangeListener axisChangeListener) {
        this.listenerList.add(AxisChangeListener.class, axisChangeListener);
    }

    public void removeChangeListener(AxisChangeListener axisChangeListener) {
        this.listenerList.remove(AxisChangeListener.class, axisChangeListener);
    }

    public boolean hasListener(EventListener eventListener) {
        List<Object> list = Arrays.asList(this.listenerList.getListenerList());
        return list.contains(eventListener);
    }

    protected void notifyListeners(AxisChangeEvent axisChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != AxisChangeListener.class) continue;
            ((AxisChangeListener)objectArray[i2 + 1]).axisChanged(axisChangeEvent);
        }
    }

    protected void fireChangeEvent() {
        this.notifyListeners(new AxisChangeEvent(this));
    }

    protected Rectangle2D getLabelEnclosure(Graphics2D graphics2D, RectangleEdge rectangleEdge) {
        Object object;
        Rectangle2D rectangle2D = new Rectangle2D.Double();
        Rectangle2D rectangle2D2 = null;
        if (this.attributedLabel != null) {
            object = new TextLayout(this.attributedLabel.getIterator(), graphics2D.getFontRenderContext());
            rectangle2D2 = ((TextLayout)object).getBounds();
        } else {
            object = this.getLabel();
            if (object != null && !((String)object).equals("")) {
                FontMetrics fontMetrics = graphics2D.getFontMetrics(this.getLabelFont());
                rectangle2D2 = TextUtilities.getTextBounds((String)object, graphics2D, fontMetrics);
            }
        }
        if (rectangle2D2 != null) {
            object = this.getLabelInsets();
            rectangle2D2 = ((RectangleInsets)object).createOutsetRectangle(rectangle2D2);
            double d2 = this.getLabelAngle();
            if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
                d2 -= 1.5707963267948966;
            }
            double d3 = rectangle2D2.getCenterX();
            double d4 = rectangle2D2.getCenterY();
            AffineTransform affineTransform = AffineTransform.getRotateInstance(d2, d3, d4);
            Shape shape = affineTransform.createTransformedShape(rectangle2D2);
            rectangle2D = shape.getBounds2D();
        }
        return rectangle2D;
    }

    protected double labelLocationX(AxisLabelLocation axisLabelLocation, Rectangle2D rectangle2D) {
        if (axisLabelLocation.equals(AxisLabelLocation.HIGH_END)) {
            return rectangle2D.getMaxX();
        }
        if (axisLabelLocation.equals(AxisLabelLocation.MIDDLE)) {
            return rectangle2D.getCenterX();
        }
        if (axisLabelLocation.equals(AxisLabelLocation.LOW_END)) {
            return rectangle2D.getMinX();
        }
        throw new RuntimeException("Unexpected AxisLabelLocation: " + axisLabelLocation);
    }

    protected double labelLocationY(AxisLabelLocation axisLabelLocation, Rectangle2D rectangle2D) {
        if (axisLabelLocation.equals(AxisLabelLocation.HIGH_END)) {
            return rectangle2D.getMinY();
        }
        if (axisLabelLocation.equals(AxisLabelLocation.MIDDLE)) {
            return rectangle2D.getCenterY();
        }
        if (axisLabelLocation.equals(AxisLabelLocation.LOW_END)) {
            return rectangle2D.getMaxY();
        }
        throw new RuntimeException("Unexpected AxisLabelLocation: " + axisLabelLocation);
    }

    protected TextAnchor labelAnchorH(AxisLabelLocation axisLabelLocation) {
        if (axisLabelLocation.equals(AxisLabelLocation.HIGH_END)) {
            return TextAnchor.CENTER_RIGHT;
        }
        if (axisLabelLocation.equals(AxisLabelLocation.MIDDLE)) {
            return TextAnchor.CENTER;
        }
        if (axisLabelLocation.equals(AxisLabelLocation.LOW_END)) {
            return TextAnchor.CENTER_LEFT;
        }
        throw new RuntimeException("Unexpected AxisLabelLocation: " + axisLabelLocation);
    }

    protected TextAnchor labelAnchorV(AxisLabelLocation axisLabelLocation) {
        if (axisLabelLocation.equals(AxisLabelLocation.HIGH_END)) {
            return TextAnchor.CENTER_RIGHT;
        }
        if (axisLabelLocation.equals(AxisLabelLocation.MIDDLE)) {
            return TextAnchor.CENTER;
        }
        if (axisLabelLocation.equals(AxisLabelLocation.LOW_END)) {
            return TextAnchor.CENTER_LEFT;
        }
        throw new RuntimeException("Unexpected AxisLabelLocation: " + axisLabelLocation);
    }

    protected AxisState drawLabel(String string, Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, AxisState axisState) {
        ParamChecks.nullNotPermitted(axisState, "state");
        if (string == null || string.equals("")) {
            return axisState;
        }
        Font font = this.getLabelFont();
        RectangleInsets rectangleInsets = this.getLabelInsets();
        graphics2D.setFont(font);
        graphics2D.setPaint(this.getLabelPaint());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D3 = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
        if (rectangleEdge == RectangleEdge.TOP) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getLabelAngle(), rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d2 = this.labelLocationX(this.labelLocation, rectangle2D2);
            double d3 = axisState.getCursor() - rectangleInsets.getBottom() - rectangle2D3.getHeight() / 2.0;
            TextAnchor textAnchor = this.labelAnchorH(this.labelLocation);
            TextUtilities.drawRotatedString(string, graphics2D, (float)d2, (float)d3, textAnchor, this.getLabelAngle(), TextAnchor.CENTER);
            axisState.cursorUp(rectangleInsets.getTop() + rectangle2D3.getHeight() + rectangleInsets.getBottom());
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getLabelAngle(), rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d4 = this.labelLocationX(this.labelLocation, rectangle2D2);
            double d5 = axisState.getCursor() + rectangleInsets.getTop() + rectangle2D3.getHeight() / 2.0;
            TextAnchor textAnchor = this.labelAnchorH(this.labelLocation);
            TextUtilities.drawRotatedString(string, graphics2D, (float)d4, (float)d5, textAnchor, this.getLabelAngle(), TextAnchor.CENTER);
            axisState.cursorDown(rectangleInsets.getTop() + rectangle2D3.getHeight() + rectangleInsets.getBottom());
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getLabelAngle() - 1.5707963267948966, rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d6 = axisState.getCursor() - rectangleInsets.getRight() - rectangle2D3.getWidth() / 2.0;
            double d7 = this.labelLocationY(this.labelLocation, rectangle2D2);
            TextAnchor textAnchor = this.labelAnchorV(this.labelLocation);
            TextUtilities.drawRotatedString(string, graphics2D, (float)d6, (float)d7, textAnchor, this.getLabelAngle() - 1.5707963267948966, textAnchor);
            axisState.cursorLeft(rectangleInsets.getLeft() + rectangle2D3.getWidth() + rectangleInsets.getRight());
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getLabelAngle() + 1.5707963267948966, rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d8 = axisState.getCursor() + rectangleInsets.getLeft() + rectangle2D3.getWidth() / 2.0;
            double d9 = this.labelLocationY(this.labelLocation, rectangle2D2);
            TextAnchor textAnchor = this.labelAnchorV(this.labelLocation);
            TextUtilities.drawRotatedString(string, graphics2D, (float)d8, (float)d9, textAnchor, this.getLabelAngle() + 1.5707963267948966, textAnchor);
            axisState.cursorRight(rectangleInsets.getLeft() + rectangle2D3.getWidth() + rectangleInsets.getRight());
        }
        return axisState;
    }

    protected AxisState drawAttributedLabel(AttributedString attributedString, Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, AxisState axisState) {
        ParamChecks.nullNotPermitted(axisState, "state");
        if (attributedString == null) {
            return axisState;
        }
        RectangleInsets rectangleInsets = this.getLabelInsets();
        graphics2D.setFont(this.getLabelFont());
        graphics2D.setPaint(this.getLabelPaint());
        TextLayout textLayout = new TextLayout(this.attributedLabel.getIterator(), graphics2D.getFontRenderContext());
        Rectangle2D rectangle2D3 = textLayout.getBounds();
        if (rectangleEdge == RectangleEdge.TOP) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getLabelAngle(), rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d2 = this.labelLocationX(this.labelLocation, rectangle2D2);
            double d3 = axisState.getCursor() - rectangleInsets.getBottom() - rectangle2D3.getHeight() / 2.0;
            TextAnchor textAnchor = this.labelAnchorH(this.labelLocation);
            AttrStringUtils.drawRotatedString(attributedString, graphics2D, (float)d2, (float)d3, textAnchor, this.getLabelAngle(), TextAnchor.CENTER);
            axisState.cursorUp(rectangleInsets.getTop() + rectangle2D3.getHeight() + rectangleInsets.getBottom());
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getLabelAngle(), rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d4 = this.labelLocationX(this.labelLocation, rectangle2D2);
            double d5 = axisState.getCursor() + rectangleInsets.getTop() + rectangle2D3.getHeight() / 2.0;
            TextAnchor textAnchor = this.labelAnchorH(this.labelLocation);
            AttrStringUtils.drawRotatedString(attributedString, graphics2D, (float)d4, (float)d5, textAnchor, this.getLabelAngle(), TextAnchor.CENTER);
            axisState.cursorDown(rectangleInsets.getTop() + rectangle2D3.getHeight() + rectangleInsets.getBottom());
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getLabelAngle() - 1.5707963267948966, rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d6 = axisState.getCursor() - rectangleInsets.getRight() - rectangle2D3.getWidth() / 2.0;
            double d7 = this.labelLocationY(this.labelLocation, rectangle2D2);
            TextAnchor textAnchor = this.labelAnchorV(this.labelLocation);
            AttrStringUtils.drawRotatedString(attributedString, graphics2D, (float)d6, (float)d7, textAnchor, this.getLabelAngle() - 1.5707963267948966, textAnchor);
            axisState.cursorLeft(rectangleInsets.getLeft() + rectangle2D3.getWidth() + rectangleInsets.getRight());
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getLabelAngle() + 1.5707963267948966, rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d8 = axisState.getCursor() + rectangleInsets.getLeft() + rectangle2D3.getWidth() / 2.0;
            double d9 = this.labelLocationY(this.labelLocation, rectangle2D2);
            TextAnchor textAnchor = this.labelAnchorV(this.labelLocation);
            AttrStringUtils.drawRotatedString(attributedString, graphics2D, (float)d8, (float)d9, textAnchor, this.getLabelAngle() + 1.5707963267948966, textAnchor);
            axisState.cursorRight(rectangleInsets.getLeft() + rectangle2D3.getWidth() + rectangleInsets.getRight());
        }
        return axisState;
    }

    protected void drawAxisLine(Graphics2D graphics2D, double d2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Line2D.Double double_ = null;
        double d3 = rectangle2D.getX();
        double d4 = rectangle2D.getY();
        if (rectangleEdge == RectangleEdge.TOP) {
            double_ = new Line2D.Double(d3, d2, rectangle2D.getMaxX(), d2);
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            double_ = new Line2D.Double(d3, d2, rectangle2D.getMaxX(), d2);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            double_ = new Line2D.Double(d2, d4, d2, rectangle2D.getMaxY());
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            double_ = new Line2D.Double(d2, d4, d2, rectangle2D.getMaxY());
        }
        graphics2D.setPaint(this.axisLinePaint);
        graphics2D.setStroke(this.axisLineStroke);
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.draw(double_);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
    }

    public Object clone() {
        Axis axis = (Axis)super.clone();
        axis.plot = null;
        axis.listenerList = new EventListenerList();
        return axis;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Axis)) {
            return false;
        }
        Axis axis = (Axis)object;
        if (this.visible != axis.visible) {
            return false;
        }
        if (!ObjectUtilities.equal(this.label, axis.label)) {
            return false;
        }
        if (!AttributedStringUtilities.equal(this.attributedLabel, axis.attributedLabel)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.labelFont, axis.labelFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.labelPaint, axis.labelPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.labelInsets, axis.labelInsets)) {
            return false;
        }
        if (this.labelAngle != axis.labelAngle) {
            return false;
        }
        if (!this.labelLocation.equals(axis.labelLocation)) {
            return false;
        }
        if (this.axisLineVisible != axis.axisLineVisible) {
            return false;
        }
        if (!ObjectUtilities.equal(this.axisLineStroke, axis.axisLineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.axisLinePaint, axis.axisLinePaint)) {
            return false;
        }
        if (this.tickLabelsVisible != axis.tickLabelsVisible) {
            return false;
        }
        if (!ObjectUtilities.equal(this.tickLabelFont, axis.tickLabelFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.tickLabelPaint, axis.tickLabelPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.tickLabelInsets, axis.tickLabelInsets)) {
            return false;
        }
        if (this.tickMarksVisible != axis.tickMarksVisible) {
            return false;
        }
        if (this.tickMarkInsideLength != axis.tickMarkInsideLength) {
            return false;
        }
        if (this.tickMarkOutsideLength != axis.tickMarkOutsideLength) {
            return false;
        }
        if (!PaintUtilities.equal(this.tickMarkPaint, axis.tickMarkPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.tickMarkStroke, axis.tickMarkStroke)) {
            return false;
        }
        if (this.minorTickMarksVisible != axis.minorTickMarksVisible) {
            return false;
        }
        if (this.minorTickMarkInsideLength != axis.minorTickMarkInsideLength) {
            return false;
        }
        if (this.minorTickMarkOutsideLength != axis.minorTickMarkOutsideLength) {
            return false;
        }
        return this.fixedDimension == axis.fixedDimension;
    }

    public int hashCode() {
        int n2 = 3;
        if (this.label != null) {
            n2 = 83 * n2 + this.label.hashCode();
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeAttributedString(this.attributedLabel, objectOutputStream);
        SerialUtilities.writePaint(this.labelPaint, objectOutputStream);
        SerialUtilities.writePaint(this.tickLabelPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.axisLineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.axisLinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.tickMarkStroke, objectOutputStream);
        SerialUtilities.writePaint(this.tickMarkPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.attributedLabel = SerialUtilities.readAttributedString(objectInputStream);
        this.labelPaint = SerialUtilities.readPaint(objectInputStream);
        this.tickLabelPaint = SerialUtilities.readPaint(objectInputStream);
        this.axisLineStroke = SerialUtilities.readStroke(objectInputStream);
        this.axisLinePaint = SerialUtilities.readPaint(objectInputStream);
        this.tickMarkStroke = SerialUtilities.readStroke(objectInputStream);
        this.tickMarkPaint = SerialUtilities.readPaint(objectInputStream);
        this.listenerList = new EventListenerList();
    }
}

