/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.annotations.AbstractXYAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockParams;
import org.jfree.chart.block.EntityBlockResult;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.Title;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.XYCoordinateType;
import org.jfree.data.Range;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Size2D;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class XYTitleAnnotation
extends AbstractXYAnnotation
implements Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = -4364694501921559958L;
    private XYCoordinateType coordinateType;
    private double x;
    private double y;
    private double maxWidth;
    private double maxHeight;
    private Title title;
    private RectangleAnchor anchor;

    public XYTitleAnnotation(double d2, double d3, Title title) {
        this(d2, d3, title, RectangleAnchor.CENTER);
    }

    public XYTitleAnnotation(double d2, double d3, Title title, RectangleAnchor rectangleAnchor) {
        ParamChecks.nullNotPermitted(title, "title");
        ParamChecks.nullNotPermitted(rectangleAnchor, "anchor");
        this.coordinateType = XYCoordinateType.RELATIVE;
        this.x = d2;
        this.y = d3;
        this.maxWidth = 0.0;
        this.maxHeight = 0.0;
        this.title = title;
        this.anchor = rectangleAnchor;
    }

    public XYCoordinateType getCoordinateType() {
        return this.coordinateType;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Title getTitle() {
        return this.title;
    }

    public RectangleAnchor getTitleAnchor() {
        return this.anchor;
    }

    public double getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(double d2) {
        this.maxWidth = d2;
        this.fireAnnotationChanged();
    }

    public double getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(double d2) {
        this.maxHeight = d2;
        this.fireAnnotationChanged();
    }

    @Override
    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2, int n2, PlotRenderingInfo plotRenderingInfo) {
        double d2;
        double d3;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        AxisLocation axisLocation = xYPlot.getDomainAxisLocation();
        AxisLocation axisLocation2 = xYPlot.getRangeAxisLocation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(axisLocation, plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(axisLocation2, plotOrientation);
        Range range = valueAxis.getRange();
        Range range2 = valueAxis2.getRange();
        if (this.coordinateType == XYCoordinateType.RELATIVE) {
            d3 = range.getLowerBound() + this.x * range.getLength();
            d2 = range2.getLowerBound() + this.y * range2.getLength();
        } else {
            d3 = valueAxis.valueToJava2D(this.x, rectangle2D, rectangleEdge);
            d2 = valueAxis2.valueToJava2D(this.y, rectangle2D, rectangleEdge2);
        }
        float f2 = (float)valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
        float f3 = (float)valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            f4 = f3;
            f5 = f2;
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            f4 = f2;
            f5 = f3;
        }
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        if (this.coordinateType == XYCoordinateType.RELATIVE) {
            if (this.maxWidth > 0.0) {
                d4 *= this.maxWidth;
            }
            if (this.maxHeight > 0.0) {
                d5 *= this.maxHeight;
            }
        }
        if (this.coordinateType == XYCoordinateType.DATA) {
            d4 = this.maxWidth;
            d5 = this.maxHeight;
        }
        RectangleConstraint rectangleConstraint = new RectangleConstraint(new Range(0.0, d4), new Range(0.0, d5));
        Size2D size2D = this.title.arrange(graphics2D, rectangleConstraint);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, size2D.width, size2D.height);
        Point2D point2D = RectangleAnchor.coordinates(double_, this.anchor);
        ((Rectangle2D)double_).setRect(f4 -= (float)point2D.getX(), f5 -= (float)point2D.getY(), ((RectangularShape)double_).getWidth(), ((RectangularShape)double_).getHeight());
        BlockParams blockParams = new BlockParams();
        if (plotRenderingInfo != null && plotRenderingInfo.getOwner().getEntityCollection() != null) {
            blockParams.setGenerateEntities(true);
        }
        Object object = this.title.draw(graphics2D, double_, blockParams);
        if (plotRenderingInfo != null) {
            Object object2;
            if (object instanceof EntityBlockResult) {
                object2 = (EntityBlockResult)object;
                plotRenderingInfo.getOwner().getEntityCollection().addAll(object2.getEntityCollection());
            }
            object2 = this.getToolTipText();
            String string = this.getURL();
            if (object2 != null || string != null) {
                this.addEntity(plotRenderingInfo, new Rectangle2D.Float(f4, f5, (float)size2D.width, (float)size2D.height), n2, (String)object2, string);
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYTitleAnnotation)) {
            return false;
        }
        XYTitleAnnotation xYTitleAnnotation = (XYTitleAnnotation)object;
        if (this.coordinateType != xYTitleAnnotation.coordinateType) {
            return false;
        }
        if (this.x != xYTitleAnnotation.x) {
            return false;
        }
        if (this.y != xYTitleAnnotation.y) {
            return false;
        }
        if (this.maxWidth != xYTitleAnnotation.maxWidth) {
            return false;
        }
        if (this.maxHeight != xYTitleAnnotation.maxHeight) {
            return false;
        }
        if (!ObjectUtilities.equal(this.title, xYTitleAnnotation.title)) {
            return false;
        }
        if (!this.anchor.equals(xYTitleAnnotation.anchor)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = 193;
        n2 = HashUtilities.hashCode(n2, this.anchor);
        n2 = HashUtilities.hashCode(n2, this.coordinateType);
        n2 = HashUtilities.hashCode(n2, this.x);
        n2 = HashUtilities.hashCode(n2, this.y);
        n2 = HashUtilities.hashCode(n2, this.maxWidth);
        n2 = HashUtilities.hashCode(n2, this.maxHeight);
        n2 = HashUtilities.hashCode(n2, this.title);
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

