/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.annotations.AbstractXYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.util.ParamChecks;
import org.jfree.ui.Drawable;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class XYDrawableAnnotation
extends AbstractXYAnnotation
implements Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = -6540812859722691020L;
    private double drawScaleFactor;
    private double x;
    private double y;
    private double displayWidth;
    private double displayHeight;
    private Drawable drawable;

    public XYDrawableAnnotation(double d2, double d3, double d4, double d5, Drawable drawable) {
        this(d2, d3, d4, d5, 1.0, drawable);
    }

    public XYDrawableAnnotation(double d2, double d3, double d4, double d5, double d6, Drawable drawable) {
        ParamChecks.nullNotPermitted(drawable, "drawable");
        this.x = d2;
        this.y = d3;
        this.displayWidth = d4;
        this.displayHeight = d5;
        this.drawScaleFactor = d6;
        this.drawable = drawable;
    }

    @Override
    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2, int n2, PlotRenderingInfo plotRenderingInfo) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(xYPlot.getDomainAxisLocation(), plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(xYPlot.getRangeAxisLocation(), plotOrientation);
        float f2 = (float)valueAxis.valueToJava2D(this.x, rectangle2D, rectangleEdge);
        float f3 = (float)valueAxis2.valueToJava2D(this.y, rectangle2D, rectangleEdge2);
        Rectangle2D.Double double_ = new Rectangle2D.Double((double)f2 - this.displayWidth / 2.0, (double)f3 - this.displayHeight / 2.0, this.displayWidth, this.displayHeight);
        AffineTransform affineTransform = graphics2D.getTransform();
        Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, this.displayWidth * this.drawScaleFactor, this.displayHeight * this.drawScaleFactor);
        graphics2D.scale(1.0 / this.drawScaleFactor, 1.0 / this.drawScaleFactor);
        graphics2D.translate(((double)f2 - this.displayWidth / 2.0) * this.drawScaleFactor, ((double)f3 - this.displayHeight / 2.0) * this.drawScaleFactor);
        this.drawable.draw(graphics2D, double_2);
        graphics2D.setTransform(affineTransform);
        String string = this.getToolTipText();
        String string2 = this.getURL();
        if (string != null || string2 != null) {
            this.addEntity(plotRenderingInfo, double_, n2, string, string2);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof XYDrawableAnnotation)) {
            return false;
        }
        XYDrawableAnnotation xYDrawableAnnotation = (XYDrawableAnnotation)object;
        if (this.x != xYDrawableAnnotation.x) {
            return false;
        }
        if (this.y != xYDrawableAnnotation.y) {
            return false;
        }
        if (this.displayWidth != xYDrawableAnnotation.displayWidth) {
            return false;
        }
        if (this.displayHeight != xYDrawableAnnotation.displayHeight) {
            return false;
        }
        if (this.drawScaleFactor != xYDrawableAnnotation.drawScaleFactor) {
            return false;
        }
        return ObjectUtilities.equal(this.drawable, xYDrawableAnnotation.drawable);
    }

    @Override
    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.x);
        int n2 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.y);
        n2 = 29 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.displayWidth);
        n2 = 29 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.displayHeight);
        n2 = 29 * n2 + (int)(l2 ^ l2 >>> 32);
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

