/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.chart.annotations.AbstractXYAnnotation;
import org.jfree.chart.annotations.XYAnnotationBoundsInfo;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class XYDataImageAnnotation
extends AbstractXYAnnotation
implements Cloneable,
XYAnnotationBoundsInfo,
PublicCloneable {
    private transient Image image;
    private double x;
    private double y;
    private double w;
    private double h;
    private boolean includeInDataBounds;

    public XYDataImageAnnotation(Image image, double d2, double d3, double d4, double d5) {
        this(image, d2, d3, d4, d5, false);
    }

    public XYDataImageAnnotation(Image image, double d2, double d3, double d4, double d5, boolean bl2) {
        ParamChecks.nullNotPermitted(image, "image");
        this.image = image;
        this.x = d2;
        this.y = d3;
        this.w = d4;
        this.h = d5;
        this.includeInDataBounds = bl2;
    }

    public Image getImage() {
        return this.image;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.w;
    }

    public double getHeight() {
        return this.h;
    }

    @Override
    public boolean getIncludeInDataBounds() {
        return this.includeInDataBounds;
    }

    @Override
    public Range getXRange() {
        return new Range(this.x, this.x + this.w);
    }

    @Override
    public Range getYRange() {
        return new Range(this.y, this.y + this.h);
    }

    @Override
    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2, int n2, PlotRenderingInfo plotRenderingInfo) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        AxisLocation axisLocation = xYPlot.getDomainAxisLocation();
        AxisLocation axisLocation2 = xYPlot.getRangeAxisLocation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(axisLocation, plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(axisLocation2, plotOrientation);
        float f2 = (float)valueAxis.valueToJava2D(this.x, rectangle2D, rectangleEdge);
        float f3 = (float)valueAxis2.valueToJava2D(this.y, rectangle2D, rectangleEdge2);
        float f4 = (float)valueAxis.valueToJava2D(this.x + this.w, rectangle2D, rectangleEdge);
        float f5 = (float)valueAxis2.valueToJava2D(this.y + this.h, rectangle2D, rectangleEdge2);
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            f6 = f3;
            f8 = f5;
            f7 = f2;
            f9 = f4;
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            f6 = f2;
            f8 = f4;
            f7 = f3;
            f9 = f5;
        }
        graphics2D.drawImage(this.image, (int)f6, (int)Math.min(f7, f9), (int)(f8 - f6), (int)Math.abs(f9 - f7), null);
        String string = this.getToolTipText();
        String string2 = this.getURL();
        if (string != null || string2 != null) {
            this.addEntity(plotRenderingInfo, new Rectangle2D.Float(f6, f7, f8 - f6, f9 - f7), n2, string, string2);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof XYDataImageAnnotation)) {
            return false;
        }
        XYDataImageAnnotation xYDataImageAnnotation = (XYDataImageAnnotation)object;
        if (this.x != xYDataImageAnnotation.x) {
            return false;
        }
        if (this.y != xYDataImageAnnotation.y) {
            return false;
        }
        if (this.w != xYDataImageAnnotation.w) {
            return false;
        }
        if (this.h != xYDataImageAnnotation.h) {
            return false;
        }
        if (this.includeInDataBounds != xYDataImageAnnotation.includeInDataBounds) {
            return false;
        }
        return ObjectUtilities.equal(this.image, xYDataImageAnnotation.image);
    }

    @Override
    public int hashCode() {
        return this.image.hashCode();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
    }
}

