/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jfree.chart.annotations.Annotation;
import org.jfree.chart.event.AnnotationChangeEvent;
import org.jfree.chart.event.AnnotationChangeListener;

public abstract class AbstractAnnotation
implements Serializable,
Cloneable,
Annotation {
    private transient EventListenerList listenerList = new EventListenerList();
    private boolean notify = true;

    protected AbstractAnnotation() {
    }

    @Override
    public void addChangeListener(AnnotationChangeListener annotationChangeListener) {
        this.listenerList.add(AnnotationChangeListener.class, annotationChangeListener);
    }

    @Override
    public void removeChangeListener(AnnotationChangeListener annotationChangeListener) {
        this.listenerList.remove(AnnotationChangeListener.class, annotationChangeListener);
    }

    public boolean hasListener(EventListener eventListener) {
        List<Object> list = Arrays.asList(this.listenerList.getListenerList());
        return list.contains(eventListener);
    }

    protected void fireAnnotationChanged() {
        if (this.notify) {
            this.notifyListeners(new AnnotationChangeEvent((Object)this, this));
        }
    }

    protected void notifyListeners(AnnotationChangeEvent annotationChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != AnnotationChangeListener.class) continue;
            ((AnnotationChangeListener)objectArray[i2 + 1]).annotationChanged(annotationChangeEvent);
        }
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean bl2) {
        this.notify = bl2;
        if (this.notify) {
            this.fireAnnotationChanged();
        }
    }

    public Object clone() {
        AbstractAnnotation abstractAnnotation = (AbstractAnnotation)super.clone();
        abstractAnnotation.listenerList = new EventListenerList();
        return abstractAnnotation;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
    }
}

