/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Stroke;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.util.ObjectUtilities;

public class StrokeMap
implements Serializable,
Cloneable {
    static final long serialVersionUID = -8148916785963525169L;
    private transient Map store = new TreeMap();

    public Stroke getStroke(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        return (Stroke)this.store.get(comparable);
    }

    public boolean containsKey(Comparable comparable) {
        return this.store.containsKey(comparable);
    }

    public void put(Comparable comparable, Stroke stroke) {
        ParamChecks.nullNotPermitted(comparable, "key");
        this.store.put(comparable, stroke);
    }

    public void clear() {
        this.store.clear();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StrokeMap)) {
            return false;
        }
        StrokeMap strokeMap = (StrokeMap)object;
        if (this.store.size() != strokeMap.store.size()) {
            return false;
        }
        Set set = this.store.keySet();
        for (Comparable comparable : set) {
            Stroke stroke;
            Stroke stroke2 = this.getStroke(comparable);
            if (ObjectUtilities.equal(stroke2, stroke = strokeMap.getStroke(comparable))) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        StrokeMap strokeMap = (StrokeMap)super.clone();
        strokeMap.store = new TreeMap();
        strokeMap.store.putAll(this.store);
        return strokeMap;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.store.size());
        Set set = this.store.keySet();
        for (Comparable comparable : set) {
            objectOutputStream.writeObject(comparable);
            Stroke stroke = this.getStroke(comparable);
            SerialUtilities.writeStroke(stroke, objectOutputStream);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.store = new TreeMap();
        int n2 = objectInputStream.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            Comparable comparable = (Comparable)objectInputStream.readObject();
            Stroke stroke = SerialUtilities.readStroke(objectInputStream);
            this.store.put(comparable, stroke);
        }
    }
}

