/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PolarPlot;

public class PolarChartPanel
extends ChartPanel {
    private static final String POLAR_ZOOM_IN_ACTION_COMMAND = "Polar Zoom In";
    private static final String POLAR_ZOOM_OUT_ACTION_COMMAND = "Polar Zoom Out";
    private static final String POLAR_AUTO_RANGE_ACTION_COMMAND = "Polar Auto Range";

    public PolarChartPanel(JFreeChart jFreeChart) {
        this(jFreeChart, true);
    }

    public PolarChartPanel(JFreeChart jFreeChart, boolean bl2) {
        super(jFreeChart, bl2);
        this.checkChart(jFreeChart);
        this.setMinimumDrawWidth(200);
        this.setMinimumDrawHeight(200);
        this.setMaximumDrawWidth(2000);
        this.setMaximumDrawHeight(2000);
    }

    @Override
    public void setChart(JFreeChart jFreeChart) {
        this.checkChart(jFreeChart);
        super.setChart(jFreeChart);
    }

    @Override
    protected JPopupMenu createPopupMenu(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        JPopupMenu jPopupMenu = super.createPopupMenu(bl2, bl3, bl4, bl5);
        int n2 = this.getPopupMenuItem(jPopupMenu, localizationResources.getString("Zoom_In"));
        int n3 = this.getPopupMenuItem(jPopupMenu, localizationResources.getString("Zoom_Out"));
        int n4 = this.getPopupMenuItem(jPopupMenu, localizationResources.getString("Auto_Range"));
        if (bl5) {
            JMenuItem jMenuItem = new JMenuItem(localizationResources.getString("Zoom_In"));
            jMenuItem.setActionCommand(POLAR_ZOOM_IN_ACTION_COMMAND);
            jMenuItem.addActionListener(this);
            JMenuItem jMenuItem2 = new JMenuItem(localizationResources.getString("Zoom_Out"));
            jMenuItem2.setActionCommand(POLAR_ZOOM_OUT_ACTION_COMMAND);
            jMenuItem2.addActionListener(this);
            JMenuItem jMenuItem3 = new JMenuItem(localizationResources.getString("Auto_Range"));
            jMenuItem3.setActionCommand(POLAR_AUTO_RANGE_ACTION_COMMAND);
            jMenuItem3.addActionListener(this);
            if (n2 != -1) {
                jPopupMenu.remove(n2);
            } else {
                n2 = jPopupMenu.getComponentCount() - 1;
            }
            jPopupMenu.add((Component)jMenuItem, n2);
            if (n3 != -1) {
                jPopupMenu.remove(n3);
            } else {
                n3 = n2 + 1;
            }
            jPopupMenu.add((Component)jMenuItem2, n3);
            if (n4 != -1) {
                jPopupMenu.remove(n4);
            } else {
                n4 = n3 + 1;
            }
            jPopupMenu.add((Component)jMenuItem3, n4);
        }
        return jPopupMenu;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(POLAR_ZOOM_IN_ACTION_COMMAND)) {
            PolarPlot polarPlot = (PolarPlot)this.getChart().getPlot();
            polarPlot.zoom(0.5);
        } else if (string.equals(POLAR_ZOOM_OUT_ACTION_COMMAND)) {
            PolarPlot polarPlot = (PolarPlot)this.getChart().getPlot();
            polarPlot.zoom(2.0);
        } else if (string.equals(POLAR_AUTO_RANGE_ACTION_COMMAND)) {
            PolarPlot polarPlot = (PolarPlot)this.getChart().getPlot();
            polarPlot.getAxis().setAutoRange(true);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void checkChart(JFreeChart jFreeChart) {
        Plot plot = jFreeChart.getPlot();
        if (!(plot instanceof PolarPlot)) {
            throw new IllegalArgumentException("plot is not a PolarPlot");
        }
    }

    private int getPopupMenuItem(JPopupMenu jPopupMenu, String string) {
        int n2 = -1;
        for (int i2 = 0; n2 == -1 && i2 < jPopupMenu.getComponentCount(); ++i2) {
            JMenuItem jMenuItem;
            Component component = jPopupMenu.getComponent(i2);
            if (!(component instanceof JMenuItem) || !string.equals((jMenuItem = (JMenuItem)component).getText())) continue;
            n2 = i2;
        }
        return n2;
    }
}

