/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Paint;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PaintUtilities;

public class PaintMap
implements Serializable,
Cloneable {
    static final long serialVersionUID = -4639833772123069274L;
    private transient Map store = new HashMap();

    public Paint getPaint(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        return (Paint)this.store.get(comparable);
    }

    public boolean containsKey(Comparable comparable) {
        return this.store.containsKey(comparable);
    }

    public void put(Comparable comparable, Paint paint) {
        ParamChecks.nullNotPermitted(comparable, "key");
        this.store.put(comparable, paint);
    }

    public void clear() {
        this.store.clear();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PaintMap)) {
            return false;
        }
        PaintMap paintMap = (PaintMap)object;
        if (this.store.size() != paintMap.store.size()) {
            return false;
        }
        Set set = this.store.keySet();
        for (Comparable comparable : set) {
            Paint paint;
            Paint paint2 = this.getPaint(comparable);
            if (PaintUtilities.equal(paint2, paint = paintMap.getPaint(comparable))) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        PaintMap paintMap = (PaintMap)super.clone();
        paintMap.store = new HashMap();
        paintMap.store.putAll(this.store);
        return paintMap;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.store.size());
        Set set = this.store.keySet();
        for (Comparable comparable : set) {
            objectOutputStream.writeObject(comparable);
            Paint paint = this.getPaint(comparable);
            SerialUtilities.writePaint(paint, objectOutputStream);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.store = new HashMap();
        int n2 = objectInputStream.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            Comparable comparable = (Comparable)objectInputStream.readObject();
            Paint paint = SerialUtilities.readPaint(objectInputStream);
            this.store.put(comparable, paint);
        }
    }
}

