/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.AttributedString;
import java.text.CharacterIterator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.general.Dataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.util.AttributedStringUtilities;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class LegendItem
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -797214582948827144L;
    private Dataset dataset;
    private Comparable seriesKey;
    private int datasetIndex;
    private int series;
    private String label;
    private Font labelFont;
    private transient Paint labelPaint;
    private transient AttributedString attributedLabel;
    private String description;
    private String toolTipText;
    private String urlText;
    private boolean shapeVisible;
    private transient Shape shape;
    private boolean shapeFilled;
    private transient Paint fillPaint;
    private GradientPaintTransformer fillPaintTransformer;
    private boolean shapeOutlineVisible;
    private transient Paint outlinePaint;
    private transient Stroke outlineStroke;
    private boolean lineVisible;
    private transient Shape line;
    private transient Stroke lineStroke;
    private transient Paint linePaint;
    private static final Shape UNUSED_SHAPE = new Line2D.Float();
    private static final Stroke UNUSED_STROKE = new BasicStroke(0.0f);

    public LegendItem(String string) {
        this(string, Color.black);
    }

    public LegendItem(String string, Paint paint) {
        this(string, null, null, null, (Shape)new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0), paint);
    }

    public LegendItem(String string, String string2, String string3, String string4, Shape shape, Paint paint) {
        this(string, string2, string3, string4, true, shape, true, paint, false, (Paint)Color.black, UNUSED_STROKE, false, UNUSED_SHAPE, UNUSED_STROKE, (Paint)Color.black);
    }

    public LegendItem(String string, String string2, String string3, String string4, Shape shape, Paint paint, Stroke stroke, Paint paint2) {
        this(string, string2, string3, string4, true, shape, true, paint, true, paint2, stroke, false, UNUSED_SHAPE, UNUSED_STROKE, (Paint)Color.black);
    }

    public LegendItem(String string, String string2, String string3, String string4, Shape shape, Stroke stroke, Paint paint) {
        this(string, string2, string3, string4, false, UNUSED_SHAPE, false, (Paint)Color.black, false, (Paint)Color.black, UNUSED_STROKE, true, shape, stroke, paint);
    }

    public LegendItem(String string, String string2, String string3, String string4, boolean bl2, Shape shape, boolean bl3, Paint paint, boolean bl4, Paint paint2, Stroke stroke, boolean bl5, Shape shape2, Stroke stroke2, Paint paint3) {
        ParamChecks.nullNotPermitted(string, "label");
        ParamChecks.nullNotPermitted(paint, "fillPaint");
        ParamChecks.nullNotPermitted(stroke2, "lineStroke");
        ParamChecks.nullNotPermitted(paint2, "outlinePaint");
        ParamChecks.nullNotPermitted(stroke, "outlineStroke");
        this.label = string;
        this.labelPaint = null;
        this.attributedLabel = null;
        this.description = string2;
        this.shapeVisible = bl2;
        this.shape = shape;
        this.shapeFilled = bl3;
        this.fillPaint = paint;
        this.fillPaintTransformer = new StandardGradientPaintTransformer();
        this.shapeOutlineVisible = bl4;
        this.outlinePaint = paint2;
        this.outlineStroke = stroke;
        this.lineVisible = bl5;
        this.line = shape2;
        this.lineStroke = stroke2;
        this.linePaint = paint3;
        this.toolTipText = string3;
        this.urlText = string4;
    }

    public LegendItem(AttributedString attributedString, String string, String string2, String string3, Shape shape, Paint paint) {
        this(attributedString, string, string2, string3, true, shape, true, paint, false, (Paint)Color.black, UNUSED_STROKE, false, UNUSED_SHAPE, UNUSED_STROKE, (Paint)Color.black);
    }

    public LegendItem(AttributedString attributedString, String string, String string2, String string3, Shape shape, Paint paint, Stroke stroke, Paint paint2) {
        this(attributedString, string, string2, string3, true, shape, true, paint, true, paint2, stroke, false, UNUSED_SHAPE, UNUSED_STROKE, (Paint)Color.black);
    }

    public LegendItem(AttributedString attributedString, String string, String string2, String string3, Shape shape, Stroke stroke, Paint paint) {
        this(attributedString, string, string2, string3, false, UNUSED_SHAPE, false, (Paint)Color.black, false, (Paint)Color.black, UNUSED_STROKE, true, shape, stroke, paint);
    }

    public LegendItem(AttributedString attributedString, String string, String string2, String string3, boolean bl2, Shape shape, boolean bl3, Paint paint, boolean bl4, Paint paint2, Stroke stroke, boolean bl5, Shape shape2, Stroke stroke2, Paint paint3) {
        ParamChecks.nullNotPermitted(attributedString, "label");
        ParamChecks.nullNotPermitted(paint, "fillPaint");
        ParamChecks.nullNotPermitted(stroke2, "lineStroke");
        ParamChecks.nullNotPermitted(shape2, "line");
        ParamChecks.nullNotPermitted(paint3, "linePaint");
        ParamChecks.nullNotPermitted(paint2, "outlinePaint");
        ParamChecks.nullNotPermitted(stroke, "outlineStroke");
        this.label = this.characterIteratorToString(attributedString.getIterator());
        this.attributedLabel = attributedString;
        this.description = string;
        this.shapeVisible = bl2;
        this.shape = shape;
        this.shapeFilled = bl3;
        this.fillPaint = paint;
        this.fillPaintTransformer = new StandardGradientPaintTransformer();
        this.shapeOutlineVisible = bl4;
        this.outlinePaint = paint2;
        this.outlineStroke = stroke;
        this.lineVisible = bl5;
        this.line = shape2;
        this.lineStroke = stroke2;
        this.linePaint = paint3;
        this.toolTipText = string2;
        this.urlText = string3;
    }

    private String characterIteratorToString(CharacterIterator characterIterator) {
        int n2;
        int n3 = characterIterator.getEndIndex();
        int n4 = n3 - (n2 = characterIterator.getBeginIndex());
        if (n4 <= 0) {
            return "";
        }
        char[] cArray = new char[n4];
        int n5 = 0;
        char c2 = characterIterator.first();
        while (c2 != '\uffff') {
            cArray[n5] = c2;
            ++n5;
            c2 = characterIterator.next();
        }
        return new String(cArray);
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public int getDatasetIndex() {
        return this.datasetIndex;
    }

    public void setDatasetIndex(int n2) {
        this.datasetIndex = n2;
    }

    public Comparable getSeriesKey() {
        return this.seriesKey;
    }

    public void setSeriesKey(Comparable comparable) {
        this.seriesKey = comparable;
    }

    public int getSeriesIndex() {
        return this.series;
    }

    public void setSeriesIndex(int n2) {
        this.series = n2;
    }

    public String getLabel() {
        return this.label;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        this.labelPaint = paint;
    }

    public AttributedString getAttributedLabel() {
        return this.attributedLabel;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
    }

    public String getURLText() {
        return this.urlText;
    }

    public void setURLText(String string) {
        this.urlText = string;
    }

    public boolean isShapeVisible() {
        return this.shapeVisible;
    }

    public void setShapeVisible(boolean bl2) {
        this.shapeVisible = bl2;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "shape");
        this.shape = shape;
    }

    public boolean isShapeFilled() {
        return this.shapeFilled;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.fillPaint = paint;
    }

    public boolean isShapeOutlineVisible() {
        return this.shapeOutlineVisible;
    }

    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setLineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.lineStroke = stroke;
    }

    public Paint getLinePaint() {
        return this.linePaint;
    }

    public void setLinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.linePaint = paint;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.outlinePaint = paint;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.outlineStroke = stroke;
    }

    public boolean isLineVisible() {
        return this.lineVisible;
    }

    public void setLineVisible(boolean bl2) {
        this.lineVisible = bl2;
    }

    public Shape getLine() {
        return this.line;
    }

    public void setLine(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "line");
        this.line = shape;
    }

    public GradientPaintTransformer getFillPaintTransformer() {
        return this.fillPaintTransformer;
    }

    public void setFillPaintTransformer(GradientPaintTransformer gradientPaintTransformer) {
        ParamChecks.nullNotPermitted(gradientPaintTransformer, "transformer");
        this.fillPaintTransformer = gradientPaintTransformer;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LegendItem)) {
            return false;
        }
        LegendItem legendItem = (LegendItem)object;
        if (this.datasetIndex != legendItem.datasetIndex) {
            return false;
        }
        if (this.series != legendItem.series) {
            return false;
        }
        if (!this.label.equals(legendItem.label)) {
            return false;
        }
        if (!AttributedStringUtilities.equal(this.attributedLabel, legendItem.attributedLabel)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.description, legendItem.description)) {
            return false;
        }
        if (this.shapeVisible != legendItem.shapeVisible) {
            return false;
        }
        if (!ShapeUtilities.equal(this.shape, legendItem.shape)) {
            return false;
        }
        if (this.shapeFilled != legendItem.shapeFilled) {
            return false;
        }
        if (!PaintUtilities.equal(this.fillPaint, legendItem.fillPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.fillPaintTransformer, legendItem.fillPaintTransformer)) {
            return false;
        }
        if (this.shapeOutlineVisible != legendItem.shapeOutlineVisible) {
            return false;
        }
        if (!this.outlineStroke.equals(legendItem.outlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.outlinePaint, legendItem.outlinePaint)) {
            return false;
        }
        if (!this.lineVisible == legendItem.lineVisible) {
            return false;
        }
        if (!ShapeUtilities.equal(this.line, legendItem.line)) {
            return false;
        }
        if (!this.lineStroke.equals(legendItem.lineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.linePaint, legendItem.linePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.labelFont, legendItem.labelFont)) {
            return false;
        }
        return PaintUtilities.equal(this.labelPaint, legendItem.labelPaint);
    }

    public Object clone() {
        PublicCloneable publicCloneable;
        LegendItem legendItem = (LegendItem)super.clone();
        if (this.seriesKey instanceof PublicCloneable) {
            publicCloneable = (PublicCloneable)((Object)this.seriesKey);
            legendItem.seriesKey = (Comparable)publicCloneable.clone();
        }
        legendItem.shape = ShapeUtilities.clone(this.shape);
        if (this.fillPaintTransformer instanceof PublicCloneable) {
            publicCloneable = (PublicCloneable)((Object)this.fillPaintTransformer);
            legendItem.fillPaintTransformer = (GradientPaintTransformer)publicCloneable.clone();
        }
        legendItem.line = ShapeUtilities.clone(this.line);
        return legendItem;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeAttributedString(this.attributedLabel, objectOutputStream);
        SerialUtilities.writeShape(this.shape, objectOutputStream);
        SerialUtilities.writePaint(this.fillPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.outlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        SerialUtilities.writeShape(this.line, objectOutputStream);
        SerialUtilities.writeStroke(this.lineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.linePaint, objectOutputStream);
        SerialUtilities.writePaint(this.labelPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.attributedLabel = SerialUtilities.readAttributedString(objectInputStream);
        this.shape = SerialUtilities.readShape(objectInputStream);
        this.fillPaint = SerialUtilities.readPaint(objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.line = SerialUtilities.readShape(objectInputStream);
        this.lineStroke = SerialUtilities.readStroke(objectInputStream);
        this.linePaint = SerialUtilities.readPaint(objectInputStream);
        this.labelPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

