/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import org.jfree.util.BooleanList;
import org.jfree.util.PaintList;
import org.jfree.util.StrokeList;

public class HashUtilities {
    public static int hashCodeForPaint(Paint paint) {
        int n2;
        if (paint == null) {
            return 0;
        }
        if (paint instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)paint;
            n2 = 193;
            n2 = 37 * n2 + gradientPaint.getColor1().hashCode();
            n2 = 37 * n2 + gradientPaint.getPoint1().hashCode();
            n2 = 37 * n2 + gradientPaint.getColor2().hashCode();
            n2 = 37 * n2 + gradientPaint.getPoint2().hashCode();
        } else {
            n2 = paint.hashCode();
        }
        return n2;
    }

    public static int hashCodeForDoubleArray(double[] dArray) {
        if (dArray == null) {
            return 0;
        }
        int n2 = 193;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            long l2 = Double.doubleToLongBits(dArray[i2]);
            n2 = 29 * n2 + (int)(l2 ^ l2 >>> 32);
        }
        return n2;
    }

    public static int hashCode(int n2, boolean bl2) {
        return 37 * n2 + (bl2 ? 0 : 1);
    }

    public static int hashCode(int n2, int n3) {
        return 37 * n2 + n3;
    }

    public static int hashCode(int n2, double d2) {
        long l2 = Double.doubleToLongBits(d2);
        return 37 * n2 + (int)(l2 ^ l2 >>> 32);
    }

    public static int hashCode(int n2, Paint paint) {
        return 37 * n2 + HashUtilities.hashCodeForPaint(paint);
    }

    public static int hashCode(int n2, Stroke stroke) {
        int n3 = stroke != null ? stroke.hashCode() : 0;
        return 37 * n2 + n3;
    }

    public static int hashCode(int n2, String string) {
        int n3 = string != null ? string.hashCode() : 0;
        return 37 * n2 + n3;
    }

    public static int hashCode(int n2, Comparable comparable) {
        int n3 = comparable != null ? comparable.hashCode() : 0;
        return 37 * n2 + n3;
    }

    public static int hashCode(int n2, Object object) {
        int n3 = object != null ? object.hashCode() : 0;
        return 37 * n2 + n3;
    }

    public static int hashCode(int n2, BooleanList booleanList) {
        if (booleanList == null) {
            return n2;
        }
        int n3 = 127;
        int n4 = booleanList.size();
        n3 = HashUtilities.hashCode(n3, n4);
        if (n4 > 0) {
            n3 = HashUtilities.hashCode(n3, booleanList.getBoolean(0));
            if (n4 > 1) {
                n3 = HashUtilities.hashCode(n3, booleanList.getBoolean(n4 - 1));
                if (n4 > 2) {
                    n3 = HashUtilities.hashCode(n3, booleanList.getBoolean(n4 / 2));
                }
            }
        }
        return 37 * n2 + n3;
    }

    public static int hashCode(int n2, PaintList paintList) {
        if (paintList == null) {
            return n2;
        }
        int n3 = 127;
        int n4 = paintList.size();
        n3 = HashUtilities.hashCode(n3, n4);
        if (n4 > 0) {
            n3 = HashUtilities.hashCode(n3, paintList.getPaint(0));
            if (n4 > 1) {
                n3 = HashUtilities.hashCode(n3, paintList.getPaint(n4 - 1));
                if (n4 > 2) {
                    n3 = HashUtilities.hashCode(n3, paintList.getPaint(n4 / 2));
                }
            }
        }
        return 37 * n2 + n3;
    }

    public static int hashCode(int n2, StrokeList strokeList) {
        if (strokeList == null) {
            return n2;
        }
        int n3 = 127;
        int n4 = strokeList.size();
        n3 = HashUtilities.hashCode(n3, n4);
        if (n4 > 0) {
            n3 = HashUtilities.hashCode(n3, strokeList.getStroke(0));
            if (n4 > 1) {
                n3 = HashUtilities.hashCode(n3, strokeList.getStroke(n4 - 1));
                if (n4 > 2) {
                    n3 = HashUtilities.hashCode(n3, strokeList.getStroke(n4 / 2));
                }
            }
        }
        return 37 * n2 + n3;
    }
}

