/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jfree.chart.JFreeChart;

public class ChartTransferable
implements Transferable {
    final DataFlavor imageFlavor = new DataFlavor("image/x-java-image; class=java.awt.Image", "Image");
    private JFreeChart chart;
    private int width;
    private int height;
    private int minDrawWidth;
    private int minDrawHeight;
    private int maxDrawWidth;
    private int maxDrawHeight;

    public ChartTransferable(JFreeChart jFreeChart, int n2, int n3) {
        this(jFreeChart, n2, n3, true);
    }

    public ChartTransferable(JFreeChart jFreeChart, int n2, int n3, boolean bl2) {
        this(jFreeChart, n2, n3, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, true);
    }

    public ChartTransferable(JFreeChart jFreeChart, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        try {
            this.chart = (JFreeChart)jFreeChart.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.chart = jFreeChart;
        }
        this.width = n2;
        this.height = n3;
        this.minDrawWidth = n4;
        this.minDrawHeight = n5;
        this.maxDrawWidth = n6;
        this.maxDrawHeight = n7;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.imageFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.imageFlavor.equals(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) {
        if (this.imageFlavor.equals(dataFlavor)) {
            return this.createBufferedImage(this.chart, this.width, this.height, this.minDrawWidth, this.minDrawHeight, this.maxDrawWidth, this.maxDrawHeight);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    private BufferedImage createBufferedImage(JFreeChart jFreeChart, int n2, int n3, int n4, int n5, int n6, int n7) {
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        boolean bl2 = false;
        double d2 = n2;
        double d3 = n3;
        double d4 = 1.0;
        double d5 = 1.0;
        if (d2 < (double)n4) {
            d4 = d2 / (double)n4;
            d2 = n4;
            bl2 = true;
        } else if (d2 > (double)n6) {
            d4 = d2 / (double)n6;
            d2 = n6;
            bl2 = true;
        }
        if (d3 < (double)n5) {
            d5 = d3 / (double)n5;
            d3 = n5;
            bl2 = true;
        } else if (d3 > (double)n7) {
            d5 = d3 / (double)n7;
            d3 = n7;
            bl2 = true;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, d2, d3);
        if (bl2) {
            AffineTransform affineTransform = AffineTransform.getScaleInstance(d4, d5);
            graphics2D.transform(affineTransform);
        }
        jFreeChart.draw(graphics2D, double_, null, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

