/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryAxis3D;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.axis.Timeline;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.BoxAndWhiskerToolTipGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.HighLowItemLabelGenerator;
import org.jfree.chart.labels.IntervalCategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.StandardXYZToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.plot.RingPlot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.WaferMapPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.DefaultPolarItemRenderer;
import org.jfree.chart.renderer.WaferMapRenderer;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.GanttRenderer;
import org.jfree.chart.renderer.category.GradientBarPainter;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.LineRenderer3D;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.renderer.category.WaterfallBarRenderer;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.GradientXYBarPainter;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.WindItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYBoxAndWhiskerRenderer;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.StandardXYZURLGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.WaferMapDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.WindDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.PublicCloneable;
import org.jfree.util.SortOrder;
import org.jfree.util.TableOrder;

public abstract class ChartFactory {
    private static ChartTheme currentTheme = new StandardChartTheme("JFree");

    public static ChartTheme getChartTheme() {
        return currentTheme;
    }

    public static void setChartTheme(ChartTheme chartTheme) {
        ParamChecks.nullNotPermitted(chartTheme, "theme");
        currentTheme = chartTheme;
        if (chartTheme instanceof StandardChartTheme) {
            StandardChartTheme standardChartTheme = (StandardChartTheme)chartTheme;
            if (standardChartTheme.getName().equals("Legacy")) {
                BarRenderer.setDefaultBarPainter(new StandardBarPainter());
                XYBarRenderer.setDefaultBarPainter(new StandardXYBarPainter());
            } else {
                BarRenderer.setDefaultBarPainter(new GradientBarPainter());
                XYBarRenderer.setDefaultBarPainter(new GradientXYBarPainter());
            }
        }
    }

    public static JFreeChart createPieChart(String string, PieDataset pieDataset, boolean bl2, boolean bl3, Locale locale) {
        PiePlot piePlot = new PiePlot(pieDataset);
        piePlot.setLabelGenerator(new StandardPieSectionLabelGenerator(locale));
        piePlot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        if (bl3) {
            piePlot.setToolTipGenerator(new StandardPieToolTipGenerator(locale));
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, piePlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createPieChart(String string, PieDataset pieDataset) {
        return ChartFactory.createPieChart(string, pieDataset, true, true, false);
    }

    public static JFreeChart createPieChart(String string, PieDataset pieDataset, boolean bl2, boolean bl3, boolean bl4) {
        PiePlot piePlot = new PiePlot(pieDataset);
        piePlot.setLabelGenerator(new StandardPieSectionLabelGenerator());
        piePlot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        if (bl3) {
            piePlot.setToolTipGenerator(new StandardPieToolTipGenerator());
        }
        if (bl4) {
            piePlot.setURLGenerator(new StandardPieURLGenerator());
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, piePlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createPieChart(String string, PieDataset pieDataset, PieDataset pieDataset2, int n2, boolean bl2, boolean bl3, boolean bl4, Locale locale, boolean bl5, boolean bl6) {
        PiePlot piePlot = new PiePlot(pieDataset);
        piePlot.setLabelGenerator(new StandardPieSectionLabelGenerator(locale));
        piePlot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        if (bl4) {
            piePlot.setToolTipGenerator(new StandardPieToolTipGenerator(locale));
        }
        List list = pieDataset.getKeys();
        DefaultPieDataset defaultPieDataset = null;
        if (bl6) {
            defaultPieDataset = new DefaultPieDataset();
        }
        double d2 = 255.0 / (double)n2;
        for (Object object : list) {
            double d3;
            Number number = pieDataset.getValue((Comparable)object);
            Number number2 = pieDataset2.getValue((Comparable)object);
            if (number2 == null) {
                if (bl2) {
                    piePlot.setSectionPaint((Comparable)object, (Paint)Color.green);
                } else {
                    piePlot.setSectionPaint((Comparable)object, (Paint)Color.red);
                }
                if (!bl6) continue;
                assert (defaultPieDataset != null);
                defaultPieDataset.setValue((Comparable)((Object)(object + " (+100%)")), number);
                continue;
            }
            double d4 = (number.doubleValue() / number2.doubleValue() - 1.0) * 100.0;
            double d5 = d3 = Math.abs(d4) >= (double)n2 ? 255.0 : Math.abs(d4) * d2;
            if (bl2 && number.doubleValue() > number2.doubleValue() || !bl2 && number.doubleValue() < number2.doubleValue()) {
                piePlot.setSectionPaint((Comparable)object, (Paint)new Color(0, (int)d3, 0));
            } else {
                piePlot.setSectionPaint((Comparable)object, (Paint)new Color((int)d3, 0, 0));
            }
            if (!bl6) continue;
            assert (defaultPieDataset != null);
            defaultPieDataset.setValue((Comparable)((Object)(object + " (" + (d4 >= 0.0 ? "+" : "") + NumberFormat.getPercentInstance().format(d4 / 100.0) + ")")), number);
        }
        if (bl6) {
            piePlot.setDataset(defaultPieDataset);
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, piePlot, bl3);
        if (bl5) {
            Object object;
            object = new TextTitle("Bright " + (bl2 ? "red" : "green") + "=change >=-" + n2 + "%, Bright " + (!bl2 ? "red" : "green") + "=change >=+" + n2 + "%", new Font("SansSerif", 0, 10));
            jFreeChart.addSubtitle((Title)object);
        }
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createPieChart(String string, PieDataset pieDataset, PieDataset pieDataset2, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        PiePlot piePlot = new PiePlot(pieDataset);
        piePlot.setLabelGenerator(new StandardPieSectionLabelGenerator());
        piePlot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        if (bl4) {
            piePlot.setToolTipGenerator(new StandardPieToolTipGenerator());
        }
        if (bl5) {
            piePlot.setURLGenerator(new StandardPieURLGenerator());
        }
        List list = pieDataset.getKeys();
        DefaultPieDataset defaultPieDataset = null;
        if (bl7) {
            defaultPieDataset = new DefaultPieDataset();
        }
        double d2 = 255.0 / (double)n2;
        for (Object object : list) {
            double d3;
            Number number = pieDataset.getValue((Comparable)object);
            Number number2 = pieDataset2.getValue((Comparable)object);
            if (number2 == null) {
                if (bl2) {
                    piePlot.setSectionPaint((Comparable)object, (Paint)Color.green);
                } else {
                    piePlot.setSectionPaint((Comparable)object, (Paint)Color.red);
                }
                if (!bl7) continue;
                assert (defaultPieDataset != null);
                defaultPieDataset.setValue((Comparable)((Object)(object + " (+100%)")), number);
                continue;
            }
            double d4 = (number.doubleValue() / number2.doubleValue() - 1.0) * 100.0;
            double d5 = d3 = Math.abs(d4) >= (double)n2 ? 255.0 : Math.abs(d4) * d2;
            if (bl2 && number.doubleValue() > number2.doubleValue() || !bl2 && number.doubleValue() < number2.doubleValue()) {
                piePlot.setSectionPaint((Comparable)object, (Paint)new Color(0, (int)d3, 0));
            } else {
                piePlot.setSectionPaint((Comparable)object, (Paint)new Color((int)d3, 0, 0));
            }
            if (!bl7) continue;
            assert (defaultPieDataset != null);
            defaultPieDataset.setValue((Comparable)((Object)(object + " (" + (d4 >= 0.0 ? "+" : "") + NumberFormat.getPercentInstance().format(d4 / 100.0) + ")")), number);
        }
        if (bl7) {
            piePlot.setDataset(defaultPieDataset);
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, piePlot, bl3);
        if (bl6) {
            Object object;
            object = new TextTitle("Bright " + (bl2 ? "red" : "green") + "=change >=-" + n2 + "%, Bright " + (!bl2 ? "red" : "green") + "=change >=+" + n2 + "%", new Font("SansSerif", 0, 10));
            jFreeChart.addSubtitle((Title)object);
        }
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createRingChart(String string, PieDataset pieDataset, boolean bl2, boolean bl3, Locale locale) {
        RingPlot ringPlot = new RingPlot(pieDataset);
        ringPlot.setLabelGenerator(new StandardPieSectionLabelGenerator(locale));
        ringPlot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        if (bl3) {
            ringPlot.setToolTipGenerator(new StandardPieToolTipGenerator(locale));
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, ringPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createRingChart(String string, PieDataset pieDataset, boolean bl2, boolean bl3, boolean bl4) {
        RingPlot ringPlot = new RingPlot(pieDataset);
        ringPlot.setLabelGenerator(new StandardPieSectionLabelGenerator());
        ringPlot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        if (bl3) {
            ringPlot.setToolTipGenerator(new StandardPieToolTipGenerator());
        }
        if (bl4) {
            ringPlot.setURLGenerator(new StandardPieURLGenerator());
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, ringPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createMultiplePieChart(String string, CategoryDataset categoryDataset, TableOrder tableOrder, boolean bl2, boolean bl3, boolean bl4) {
        PiePlot piePlot;
        Serializable serializable;
        ParamChecks.nullNotPermitted(tableOrder, "order");
        MultiplePiePlot multiplePiePlot = new MultiplePiePlot(categoryDataset);
        multiplePiePlot.setDataExtractOrder(tableOrder);
        multiplePiePlot.setBackgroundPaint(null);
        multiplePiePlot.setOutlineStroke(null);
        if (bl3) {
            serializable = new StandardPieToolTipGenerator();
            piePlot = (PiePlot)multiplePiePlot.getPieChart().getPlot();
            piePlot.setToolTipGenerator((PieToolTipGenerator)((Object)serializable));
        }
        if (bl4) {
            serializable = new StandardPieURLGenerator();
            piePlot = (PiePlot)multiplePiePlot.getPieChart().getPlot();
            piePlot.setURLGenerator((PieURLGenerator)((Object)serializable));
        }
        serializable = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, multiplePiePlot, bl2);
        currentTheme.apply((JFreeChart)serializable);
        return serializable;
    }

    public static JFreeChart createPieChart3D(String string, PieDataset pieDataset, boolean bl2, boolean bl3, Locale locale) {
        ParamChecks.nullNotPermitted(locale, "locale");
        PiePlot3D piePlot3D = new PiePlot3D(pieDataset);
        piePlot3D.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        if (bl3) {
            piePlot3D.setToolTipGenerator(new StandardPieToolTipGenerator(locale));
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, piePlot3D, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createPieChart3D(String string, PieDataset pieDataset) {
        return ChartFactory.createPieChart3D(string, pieDataset, true, true, false);
    }

    public static JFreeChart createPieChart3D(String string, PieDataset pieDataset, boolean bl2, boolean bl3, boolean bl4) {
        PiePlot3D piePlot3D = new PiePlot3D(pieDataset);
        piePlot3D.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        if (bl3) {
            piePlot3D.setToolTipGenerator(new StandardPieToolTipGenerator());
        }
        if (bl4) {
            piePlot3D.setURLGenerator(new StandardPieURLGenerator());
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, piePlot3D, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createMultiplePieChart3D(String string, CategoryDataset categoryDataset, TableOrder tableOrder, boolean bl2, boolean bl3, boolean bl4) {
        PiePlot piePlot;
        Serializable serializable;
        ParamChecks.nullNotPermitted(tableOrder, "order");
        MultiplePiePlot multiplePiePlot = new MultiplePiePlot(categoryDataset);
        multiplePiePlot.setDataExtractOrder(tableOrder);
        multiplePiePlot.setBackgroundPaint(null);
        multiplePiePlot.setOutlineStroke(null);
        JFreeChart jFreeChart = new JFreeChart(new PiePlot3D(null));
        TextTitle textTitle = new TextTitle("Series Title", new Font("SansSerif", 1, 12));
        textTitle.setPosition(RectangleEdge.BOTTOM);
        jFreeChart.setTitle(textTitle);
        jFreeChart.removeLegend();
        jFreeChart.setBackgroundPaint(null);
        multiplePiePlot.setPieChart(jFreeChart);
        if (bl3) {
            serializable = new StandardPieToolTipGenerator();
            piePlot = (PiePlot)multiplePiePlot.getPieChart().getPlot();
            piePlot.setToolTipGenerator((PieToolTipGenerator)((Object)serializable));
        }
        if (bl4) {
            serializable = new StandardPieURLGenerator();
            piePlot = (PiePlot)multiplePiePlot.getPieChart().getPlot();
            piePlot.setURLGenerator((PieURLGenerator)((Object)serializable));
        }
        serializable = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, multiplePiePlot, bl2);
        currentTheme.apply((JFreeChart)serializable);
        return serializable;
    }

    public static JFreeChart createBarChart(String string, String string2, String string3, CategoryDataset categoryDataset) {
        return ChartFactory.createBarChart(string, string2, string3, categoryDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createBarChart(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        Serializable serializable;
        Serializable serializable2;
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        BarRenderer barRenderer = new BarRenderer();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            serializable2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.CENTER_LEFT);
            barRenderer.setBasePositiveItemLabelPosition((ItemLabelPosition)serializable2);
            serializable = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE9, TextAnchor.CENTER_RIGHT);
            barRenderer.setBaseNegativeItemLabelPosition((ItemLabelPosition)serializable);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            serializable2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
            barRenderer.setBasePositiveItemLabelPosition((ItemLabelPosition)serializable2);
            serializable = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
            barRenderer.setBaseNegativeItemLabelPosition((ItemLabelPosition)serializable);
        }
        if (bl3) {
            barRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        }
        if (bl4) {
            barRenderer.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        serializable2 = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, barRenderer);
        ((CategoryPlot)serializable2).setOrientation(plotOrientation);
        serializable = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, (Plot)serializable2, bl2);
        currentTheme.apply((JFreeChart)serializable);
        return serializable;
    }

    public static JFreeChart createStackedBarChart(String string, String string2, String string3, CategoryDataset categoryDataset) {
        return ChartFactory.createStackedBarChart(string, string2, string3, categoryDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createStackedBarChart(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        StackedBarRenderer stackedBarRenderer = new StackedBarRenderer();
        if (bl3) {
            stackedBarRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        }
        if (bl4) {
            stackedBarRenderer.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, stackedBarRenderer);
        categoryPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createBarChart3D(String string, String string2, String string3, CategoryDataset categoryDataset) {
        return ChartFactory.createBarChart3D(string, string2, string3, categoryDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createBarChart3D(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        CategoryAxis3D categoryAxis3D = new CategoryAxis3D(string2);
        NumberAxis3D numberAxis3D = new NumberAxis3D(string3);
        BarRenderer3D barRenderer3D = new BarRenderer3D();
        if (bl3) {
            barRenderer3D.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        }
        if (bl4) {
            barRenderer3D.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis3D, numberAxis3D, barRenderer3D);
        categoryPlot.setOrientation(plotOrientation);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            categoryPlot.setRowRenderingOrder(SortOrder.DESCENDING);
            categoryPlot.setColumnRenderingOrder(SortOrder.DESCENDING);
        }
        categoryPlot.setForegroundAlpha(0.75f);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createStackedBarChart3D(String string, String string2, String string3, CategoryDataset categoryDataset) {
        return ChartFactory.createStackedBarChart3D(string, string2, string3, categoryDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createStackedBarChart3D(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        CategoryAxis3D categoryAxis3D = new CategoryAxis3D(string2);
        NumberAxis3D numberAxis3D = new NumberAxis3D(string3);
        StackedBarRenderer3D stackedBarRenderer3D = new StackedBarRenderer3D();
        if (bl3) {
            stackedBarRenderer3D.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        }
        if (bl4) {
            stackedBarRenderer3D.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis3D, numberAxis3D, stackedBarRenderer3D);
        categoryPlot.setOrientation(plotOrientation);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            categoryPlot.setColumnRenderingOrder(SortOrder.DESCENDING);
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createAreaChart(String string, String string2, String string3, CategoryDataset categoryDataset) {
        return ChartFactory.createAreaChart(string, string2, string3, categoryDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createAreaChart(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        categoryAxis.setCategoryMargin(0.0);
        NumberAxis numberAxis = new NumberAxis(string3);
        AreaRenderer areaRenderer = new AreaRenderer();
        if (bl3) {
            areaRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        }
        if (bl4) {
            areaRenderer.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, areaRenderer);
        categoryPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createStackedAreaChart(String string, String string2, String string3, CategoryDataset categoryDataset) {
        return ChartFactory.createStackedAreaChart(string, string2, string3, categoryDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createStackedAreaChart(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        categoryAxis.setCategoryMargin(0.0);
        NumberAxis numberAxis = new NumberAxis(string3);
        StackedAreaRenderer stackedAreaRenderer = new StackedAreaRenderer();
        if (bl3) {
            stackedAreaRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        }
        if (bl4) {
            stackedAreaRenderer.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, stackedAreaRenderer);
        categoryPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createLineChart(String string, String string2, String string3, CategoryDataset categoryDataset) {
        return ChartFactory.createLineChart(string, string2, string3, categoryDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createLineChart(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer(true, false);
        if (bl3) {
            lineAndShapeRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        }
        if (bl4) {
            lineAndShapeRenderer.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, lineAndShapeRenderer);
        categoryPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createLineChart3D(String string, String string2, String string3, CategoryDataset categoryDataset) {
        return ChartFactory.createLineChart3D(string, string2, string3, categoryDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createLineChart3D(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        CategoryAxis3D categoryAxis3D = new CategoryAxis3D(string2);
        NumberAxis3D numberAxis3D = new NumberAxis3D(string3);
        LineRenderer3D lineRenderer3D = new LineRenderer3D();
        if (bl3) {
            lineRenderer3D.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        }
        if (bl4) {
            lineRenderer3D.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis3D, numberAxis3D, lineRenderer3D);
        categoryPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createGanttChart(String string, String string2, String string3, IntervalCategoryDataset intervalCategoryDataset) {
        return ChartFactory.createGanttChart(string, string2, string3, intervalCategoryDataset, true, true, false);
    }

    public static JFreeChart createGanttChart(String string, String string2, String string3, IntervalCategoryDataset intervalCategoryDataset, boolean bl2, boolean bl3, boolean bl4) {
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        DateAxis dateAxis = new DateAxis(string3);
        GanttRenderer ganttRenderer = new GanttRenderer();
        if (bl3) {
            ganttRenderer.setBaseToolTipGenerator(new IntervalCategoryToolTipGenerator("{3} - {4}", DateFormat.getDateInstance()));
        }
        if (bl4) {
            ganttRenderer.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(intervalCategoryDataset, categoryAxis, dateAxis, ganttRenderer);
        categoryPlot.setOrientation(PlotOrientation.HORIZONTAL);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createWaterfallChart(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        Serializable serializable;
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        categoryAxis.setCategoryMargin(0.0);
        NumberAxis numberAxis = new NumberAxis(string3);
        WaterfallBarRenderer waterfallBarRenderer = new WaterfallBarRenderer();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            serializable = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 1.5707963267948966);
            waterfallBarRenderer.setBasePositiveItemLabelPosition((ItemLabelPosition)serializable);
            waterfallBarRenderer.setBaseNegativeItemLabelPosition((ItemLabelPosition)serializable);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            serializable = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
            waterfallBarRenderer.setBasePositiveItemLabelPosition((ItemLabelPosition)serializable);
            waterfallBarRenderer.setBaseNegativeItemLabelPosition((ItemLabelPosition)serializable);
        }
        if (bl3) {
            serializable = new StandardCategoryToolTipGenerator();
            waterfallBarRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)((Object)serializable));
        }
        if (bl4) {
            waterfallBarRenderer.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        serializable = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, waterfallBarRenderer);
        ((CategoryPlot)serializable).clearRangeMarkers();
        ValueMarker valueMarker = new ValueMarker(0.0);
        valueMarker.setPaint(Color.black);
        ((CategoryPlot)serializable).addRangeMarker(valueMarker, Layer.FOREGROUND);
        ((CategoryPlot)serializable).setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, (Plot)serializable, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createPolarChart(String string, XYDataset xYDataset, boolean bl2, boolean bl3, boolean bl4) {
        PolarPlot polarPlot = new PolarPlot();
        polarPlot.setDataset(xYDataset);
        NumberAxis numberAxis = new NumberAxis();
        numberAxis.setAxisLineVisible(false);
        numberAxis.setTickMarksVisible(false);
        numberAxis.setTickLabelInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        polarPlot.setAxis(numberAxis);
        polarPlot.setRenderer(new DefaultPolarItemRenderer());
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, polarPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createScatterPlot(String string, String string2, String string3, XYDataset xYDataset) {
        return ChartFactory.createScatterPlot(string, string2, string3, xYDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createScatterPlot(String string, String string2, String string3, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        numberAxis2.setAutoRangeIncludesZero(false);
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis, numberAxis2, null);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl3) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl4) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer(false, true);
        xYLineAndShapeRenderer.setBaseToolTipGenerator(standardXYToolTipGenerator);
        xYLineAndShapeRenderer.setURLGenerator(standardXYURLGenerator);
        xYPlot.setRenderer(xYLineAndShapeRenderer);
        xYPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createXYBarChart(String string, String string2, boolean bl2, String string3, IntervalXYDataset intervalXYDataset) {
        return ChartFactory.createXYBarChart(string, string2, bl2, string3, intervalXYDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createXYBarChart(String string, String string2, boolean bl2, String string3, IntervalXYDataset intervalXYDataset, PlotOrientation plotOrientation, boolean bl3, boolean bl4, boolean bl5) {
        PublicCloneable publicCloneable;
        NumberAxis numberAxis;
        ValueAxis valueAxis;
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        if (bl2) {
            valueAxis = new DateAxis(string2);
        } else {
            numberAxis = new NumberAxis(string2);
            numberAxis.setAutoRangeIncludesZero(false);
            valueAxis = numberAxis;
        }
        numberAxis = new NumberAxis(string3);
        XYBarRenderer xYBarRenderer = new XYBarRenderer();
        if (bl4) {
            publicCloneable = bl2 ? StandardXYToolTipGenerator.getTimeSeriesInstance() : new StandardXYToolTipGenerator();
            xYBarRenderer.setBaseToolTipGenerator((XYToolTipGenerator)((Object)publicCloneable));
        }
        if (bl5) {
            xYBarRenderer.setURLGenerator(new StandardXYURLGenerator());
        }
        publicCloneable = new XYPlot(intervalXYDataset, valueAxis, numberAxis, xYBarRenderer);
        ((XYPlot)publicCloneable).setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, (Plot)publicCloneable, bl3);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createXYAreaChart(String string, String string2, String string3, XYDataset xYDataset) {
        return ChartFactory.createXYAreaChart(string, string2, string3, xYDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createXYAreaChart(String string, String string2, String string3, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis, numberAxis2, null);
        xYPlot.setOrientation(plotOrientation);
        xYPlot.setForegroundAlpha(0.5f);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl3) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl4) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        xYPlot.setRenderer(new XYAreaRenderer(4, standardXYToolTipGenerator, standardXYURLGenerator));
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createStackedXYAreaChart(String string, String string2, String string3, TableXYDataset tableXYDataset) {
        return ChartFactory.createStackedXYAreaChart(string, string2, string3, tableXYDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createStackedXYAreaChart(String string, String string2, String string3, TableXYDataset tableXYDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        numberAxis.setLowerMargin(0.0);
        numberAxis.setUpperMargin(0.0);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl3) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl4) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        StackedXYAreaRenderer2 stackedXYAreaRenderer2 = new StackedXYAreaRenderer2(standardXYToolTipGenerator, standardXYURLGenerator);
        stackedXYAreaRenderer2.setOutline(true);
        XYPlot xYPlot = new XYPlot(tableXYDataset, numberAxis, numberAxis2, stackedXYAreaRenderer2);
        xYPlot.setOrientation(plotOrientation);
        xYPlot.setRangeAxis(numberAxis2);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createXYLineChart(String string, String string2, String string3, XYDataset xYDataset) {
        return ChartFactory.createXYLineChart(string, string2, string3, xYDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createXYLineChart(String string, String string2, String string3, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer(true, false);
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis, numberAxis2, xYLineAndShapeRenderer);
        xYPlot.setOrientation(plotOrientation);
        if (bl3) {
            xYLineAndShapeRenderer.setBaseToolTipGenerator(new StandardXYToolTipGenerator());
        }
        if (bl4) {
            xYLineAndShapeRenderer.setURLGenerator(new StandardXYURLGenerator());
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createXYStepChart(String string, String string2, String string3, XYDataset xYDataset) {
        return ChartFactory.createXYStepChart(string, string2, string3, xYDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createXYStepChart(String string, String string2, String string3, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        DateAxis dateAxis = new DateAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl3) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl4) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        XYStepRenderer xYStepRenderer = new XYStepRenderer(standardXYToolTipGenerator, standardXYURLGenerator);
        XYPlot xYPlot = new XYPlot(xYDataset, dateAxis, numberAxis, null);
        xYPlot.setRenderer(xYStepRenderer);
        xYPlot.setOrientation(plotOrientation);
        xYPlot.setDomainCrosshairVisible(false);
        xYPlot.setRangeCrosshairVisible(false);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createXYStepAreaChart(String string, String string2, String string3, XYDataset xYDataset) {
        return ChartFactory.createXYStepAreaChart(string, string2, string3, xYDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createXYStepAreaChart(String string, String string2, String string3, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl3) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl4) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        XYStepAreaRenderer xYStepAreaRenderer = new XYStepAreaRenderer(3, standardXYToolTipGenerator, standardXYURLGenerator);
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis, numberAxis2, null);
        xYPlot.setRenderer(xYStepAreaRenderer);
        xYPlot.setOrientation(plotOrientation);
        xYPlot.setDomainCrosshairVisible(false);
        xYPlot.setRangeCrosshairVisible(false);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createTimeSeriesChart(String string, String string2, String string3, XYDataset xYDataset) {
        return ChartFactory.createTimeSeriesChart(string, string2, string3, xYDataset, true, true, false);
    }

    public static JFreeChart createTimeSeriesChart(String string, String string2, String string3, XYDataset xYDataset, boolean bl2, boolean bl3, boolean bl4) {
        DateAxis dateAxis = new DateAxis(string2);
        dateAxis.setLowerMargin(0.02);
        dateAxis.setUpperMargin(0.02);
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setAutoRangeIncludesZero(false);
        XYPlot xYPlot = new XYPlot(xYDataset, dateAxis, numberAxis, null);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl3) {
            standardXYToolTipGenerator = StandardXYToolTipGenerator.getTimeSeriesInstance();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl4) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer(true, false);
        xYLineAndShapeRenderer.setBaseToolTipGenerator(standardXYToolTipGenerator);
        xYLineAndShapeRenderer.setURLGenerator(standardXYURLGenerator);
        xYPlot.setRenderer(xYLineAndShapeRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createCandlestickChart(String string, String string2, String string3, OHLCDataset oHLCDataset, boolean bl2) {
        DateAxis dateAxis = new DateAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        XYPlot xYPlot = new XYPlot(oHLCDataset, dateAxis, numberAxis, null);
        xYPlot.setRenderer(new CandlestickRenderer());
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createHighLowChart(String string, String string2, String string3, OHLCDataset oHLCDataset, boolean bl2) {
        DateAxis dateAxis = new DateAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        HighLowRenderer highLowRenderer = new HighLowRenderer();
        highLowRenderer.setBaseToolTipGenerator(new HighLowItemLabelGenerator());
        XYPlot xYPlot = new XYPlot(oHLCDataset, dateAxis, numberAxis, highLowRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createHighLowChart(String string, String string2, String string3, OHLCDataset oHLCDataset, Timeline timeline, boolean bl2) {
        DateAxis dateAxis = new DateAxis(string2);
        dateAxis.setTimeline(timeline);
        NumberAxis numberAxis = new NumberAxis(string3);
        HighLowRenderer highLowRenderer = new HighLowRenderer();
        highLowRenderer.setBaseToolTipGenerator(new HighLowItemLabelGenerator());
        XYPlot xYPlot = new XYPlot(oHLCDataset, dateAxis, numberAxis, highLowRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createBubbleChart(String string, String string2, String string3, XYZDataset xYZDataset) {
        return ChartFactory.createBubbleChart(string, string2, string3, xYZDataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public static JFreeChart createBubbleChart(String string, String string2, String string3, XYZDataset xYZDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        numberAxis2.setAutoRangeIncludesZero(false);
        XYPlot xYPlot = new XYPlot(xYZDataset, numberAxis, numberAxis2, null);
        XYBubbleRenderer xYBubbleRenderer = new XYBubbleRenderer(2);
        if (bl3) {
            xYBubbleRenderer.setBaseToolTipGenerator(new StandardXYZToolTipGenerator());
        }
        if (bl4) {
            xYBubbleRenderer.setURLGenerator(new StandardXYZURLGenerator());
        }
        xYPlot.setRenderer(xYBubbleRenderer);
        xYPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createHistogram(String string, String string2, String string3, IntervalXYDataset intervalXYDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        XYBarRenderer xYBarRenderer = new XYBarRenderer();
        if (bl3) {
            xYBarRenderer.setBaseToolTipGenerator(new StandardXYToolTipGenerator());
        }
        if (bl4) {
            xYBarRenderer.setURLGenerator(new StandardXYURLGenerator());
        }
        XYPlot xYPlot = new XYPlot(intervalXYDataset, numberAxis, numberAxis2, xYBarRenderer);
        xYPlot.setOrientation(plotOrientation);
        xYPlot.setDomainZeroBaselineVisible(true);
        xYPlot.setRangeZeroBaselineVisible(true);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createBoxAndWhiskerChart(String string, String string2, String string3, BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset, boolean bl2) {
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setAutoRangeIncludesZero(false);
        BoxAndWhiskerRenderer boxAndWhiskerRenderer = new BoxAndWhiskerRenderer();
        boxAndWhiskerRenderer.setBaseToolTipGenerator(new BoxAndWhiskerToolTipGenerator());
        CategoryPlot categoryPlot = new CategoryPlot(boxAndWhiskerCategoryDataset, categoryAxis, numberAxis, boxAndWhiskerRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createBoxAndWhiskerChart(String string, String string2, String string3, BoxAndWhiskerXYDataset boxAndWhiskerXYDataset, boolean bl2) {
        DateAxis dateAxis = new DateAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setAutoRangeIncludesZero(false);
        XYBoxAndWhiskerRenderer xYBoxAndWhiskerRenderer = new XYBoxAndWhiskerRenderer(10.0);
        XYPlot xYPlot = new XYPlot(boxAndWhiskerXYDataset, dateAxis, numberAxis, xYBoxAndWhiskerRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createWindPlot(String string, String string2, String string3, WindDataset windDataset, boolean bl2, boolean bl3, boolean bl4) {
        DateAxis dateAxis = new DateAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setRange(-12.0, 12.0);
        WindItemRenderer windItemRenderer = new WindItemRenderer();
        if (bl3) {
            windItemRenderer.setBaseToolTipGenerator(new StandardXYToolTipGenerator());
        }
        if (bl4) {
            windItemRenderer.setURLGenerator(new StandardXYURLGenerator());
        }
        XYPlot xYPlot = new XYPlot(windDataset, dateAxis, numberAxis, windItemRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createWaferMapChart(String string, WaferMapDataset waferMapDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        WaferMapPlot waferMapPlot = new WaferMapPlot(waferMapDataset);
        WaferMapRenderer waferMapRenderer = new WaferMapRenderer();
        waferMapPlot.setRenderer(waferMapRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, waferMapPlot, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }
}

