/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.modules;

import org.jfree.base.modules.Module;
import org.jfree.base.modules.ModuleInitializeException;
import org.jfree.base.modules.SubSystem;
import org.jfree.util.Log;

public class PackageState {
    public static final int STATE_NEW = 0;
    public static final int STATE_CONFIGURED = 1;
    public static final int STATE_INITIALIZED = 2;
    public static final int STATE_ERROR = -2;
    private final Module module;
    private int state;

    public PackageState(Module module) {
        this(module, 0);
    }

    public PackageState(Module module, int n2) {
        if (module == null) {
            throw new NullPointerException("Module must not be null.");
        }
        if (n2 != 1 && n2 != -2 && n2 != 2 && n2 != 0) {
            throw new IllegalArgumentException("State is not valid");
        }
        this.module = module;
        this.state = n2;
    }

    public boolean configure(SubSystem subSystem) {
        if (this.state == 0) {
            try {
                this.module.configure(subSystem);
                this.state = 1;
                return true;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Log.warn(new Log.SimpleMessage("Unable to load module classes for ", this.module.getName(), ":", noClassDefFoundError.getMessage()));
                this.state = -2;
            }
            catch (Exception exception) {
                if (Log.isDebugEnabled()) {
                    Log.warn("Unable to configure the module " + this.module.getName(), exception);
                } else if (Log.isWarningEnabled()) {
                    Log.warn("Unable to configure the module " + this.module.getName());
                }
                this.state = -2;
            }
        }
        return false;
    }

    public Module getModule() {
        return this.module;
    }

    public int getState() {
        return this.state;
    }

    public boolean initialize(SubSystem subSystem) {
        if (this.state == 1) {
            try {
                this.module.initialize(subSystem);
                this.state = 2;
                return true;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Log.warn(new Log.SimpleMessage("Unable to load module classes for ", this.module.getName(), ":", noClassDefFoundError.getMessage()));
                this.state = -2;
            }
            catch (ModuleInitializeException moduleInitializeException) {
                if (Log.isDebugEnabled()) {
                    Log.warn("Unable to initialize the module " + this.module.getName(), moduleInitializeException);
                } else if (Log.isWarningEnabled()) {
                    Log.warn("Unable to initialize the module " + this.module.getName());
                }
                this.state = -2;
            }
            catch (Exception exception) {
                if (Log.isDebugEnabled()) {
                    Log.warn("Unable to initialize the module " + this.module.getName(), exception);
                } else if (Log.isWarningEnabled()) {
                    Log.warn("Unable to initialize the module " + this.module.getName());
                }
                this.state = -2;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PackageState)) {
            return false;
        }
        PackageState packageState = (PackageState)object;
        return this.module.getModuleClass().equals(packageState.module.getModuleClass());
    }

    public int hashCode() {
        return this.module.hashCode();
    }
}

