/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jfree.base.modules.Module;
import org.jfree.base.modules.ModuleInfo;
import org.jfree.base.modules.PackageState;
import org.jfree.util.Log;

public final class PackageSorter {
    private PackageSorter() {
    }

    public static void sort(List list) {
        int n2;
        int n3;
        SortModule sortModule;
        HashMap<String, SortModule> hashMap = new HashMap<String, SortModule>();
        ArrayList<PackageState> arrayList = new ArrayList<PackageState>();
        ArrayList<SortModule> arrayList2 = new ArrayList<SortModule>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            PackageState packageState = (PackageState)list.get(i2);
            if (packageState.getState() == -2) {
                arrayList.add(packageState);
                continue;
            }
            sortModule = new SortModule(packageState);
            arrayList2.add(sortModule);
            hashMap.put(packageState.getModule().getModuleClass(), sortModule);
        }
        Object[] objectArray = arrayList2.toArray(new SortModule[arrayList2.size()]);
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            sortModule = objectArray[n3];
            sortModule.setDependSubsystems(PackageSorter.collectSubsystemModules(sortModule.getState().getModule(), hashMap));
        }
        n3 = 1;
        while (n3 != 0) {
            n3 = 0;
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                Object object = objectArray[i3];
                int n4 = PackageSorter.searchModulePosition((SortModule)object, hashMap);
                if (n4 == ((SortModule)object).getPosition()) continue;
                ((SortModule)object).setPosition(n4);
                n3 = 1;
            }
        }
        Arrays.sort(objectArray);
        list.clear();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            list.add(((SortModule)objectArray[n2]).getState());
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            list.add(arrayList.get(n2));
        }
    }

    private static int searchModulePosition(SortModule sortModule, HashMap hashMap) {
        SortModule sortModule22;
        Object object;
        int n2;
        Module module = sortModule.getState().getModule();
        int n3 = 0;
        ModuleInfo[] moduleInfoArray = module.getOptionalModules();
        for (n2 = 0; n2 < moduleInfoArray.length; ++n2) {
            object = moduleInfoArray[n2].getModuleClass();
            sortModule22 = (SortModule)hashMap.get(object);
            if (sortModule22 == null || sortModule22.getPosition() < n3) continue;
            n3 = sortModule22.getPosition() + 1;
        }
        moduleInfoArray = module.getRequiredModules();
        for (n2 = 0; n2 < moduleInfoArray.length; ++n2) {
            object = moduleInfoArray[n2].getModuleClass();
            sortModule22 = (SortModule)hashMap.get(object);
            if (sortModule22 == null) {
                Log.warn("Invalid state: Required dependency of '" + (String)object + "' had an error.");
                continue;
            }
            if (sortModule22.getPosition() < n3) continue;
            n3 = sortModule22.getPosition() + 1;
        }
        String string = module.getSubSystem();
        for (SortModule sortModule22 : hashMap.values()) {
            Module module2;
            if (sortModule22.getState().getModule() == module || string.equals((module2 = sortModule22.getState().getModule()).getSubSystem()) || !sortModule.getDependSubsystems().contains(module2.getSubSystem()) || PackageSorter.isBaseModule(module2, module) || sortModule22.getPosition() < n3) continue;
            n3 = sortModule22.getPosition() + 1;
        }
        return n3;
    }

    private static boolean isBaseModule(Module module, ModuleInfo moduleInfo) {
        int n2;
        ModuleInfo[] moduleInfoArray = module.getRequiredModules();
        for (n2 = 0; n2 < moduleInfoArray.length; ++n2) {
            if (!moduleInfoArray[n2].getModuleClass().equals(moduleInfo.getModuleClass())) continue;
            return true;
        }
        moduleInfoArray = module.getOptionalModules();
        for (n2 = 0; n2 < moduleInfoArray.length; ++n2) {
            if (!moduleInfoArray[n2].getModuleClass().equals(moduleInfo.getModuleClass())) continue;
            return true;
        }
        return false;
    }

    private static ArrayList collectSubsystemModules(Module module, HashMap hashMap) {
        Object object;
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        ModuleInfo[] moduleInfoArray = module.getRequiredModules();
        for (n2 = 0; n2 < moduleInfoArray.length; ++n2) {
            object = (SortModule)hashMap.get(moduleInfoArray[n2].getModuleClass());
            if (object == null) {
                Log.warn(new Log.SimpleMessage("A dependent module was not found in the list of known modules.", moduleInfoArray[n2].getModuleClass()));
                continue;
            }
            arrayList.add(((SortModule)object).getState().getModule().getSubSystem());
        }
        moduleInfoArray = module.getOptionalModules();
        for (n2 = 0; n2 < moduleInfoArray.length; ++n2) {
            object = (Module)hashMap.get(moduleInfoArray[n2].getModuleClass());
            if (object == null) {
                Log.warn("A dependent module was not found in the list of known modules.");
                continue;
            }
            arrayList.add(object.getSubSystem());
        }
        return arrayList;
    }

    private static class SortModule
    implements Comparable {
        private int position = -1;
        private final PackageState state;
        private ArrayList dependSubsystems;

        public SortModule(PackageState packageState) {
            this.state = packageState;
        }

        public ArrayList getDependSubsystems() {
            return this.dependSubsystems;
        }

        public void setDependSubsystems(ArrayList arrayList) {
            this.dependSubsystems = arrayList;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int n2) {
            this.position = n2;
        }

        public PackageState getState() {
            return this.state;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SortModule: ");
            stringBuffer.append(this.position);
            stringBuffer.append(" ");
            stringBuffer.append(this.state.getModule().getName());
            stringBuffer.append(" ");
            stringBuffer.append(this.state.getModule().getModuleClass());
            return stringBuffer.toString();
        }

        public int compareTo(Object object) {
            SortModule sortModule = (SortModule)object;
            if (this.position > sortModule.position) {
                return 1;
            }
            if (this.position < sortModule.position) {
                return -1;
            }
            return 0;
        }
    }
}

