/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.modules;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.jfree.base.AbstractBoot;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.base.config.PropertyFileConfiguration;
import org.jfree.base.log.PadMessage;
import org.jfree.base.modules.DefaultModuleInfo;
import org.jfree.base.modules.Module;
import org.jfree.base.modules.ModuleInfo;
import org.jfree.base.modules.PackageSorter;
import org.jfree.base.modules.PackageState;
import org.jfree.util.Configuration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public final class PackageManager {
    private static final int RETURN_MODULE_LOADED = 0;
    private static final int RETURN_MODULE_UNKNOWN = 1;
    private static final int RETURN_MODULE_ERROR = 2;
    private final PackageConfiguration packageConfiguration;
    private final ArrayList modules;
    private final ArrayList initSections;
    private AbstractBoot booter;
    private static HashMap instances;

    public static PackageManager createInstance(AbstractBoot abstractBoot) {
        if (instances == null) {
            instances = new HashMap();
            PackageManager packageManager = new PackageManager(abstractBoot);
            instances.put(abstractBoot, packageManager);
            return packageManager;
        }
        PackageManager packageManager = (PackageManager)instances.get(abstractBoot);
        if (packageManager == null) {
            packageManager = new PackageManager(abstractBoot);
            instances.put(abstractBoot, packageManager);
        }
        return packageManager;
    }

    private PackageManager(AbstractBoot abstractBoot) {
        if (abstractBoot == null) {
            throw new NullPointerException();
        }
        this.booter = abstractBoot;
        this.packageConfiguration = new PackageConfiguration();
        this.modules = new ArrayList();
        this.initSections = new ArrayList();
    }

    public boolean isModuleAvailable(ModuleInfo moduleInfo) {
        PackageState[] packageStateArray = this.modules.toArray(new PackageState[this.modules.size()]);
        for (int i2 = 0; i2 < packageStateArray.length; ++i2) {
            PackageState packageState = packageStateArray[i2];
            if (!packageState.getModule().getModuleClass().equals(moduleInfo.getModuleClass())) continue;
            return packageState.getState() == 2;
        }
        return false;
    }

    public void load(String string) {
        if (this.initSections.contains(string)) {
            return;
        }
        this.initSections.add(string);
        Configuration configuration = this.booter.getGlobalConfig();
        Iterator iterator = configuration.findPropertyKeys(string);
        int n2 = 0;
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            if (!string3.endsWith(".Module") || (string2 = configuration.getConfigProperty(string3)) == null || string2.length() <= 0) continue;
            this.addModule(string2);
            ++n2;
        }
        Log.debug("Loaded a total of " + n2 + " modules under prefix: " + string);
    }

    public synchronized void initializeModules() {
        PackageState packageState;
        int n2;
        PackageSorter.sort(this.modules);
        for (n2 = 0; n2 < this.modules.size(); ++n2) {
            packageState = (PackageState)this.modules.get(n2);
            if (!packageState.configure(this.booter)) continue;
            Log.debug(new Log.SimpleMessage("Conf: ", new PadMessage(packageState.getModule().getModuleClass(), 70), " [", packageState.getModule().getSubSystem(), "]"));
        }
        for (n2 = 0; n2 < this.modules.size(); ++n2) {
            packageState = (PackageState)this.modules.get(n2);
            if (!packageState.initialize(this.booter)) continue;
            Log.debug(new Log.SimpleMessage("Init: ", new PadMessage(packageState.getModule().getModuleClass(), 70), " [", packageState.getModule().getSubSystem(), "]"));
        }
    }

    public synchronized void addModule(String string) {
        DefaultModuleInfo defaultModuleInfo = new DefaultModuleInfo(string, null, null, null);
        ArrayList arrayList = new ArrayList();
        if (this.loadModule(defaultModuleInfo, new ArrayList(), arrayList, false)) {
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                Module module = (Module)arrayList.get(i2);
                this.modules.add(new PackageState(module));
            }
        }
    }

    private int containsModule(ArrayList arrayList, ModuleInfo moduleInfo) {
        int n2;
        Object[] objectArray;
        if (arrayList != null) {
            objectArray = arrayList.toArray(new ModuleInfo[arrayList.size()]);
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (!objectArray[n2].getModuleClass().equals(moduleInfo.getModuleClass())) continue;
                return 0;
            }
        }
        objectArray = this.modules.toArray(new PackageState[this.modules.size()]);
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (!((PackageState)objectArray[n2]).getModule().getModuleClass().equals(moduleInfo.getModuleClass())) continue;
            if (((PackageState)objectArray[n2]).getState() == -2) {
                return 2;
            }
            return 0;
        }
        return 1;
    }

    private void dropFailedModule(PackageState packageState) {
        if (!this.modules.contains(packageState)) {
            this.modules.add(packageState);
        }
    }

    private boolean loadModule(ModuleInfo moduleInfo, ArrayList arrayList, ArrayList arrayList2, boolean bl2) {
        try {
            Class<?> clazz = ObjectUtilities.getClassLoader(this.getClass()).loadClass(moduleInfo.getModuleClass());
            Module module = (Module)clazz.newInstance();
            if (!this.acceptVersion(moduleInfo, module)) {
                Log.warn("Module " + module.getName() + ": required version: " + moduleInfo + ", but found Version: \n" + module);
                PackageState packageState = new PackageState(module, -2);
                this.dropFailedModule(packageState);
                return false;
            }
            int n2 = this.containsModule(arrayList2, module);
            if (n2 == 2) {
                Log.debug("Indicated failure for module: " + module.getModuleClass());
                PackageState packageState = new PackageState(module, -2);
                this.dropFailedModule(packageState);
                return false;
            }
            if (n2 == 1) {
                if (arrayList.contains(module)) {
                    Log.error(new Log.SimpleMessage("Circular module reference: This module definition is invalid: ", module.getClass()));
                    PackageState packageState = new PackageState(module, -2);
                    this.dropFailedModule(packageState);
                    return false;
                }
                arrayList.add(module);
                ModuleInfo[] moduleInfoArray = module.getRequiredModules();
                for (int i2 = 0; i2 < moduleInfoArray.length; ++i2) {
                    if (this.loadModule(moduleInfoArray[i2], arrayList, arrayList2, true)) continue;
                    Log.debug("Indicated failure for module: " + module.getModuleClass());
                    PackageState packageState = new PackageState(module, -2);
                    this.dropFailedModule(packageState);
                    return false;
                }
                ModuleInfo[] moduleInfoArray2 = module.getOptionalModules();
                for (int i3 = 0; i3 < moduleInfoArray2.length; ++i3) {
                    if (this.loadModule(moduleInfoArray2[i3], arrayList, arrayList2, true)) continue;
                    Log.debug(new Log.SimpleMessage("Optional module: ", moduleInfoArray2[i3].getModuleClass(), " was not loaded."));
                }
                if (this.containsModule(arrayList2, module) == 1) {
                    arrayList2.add(module);
                }
                arrayList.remove(module);
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl2) {
                Log.warn(new Log.SimpleMessage("Unresolved dependency for package: ", moduleInfo.getModuleClass()));
            }
            Log.debug(new Log.SimpleMessage("ClassNotFound: ", classNotFoundException.getMessage()));
            return false;
        }
        catch (Exception exception) {
            Log.warn(new Log.SimpleMessage("Exception while loading module: ", moduleInfo), exception);
            return false;
        }
    }

    private boolean acceptVersion(ModuleInfo moduleInfo, Module module) {
        int n2;
        if (moduleInfo.getMajorVersion() == null) {
            return true;
        }
        if (module.getMajorVersion() == null) {
            Log.warn("Module " + module.getName() + " does not define a major version.");
        } else {
            n2 = this.acceptVersion(moduleInfo.getMajorVersion(), module.getMajorVersion());
            if (n2 > 0) {
                return false;
            }
            if (n2 < 0) {
                return true;
            }
        }
        if (moduleInfo.getMinorVersion() == null) {
            return true;
        }
        if (module.getMinorVersion() == null) {
            Log.warn("Module " + module.getName() + " does not define a minor version.");
        } else {
            n2 = this.acceptVersion(moduleInfo.getMinorVersion(), module.getMinorVersion());
            if (n2 > 0) {
                return false;
            }
            if (n2 < 0) {
                return true;
            }
        }
        if (moduleInfo.getPatchLevel() == null) {
            return true;
        }
        if (module.getPatchLevel() == null) {
            Log.debug("Module " + module.getName() + " does not define a patch level.");
        } else if (this.acceptVersion(moduleInfo.getPatchLevel(), module.getPatchLevel()) > 0) {
            Log.debug("Did not accept patchlevel: " + moduleInfo.getPatchLevel() + " - " + module.getPatchLevel());
            return false;
        }
        return true;
    }

    private int acceptVersion(String string, String string2) {
        char[] cArray;
        char[] cArray2;
        int n2 = Math.max(string.length(), string2.length());
        if (string.length() > string2.length()) {
            cArray2 = string.toCharArray();
            cArray = new char[n2];
            int n3 = string.length() - string2.length();
            Arrays.fill(cArray, 0, n3, ' ');
            System.arraycopy(cArray, n3, string2.toCharArray(), 0, string2.length());
        } else if (string.length() < string2.length()) {
            cArray = string2.toCharArray();
            cArray2 = new char[n2];
            char[] cArray3 = new char[n2];
            int n4 = string2.length() - string.length();
            Arrays.fill(cArray3, 0, n4, ' ');
            System.arraycopy(cArray3, n4, string.toCharArray(), 0, string.length());
        } else {
            cArray = string2.toCharArray();
            cArray2 = string.toCharArray();
        }
        return new String(cArray2).compareTo(new String(cArray));
    }

    public PackageConfiguration getPackageConfiguration() {
        return this.packageConfiguration;
    }

    public Module[] getAllModules() {
        Module[] moduleArray = new Module[this.modules.size()];
        for (int i2 = 0; i2 < this.modules.size(); ++i2) {
            PackageState packageState = (PackageState)this.modules.get(i2);
            moduleArray[i2] = packageState.getModule();
        }
        return moduleArray;
    }

    public Module[] getActiveModules() {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        for (int i2 = 0; i2 < this.modules.size(); ++i2) {
            PackageState packageState = (PackageState)this.modules.get(i2);
            if (packageState.getState() != 2) continue;
            arrayList.add(packageState.getModule());
        }
        return arrayList.toArray(new Module[arrayList.size()]);
    }

    public void printUsedModules(PrintStream printStream) {
        int n2;
        Module[] moduleArray = this.getAllModules();
        ArrayList<Module> arrayList = new ArrayList<Module>();
        ArrayList<Module> arrayList2 = new ArrayList<Module>();
        for (n2 = 0; n2 < moduleArray.length; ++n2) {
            if (this.isModuleAvailable(moduleArray[n2])) {
                arrayList.add(moduleArray[n2]);
                continue;
            }
            arrayList2.add(moduleArray[n2]);
        }
        printStream.print("Active modules: ");
        printStream.println(arrayList.size());
        printStream.println("----------------------------------------------------------");
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            Module module = (Module)arrayList.get(n2);
            printStream.print(new PadMessage(module.getModuleClass(), 70));
            printStream.print(" [");
            printStream.print(module.getSubSystem());
            printStream.println("]");
            printStream.print("  Version: ");
            printStream.print(module.getMajorVersion());
            printStream.print("-");
            printStream.print(module.getMinorVersion());
            printStream.print("-");
            printStream.print(module.getPatchLevel());
            printStream.print(" Producer: ");
            printStream.println(module.getProducer());
            printStream.print("  Description: ");
            printStream.println(module.getDescription());
        }
    }

    public static class PackageConfiguration
    extends PropertyFileConfiguration {
        @Override
        public void insertConfiguration(HierarchicalConfiguration hierarchicalConfiguration) {
            super.insertConfiguration(hierarchicalConfiguration);
        }
    }
}

