/*
 * Decompiled with CFR 0.152.
 */
package org.ibex.nestedvm.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.ibex.nestedvm.util.Platform;

public abstract class Seekable {
    public abstract int read(byte[] var1, int var2, int var3);

    public abstract int write(byte[] var1, int var2, int var3);

    public abstract int length();

    public abstract void seek(int var1);

    public abstract void close();

    public abstract int pos();

    public void sync() {
        throw new IOException("sync not implemented for " + this.getClass());
    }

    public void resize(long l2) {
        throw new IOException("resize not implemented for " + this.getClass());
    }

    public Lock lock(long l2, long l3, boolean bl2) {
        throw new IOException("lock not implemented for " + this.getClass());
    }

    public int read() {
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray, 0, 1);
        return n2 == -1 ? -1 : byArray[0] & 0xFF;
    }

    public int tryReadFully(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = 0;
        while (n3 > 0 && (n4 = this.read(byArray, n2, n3)) != -1) {
            n2 += n4;
            n3 -= n4;
            n5 += n4;
        }
        return n5 == 0 ? -1 : n5;
    }

    public static abstract class Lock {
        private Object owner = null;

        public abstract Seekable seekable();

        public abstract boolean isShared();

        public abstract boolean isValid();

        public abstract void release();

        public abstract long position();

        public abstract long size();

        public void setOwner(Object object) {
            this.owner = object;
        }

        public Object getOwner() {
            return this.owner;
        }

        public final boolean contains(int n2, int n3) {
            return (long)n2 >= this.position() && this.position() + this.size() >= (long)(n2 + n3);
        }

        public final boolean contained(int n2, int n3) {
            return (long)n2 < this.position() && this.position() + this.size() < (long)(n2 + n3);
        }

        public final boolean overlaps(int n2, int n3) {
            return this.contains(n2, n3) || this.contained(n2, n3);
        }
    }

    public static class InputStream
    extends Seekable {
        private byte[] buffer = new byte[4096];
        private int bytesRead = 0;
        private boolean eof = false;
        private int pos;
        private java.io.InputStream is;

        public InputStream(java.io.InputStream inputStream) {
            this.is = inputStream;
        }

        public int read(byte[] byArray, int n2, int n3) {
            if (this.pos >= this.bytesRead && !this.eof) {
                this.readTo(this.pos + 1);
            }
            if ((n3 = Math.min(n3, this.bytesRead - this.pos)) <= 0) {
                return -1;
            }
            System.arraycopy(this.buffer, this.pos, byArray, n2, n3);
            this.pos += n3;
            return n3;
        }

        private void readTo(int n2) {
            if (n2 >= this.buffer.length) {
                byte[] byArray = new byte[Math.max(this.buffer.length + Math.min(this.buffer.length, 65536), n2)];
                System.arraycopy(this.buffer, 0, byArray, 0, this.bytesRead);
                this.buffer = byArray;
            }
            while (this.bytesRead < n2) {
                int n3 = this.is.read(this.buffer, this.bytesRead, this.buffer.length - this.bytesRead);
                if (n3 == -1) {
                    this.eof = true;
                    break;
                }
                this.bytesRead += n3;
            }
        }

        public int length() {
            while (!this.eof) {
                this.readTo(this.bytesRead + 4096);
            }
            return this.bytesRead;
        }

        public int write(byte[] byArray, int n2, int n3) {
            throw new IOException("read-only");
        }

        public void seek(int n2) {
            this.pos = n2;
        }

        public int pos() {
            return this.pos;
        }

        public void close() {
            this.is.close();
        }
    }

    public static class File
    extends Seekable {
        private final java.io.File file;
        private final RandomAccessFile raf;

        public File(String string) {
            this(string, false);
        }

        public File(String string, boolean bl2) {
            this(new java.io.File(string), bl2, false);
        }

        public File(java.io.File file, boolean bl2, boolean bl3) {
            this.file = file;
            String string = bl2 ? "rw" : "r";
            this.raf = new RandomAccessFile(file, string);
            if (bl3) {
                Platform.setFileLength(this.raf, 0);
            }
        }

        public int read(byte[] byArray, int n2, int n3) {
            return this.raf.read(byArray, n2, n3);
        }

        public int write(byte[] byArray, int n2, int n3) {
            this.raf.write(byArray, n2, n3);
            return n3;
        }

        public void sync() {
            this.raf.getFD().sync();
        }

        public void seek(int n2) {
            this.raf.seek(n2);
        }

        public int pos() {
            return (int)this.raf.getFilePointer();
        }

        public int length() {
            return (int)this.raf.length();
        }

        public void close() {
            this.raf.close();
        }

        public void resize(long l2) {
            Platform.setFileLength(this.raf, (int)l2);
        }

        public boolean equals(Object object) {
            return object != null && object instanceof File && this.file.equals(((File)object).file);
        }

        public Lock lock(long l2, long l3, boolean bl2) {
            return Platform.lockFile(this, this.raf, l2, l3, bl2);
        }
    }

    public static class ByteArray
    extends Seekable {
        protected byte[] data;
        protected int pos;
        private final boolean writable;

        public ByteArray(byte[] byArray, boolean bl2) {
            this.data = byArray;
            this.pos = 0;
            this.writable = bl2;
        }

        public int read(byte[] byArray, int n2, int n3) {
            if ((n3 = Math.min(n3, this.data.length - this.pos)) <= 0) {
                return -1;
            }
            System.arraycopy(this.data, this.pos, byArray, n2, n3);
            this.pos += n3;
            return n3;
        }

        public int write(byte[] byArray, int n2, int n3) {
            if (!this.writable) {
                throw new IOException("read-only data");
            }
            if ((n3 = Math.min(n3, this.data.length - this.pos)) <= 0) {
                throw new IOException("no space");
            }
            System.arraycopy(byArray, n2, this.data, this.pos, n3);
            this.pos += n3;
            return n3;
        }

        public int length() {
            return this.data.length;
        }

        public int pos() {
            return this.pos;
        }

        public void seek(int n2) {
            this.pos = n2;
        }

        public void close() {
        }
    }
}

