/*
 * Decompiled with CFR 0.152.
 */
package org.ibex.nestedvm.util;

public class InodeCache {
    private static final Object PLACEHOLDER = new Object();
    private static final short SHORT_PLACEHOLDER = -2;
    private static final short SHORT_NULL = -1;
    private static final int LOAD_FACTOR = 2;
    private final int maxSize;
    private final int totalSlots;
    private final int maxUsedSlots;
    private final Object[] keys;
    private final short[] next;
    private final short[] prev;
    private final short[] inodes;
    private final short[] reverse;
    private int size;
    private int usedSlots;
    private short mru;
    private short lru;

    public InodeCache() {
        this(1024);
    }

    public InodeCache(int n2) {
        this.maxSize = n2;
        this.totalSlots = n2 * 2 * 2 + 3;
        this.maxUsedSlots = this.totalSlots / 2;
        if (this.totalSlots > Short.MAX_VALUE) {
            throw new IllegalArgumentException("cache size too large");
        }
        this.keys = new Object[this.totalSlots];
        this.next = new short[this.totalSlots];
        this.prev = new short[this.totalSlots];
        this.inodes = new short[this.totalSlots];
        this.reverse = new short[this.totalSlots];
        this.clear();
    }

    private static void fill(Object[] objectArray, Object object) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = object;
        }
    }

    private static void fill(short[] sArray, short s2) {
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            sArray[i2] = s2;
        }
    }

    public final void clear() {
        this.usedSlots = 0;
        this.size = 0;
        this.lru = (short)-1;
        this.mru = (short)-1;
        InodeCache.fill(this.keys, null);
        InodeCache.fill(this.inodes, (short)-1);
        InodeCache.fill(this.reverse, (short)-1);
    }

    public final short get(Object object) {
        int n2;
        Object object2;
        int n3;
        int n4 = object.hashCode() & Integer.MAX_VALUE;
        int n5 = n3 = n4 % this.totalSlots;
        int n6 = 1;
        boolean bl2 = true;
        int n7 = -1;
        while ((object2 = this.keys[n3]) != null) {
            if (object2 == PLACEHOLDER) {
                if (n7 == -1) {
                    n7 = n3;
                }
            } else if (object2.equals(object)) {
                short s2 = this.inodes[n3];
                if (n3 == this.mru) {
                    return s2;
                }
                if (this.lru == n3) {
                    this.lru = this.next[this.lru];
                } else {
                    short s3;
                    short s4 = this.prev[n3];
                    this.next[s4] = s3 = this.next[n3];
                    this.prev[s3] = s4;
                }
                this.prev[n3] = this.mru;
                this.next[this.mru] = (short)n3;
                this.mru = (short)n3;
                return s2;
            }
            n3 = Math.abs((n5 + (bl2 ? 1 : -1) * n6 * n6) % this.totalSlots);
            if (!bl2) {
                ++n6;
            }
            bl2 = !bl2;
        }
        if (n7 == -1) {
            n2 = n3;
            if (this.usedSlots == this.maxUsedSlots) {
                this.clear();
                return this.get(object);
            }
            ++this.usedSlots;
        } else {
            n2 = n7;
        }
        if (this.size == this.maxSize) {
            this.keys[this.lru] = PLACEHOLDER;
            this.inodes[this.lru] = -2;
            this.lru = this.next[this.lru];
        } else {
            if (this.size == 0) {
                this.lru = (short)n2;
            }
            ++this.size;
        }
        int n8 = n4 & Short.MAX_VALUE;
        while (true) {
            block24: {
                short s5;
                n5 = n3 = n8 % this.totalSlots;
                n6 = 1;
                bl2 = true;
                n7 = -1;
                while ((s5 = this.reverse[n3]) != -1) {
                    short s6 = this.inodes[s5];
                    if (s6 == -2) {
                        if (n7 == -1) {
                            n7 = n3;
                        }
                    } else if (s6 == n8) break block24;
                    n3 = Math.abs((n5 + (bl2 ? 1 : -1) * n6 * n6) % this.totalSlots);
                    if (!bl2) {
                        ++n6;
                    }
                    bl2 = !bl2;
                }
                if (n7 == -1) break;
                n3 = n7;
                break;
            }
            ++n8;
        }
        this.keys[n2] = object;
        this.reverse[n3] = (short)n2;
        this.inodes[n2] = (short)n8;
        if (this.mru != -1) {
            this.prev[n2] = this.mru;
            this.next[this.mru] = (short)n2;
        }
        this.mru = (short)n2;
        return (short)n8;
    }

    public Object reverse(short s2) {
        short s3;
        int n2;
        int n3 = n2 = s2 % this.totalSlots;
        int n4 = 1;
        boolean bl2 = true;
        while ((s3 = this.reverse[n2]) != -1) {
            if (this.inodes[s3] == s2) {
                return this.keys[s3];
            }
            n2 = Math.abs((n3 + (bl2 ? 1 : -1) * n4 * n4) % this.totalSlots);
            if (!bl2) {
                ++n4;
            }
            bl2 = !bl2;
        }
        return null;
    }
}

