/*
 * Decompiled with CFR 0.152.
 */
package org.ibex.nestedvm.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ibex.nestedvm.util.Seekable;

public class ELF {
    private static final int ELF_MAGIC = 2135247942;
    public static final int ELFCLASSNONE = 0;
    public static final int ELFCLASS32 = 1;
    public static final int ELFCLASS64 = 2;
    public static final int ELFDATANONE = 0;
    public static final int ELFDATA2LSB = 1;
    public static final int ELFDATA2MSB = 2;
    public static final int SHT_SYMTAB = 2;
    public static final int SHT_STRTAB = 3;
    public static final int SHT_NOBITS = 8;
    public static final int SHF_WRITE = 1;
    public static final int SHF_ALLOC = 2;
    public static final int SHF_EXECINSTR = 4;
    public static final int PF_X = 1;
    public static final int PF_W = 2;
    public static final int PF_R = 4;
    public static final int PT_LOAD = 1;
    public static final short ET_EXEC = 2;
    public static final short EM_MIPS = 8;
    private Seekable data;
    public ELFIdent ident;
    public ELFHeader header;
    public PHeader[] pheaders;
    public SHeader[] sheaders;
    private byte[] stringTable;
    private boolean sectionReaderActive;
    private Symtab _symtab;

    private void readFully(byte[] byArray) {
        int n2;
        int n3 = 0;
        for (int i2 = byArray.length; i2 > 0; i2 -= n2) {
            n2 = this.data.read(byArray, n3, i2);
            if (n2 == -1) {
                throw new IOException("EOF");
            }
            n3 += n2;
        }
    }

    private int readIntBE() {
        byte[] byArray = new byte[4];
        this.readFully(byArray);
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | (byArray[3] & 0xFF) << 0;
    }

    private int readInt() {
        int n2 = this.readIntBE();
        if (this.ident != null && this.ident.data == 1) {
            n2 = n2 << 24 & 0xFF000000 | n2 << 8 & 0xFF0000 | n2 >>> 8 & 0xFF00 | n2 >> 24 & 0xFF;
        }
        return n2;
    }

    private short readShortBE() {
        byte[] byArray = new byte[2];
        this.readFully(byArray);
        return (short)((byArray[0] & 0xFF) << 8 | (byArray[1] & 0xFF) << 0);
    }

    private short readShort() {
        short s2 = this.readShortBE();
        if (this.ident != null && this.ident.data == 1) {
            s2 = (short)((s2 << 8 & 0xFF00 | s2 >> 8 & 0xFF) & 0xFFFF);
        }
        return s2;
    }

    private byte readByte() {
        byte[] byArray = new byte[1];
        this.readFully(byArray);
        return byArray[0];
    }

    public ELF(String string) {
        this(new Seekable.File(string, false));
    }

    public ELF(Seekable seekable) {
        int n2;
        this.data = seekable;
        this.ident = new ELFIdent(this);
        this.header = new ELFHeader(this);
        this.pheaders = new PHeader[this.header.phnum];
        for (n2 = 0; n2 < this.header.phnum; ++n2) {
            seekable.seek(this.header.phoff + n2 * this.header.phentsize);
            this.pheaders[n2] = new PHeader(this);
        }
        this.sheaders = new SHeader[this.header.shnum];
        for (n2 = 0; n2 < this.header.shnum; ++n2) {
            seekable.seek(this.header.shoff + n2 * this.header.shentsize);
            this.sheaders[n2] = new SHeader(this);
        }
        if (this.header.shstrndx < 0 || this.header.shstrndx >= this.header.shnum) {
            throw new ELFException(this, "Bad shstrndx");
        }
        seekable.seek(this.sheaders[this.header.shstrndx].offset);
        this.stringTable = new byte[this.sheaders[this.header.shstrndx].size];
        this.readFully(this.stringTable);
        for (n2 = 0; n2 < this.header.shnum; ++n2) {
            SHeader sHeader = this.sheaders[n2];
            sHeader.name = this.getString(sHeader.nameidx);
        }
    }

    private String getString(int n2) {
        return this.getString(n2, this.stringTable);
    }

    private String getString(int n2, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 < 0 || n2 >= byArray.length) {
            return "<invalid strtab entry>";
        }
        while (n2 >= 0 && n2 < byArray.length && byArray[n2] != 0) {
            stringBuffer.append((char)byArray[n2++]);
        }
        return stringBuffer.toString();
    }

    public SHeader sectionWithName(String string) {
        for (int i2 = 0; i2 < this.sheaders.length; ++i2) {
            if (!this.sheaders[i2].name.equals(string)) continue;
            return this.sheaders[i2];
        }
        return null;
    }

    public Symtab getSymtab() {
        if (this._symtab != null) {
            return this._symtab;
        }
        if (this.sectionReaderActive) {
            throw new ELFException(this, "Can't read the symtab while a section reader is active");
        }
        SHeader sHeader = this.sectionWithName(".symtab");
        if (sHeader == null || sHeader.type != 2) {
            return null;
        }
        SHeader sHeader2 = this.sectionWithName(".strtab");
        if (sHeader2 == null || sHeader2.type != 3) {
            return null;
        }
        byte[] byArray = new byte[sHeader2.size];
        DataInputStream dataInputStream = new DataInputStream(sHeader2.getInputStream());
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        this._symtab = new Symtab(this, sHeader.offset, sHeader.size, byArray);
        return this._symtab;
    }

    private static String toHex(int n2) {
        return "0x" + Long.toString((long)n2 & 0xFFFFFFFFL, 16);
    }

    static int access$000(ELF eLF) {
        return eLF.readIntBE();
    }

    static byte access$100(ELF eLF) {
        return eLF.readByte();
    }

    static short access$200(ELF eLF) {
        return eLF.readShort();
    }

    static int access$300(ELF eLF) {
        return eLF.readInt();
    }

    static String access$400(int n2) {
        return ELF.toHex(n2);
    }

    static boolean access$500(ELF eLF) {
        return eLF.sectionReaderActive;
    }

    static boolean access$502(ELF eLF, boolean bl2) {
        eLF.sectionReaderActive = bl2;
        return eLF.sectionReaderActive;
    }

    static Seekable access$600(ELF eLF) {
        return eLF.data;
    }

    static String access$700(ELF eLF, int n2, byte[] byArray) {
        return eLF.getString(n2, byArray);
    }

    public class Symbol {
        public String name;
        public int addr;
        public int size;
        public byte info;
        public byte type;
        public byte binding;
        public byte other;
        public short shndx;
        public SHeader sheader;
        public static final int STT_FUNC = 2;
        public static final int STB_GLOBAL = 1;
        private final ELF this$0;

        Symbol(ELF eLF, byte[] byArray) {
            this.this$0 = eLF;
            this.name = ELF.access$700(eLF, ELF.access$300(eLF), byArray);
            this.addr = ELF.access$300(eLF);
            this.size = ELF.access$300(eLF);
            this.info = ELF.access$100(eLF);
            this.type = (byte)(this.info & 0xF);
            this.binding = (byte)(this.info >> 4);
            this.other = ELF.access$100(eLF);
            this.shndx = ELF.access$200(eLF);
        }
    }

    public class Symtab {
        public Symbol[] symbols;
        private final ELF this$0;

        Symtab(ELF eLF, int n2, int n3, byte[] byArray) {
            this.this$0 = eLF;
            ELF.access$600(eLF).seek(n2);
            int n4 = n3 / 16;
            this.symbols = new Symbol[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                this.symbols[i2] = new Symbol(eLF, byArray);
            }
        }

        public Symbol getSymbol(String string) {
            Symbol symbol = null;
            for (int i2 = 0; i2 < this.symbols.length; ++i2) {
                if (!this.symbols[i2].name.equals(string)) continue;
                if (symbol == null) {
                    symbol = this.symbols[i2];
                    continue;
                }
                System.err.println("WARNING: Multiple symbol matches for " + string);
            }
            return symbol;
        }

        public Symbol getGlobalSymbol(String string) {
            for (int i2 = 0; i2 < this.symbols.length; ++i2) {
                if (this.symbols[i2].binding != 1 || !this.symbols[i2].name.equals(string)) continue;
                return this.symbols[i2];
            }
            return null;
        }
    }

    private class SectionInputStream
    extends InputStream {
        private int pos;
        private int maxpos;
        private final ELF this$0;

        SectionInputStream(ELF eLF, int n2, int n3) {
            this.this$0 = eLF;
            if (ELF.access$500(eLF)) {
                throw new IOException("Section reader already active");
            }
            ELF.access$502(eLF, true);
            this.pos = n2;
            ELF.access$600(eLF).seek(this.pos);
            this.maxpos = n3;
        }

        private int bytesLeft() {
            return this.maxpos - this.pos;
        }

        public int read() {
            byte[] byArray = new byte[1];
            return this.read(byArray, 0, 1) == -1 ? -1 : byArray[0] & 0xFF;
        }

        public int read(byte[] byArray, int n2, int n3) {
            int n4 = ELF.access$600(this.this$0).read(byArray, n2, Math.min(n3, this.bytesLeft()));
            if (n4 > 0) {
                this.pos += n4;
            }
            return n4;
        }

        public void close() {
            ELF.access$502(this.this$0, false);
        }
    }

    public class ELFException
    extends IOException {
        private final ELF this$0;

        ELFException(ELF eLF, String string) {
            super(string);
            this.this$0 = eLF;
        }
    }

    public class SHeader {
        int nameidx;
        public String name;
        public int type;
        public int flags;
        public int addr;
        public int offset;
        public int size;
        public int link;
        public int info;
        public int addralign;
        public int entsize;
        private final ELF this$0;

        SHeader(ELF eLF) {
            this.this$0 = eLF;
            this.nameidx = ELF.access$300(eLF);
            this.type = ELF.access$300(eLF);
            this.flags = ELF.access$300(eLF);
            this.addr = ELF.access$300(eLF);
            this.offset = ELF.access$300(eLF);
            this.size = ELF.access$300(eLF);
            this.link = ELF.access$300(eLF);
            this.info = ELF.access$300(eLF);
            this.addralign = ELF.access$300(eLF);
            this.entsize = ELF.access$300(eLF);
        }

        public InputStream getInputStream() {
            return new BufferedInputStream(new SectionInputStream(this.this$0, this.offset, this.type == 8 ? 0 : this.offset + this.size));
        }

        public boolean isText() {
            return this.name.equals(".text");
        }

        public boolean isData() {
            return this.name.equals(".data") || this.name.equals(".sdata") || this.name.equals(".rodata") || this.name.equals(".ctors") || this.name.equals(".dtors");
        }

        public boolean isBSS() {
            return this.name.equals(".bss") || this.name.equals(".sbss");
        }
    }

    public class PHeader {
        public int type;
        public int offset;
        public int vaddr;
        public int paddr;
        public int filesz;
        public int memsz;
        public int flags;
        public int align;
        private final ELF this$0;

        PHeader(ELF eLF) {
            this.this$0 = eLF;
            this.type = ELF.access$300(eLF);
            this.offset = ELF.access$300(eLF);
            this.vaddr = ELF.access$300(eLF);
            this.paddr = ELF.access$300(eLF);
            this.filesz = ELF.access$300(eLF);
            this.memsz = ELF.access$300(eLF);
            this.flags = ELF.access$300(eLF);
            this.align = ELF.access$300(eLF);
            if (this.filesz > this.memsz) {
                throw new ELFException(eLF, "ELF inconsistency: filesz > memsz (" + ELF.access$400(this.filesz) + " > " + ELF.access$400(this.memsz) + ")");
            }
        }

        public boolean writable() {
            return (this.flags & 2) != 0;
        }

        public InputStream getInputStream() {
            return new BufferedInputStream(new SectionInputStream(this.this$0, this.offset, this.offset + this.filesz));
        }
    }

    public class ELFHeader {
        public short type;
        public short machine;
        public int version;
        public int entry;
        public int phoff;
        public int shoff;
        public int flags;
        public short ehsize;
        public short phentsize;
        public short phnum;
        public short shentsize;
        public short shnum;
        public short shstrndx;
        private final ELF this$0;

        ELFHeader(ELF eLF) {
            this.this$0 = eLF;
            this.type = ELF.access$200(eLF);
            this.machine = ELF.access$200(eLF);
            this.version = ELF.access$300(eLF);
            if (this.version != 1) {
                throw new ELFException(eLF, "version != 1");
            }
            this.entry = ELF.access$300(eLF);
            this.phoff = ELF.access$300(eLF);
            this.shoff = ELF.access$300(eLF);
            this.flags = ELF.access$300(eLF);
            this.ehsize = ELF.access$200(eLF);
            this.phentsize = ELF.access$200(eLF);
            this.phnum = ELF.access$200(eLF);
            this.shentsize = ELF.access$200(eLF);
            this.shnum = ELF.access$200(eLF);
            this.shstrndx = ELF.access$200(eLF);
        }
    }

    public class ELFIdent {
        public byte klass;
        public byte data;
        public byte osabi;
        public byte abiversion;
        private final ELF this$0;

        ELFIdent(ELF eLF) {
            this.this$0 = eLF;
            if (ELF.access$000(eLF) != 2135247942) {
                throw new ELFException(eLF, "Bad Magic");
            }
            this.klass = ELF.access$100(eLF);
            if (this.klass != 1) {
                throw new ELFException(eLF, "org.ibex.nestedvm.util.ELF does not suport 64-bit binaries");
            }
            this.data = ELF.access$100(eLF);
            if (this.data != 1 && this.data != 2) {
                throw new ELFException(eLF, "Unknown byte order");
            }
            ELF.access$100(eLF);
            this.osabi = ELF.access$100(eLF);
            this.abiversion = ELF.access$100(eLF);
            for (int i2 = 0; i2 < 7; ++i2) {
                ELF.access$100(eLF);
            }
        }
    }
}

