/*
 * Decompiled with CFR 0.152.
 */
package org.ibex.nestedvm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import org.ibex.nestedvm.Runtime;
import org.ibex.nestedvm.util.InodeCache;
import org.ibex.nestedvm.util.Platform;
import org.ibex.nestedvm.util.Seekable;
import org.ibex.nestedvm.util.Sort;

public abstract class UnixRuntime
extends Runtime
implements Cloneable {
    private int pid;
    private UnixRuntime parent;
    private static final GlobalState defaultGS;
    private GlobalState gs;
    private String cwd;
    private UnixRuntime execedRuntime;
    private Object children;
    private Vector activeChildren;
    private Vector exitedChildren;
    private static final Method runtimeCompilerCompile;
    static Class class$org$ibex$nestedvm$util$Seekable;
    static Class class$java$lang$String;

    public final int getPid() {
        return this.pid;
    }

    public void setGlobalState(GlobalState globalState) {
        if (this.state != 1) {
            throw new IllegalStateException("can't change GlobalState when running");
        }
        if (globalState == null) {
            throw new NullPointerException("gs is null");
        }
        this.gs = globalState;
    }

    protected UnixRuntime(int n2, int n3) {
        this(n2, n3, false);
    }

    protected UnixRuntime(int n2, int n3, boolean bl2) {
        super(n2, n3, bl2);
        if (!bl2) {
            this.gs = defaultGS;
            String string = Platform.getProperty("user.dir");
            String string2 = this.cwd = string == null ? null : this.gs.mapHostPath(string);
            if (this.cwd == null) {
                this.cwd = "/";
            }
            this.cwd = this.cwd.substring(1);
        }
    }

    private static String posixTZ() {
        StringBuffer stringBuffer = new StringBuffer();
        TimeZone timeZone = TimeZone.getDefault();
        int n2 = timeZone.getRawOffset() / 1000;
        stringBuffer.append(Platform.timeZoneGetDisplayName(timeZone, false, false));
        if (n2 > 0) {
            stringBuffer.append("-");
        } else {
            n2 = -n2;
        }
        stringBuffer.append(n2 / 3600);
        if ((n2 %= 3600) > 0) {
            stringBuffer.append(":").append(n2 / 60);
        }
        if ((n2 %= 60) > 0) {
            stringBuffer.append(":").append(n2);
        }
        if (timeZone.useDaylightTime()) {
            stringBuffer.append(Platform.timeZoneGetDisplayName(timeZone, true, false));
        }
        return stringBuffer.toString();
    }

    private static boolean envHas(String string, String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null || !stringArray[i2].startsWith(string + "=")) continue;
            return true;
        }
        return false;
    }

    String[] createEnv(String[] stringArray) {
        int n2;
        String string;
        String[] stringArray2 = new String[7];
        int n3 = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (!UnixRuntime.envHas("USER", stringArray) && Platform.getProperty("user.name") != null) {
            stringArray2[n3++] = "USER=" + Platform.getProperty("user.name");
        }
        if (!UnixRuntime.envHas("HOME", stringArray) && (string = Platform.getProperty("user.home")) != null && (string = this.gs.mapHostPath(string)) != null) {
            stringArray2[n3++] = "HOME=" + string;
        }
        if (!UnixRuntime.envHas("TMPDIR", stringArray) && (string = Platform.getProperty("java.io.tmpdir")) != null && (string = this.gs.mapHostPath(string)) != null) {
            stringArray2[n3++] = "TMPDIR=" + string;
        }
        if (!UnixRuntime.envHas("SHELL", stringArray)) {
            stringArray2[n3++] = "SHELL=/bin/sh";
        }
        if (!UnixRuntime.envHas("TERM", stringArray) && !win32Hacks) {
            stringArray2[n3++] = "TERM=vt100";
        }
        if (!UnixRuntime.envHas("TZ", stringArray)) {
            stringArray2[n3++] = "TZ=" + UnixRuntime.posixTZ();
        }
        if (!UnixRuntime.envHas("PATH", stringArray)) {
            stringArray2[n3++] = "PATH=/usr/local/bin:/usr/bin:/bin:/usr/local/sbin:/usr/sbin:/sbin";
        }
        String[] stringArray3 = new String[stringArray.length + n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray3[n2] = stringArray2[n2];
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArray3[n3++] = stringArray[n2];
        }
        return stringArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _started() {
        UnixRuntime[] unixRuntimeArray = this.gs.tasks;
        GlobalState globalState = this.gs;
        synchronized (globalState) {
            if (this.pid != 0) {
                UnixRuntime unixRuntime = unixRuntimeArray[this.pid];
                if (unixRuntime == null || unixRuntime == this || unixRuntime.pid != this.pid || unixRuntime.parent != this.parent) {
                    throw new Error("should never happen");
                }
                Object object = this.parent.children;
                synchronized (object) {
                    int n2 = this.parent.activeChildren.indexOf(unixRuntime);
                    if (n2 == -1) {
                        throw new Error("should never happen");
                    }
                    this.parent.activeChildren.setElementAt(this, n2);
                }
            } else {
                int n3;
                int n4;
                int n5 = -1;
                for (n4 = n3 = this.gs.nextPID; n4 < unixRuntimeArray.length; ++n4) {
                    if (unixRuntimeArray[n4] != null) continue;
                    n5 = n4;
                    break;
                }
                if (n5 == -1) {
                    for (n4 = 1; n4 < n3; ++n4) {
                        if (unixRuntimeArray[n4] != null) continue;
                        n5 = n4;
                        break;
                    }
                }
                if (n5 == -1) {
                    throw new ProcessTableFullExn(null);
                }
                this.pid = n5;
                this.gs.nextPID = n5 + 1;
            }
            unixRuntimeArray[this.pid] = this;
        }
    }

    int _syscall(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        switch (n2) {
            case 11: {
                return this.sys_kill(n3, n4);
            }
            case 25: {
                return this.sys_fork();
            }
            case 23: {
                return this.sys_pipe(n3);
            }
            case 24: {
                return this.sys_dup2(n3, n4);
            }
            case 39: {
                return this.sys_dup(n3);
            }
            case 26: {
                return this.sys_waitpid(n3, n4, n5);
            }
            case 14: {
                return this.sys_stat(n3, n4);
            }
            case 33: {
                return this.sys_lstat(n3, n4);
            }
            case 18: {
                return this.sys_mkdir(n3, n4);
            }
            case 27: {
                return this.sys_getcwd(n3, n4);
            }
            case 22: {
                return this.sys_chdir(n3);
            }
            case 28: {
                return this.sys_exec(n3, n4, n5);
            }
            case 36: {
                return this.sys_getdents(n3, n4, n5, n6);
            }
            case 20: {
                return this.sys_unlink(n3);
            }
            case 46: {
                return this.sys_getppid();
            }
            case 56: {
                return this.sys_socket(n3, n4, n5);
            }
            case 57: {
                return this.sys_connect(n3, n4, n5);
            }
            case 58: {
                return this.sys_resolve_hostname(n3, n4, n5);
            }
            case 60: {
                return this.sys_setsockopt(n3, n4, n5, n6, n7);
            }
            case 61: {
                return this.sys_getsockopt(n3, n4, n5, n6, n7);
            }
            case 63: {
                return this.sys_bind(n3, n4, n5);
            }
            case 62: {
                return this.sys_listen(n3, n4);
            }
            case 59: {
                return this.sys_accept(n3, n4, n5);
            }
            case 64: {
                return this.sys_shutdown(n3, n4);
            }
            case 53: {
                return this.sys_sysctl(n3, n4, n5, n6, n7, n8);
            }
            case 65: {
                return this.sys_sendto(n3, n4, n5, n6, n7, n8);
            }
            case 66: {
                return this.sys_recvfrom(n3, n4, n5, n6, n7, n8);
            }
            case 67: {
                return this.sys_select(n3, n4, n5, n6, n7);
            }
            case 78: {
                return this.sys_access(n3, n4);
            }
            case 52: {
                return this.sys_realpath(n3, n4);
            }
            case 76: {
                return this.sys_chown(n3, n4, n5);
            }
            case 43: {
                return this.sys_chown(n3, n4, n5);
            }
            case 77: {
                return this.sys_fchown(n3, n4, n5);
            }
            case 74: {
                return this.sys_chmod(n3, n4, n5);
            }
            case 75: {
                return this.sys_fchmod(n3, n4, n5);
            }
            case 29: {
                return this.sys_fcntl_lock(n3, n4, n5);
            }
            case 73: {
                return this.sys_umask(n3);
            }
        }
        return super._syscall(n2, n3, n4, n5, n6, n7, n8);
    }

    Runtime.FD _open(String string, int n2, int n3) {
        Runtime.FD fD = this.gs.open(this, string = this.normalizePath(string), n2, n3);
        if (fD != null && string != null) {
            fD.setNormalizedPath(string);
        }
        return fD;
    }

    private int sys_getppid() {
        return this.parent == null ? 1 : this.parent.pid;
    }

    private int sys_chown(int n2, int n3, int n4) {
        return 0;
    }

    private int sys_lchown(int n2, int n3, int n4) {
        return 0;
    }

    private int sys_fchown(int n2, int n3, int n4) {
        return 0;
    }

    private int sys_chmod(int n2, int n3, int n4) {
        return 0;
    }

    private int sys_fchmod(int n2, int n3, int n4) {
        return 0;
    }

    private int sys_umask(int n2) {
        return 0;
    }

    private int sys_access(int n2, int n3) {
        return this.gs.stat(this, this.cstring(n2)) == null ? -2 : 0;
    }

    private int sys_realpath(int n2, int n3) {
        String string = this.normalizePath(this.cstring(n2));
        byte[] byArray = UnixRuntime.getNullTerminatedBytes(string);
        if (byArray.length > 1024) {
            return -34;
        }
        this.copyout(byArray, n3, byArray.length);
        return 0;
    }

    private int sys_kill(int n2, int n3) {
        if (n2 != n2) {
            return -3;
        }
        if (n3 < 0 || n3 >= 32) {
            return -22;
        }
        switch (n3) {
            case 0: {
                return 0;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: {
                break;
            }
            default: {
                this.exit(128 + n3, true);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sys_waitpid(int n2, int n3, int n4) {
        boolean bl2;
        if ((n4 & 0xFFFFFFFE) != 0) {
            return -22;
        }
        if (n2 == 0 || n2 < -1) {
            System.err.println("WARNING: waitpid called with a pid of " + n2);
            return -10;
        }
        boolean bl3 = bl2 = (n4 & 1) == 0;
        if (n2 != -1 && (n2 <= 0 || n2 >= this.gs.tasks.length)) {
            return -10;
        }
        if (this.children == null) {
            return bl2 ? -10 : 0;
        }
        UnixRuntime unixRuntime = null;
        Object object = this.children;
        synchronized (object) {
            while (true) {
                if (n2 == -1) {
                    if (this.exitedChildren.size() > 0) {
                        unixRuntime = (UnixRuntime)this.exitedChildren.elementAt(this.exitedChildren.size() - 1);
                        this.exitedChildren.removeElementAt(this.exitedChildren.size() - 1);
                    }
                } else if (n2 > 0) {
                    if (n2 >= this.gs.tasks.length) {
                        return -10;
                    }
                    UnixRuntime unixRuntime2 = this.gs.tasks[n2];
                    if (unixRuntime2.parent != this) {
                        return -10;
                    }
                    if (unixRuntime2.state == 4) {
                        if (!this.exitedChildren.removeElement(unixRuntime2)) {
                            throw new Error("should never happen");
                        }
                        unixRuntime = unixRuntime2;
                    }
                } else {
                    throw new Error("should never happen");
                }
                if (unixRuntime != null) break;
                if (!bl2) {
                    return 0;
                }
                try {
                    this.children.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.gs.tasks[unixRuntime.pid] = null;
        }
        if (n3 != 0) {
            this.memWrite(n3, unixRuntime.exitStatus() << 8);
        }
        return unixRuntime.pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _exited() {
        Enumeration enumeration;
        Object object;
        if (this.children != null) {
            object = this.children;
            synchronized (object) {
                UnixRuntime unixRuntime;
                enumeration = this.exitedChildren.elements();
                while (enumeration.hasMoreElements()) {
                    unixRuntime = (UnixRuntime)enumeration.nextElement();
                    this.gs.tasks[unixRuntime.pid] = null;
                }
                this.exitedChildren.removeAllElements();
                enumeration = this.activeChildren.elements();
                while (enumeration.hasMoreElements()) {
                    unixRuntime = (UnixRuntime)enumeration.nextElement();
                    unixRuntime.parent = null;
                }
                this.activeChildren.removeAllElements();
            }
        }
        if ((object = this.parent) == null) {
            this.gs.tasks[this.pid] = null;
        } else {
            enumeration = ((UnixRuntime)object).children;
            synchronized (enumeration) {
                if (this.parent == null) {
                    this.gs.tasks[this.pid] = null;
                } else {
                    if (!this.parent.activeChildren.removeElement(this)) {
                        throw new Error("should never happen _exited: pid: " + this.pid);
                    }
                    this.parent.exitedChildren.addElement(this);
                    this.parent.children.notify();
                }
            }
        }
    }

    protected Object clone() {
        UnixRuntime unixRuntime = (UnixRuntime)super.clone();
        unixRuntime.pid = 0;
        unixRuntime.parent = null;
        unixRuntime.children = null;
        unixRuntime.exitedChildren = null;
        unixRuntime.activeChildren = null;
        return unixRuntime;
    }

    private int sys_fork() {
        UnixRuntime unixRuntime;
        try {
            unixRuntime = (UnixRuntime)this.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -12;
        }
        unixRuntime.parent = this;
        try {
            unixRuntime._started();
        }
        catch (ProcessTableFullExn processTableFullExn) {
            return -12;
        }
        if (this.children == null) {
            this.children = new Object();
            this.activeChildren = new Vector();
            this.exitedChildren = new Vector();
        }
        this.activeChildren.addElement(unixRuntime);
        Runtime.CPUState cPUState = new Runtime.CPUState();
        this.getCPUState(cPUState);
        cPUState.r[2] = 0;
        cPUState.pc += 4;
        unixRuntime.setCPUState(cPUState);
        unixRuntime.state = 2;
        new ForkedProcess(unixRuntime);
        return unixRuntime.pid;
    }

    public static int runAndExec(UnixRuntime unixRuntime, String string, String[] stringArray) {
        return UnixRuntime.runAndExec(unixRuntime, UnixRuntime.concatArgv(string, stringArray));
    }

    public static int runAndExec(UnixRuntime unixRuntime, String[] stringArray) {
        unixRuntime.start(stringArray);
        return UnixRuntime.executeAndExec(unixRuntime);
    }

    public static int executeAndExec(UnixRuntime unixRuntime) {
        while (true) {
            if (!unixRuntime.execute()) {
                System.err.println("WARNING: Pause requested while executing runAndExec()");
                continue;
            }
            if (unixRuntime.state != 5) {
                return unixRuntime.exitStatus();
            }
            unixRuntime = unixRuntime.execedRuntime;
        }
    }

    private String[] readStringArray(int n2) {
        int n3 = 0;
        int n4 = n2;
        while (this.memRead(n4) != 0) {
            ++n3;
            n4 += 4;
        }
        String[] stringArray = new String[n3];
        int n5 = 0;
        int n6 = n2;
        while (n5 < n3) {
            stringArray[n5] = this.cstring(this.memRead(n6));
            ++n5;
            n6 += 4;
        }
        return stringArray;
    }

    private int sys_exec(int n2, int n3, int n4) {
        return this.exec(this.normalizePath(this.cstring(n2)), this.readStringArray(n3), this.readStringArray(n4));
    }

    public Class runtimeCompile(Seekable seekable, String string) {
        if (runtimeCompilerCompile == null) {
            System.err.println("WARNING: Exec attempted but RuntimeCompiler not found!");
            return null;
        }
        try {
            return (Class)runtimeCompilerCompile.invoke(null, seekable, "unixruntime,maxinsnpermethod=256,lessconstants", string);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throwable.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int exec(String string, String[] stringArray, String[] stringArray2) {
        Runtime.FD fD;
        if (stringArray.length == 0) {
            stringArray = new String[]{""};
        }
        if (string.equals("bin/busybox") && this.getClass().getName().endsWith("BusyBox")) {
            return this.execClass(this.getClass(), stringArray, stringArray2);
        }
        Runtime.FStat fStat = this.gs.stat(this, string);
        if (fStat == null) {
            return -2;
        }
        GlobalState.CacheEnt cacheEnt = (GlobalState.CacheEnt)this.gs.execCache.get(string);
        long l2 = fStat.mtime();
        long l3 = fStat.size();
        if (cacheEnt != null) {
            if (cacheEnt.time == l2 && cacheEnt.size == l3) {
                if (cacheEnt.o instanceof Class) {
                    return this.execClass((Class)cacheEnt.o, stringArray, stringArray2);
                }
                if (cacheEnt.o instanceof String[]) {
                    return this.execScript(string, (String[])cacheEnt.o, stringArray, stringArray2);
                }
                throw new Error("should never happen");
            }
            this.gs.execCache.remove(string);
        }
        if ((fD = this.gs.open(this, string, 0, 0)) == null) {
            throw new Runtime.ErrnoException(2);
        }
        Seekable seekable = fD.seekable();
        if (seekable == null) {
            throw new Runtime.ErrnoException(13);
        }
        byte[] byArray = new byte[4096];
        try {
            int n2 = seekable.read(byArray, 0, byArray.length);
            if (n2 == -1) {
                throw new Runtime.ErrnoException(8);
            }
            switch (byArray[0]) {
                case 127: {
                    if (n2 < 4) {
                        seekable.tryReadFully(byArray, n2, 4 - n2);
                    }
                    if (byArray[1] != 69 || byArray[2] != 76 || byArray[3] != 70) {
                        int n3 = -8;
                        return n3;
                    }
                    seekable.seek(0);
                    System.err.println("Running RuntimeCompiler for " + string);
                    Class clazz = this.runtimeCompile(seekable, string);
                    System.err.println("RuntimeCompiler finished for " + string);
                    if (clazz == null) {
                        throw new Runtime.ErrnoException(8);
                    }
                    this.gs.execCache.put(string, new GlobalState.CacheEnt(l2, l3, clazz));
                    int n4 = this.execClass(clazz, stringArray, stringArray2);
                    return n4;
                }
                case 35: {
                    int n5;
                    int n6;
                    int n7;
                    if (n2 == 1) {
                        n7 = seekable.read(byArray, 1, byArray.length - 1);
                        if (n7 == -1) {
                            int n8 = -8;
                            return n8;
                        }
                        n2 += n7;
                    }
                    if (byArray[1] != 33) {
                        n7 = -8;
                        return n7;
                    }
                    n7 = 2;
                    n2 -= 2;
                    block14: while (true) {
                        for (n6 = n7; n6 < n7 + n2; ++n6) {
                            if (byArray[n6] != 10) continue;
                            n7 = n6;
                            break block14;
                        }
                        if ((n7 += n2) == byArray.length) break;
                        n2 = seekable.read(byArray, n7, byArray.length - n7);
                    }
                    for (n6 = 2; n6 < n7 && byArray[n6] == 32; ++n6) {
                    }
                    if (n6 == n7) {
                        throw new Runtime.ErrnoException(8);
                    }
                    for (n5 = n6; n5 < n7 && byArray[n5] != 32; ++n5) {
                    }
                    int n9 = n5;
                    while (n5 < n7 && byArray[n5] == 32) {
                        ++n5;
                    }
                    String[] stringArray3 = new String[]{new String(byArray, n6, n9 - n6), n5 < n7 ? new String(byArray, n5, n7 - n5) : null};
                    this.gs.execCache.put(string, new GlobalState.CacheEnt(l2, l3, stringArray3));
                    int n10 = this.execScript(string, stringArray3, stringArray, stringArray2);
                    return n10;
                }
            }
            int n11 = -8;
            return n11;
        }
        catch (IOException iOException) {
            int n12 = -5;
            return n12;
        }
        finally {
            fD.close();
        }
    }

    public int execScript(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        int n2;
        String[] stringArray4 = new String[stringArray2.length - 1 + (stringArray[1] != null ? 3 : 2)];
        int n3 = stringArray[0].lastIndexOf(47);
        stringArray4[0] = n3 == -1 ? stringArray[0] : stringArray[0].substring(n3 + 1);
        stringArray4[1] = "/" + string;
        n3 = 2;
        if (stringArray[1] != null) {
            stringArray4[n3++] = stringArray[1];
        }
        for (n2 = 1; n2 < stringArray2.length; ++n2) {
            stringArray4[n3++] = stringArray2[n2];
        }
        if (n3 != stringArray4.length) {
            throw new Error("p != newArgv.length");
        }
        System.err.println("Execing: " + stringArray[0]);
        for (n2 = 0; n2 < stringArray4.length; ++n2) {
            System.err.println("execing [" + n2 + "] " + stringArray4[n2]);
        }
        return this.exec(stringArray[0], stringArray4, stringArray3);
    }

    public int execClass(Class clazz, String[] stringArray, String[] stringArray2) {
        try {
            UnixRuntime unixRuntime = (UnixRuntime)clazz.getDeclaredConstructor(Boolean.TYPE).newInstance(Boolean.TRUE);
            return this.exec(unixRuntime, stringArray, stringArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -8;
        }
    }

    private int exec(UnixRuntime unixRuntime, String[] stringArray, String[] stringArray2) {
        for (int i2 = 0; i2 < 64; ++i2) {
            if (!this.closeOnExec[i2]) continue;
            this.closeFD(i2);
        }
        unixRuntime.fds = this.fds;
        unixRuntime.closeOnExec = this.closeOnExec;
        this.fds = null;
        this.closeOnExec = null;
        unixRuntime.gs = this.gs;
        unixRuntime.sm = this.sm;
        unixRuntime.cwd = this.cwd;
        unixRuntime.pid = this.pid;
        unixRuntime.parent = this.parent;
        unixRuntime.start(stringArray, stringArray2);
        this.state = 5;
        this.execedRuntime = unixRuntime;
        return 0;
    }

    private int sys_pipe(int n2) {
        Pipe pipe = new Pipe();
        int n3 = this.addFD(pipe.reader);
        if (n3 < 0) {
            return -23;
        }
        int n4 = this.addFD(pipe.writer);
        if (n4 < 0) {
            this.closeFD(n3);
            return -23;
        }
        try {
            this.memWrite(n2, n3);
            this.memWrite(n2 + 4, n4);
        }
        catch (Runtime.FaultException faultException) {
            this.closeFD(n3);
            this.closeFD(n4);
            return -14;
        }
        return 0;
    }

    private int sys_dup2(int n2, int n3) {
        if (n2 == n3) {
            return 0;
        }
        if (n2 < 0 || n2 >= 64) {
            return -81;
        }
        if (n3 < 0 || n3 >= 64) {
            return -81;
        }
        if (this.fds[n2] == null) {
            return -81;
        }
        if (this.fds[n3] != null) {
            this.fds[n3].close();
        }
        this.fds[n3] = this.fds[n2].dup();
        return 0;
    }

    private int sys_dup(int n2) {
        if (n2 < 0 || n2 >= 64) {
            return -81;
        }
        if (this.fds[n2] == null) {
            return -81;
        }
        Runtime.FD fD = this.fds[n2].dup();
        int n3 = this.addFD(fD);
        if (n3 < 0) {
            fD.close();
            return -23;
        }
        return n3;
    }

    private int sys_stat(int n2, int n3) {
        Runtime.FStat fStat = this.gs.stat(this, this.normalizePath(this.cstring(n2)));
        if (fStat == null) {
            return -2;
        }
        return this.stat(fStat, n3);
    }

    private int sys_lstat(int n2, int n3) {
        Runtime.FStat fStat = this.gs.lstat(this, this.normalizePath(this.cstring(n2)));
        if (fStat == null) {
            return -2;
        }
        return this.stat(fStat, n3);
    }

    private int sys_mkdir(int n2, int n3) {
        this.gs.mkdir(this, this.normalizePath(this.cstring(n2)), n3);
        return 0;
    }

    private int sys_unlink(int n2) {
        this.gs.unlink(this, this.normalizePath(this.cstring(n2)));
        return 0;
    }

    private int sys_getcwd(int n2, int n3) {
        byte[] byArray = UnixRuntime.getBytes(this.cwd);
        if (n3 == 0) {
            return -22;
        }
        if (n3 < byArray.length + 2) {
            return -34;
        }
        this.memset(n2, 47, 1);
        this.copyout(byArray, n2 + 1, byArray.length);
        this.memset(n2 + byArray.length + 1, 0, 1);
        return n2;
    }

    private int sys_chdir(int n2) {
        String string = this.normalizePath(this.cstring(n2));
        Runtime.FStat fStat = this.gs.stat(this, string);
        if (fStat == null) {
            return -2;
        }
        if (fStat.type() != 16384) {
            return -20;
        }
        this.cwd = string;
        return 0;
    }

    private int sys_getdents(int n2, int n3, int n4, int n5) {
        n4 = Math.min(n4, 0xFFFC00);
        if (n2 < 0 || n2 >= 64) {
            return -81;
        }
        if (this.fds[n2] == null) {
            return -81;
        }
        byte[] byArray = this.byteBuf(n4);
        int n6 = this.fds[n2].getdents(byArray, 0, n4);
        this.copyout(byArray, n3, n6);
        return n6;
    }

    void _preCloseFD(Runtime.FD fD) {
        Seekable seekable = fD.seekable();
        if (seekable == null) {
            return;
        }
        try {
            for (int i2 = 0; i2 < this.gs.locks.length; ++i2) {
                Seekable.Lock lock = this.gs.locks[i2];
                if (lock == null || !seekable.equals(lock.seekable()) || lock.getOwner() != this) continue;
                lock.release();
                this.gs.locks[i2] = null;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    void _postCloseFD(Runtime.FD fD) {
        if (fD.isMarkedForDeleteOnClose()) {
            try {
                this.gs.unlink(this, fD.getNormalizedPath());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private int sys_fcntl_lock(int n2, int n3, int n4) {
        if (n3 != 7 && n3 != 8) {
            return this.sys_fcntl(n2, n3, n4);
        }
        if (n2 < 0 || n2 >= 64) {
            return -81;
        }
        if (this.fds[n2] == null) {
            return -81;
        }
        Runtime.FD fD = this.fds[n2];
        if (n4 == 0) {
            return -22;
        }
        int n5 = this.memRead(n4);
        int n6 = this.memRead(n4 + 4);
        int n7 = this.memRead(n4 + 8);
        int n8 = n5 >> 16;
        int n9 = n5 & 0xFF;
        Seekable.Lock[] lockArray = this.gs.locks;
        Seekable seekable = fD.seekable();
        if (seekable == null) {
            return -22;
        }
        try {
            switch (n9) {
                case 0: {
                    break;
                }
                case 1: {
                    n6 += seekable.pos();
                    break;
                }
                case 2: {
                    n6 += seekable.length();
                    break;
                }
                default: {
                    return -1;
                }
            }
            if (n3 == 7) {
                for (int i2 = 0; i2 < lockArray.length; ++i2) {
                    if (lockArray[i2] == null || !seekable.equals(lockArray[i2].seekable()) || !lockArray[i2].overlaps(n6, n7) || lockArray[i2].getOwner() == this || lockArray[i2].isShared() && n8 == 1) continue;
                    return 0;
                }
                Seekable.Lock lock = seekable.lock(n6, n7, n8 == 1);
                if (lock != null) {
                    this.memWrite(n4, 196608);
                    lock.release();
                }
                return 0;
            }
            if (n3 != 8) {
                return -22;
            }
            if (n8 == 3) {
                for (int i3 = 0; i3 < lockArray.length; ++i3) {
                    int n10;
                    if (lockArray[i3] == null || !seekable.equals(lockArray[i3].seekable()) || lockArray[i3].getOwner() != this || (n10 = (int)lockArray[i3].position()) < n6 || n6 != 0 && n7 != 0 && (long)n10 + lockArray[i3].size() > (long)(n6 + n7)) continue;
                    lockArray[i3].release();
                    lockArray[i3] = null;
                }
                return 0;
            }
            if (n8 == 1 || n8 == 2) {
                int n11;
                for (int i4 = 0; i4 < lockArray.length; ++i4) {
                    if (lockArray[i4] == null || !seekable.equals(lockArray[i4].seekable())) continue;
                    if (lockArray[i4].getOwner() == this) {
                        if (lockArray[i4].contained(n6, n7)) {
                            lockArray[i4].release();
                            lockArray[i4] = null;
                            continue;
                        }
                        if (!lockArray[i4].contains(n6, n7)) continue;
                        if (lockArray[i4].isShared() == (n8 == 1)) {
                            this.memWrite(n4 + 4, (int)lockArray[i4].position());
                            this.memWrite(n4 + 8, (int)lockArray[i4].size());
                            return 0;
                        }
                        lockArray[i4].release();
                        lockArray[i4] = null;
                        continue;
                    }
                    if (!lockArray[i4].overlaps(n6, n7) || lockArray[i4].isShared() && n8 != 2) continue;
                    return -11;
                }
                Seekable.Lock lock = seekable.lock(n6, n7, n8 == 1);
                if (lock == null) {
                    return -11;
                }
                lock.setOwner(this);
                for (n11 = 0; n11 < lockArray.length && lockArray[n11] != null; ++n11) {
                }
                if (n11 == lockArray.length) {
                    return -46;
                }
                lockArray[n11] = lock;
                return 0;
            }
            return -22;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private int sys_socket(int n2, int n3, int n4) {
        if (n2 != 2 || n3 != 1 && n3 != 2) {
            return -123;
        }
        return this.addFD(new SocketFD(n3 == 1 ? 0 : 1));
    }

    private SocketFD getSocketFD(int n2) {
        if (n2 < 0 || n2 >= 64) {
            throw new Runtime.ErrnoException(81);
        }
        if (this.fds[n2] == null) {
            throw new Runtime.ErrnoException(81);
        }
        if (!(this.fds[n2] instanceof SocketFD)) {
            throw new Runtime.ErrnoException(108);
        }
        return (SocketFD)this.fds[n2];
    }

    private int sys_connect(int n2, int n3, int n4) {
        InetAddress inetAddress;
        SocketFD socketFD = this.getSocketFD(n2);
        if (socketFD.type() == 0 && (socketFD.s != null || socketFD.ss != null)) {
            return -127;
        }
        int n5 = this.memRead(n3);
        if ((n5 >>> 16 & 0xFF) != 2) {
            return -106;
        }
        int n6 = n5 & 0xFFFF;
        byte[] byArray = new byte[4];
        this.copyin(n3 + 4, byArray, 4);
        try {
            inetAddress = Platform.inetAddressFromBytes(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            return -125;
        }
        socketFD.connectAddr = inetAddress;
        socketFD.connectPort = n6;
        try {
            switch (socketFD.type()) {
                case 0: {
                    Socket socket;
                    socketFD.s = socket = new Socket(inetAddress, n6);
                    socketFD.setOptions();
                    socketFD.is = socket.getInputStream();
                    socketFD.os = socket.getOutputStream();
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new Error("should never happen");
                }
            }
        }
        catch (IOException iOException) {
            return -111;
        }
        return 0;
    }

    private int sys_resolve_hostname(int n2, int n3, int n4) {
        InetAddress[] inetAddressArray;
        String string = this.cstring(n2);
        int n5 = this.memRead(n4);
        try {
            inetAddressArray = InetAddress.getAllByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return 1;
        }
        int n6 = UnixRuntime.min(n5 / 4, inetAddressArray.length);
        int n7 = 0;
        while (n7 < n6) {
            byte[] byArray = inetAddressArray[n7].getAddress();
            this.copyout(byArray, n3, 4);
            ++n7;
            n3 += 4;
        }
        this.memWrite(n4, n6 * 4);
        return 0;
    }

    private int sys_setsockopt(int n2, int n3, int n4, int n5, int n6) {
        SocketFD socketFD = this.getSocketFD(n2);
        switch (n3) {
            case 65535: {
                switch (n4) {
                    case 4: 
                    case 8: {
                        if (n6 != 4) {
                            return -22;
                        }
                        int n7 = this.memRead(n5);
                        socketFD.options = n7 != 0 ? (socketFD.options |= n4) : (socketFD.options &= ~n4);
                        socketFD.setOptions();
                        return 0;
                    }
                }
                System.err.println("Unknown setsockopt name passed: " + n4);
                return -109;
            }
        }
        System.err.println("Unknown setsockopt leve passed: " + n3);
        return -109;
    }

    private int sys_getsockopt(int n2, int n3, int n4, int n5, int n6) {
        SocketFD socketFD = this.getSocketFD(n2);
        switch (n3) {
            case 65535: {
                switch (n4) {
                    case 4: 
                    case 8: {
                        int n7 = this.memRead(n6);
                        if (n7 < 4) {
                            return -22;
                        }
                        int n8 = (socketFD.options & n4) != 0 ? 1 : 0;
                        this.memWrite(n5, n8);
                        this.memWrite(n6, 4);
                        return 0;
                    }
                }
                System.err.println("Unknown setsockopt name passed: " + n4);
                return -109;
            }
        }
        System.err.println("Unknown setsockopt leve passed: " + n3);
        return -109;
    }

    private int sys_bind(int n2, int n3, int n4) {
        SocketFD socketFD = this.getSocketFD(n2);
        if (socketFD.type() == 0 && (socketFD.s != null || socketFD.ss != null)) {
            return -127;
        }
        int n5 = this.memRead(n3);
        if ((n5 >>> 16 & 0xFF) != 2) {
            return -106;
        }
        int n6 = n5 & 0xFFFF;
        InetAddress inetAddress = null;
        if (this.memRead(n3 + 4) != 0) {
            byte[] byArray = new byte[4];
            this.copyin(n3 + 4, byArray, 4);
            try {
                inetAddress = Platform.inetAddressFromBytes(byArray);
            }
            catch (UnknownHostException unknownHostException) {
                return -125;
            }
        }
        switch (socketFD.type()) {
            case 0: {
                socketFD.bindAddr = inetAddress;
                socketFD.bindPort = n6;
                return 0;
            }
            case 1: {
                if (socketFD.ds != null) {
                    socketFD.ds.close();
                }
                try {
                    socketFD.ds = inetAddress != null ? new DatagramSocket(n6, inetAddress) : new DatagramSocket(n6);
                }
                catch (IOException iOException) {
                    return -112;
                }
                return 0;
            }
        }
        throw new Error("should never happen");
    }

    private int sys_listen(int n2, int n3) {
        SocketFD socketFD = this.getSocketFD(n2);
        if (socketFD.type() != 0) {
            return -95;
        }
        if (socketFD.ss != null || socketFD.s != null) {
            return -127;
        }
        if (socketFD.bindPort < 0) {
            return -95;
        }
        try {
            socketFD.ss = new ServerSocket(socketFD.bindPort, n3, socketFD.bindAddr);
            socketFD.flags |= 2;
            return 0;
        }
        catch (IOException iOException) {
            return -112;
        }
    }

    private int sys_accept(int n2, int n3, int n4) {
        Object object;
        Socket socket;
        SocketFD socketFD = this.getSocketFD(n2);
        if (socketFD.type() != 0) {
            return -95;
        }
        if (!socketFD.listen()) {
            return -95;
        }
        int n5 = this.memRead(n4);
        ServerSocket serverSocket = socketFD.ss;
        try {
            socket = serverSocket.accept();
        }
        catch (IOException iOException) {
            return -5;
        }
        if (n5 >= 8) {
            this.memWrite(n3, 0x6020000 | socket.getPort());
            object = socket.getInetAddress().getAddress();
            this.copyout((byte[])object, n3 + 4, 4);
            this.memWrite(n4, 8);
        }
        object = new SocketFD(0);
        ((SocketFD)object).s = socket;
        try {
            ((SocketFD)object).is = socket.getInputStream();
            ((SocketFD)object).os = socket.getOutputStream();
        }
        catch (IOException iOException) {
            return -5;
        }
        int n6 = this.addFD((Runtime.FD)object);
        if (n6 == -1) {
            ((Runtime.FD)object).close();
            return -23;
        }
        return n6;
    }

    private int sys_shutdown(int n2, int n3) {
        SocketFD socketFD = this.getSocketFD(n2);
        if (socketFD.type() != 0 || socketFD.listen()) {
            return -95;
        }
        if (socketFD.s == null) {
            return -128;
        }
        Socket socket = socketFD.s;
        try {
            if (n3 == 0 || n3 == 2) {
                Platform.socketHalfClose(socket, false);
            }
            if (n3 == 1 || n3 == 2) {
                Platform.socketHalfClose(socket, true);
            }
        }
        catch (IOException iOException) {
            return -5;
        }
        return 0;
    }

    private int sys_sendto(int n2, int n3, int n4, int n5, int n6, int n7) {
        InetAddress inetAddress;
        SocketFD socketFD = this.getSocketFD(n2);
        if (n5 != 0) {
            throw new Runtime.ErrnoException(22);
        }
        int n8 = this.memRead(n6);
        if ((n8 >>> 16 & 0xFF) != 2) {
            return -106;
        }
        int n9 = n8 & 0xFFFF;
        byte[] byArray = new byte[4];
        this.copyin(n6 + 4, byArray, 4);
        try {
            inetAddress = Platform.inetAddressFromBytes(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            return -125;
        }
        n4 = Math.min(n4, 0xFFFC00);
        byte[] byArray2 = this.byteBuf(n4);
        this.copyin(n3, byArray2, n4);
        try {
            return socketFD.sendto(byArray2, 0, n4, inetAddress, n9);
        }
        catch (Runtime.ErrnoException errnoException) {
            if (errnoException.errno == 32) {
                this.exit(141, true);
            }
            throw errnoException;
        }
    }

    private int sys_recvfrom(int n2, int n3, int n4, int n5, int n6, int n7) {
        SocketFD socketFD = this.getSocketFD(n2);
        if (n5 != 0) {
            throw new Runtime.ErrnoException(22);
        }
        InetAddress[] inetAddressArray = n6 == 0 ? null : new InetAddress[1];
        int[] nArray = n6 == 0 ? null : new int[1];
        n4 = Math.min(n4, 0xFFFC00);
        byte[] byArray = this.byteBuf(n4);
        int n8 = socketFD.recvfrom(byArray, 0, n4, inetAddressArray, nArray);
        this.copyout(byArray, n3, n8);
        if (n6 != 0) {
            this.memWrite(n6, 0x20000 | nArray[0]);
            byte[] byArray2 = inetAddressArray[0].getAddress();
            this.copyout(byArray2, n6 + 4, 4);
        }
        return n8;
    }

    private int sys_select(int n2, int n3, int n4, int n5, int n6) {
        return -88;
    }

    private static String hostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "darkstar";
        }
    }

    private int sys_sysctl(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n6 != 0) {
            return -1;
        }
        if (n3 == 0) {
            return -2;
        }
        if (n4 == 0) {
            return 0;
        }
        String string = null;
        switch (this.memRead(n2)) {
            case 1: {
                if (n3 != 2) break;
                switch (this.memRead(n2 + 4)) {
                    case 1: {
                        string = "NestedVM";
                        break;
                    }
                    case 10: {
                        string = UnixRuntime.hostName();
                        break;
                    }
                    case 2: {
                        string = "1.0";
                        break;
                    }
                    case 4: {
                        string = "NestedVM Kernel Version 1.0";
                    }
                }
                break;
            }
            case 6: {
                if (n3 != 2) break;
                switch (this.memRead(n2 + 4)) {
                    case 1: {
                        string = "NestedVM Virtual Machine";
                    }
                }
            }
        }
        if (string == null) {
            return -2;
        }
        int n8 = this.memRead(n5);
        if (string instanceof String) {
            byte[] byArray = UnixRuntime.getNullTerminatedBytes(string);
            if (n8 < byArray.length) {
                return -12;
            }
            n8 = byArray.length;
            this.copyout(byArray, n4, n8);
            this.memWrite(n5, n8);
        } else if (string instanceof Integer) {
            if (n8 < 4) {
                return -12;
            }
            this.memWrite(n4, (Integer)((Object)string));
        } else {
            throw new Error("should never happen");
        }
        return 0;
    }

    private String normalizePath(String string) {
        boolean bl2 = string.startsWith("/");
        int n2 = this.cwd.length();
        if (!string.startsWith(".") && string.indexOf("./") == -1 && string.indexOf("//") == -1 && !string.endsWith(".")) {
            return bl2 ? string.substring(1) : (n2 == 0 ? string : (string.length() == 0 ? this.cwd : this.cwd + "/" + string));
        }
        char[] cArray = new char[string.length() + 1];
        char[] cArray2 = new char[cArray.length + (bl2 ? -1 : this.cwd.length())];
        string.getChars(0, string.length(), cArray, 0);
        int n3 = 0;
        int n4 = 0;
        if (bl2) {
            while (cArray[++n3] == '/') {
            }
        } else if (n2 != 0) {
            this.cwd.getChars(0, n2, cArray2, 0);
            n4 = n2;
        }
        while (cArray[n3] != '\u0000') {
            if (n3 != 0) {
                while (cArray[n3] != '\u0000' && cArray[n3] != '/') {
                    cArray2[n4++] = cArray[n3++];
                }
                if (cArray[n3] == '\u0000') break;
                while (cArray[n3] == '/') {
                    ++n3;
                }
            }
            if (cArray[n3] == '\u0000') break;
            if (cArray[n3] != '.') {
                cArray2[n4++] = 47;
                cArray2[n4++] = cArray[n3++];
                continue;
            }
            if (cArray[n3 + 1] == '\u0000' || cArray[n3 + 1] == '/') {
                ++n3;
                continue;
            }
            if (cArray[n3 + 1] == '.' && (cArray[n3 + 2] == '\u0000' || cArray[n3 + 2] == '/')) {
                n3 += 2;
                if (n4 > 0) {
                    --n4;
                }
                while (n4 > 0 && cArray2[n4] != '/') {
                    --n4;
                }
                continue;
            }
            ++n3;
            cArray2[n4++] = 47;
            cArray2[n4++] = 46;
        }
        if (n4 > 0 && cArray2[n4 - 1] == '/') {
            --n4;
        }
        int n5 = cArray2[0] == '/' ? 1 : 0;
        return new String(cArray2, n5, n4 - n5);
    }

    Runtime.FStat hostFStat(File file, Object object) {
        Object object2;
        boolean bl2 = false;
        try {
            object2 = new FileInputStream(file);
            switch (((FileInputStream)object2).read()) {
                case 127: {
                    bl2 = ((FileInputStream)object2).read() == 69 && ((FileInputStream)object2).read() == 76 && ((FileInputStream)object2).read() == 70;
                    break;
                }
                case 35: {
                    bl2 = ((FileInputStream)object2).read() == 33;
                }
            }
            ((FileInputStream)object2).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object2 = (HostFS)object;
        short s2 = ((HostFS)object2).inodes.get(file.getAbsolutePath());
        int n2 = ((HostFS)object2).devno;
        return new Runtime.HostFStat(this, file, bl2, s2, n2){
            private final int val$inode;
            private final int val$devno;
            private final UnixRuntime this$0;
            {
                this.this$0 = unixRuntime;
                this.val$inode = n2;
                this.val$devno = n3;
            }

            public int inode() {
                return this.val$inode;
            }

            public int dev() {
                return this.val$devno;
            }
        };
    }

    Runtime.FD hostFSDirFD(File file, Object object) {
        HostFS hostFS;
        HostFS hostFS2 = hostFS = (HostFS)object;
        hostFS2.getClass();
        return new HostFS.HostDirFD(hostFS2, file);
    }

    private static void putInt(byte[] byArray, int n2, int n3) {
        byArray[n2 + 0] = (byte)(n3 >>> 24 & 0xFF);
        byArray[n2 + 1] = (byte)(n3 >>> 16 & 0xFF);
        byArray[n2 + 2] = (byte)(n3 >>> 8 & 0xFF);
        byArray[n2 + 3] = (byte)(n3 >>> 0 & 0xFF);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static void access$500(byte[] byArray, int n2, int n3) {
        UnixRuntime.putInt(byArray, n2, n3);
    }

    static {
        Method method;
        defaultGS = new GlobalState();
        try {
            method = Class.forName("org.ibex.nestedvm.RuntimeCompiler").getMethod("compile", class$org$ibex$nestedvm$util$Seekable == null ? (class$org$ibex$nestedvm$util$Seekable = UnixRuntime.class$("org.ibex.nestedvm.util.Seekable")) : class$org$ibex$nestedvm$util$Seekable, class$java$lang$String == null ? (class$java$lang$String = UnixRuntime.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = UnixRuntime.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            method = null;
        }
        runtimeCompilerCompile = method;
    }

    public static class ResourceFS
    extends FS {
        final InodeCache inodes = new InodeCache(500);

        public Runtime.FStat lstat(UnixRuntime unixRuntime, String string) {
            return this.stat(unixRuntime, string);
        }

        public void mkdir(UnixRuntime unixRuntime, String string, int n2) {
            throw new Runtime.ErrnoException(30);
        }

        public void unlink(UnixRuntime unixRuntime, String string) {
            throw new Runtime.ErrnoException(30);
        }

        Runtime.FStat connFStat(URLConnection uRLConnection) {
            return new Runtime.FStat(this, uRLConnection){
                private final URLConnection val$conn;
                private final ResourceFS this$0;
                {
                    this.this$0 = resourceFS;
                    this.val$conn = uRLConnection;
                }

                public int type() {
                    return 32768;
                }

                public int nlink() {
                    return 1;
                }

                public int mode() {
                    return 292;
                }

                public int size() {
                    return this.val$conn.getContentLength();
                }

                public int mtime() {
                    return (int)(this.val$conn.getDate() / 1000L);
                }

                public int inode() {
                    return this.this$0.inodes.get(this.val$conn.getURL().toString());
                }

                public int dev() {
                    return this.this$0.devno;
                }
            };
        }

        public Runtime.FStat stat(UnixRuntime unixRuntime, String string) {
            URL uRL = unixRuntime.getClass().getResource("/" + string);
            if (uRL == null) {
                return null;
            }
            try {
                return this.connFStat(uRL.openConnection());
            }
            catch (IOException iOException) {
                throw new Runtime.ErrnoException(5);
            }
        }

        public Runtime.FD open(UnixRuntime unixRuntime, String string, int n2, int n3) {
            if ((n2 & 0xFFFFFFFC) != 0) {
                System.err.println("WARNING: Unsupported flags passed to ResourceFS.open(\"" + string + "\"): " + Runtime.toHex(n2 & 0xFFFFFFFC));
                throw new Runtime.ErrnoException(134);
            }
            if ((n2 & 3) != 0) {
                throw new Runtime.ErrnoException(30);
            }
            URL uRL = unixRuntime.getClass().getResource("/" + string);
            if (uRL == null) {
                return null;
            }
            try {
                URLConnection uRLConnection = uRL.openConnection();
                Seekable.InputStream inputStream = new Seekable.InputStream(uRLConnection.getInputStream());
                return new Runtime.SeekableFD(this, inputStream, n2, uRLConnection){
                    private final URLConnection val$conn;
                    private final ResourceFS this$0;
                    {
                        this.this$0 = resourceFS;
                        this.val$conn = uRLConnection;
                    }

                    protected Runtime.FStat _fstat() {
                        return this.this$0.connFStat(this.val$conn);
                    }
                };
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (fileNotFoundException.getMessage() != null && fileNotFoundException.getMessage().indexOf("Permission denied") >= 0) {
                    throw new Runtime.ErrnoException(13);
                }
                return null;
            }
            catch (IOException iOException) {
                throw new Runtime.ErrnoException(5);
            }
        }
    }

    public static class DevFS
    extends FS {
        private static final int ROOT_INODE = 1;
        private static final int NULL_INODE = 2;
        private static final int ZERO_INODE = 3;
        private static final int FD_INODE = 4;
        private static final int FD_INODES = 32;
        private Runtime.FD devZeroFD = new Runtime.FD(this){
            private final DevFS this$0;
            {
                this.this$0 = devFS;
            }

            public int read(byte[] byArray, int n2, int n3) {
                for (int i2 = n2; i2 < n2 + n3; ++i2) {
                    byArray[i2] = 0;
                }
                return n3;
            }

            public int write(byte[] byArray, int n2, int n3) {
                return n3;
            }

            public int seek(int n2, int n3) {
                return 0;
            }

            public Runtime.FStat _fstat() {
                return new DevFStat(this){
                    private final 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public int inode() {
                        return 3;
                    }
                };
            }

            public int flags() {
                return 2;
            }

            static DevFS access$700(1 var0) {
                return var0.this$0;
            }
        };
        private Runtime.FD devNullFD = new Runtime.FD(this){
            private final DevFS this$0;
            {
                this.this$0 = devFS;
            }

            public int read(byte[] byArray, int n2, int n3) {
                return 0;
            }

            public int write(byte[] byArray, int n2, int n3) {
                return n3;
            }

            public int seek(int n2, int n3) {
                return 0;
            }

            public Runtime.FStat _fstat() {
                return new DevFStat(this){
                    private final 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public int inode() {
                        return 2;
                    }
                };
            }

            public int flags() {
                return 2;
            }

            static DevFS access$800(2 var0) {
                return var0.this$0;
            }
        };

        public Runtime.FD open(UnixRuntime unixRuntime, String string, int n2, int n3) {
            if (string.equals("null")) {
                return this.devNullFD;
            }
            if (string.equals("zero")) {
                return this.devZeroFD;
            }
            if (string.startsWith("fd/")) {
                int n4;
                try {
                    n4 = Integer.parseInt(string.substring(4));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                if (n4 < 0 || n4 >= 64) {
                    return null;
                }
                if (unixRuntime.fds[n4] == null) {
                    return null;
                }
                return unixRuntime.fds[n4].dup();
            }
            if (string.equals("fd")) {
                int n5 = 0;
                for (int i2 = 0; i2 < 64; ++i2) {
                    if (unixRuntime.fds[i2] == null) continue;
                    ++n5;
                }
                int[] nArray = new int[n5];
                n5 = 0;
                for (int i3 = 0; i3 < 64; ++i3) {
                    if (unixRuntime.fds[i3] == null) continue;
                    nArray[n5++] = i3;
                }
                return new DevDirFD(this, nArray){
                    private final int[] val$files;
                    private final DevFS this$0;
                    {
                        this.this$0 = devFS;
                        this.val$files = nArray;
                    }

                    public int myInode() {
                        return 4;
                    }

                    public int parentInode() {
                        return 1;
                    }

                    public int inode(int n2) {
                        return 32 + n2;
                    }

                    public String name(int n2) {
                        return Integer.toString(this.val$files[n2]);
                    }

                    public int size() {
                        return this.val$files.length;
                    }
                };
            }
            if (string.equals("")) {
                return new DevDirFD(this){
                    private final DevFS this$0;
                    {
                        this.this$0 = devFS;
                    }

                    public int myInode() {
                        return 1;
                    }

                    public int parentInode() {
                        return 1;
                    }

                    public int inode(int n2) {
                        switch (n2) {
                            case 0: {
                                return 2;
                            }
                            case 1: {
                                return 3;
                            }
                            case 2: {
                                return 4;
                            }
                        }
                        return -1;
                    }

                    public String name(int n2) {
                        switch (n2) {
                            case 0: {
                                return "null";
                            }
                            case 1: {
                                return "zero";
                            }
                            case 2: {
                                return "fd";
                            }
                        }
                        return null;
                    }

                    public int size() {
                        return 3;
                    }
                };
            }
            return null;
        }

        public Runtime.FStat stat(UnixRuntime unixRuntime, String string) {
            if (string.equals("null")) {
                return this.devNullFD.fstat();
            }
            if (string.equals("zero")) {
                return this.devZeroFD.fstat();
            }
            if (string.startsWith("fd/")) {
                int n2;
                try {
                    n2 = Integer.parseInt(string.substring(3));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                if (n2 < 0 || n2 >= 64) {
                    return null;
                }
                if (unixRuntime.fds[n2] == null) {
                    return null;
                }
                return unixRuntime.fds[n2].fstat();
            }
            if (string.equals("fd")) {
                return new Runtime.FStat(this){
                    private final DevFS this$0;
                    {
                        this.this$0 = devFS;
                    }

                    public int inode() {
                        return 4;
                    }

                    public int dev() {
                        return this.this$0.devno;
                    }

                    public int type() {
                        return 16384;
                    }

                    public int mode() {
                        return 292;
                    }
                };
            }
            if (string.equals("")) {
                return new Runtime.FStat(this){
                    private final DevFS this$0;
                    {
                        this.this$0 = devFS;
                    }

                    public int inode() {
                        return 1;
                    }

                    public int dev() {
                        return this.this$0.devno;
                    }

                    public int type() {
                        return 16384;
                    }

                    public int mode() {
                        return 292;
                    }
                };
            }
            return null;
        }

        public void mkdir(UnixRuntime unixRuntime, String string, int n2) {
            throw new Runtime.ErrnoException(30);
        }

        public void unlink(UnixRuntime unixRuntime, String string) {
            throw new Runtime.ErrnoException(30);
        }

        private abstract class DevDirFD
        extends DirFD {
            private final DevFS this$0;

            private DevDirFD(DevFS devFS) {
                this.this$0 = devFS;
            }

            public int myDev() {
                return this.this$0.devno;
            }

            DevDirFD(DevFS devFS, org.ibex.nestedvm.UnixRuntime$1 var2_2) {
                this(devFS);
            }
        }

        private abstract class DevFStat
        extends Runtime.FStat {
            private final DevFS this$0;

            private DevFStat(DevFS devFS) {
                this.this$0 = devFS;
            }

            public int dev() {
                return this.this$0.devno;
            }

            public int mode() {
                return 438;
            }

            public int type() {
                return 8192;
            }

            public int nlink() {
                return 1;
            }

            public abstract int inode();

            DevFStat(DevFS devFS, org.ibex.nestedvm.UnixRuntime$1 var2_2) {
                this(devFS);
            }
        }
    }

    public static abstract class DirFD
    extends Runtime.FD {
        private int pos = -2;

        protected abstract int size();

        protected abstract String name(int var1);

        protected abstract int inode(int var1);

        protected abstract int myDev();

        protected abstract int parentInode();

        protected abstract int myInode();

        public int flags() {
            return 0;
        }

        public int getdents(byte[] byArray, int n2, int n3) {
            int n4 = n2;
            block3: while (n3 > 0 && this.pos < this.size()) {
                block5: {
                    int n5;
                    int n6;
                    switch (this.pos) {
                        case -2: 
                        case -1: {
                            int n7 = n6 = this.pos == -1 ? this.parentInode() : this.myInode();
                            if (n6 != -1) {
                                n5 = 9 + (this.pos == -1 ? 2 : 1);
                                if (n5 > n3) break block3;
                                byArray[n2 + 8] = 46;
                                if (this.pos != -1) break;
                                byArray[n2 + 9] = 46;
                                break;
                            }
                            break block5;
                        }
                        default: {
                            String string = this.name(this.pos);
                            byte[] byArray2 = Runtime.getBytes(string);
                            n5 = byArray2.length + 9;
                            if (n5 > n3) break block3;
                            n6 = this.inode(this.pos);
                            System.arraycopy(byArray2, 0, byArray, n2 + 8, byArray2.length);
                        }
                    }
                    byArray[n2 + n5 - 1] = 0;
                    n5 = n5 + 3 & 0xFFFFFFFC;
                    UnixRuntime.access$500(byArray, n2, n5);
                    UnixRuntime.access$500(byArray, n2 + 4, n6);
                    n2 += n5;
                    n3 -= n5;
                }
                ++this.pos;
            }
            return n2 - n4;
        }

        protected Runtime.FStat _fstat() {
            return new Runtime.FStat(this){
                private final DirFD this$0;
                {
                    this.this$0 = dirFD;
                }

                public int type() {
                    return 16384;
                }

                public int inode() {
                    return this.this$0.myInode();
                }

                public int dev() {
                    return this.this$0.myDev();
                }
            };
        }
    }

    public static class CygdriveFS
    extends HostFS {
        protected File hostFile(String string) {
            char c2 = string.charAt(0);
            if (c2 < 'a' || c2 > 'z' || string.charAt(1) != '/') {
                return null;
            }
            string = c2 + ":" + string.substring(1).replace('/', '\\');
            return new File(string);
        }

        public CygdriveFS() {
            super("/");
        }
    }

    public static class HostFS
    extends FS {
        InodeCache inodes = new InodeCache(4000);
        protected File root;

        public File getRoot() {
            return this.root;
        }

        protected File hostFile(String string) {
            char c2 = File.separatorChar;
            if (c2 != '/') {
                char[] cArray = string.toCharArray();
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    char c3 = cArray[i2];
                    if (c3 == '/') {
                        cArray[i2] = c2;
                        continue;
                    }
                    if (c3 != c2) continue;
                    cArray[i2] = 47;
                }
                string = new String(cArray);
            }
            return new File(this.root, string);
        }

        public HostFS(String string) {
            this(new File(string));
        }

        public HostFS(File file) {
            this.root = file;
        }

        public Runtime.FD open(UnixRuntime unixRuntime, String string, int n2, int n3) {
            File file = this.hostFile(string);
            return unixRuntime.hostFSOpen(file, n2, n3, this);
        }

        public void unlink(UnixRuntime unixRuntime, String string) {
            File file = this.hostFile(string);
            if (unixRuntime.sm != null && !unixRuntime.sm.allowUnlink(file)) {
                throw new Runtime.ErrnoException(1);
            }
            if (!file.exists()) {
                throw new Runtime.ErrnoException(2);
            }
            if (!file.delete()) {
                boolean bl2 = false;
                for (int i2 = 0; i2 < 64; ++i2) {
                    String string2;
                    if (unixRuntime.fds[i2] == null || (string2 = unixRuntime.fds[i2].getNormalizedPath()) == null || !string2.equals(string)) continue;
                    unixRuntime.fds[i2].markDeleteOnClose();
                    bl2 = true;
                }
                if (!bl2) {
                    throw new Runtime.ErrnoException(1);
                }
            }
        }

        public Runtime.FStat stat(UnixRuntime unixRuntime, String string) {
            File file = this.hostFile(string);
            if (unixRuntime.sm != null && !unixRuntime.sm.allowStat(file)) {
                throw new Runtime.ErrnoException(13);
            }
            if (!file.exists()) {
                return null;
            }
            return unixRuntime.hostFStat(file, this);
        }

        public void mkdir(UnixRuntime unixRuntime, String string, int n2) {
            File file = this.hostFile(string);
            if (unixRuntime.sm != null && !unixRuntime.sm.allowWrite(file)) {
                throw new Runtime.ErrnoException(13);
            }
            if (file.exists() && file.isDirectory()) {
                throw new Runtime.ErrnoException(17);
            }
            if (file.exists()) {
                throw new Runtime.ErrnoException(20);
            }
            File file2 = HostFS.getParentFile(file);
            if (!(file2 == null || file2.exists() && file2.isDirectory())) {
                throw new Runtime.ErrnoException(20);
            }
            if (!file.mkdir()) {
                throw new Runtime.ErrnoException(5);
            }
        }

        private static File getParentFile(File file) {
            String string = file.getParent();
            return string == null ? null : new File(string);
        }

        static File access$400(File file) {
            return HostFS.getParentFile(file);
        }

        public class HostDirFD
        extends DirFD {
            private final File f;
            private final File[] children;
            private final HostFS this$0;

            public HostDirFD(HostFS hostFS, File file) {
                this.this$0 = hostFS;
                this.f = file;
                String[] stringArray = file.list();
                this.children = new File[stringArray.length];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    this.children[i2] = new File(file, stringArray[i2]);
                }
            }

            public int size() {
                return this.children.length;
            }

            public String name(int n2) {
                return this.children[n2].getName();
            }

            public int inode(int n2) {
                return this.this$0.inodes.get(this.children[n2].getAbsolutePath());
            }

            public int parentInode() {
                File file = HostFS.access$400(this.f);
                return file == null ? this.myInode() : (int)this.this$0.inodes.get(file.getAbsolutePath());
            }

            public int myInode() {
                return this.this$0.inodes.get(this.f.getAbsolutePath());
            }

            public int myDev() {
                return this.this$0.devno;
            }
        }
    }

    public static abstract class FS {
        static final int OPEN = 1;
        static final int STAT = 2;
        static final int LSTAT = 3;
        static final int MKDIR = 4;
        static final int UNLINK = 5;
        GlobalState owner;
        int devno;

        Object dispatch(int n2, UnixRuntime unixRuntime, String string, int n3, int n4) {
            switch (n2) {
                case 1: {
                    return this.open(unixRuntime, string, n3, n4);
                }
                case 2: {
                    return this.stat(unixRuntime, string);
                }
                case 3: {
                    return this.lstat(unixRuntime, string);
                }
                case 4: {
                    this.mkdir(unixRuntime, string, n3);
                    return null;
                }
                case 5: {
                    this.unlink(unixRuntime, string);
                    return null;
                }
            }
            throw new Error("should never happen");
        }

        public Runtime.FStat lstat(UnixRuntime unixRuntime, String string) {
            return this.stat(unixRuntime, string);
        }

        public abstract Runtime.FD open(UnixRuntime var1, String var2, int var3, int var4);

        public abstract Runtime.FStat stat(UnixRuntime var1, String var2);

        public abstract void mkdir(UnixRuntime var1, String var2, int var3);

        public abstract void unlink(UnixRuntime var1, String var2);
    }

    public static final class GlobalState {
        Hashtable execCache = new Hashtable();
        final UnixRuntime[] tasks;
        int nextPID = 1;
        Seekable.Lock[] locks = new Seekable.Lock[16];
        private MP[] mps = new MP[0];
        private FS root;

        public GlobalState() {
            this(255);
        }

        public GlobalState(int n2) {
            this(n2, true);
        }

        public GlobalState(int n2, boolean bl2) {
            this.tasks = new UnixRuntime[n2 + 1];
            if (bl2) {
                File[] fileArray;
                File file = null;
                if (Platform.getProperty("nestedvm.root") != null) {
                    file = new File(Platform.getProperty("nestedvm.root"));
                    if (!file.isDirectory()) {
                        throw new IllegalArgumentException("nestedvm.root is not a directory");
                    }
                } else {
                    fileArray = Platform.getProperty("user.dir");
                    file = Platform.getRoot(new File((String)(fileArray != null ? fileArray : ".")));
                }
                this.addMount("/", new HostFS(file));
                if (Platform.getProperty("nestedvm.root") == null) {
                    fileArray = Platform.listRoots();
                    for (int i2 = 0; i2 < fileArray.length; ++i2) {
                        String string = fileArray[i2].getPath();
                        if (string.endsWith(File.separator)) {
                            string = string.substring(0, string.length() - 1);
                        }
                        if (string.length() == 0 || string.indexOf(47) != -1) continue;
                        this.addMount("/" + string.toLowerCase(), new HostFS(fileArray[i2]));
                    }
                }
                this.addMount("/dev", new DevFS());
                this.addMount("/resource", new ResourceFS());
                this.addMount("/cygdrive", new CygdriveFS());
            }
        }

        public String mapHostPath(String string) {
            return this.mapHostPath(new File(string));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String mapHostPath(File file) {
            FS fS;
            GlobalState globalState = this;
            synchronized (globalState) {
                this.mps = this.mps;
                fS = this.root;
            }
            if (!file.isAbsolute()) {
                file = new File(file.getAbsolutePath());
            }
            for (int i2 = this.mps.length; i2 >= 0; --i2) {
                Object object;
                String string;
                FS fS2 = i2 == this.mps.length ? fS : this.mps[i2].fs;
                String string2 = string = i2 == this.mps.length ? "" : this.mps[i2].path;
                if (!(fS2 instanceof HostFS)) continue;
                File file2 = ((HostFS)fS2).getRoot();
                if (!file2.isAbsolute()) {
                    file2 = new File(file2.getAbsolutePath());
                }
                if (!file.getPath().startsWith(file2.getPath())) continue;
                char c2 = File.separatorChar;
                String string3 = file.getPath().substring(file2.getPath().length());
                if (c2 != '/') {
                    object = string3.toCharArray();
                    for (int i3 = 0; i3 < ((char[])object).length; ++i3) {
                        if (object[i3] == '/') {
                            object[i3] = c2;
                            continue;
                        }
                        if (object[i3] != c2) continue;
                        object[i3] = 47;
                    }
                    string3 = new String((char[])object);
                }
                object = "/" + (string.length() == 0 ? "" : string + "/") + string3;
                return object;
            }
            return null;
        }

        public synchronized FS getMount(String string) {
            if (!string.startsWith("/")) {
                throw new IllegalArgumentException("Mount point doesn't start with a /");
            }
            if (string.equals("/")) {
                return this.root;
            }
            string = string.substring(1);
            for (int i2 = 0; i2 < this.mps.length; ++i2) {
                if (!this.mps[i2].path.equals(string)) continue;
                return this.mps[i2].fs;
            }
            return null;
        }

        public synchronized void addMount(String string, FS fS) {
            if (this.getMount(string) != null) {
                throw new IllegalArgumentException("mount point already exists");
            }
            if (!string.startsWith("/")) {
                throw new IllegalArgumentException("Mount point doesn't start with a /");
            }
            if (fS.owner != null) {
                fS.owner.removeMount(fS);
            }
            fS.owner = this;
            if (string.equals("/")) {
                this.root = fS;
                fS.devno = 1;
                return;
            }
            string = string.substring(1);
            int n2 = this.mps.length;
            Sort.Comparable[] comparableArray = new MP[n2 + 1];
            if (n2 != 0) {
                System.arraycopy(this.mps, 0, comparableArray, 0, n2);
            }
            comparableArray[n2] = new MP(string, fS);
            Sort.sort(comparableArray);
            this.mps = comparableArray;
            int n3 = 0;
            for (int i2 = 0; i2 < this.mps.length; ++i2) {
                n3 = Runtime.max(n3, this.mps[i2].fs.devno);
            }
            fS.devno = n3 + 2;
        }

        public synchronized void removeMount(FS fS) {
            for (int i2 = 0; i2 < this.mps.length; ++i2) {
                if (this.mps[i2].fs != fS) continue;
                this.removeMount(i2);
                return;
            }
            throw new IllegalArgumentException("mount point doesn't exist");
        }

        public synchronized void removeMount(String string) {
            if (!string.startsWith("/")) {
                throw new IllegalArgumentException("Mount point doesn't start with a /");
            }
            if (string.equals("/")) {
                this.removeMount(-1);
            } else {
                int n2;
                string = string.substring(1);
                for (n2 = 0; n2 < this.mps.length && !this.mps[n2].path.equals(string); ++n2) {
                }
                if (n2 == this.mps.length) {
                    throw new IllegalArgumentException("mount point doesn't exist");
                }
                this.removeMount(n2);
            }
        }

        private void removeMount(int n2) {
            if (n2 == -1) {
                this.root.owner = null;
                this.root = null;
                return;
            }
            MP[] mPArray = new MP[this.mps.length - 1];
            System.arraycopy(this.mps, 0, mPArray, 0, n2);
            System.arraycopy(this.mps, 0, mPArray, n2, this.mps.length - n2 - 1);
            this.mps = mPArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object fsop(int n2, UnixRuntime unixRuntime, String string, int n3, int n4) {
            int n5 = string.length();
            if (n5 != 0) {
                MP[] mPArray;
                GlobalState globalState = this;
                synchronized (globalState) {
                    mPArray = this.mps;
                }
                for (int i2 = 0; i2 < mPArray.length; ++i2) {
                    MP mP = mPArray[i2];
                    int n6 = mP.path.length();
                    if (!string.startsWith(mP.path) || n5 != n6 && string.charAt(n6) != '/') continue;
                    return mP.fs.dispatch(n2, unixRuntime, n5 == n6 ? "" : string.substring(n6 + 1), n3, n4);
                }
            }
            return this.root.dispatch(n2, unixRuntime, string, n3, n4);
        }

        public final Runtime.FD open(UnixRuntime unixRuntime, String string, int n2, int n3) {
            return (Runtime.FD)this.fsop(1, unixRuntime, string, n2, n3);
        }

        public final Runtime.FStat stat(UnixRuntime unixRuntime, String string) {
            return (Runtime.FStat)this.fsop(2, unixRuntime, string, 0, 0);
        }

        public final Runtime.FStat lstat(UnixRuntime unixRuntime, String string) {
            return (Runtime.FStat)this.fsop(3, unixRuntime, string, 0, 0);
        }

        public final void mkdir(UnixRuntime unixRuntime, String string, int n2) {
            this.fsop(4, unixRuntime, string, n2, 0);
        }

        public final void unlink(UnixRuntime unixRuntime, String string) {
            this.fsop(5, unixRuntime, string, 0, 0);
        }

        private static class CacheEnt {
            public final long time;
            public final long size;
            public final Object o;

            public CacheEnt(long l2, long l3, Object object) {
                this.time = l2;
                this.size = l3;
                this.o = object;
            }
        }

        static class MP
        implements Sort.Comparable {
            public String path;
            public FS fs;

            public MP(String string, FS fS) {
                this.path = string;
                this.fs = fS;
            }

            public int compareTo(Object object) {
                if (!(object instanceof MP)) {
                    return 1;
                }
                return -this.path.compareTo(((MP)object).path);
            }
        }
    }

    static class SocketFD
    extends Runtime.FD {
        public static final int TYPE_STREAM = 0;
        public static final int TYPE_DGRAM = 1;
        public static final int LISTEN = 2;
        int flags;
        int options;
        Socket s;
        ServerSocket ss;
        DatagramSocket ds;
        InetAddress bindAddr;
        int bindPort = -1;
        InetAddress connectAddr;
        int connectPort = -1;
        DatagramPacket dp;
        InputStream is;
        OutputStream os;
        private static final byte[] EMPTY = new byte[0];

        public int type() {
            return this.flags & 1;
        }

        public boolean listen() {
            return (this.flags & 2) != 0;
        }

        public SocketFD(int n2) {
            this.flags = n2;
            if (n2 == 1) {
                this.dp = new DatagramPacket(EMPTY, 0);
            }
        }

        public void setOptions() {
            try {
                if (this.s != null && this.type() == 0 && !this.listen()) {
                    Platform.socketSetKeepAlive(this.s, (this.options & 8) != 0);
                }
            }
            catch (SocketException socketException) {
                socketException.printStackTrace();
            }
        }

        public void _close() {
            try {
                if (this.s != null) {
                    this.s.close();
                }
                if (this.ss != null) {
                    this.ss.close();
                }
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public int read(byte[] byArray, int n2, int n3) {
            if (this.type() == 1) {
                return this.recvfrom(byArray, n2, n3, null, null);
            }
            if (this.is == null) {
                throw new Runtime.ErrnoException(32);
            }
            try {
                int n4 = this.is.read(byArray, n2, n3);
                return n4 < 0 ? 0 : n4;
            }
            catch (IOException iOException) {
                throw new Runtime.ErrnoException(5);
            }
        }

        public int recvfrom(byte[] byArray, int n2, int n3, InetAddress[] inetAddressArray, int[] nArray) {
            if (this.type() == 0) {
                return this.read(byArray, n2, n3);
            }
            if (n2 != 0) {
                throw new IllegalArgumentException("off must be 0");
            }
            this.dp.setData(byArray);
            this.dp.setLength(n3);
            try {
                if (this.ds == null) {
                    this.ds = new DatagramSocket();
                }
                this.ds.receive(this.dp);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new Runtime.ErrnoException(5);
            }
            if (inetAddressArray != null) {
                inetAddressArray[0] = this.dp.getAddress();
                nArray[0] = this.dp.getPort();
            }
            return this.dp.getLength();
        }

        public int write(byte[] byArray, int n2, int n3) {
            if (this.type() == 1) {
                return this.sendto(byArray, n2, n3, null, -1);
            }
            if (this.os == null) {
                throw new Runtime.ErrnoException(32);
            }
            try {
                this.os.write(byArray, n2, n3);
                return n3;
            }
            catch (IOException iOException) {
                throw new Runtime.ErrnoException(5);
            }
        }

        public int sendto(byte[] byArray, int n2, int n3, InetAddress inetAddress, int n4) {
            if (n2 != 0) {
                throw new IllegalArgumentException("off must be 0");
            }
            if (this.type() == 0) {
                return this.write(byArray, n2, n3);
            }
            if (inetAddress == null) {
                inetAddress = this.connectAddr;
                n4 = this.connectPort;
                if (inetAddress == null) {
                    throw new Runtime.ErrnoException(128);
                }
            }
            this.dp.setAddress(inetAddress);
            this.dp.setPort(n4);
            this.dp.setData(byArray);
            this.dp.setLength(n3);
            try {
                if (this.ds == null) {
                    this.ds = new DatagramSocket();
                }
                this.ds.send(this.dp);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                if ("Network is unreachable".equals(iOException.getMessage())) {
                    throw new Runtime.ErrnoException(118);
                }
                throw new Runtime.ErrnoException(5);
            }
            return this.dp.getLength();
        }

        public int flags() {
            return 2;
        }

        public Runtime.FStat _fstat() {
            return new Runtime.SocketFStat();
        }
    }

    static class Pipe {
        private final byte[] pipebuf = new byte[2048];
        private int readPos;
        private int writePos;
        public final Runtime.FD reader = new Reader(this);
        public final Runtime.FD writer = new Writer(this);

        Pipe() {
        }

        static int access$100(Pipe pipe) {
            return pipe.writePos;
        }

        static int access$200(Pipe pipe) {
            return pipe.readPos;
        }

        static byte[] access$300(Pipe pipe) {
            return pipe.pipebuf;
        }

        static int access$212(Pipe pipe, int n2) {
            return pipe.readPos += n2;
        }

        static int access$202(Pipe pipe, int n2) {
            pipe.readPos = n2;
            return pipe.readPos;
        }

        static int access$102(Pipe pipe, int n2) {
            pipe.writePos = n2;
            return pipe.writePos;
        }

        static int access$112(Pipe pipe, int n2) {
            return pipe.writePos += n2;
        }

        public class Writer
        extends Runtime.FD {
            private final Pipe this$0;

            public Writer(Pipe pipe) {
                this.this$0 = pipe;
            }

            protected Runtime.FStat _fstat() {
                return new Runtime.SocketFStat();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int write(byte[] byArray, int n2, int n3) {
                if (n3 == 0) {
                    return 0;
                }
                Pipe pipe = this.this$0;
                synchronized (pipe) {
                    if (Pipe.access$200(this.this$0) == -1) {
                        throw new Runtime.ErrnoException(32);
                    }
                    if (Pipe.access$300(this.this$0).length - Pipe.access$100(this.this$0) < Math.min(n3, 512)) {
                        while (Pipe.access$200(this.this$0) != -1 && Pipe.access$200(this.this$0) != Pipe.access$100(this.this$0)) {
                            try {
                                this.this$0.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (Pipe.access$200(this.this$0) == -1) {
                            throw new Runtime.ErrnoException(32);
                        }
                        Pipe.access$202(this.this$0, Pipe.access$102(this.this$0, 0));
                    }
                    n3 = Math.min(n3, Pipe.access$300(this.this$0).length - Pipe.access$100(this.this$0));
                    System.arraycopy(byArray, n2, Pipe.access$300(this.this$0), Pipe.access$100(this.this$0), n3);
                    if (Pipe.access$200(this.this$0) == Pipe.access$100(this.this$0)) {
                        this.this$0.notify();
                    }
                    Pipe.access$112(this.this$0, n3);
                    return n3;
                }
            }

            public int flags() {
                return 1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void _close() {
                Pipe pipe = this.this$0;
                synchronized (pipe) {
                    Pipe.access$102(this.this$0, -1);
                    this.this$0.notify();
                }
            }
        }

        public class Reader
        extends Runtime.FD {
            private final Pipe this$0;

            public Reader(Pipe pipe) {
                this.this$0 = pipe;
            }

            protected Runtime.FStat _fstat() {
                return new Runtime.SocketFStat();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(byte[] byArray, int n2, int n3) {
                if (n3 == 0) {
                    return 0;
                }
                Pipe pipe = this.this$0;
                synchronized (pipe) {
                    while (Pipe.access$100(this.this$0) != -1 && Pipe.access$200(this.this$0) == Pipe.access$100(this.this$0)) {
                        try {
                            this.this$0.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (Pipe.access$100(this.this$0) == -1) {
                        return 0;
                    }
                    n3 = Math.min(n3, Pipe.access$100(this.this$0) - Pipe.access$200(this.this$0));
                    System.arraycopy(Pipe.access$300(this.this$0), Pipe.access$200(this.this$0), byArray, n2, n3);
                    Pipe.access$212(this.this$0, n3);
                    if (Pipe.access$200(this.this$0) == Pipe.access$100(this.this$0)) {
                        this.this$0.notify();
                    }
                    return n3;
                }
            }

            public int flags() {
                return 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void _close() {
                Pipe pipe = this.this$0;
                synchronized (pipe) {
                    Pipe.access$202(this.this$0, -1);
                    this.this$0.notify();
                }
            }
        }
    }

    public static final class ForkedProcess
    extends Thread {
        private final UnixRuntime initial;

        public ForkedProcess(UnixRuntime unixRuntime) {
            this.initial = unixRuntime;
            this.start();
        }

        public void run() {
            UnixRuntime.executeAndExec(this.initial);
        }
    }

    private static class ProcessTableFullExn
    extends RuntimeException {
        private ProcessTableFullExn() {
        }

        ProcessTableFullExn(1 var1_1) {
            this();
        }
    }
}

