/*
 * Decompiled with CFR 0.152.
 */
package org.ibex.nestedvm;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.ibex.nestedvm.Registers;
import org.ibex.nestedvm.UsermodeConstants;
import org.ibex.nestedvm.util.Platform;
import org.ibex.nestedvm.util.Seekable;

public abstract class Runtime
implements Cloneable,
Registers,
UsermodeConstants {
    public static final String VERSION = "1.0";
    static final boolean STDERR_DIAG = true;
    protected final int pageShift;
    private final int stackBottom;
    protected int[][] readPages;
    protected int[][] writePages;
    private int heapEnd;
    private static final int STACK_GUARD_PAGES = 4;
    private long startTime;
    public static final int RUNNING = 0;
    public static final int STOPPED = 1;
    public static final int PAUSED = 2;
    public static final int CALLJAVA = 3;
    public static final int EXITED = 4;
    public static final int EXECED = 5;
    protected int state = 1;
    private int exitStatus;
    public ExecutionException exitException;
    FD[] fds;
    boolean[] closeOnExec;
    SecurityManager sm;
    private CallJavaCB callJavaCB;
    private byte[] _byteBuf;
    static final int MAX_CHUNK = 0xFFFC00;
    static final boolean win32Hacks;
    public static final int RD_ONLY = 0;
    public static final int WR_ONLY = 1;
    public static final int RDWR = 2;
    public static final int O_CREAT = 512;
    public static final int O_EXCL = 2048;
    public static final int O_APPEND = 8;
    public static final int O_TRUNC = 1024;
    public static final int O_NONBLOCK = 16384;
    public static final int O_NOCTTY = 32768;

    protected abstract int heapStart();

    protected abstract int entryPoint();

    protected int userInfoBase() {
        return 0;
    }

    protected int userInfoSize() {
        return 0;
    }

    protected abstract int gp();

    public final int getState() {
        return this.state;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.sm = securityManager;
    }

    public void setCallJavaCB(CallJavaCB callJavaCB) {
        this.callJavaCB = callJavaCB;
    }

    protected abstract void _execute();

    public int lookupSymbol(String string) {
        return -1;
    }

    protected abstract void getCPUState(CPUState var1);

    protected abstract void setCPUState(CPUState var1);

    protected Object clone() {
        int n2;
        Runtime runtime = (Runtime)super.clone();
        runtime._byteBuf = null;
        runtime.startTime = 0L;
        runtime.fds = new FD[64];
        for (n2 = 0; n2 < 64; ++n2) {
            if (this.fds[n2] == null) continue;
            runtime.fds[n2] = this.fds[n2].dup();
        }
        n2 = this.writePages.length;
        runtime.readPages = new int[n2][];
        runtime.writePages = new int[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.readPages[i2] == null) continue;
            if (this.writePages[i2] == null) {
                runtime.readPages[i2] = this.readPages[i2];
                continue;
            }
            runtime.writePages[i2] = (int[])this.writePages[i2].clone();
            runtime.readPages[i2] = runtime.writePages[i2];
        }
        return runtime;
    }

    protected Runtime(int n2, int n3) {
        this(n2, n3, false);
    }

    protected Runtime(int n2, int n3, boolean bl2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("pageSize <= 0");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("totalPages <= 0");
        }
        if ((n2 & n2 - 1) != 0) {
            throw new IllegalArgumentException("pageSize not a power of two");
        }
        int n4 = 0;
        while (n2 >>> n4 != 1) {
            ++n4;
        }
        this.pageShift = n4;
        int n5 = this.heapStart();
        int n6 = n3 * n2;
        int n7 = Runtime.max(n6 / 512, 131072);
        int n8 = 0;
        if (n3 > 1) {
            n7 = Runtime.max(n7, n2);
            n8 = (n7 = n7 + n2 - 1 & ~(n2 - 1)) >>> this.pageShift;
            if (n8 + 4 + ((n5 = n5 + n2 - 1 & ~(n2 - 1)) >>> this.pageShift) >= n3) {
                throw new IllegalArgumentException("total pages too small");
            }
        } else {
            if (n2 < n5 + n7) {
                throw new IllegalArgumentException("total memory too small");
            }
            n5 = n5 + 4095 & 0xFFFFEFFF;
        }
        this.stackBottom = n6 - n7;
        this.heapEnd = n5;
        this.readPages = new int[n3][];
        this.writePages = new int[n3][];
        if (n3 == 1) {
            this.writePages[0] = new int[n2 >> 2];
            this.readPages[0] = this.writePages[0];
        } else {
            for (int i2 = this.stackBottom >>> this.pageShift; i2 < this.writePages.length; ++i2) {
                this.writePages[i2] = new int[n2 >> 2];
                this.readPages[i2] = this.writePages[i2];
            }
        }
        if (!bl2) {
            this.fds = new FD[64];
            this.closeOnExec = new boolean[64];
            InputStream inputStream = win32Hacks ? new Win32ConsoleIS(System.in) : System.in;
            this.addFD(new TerminalFD(inputStream));
            this.addFD(new TerminalFD(System.out));
            this.addFD(new TerminalFD(System.err));
        }
    }

    protected final void initPages(int[] nArray, int n2, boolean bl2) {
        int n3 = 1 << this.pageShift >>> 2;
        int n4 = (1 << this.pageShift) - 1;
        int n5 = 0;
        while (n5 < nArray.length) {
            int n6 = n2 >>> this.pageShift;
            int n7 = (n2 & n4) >> 2;
            int n8 = Runtime.min(n3 - n7, nArray.length - n5);
            if (this.readPages[n6] == null) {
                this.initPage(n6, bl2);
            } else if (!bl2 && this.writePages[n6] == null) {
                this.writePages[n6] = this.readPages[n6];
            }
            System.arraycopy(nArray, n5, this.readPages[n6], n7, n8);
            n5 += n8;
            n2 += n8 * 4;
        }
    }

    protected final void clearPages(int n2, int n3) {
        int n4 = 1 << this.pageShift >>> 2;
        int n5 = (1 << this.pageShift) - 1;
        int n6 = 0;
        while (n6 < n3) {
            int n7 = n2 >>> this.pageShift;
            int n8 = (n2 & n5) >> 2;
            int n9 = Runtime.min(n4 - n8, n3 - n6);
            if (this.readPages[n7] == null) {
                this.writePages[n7] = new int[n4];
                this.readPages[n7] = this.writePages[n7];
            } else {
                if (this.writePages[n7] == null) {
                    this.writePages[n7] = this.readPages[n7];
                }
                for (int i2 = n8; i2 < n8 + n9; ++i2) {
                    this.writePages[n7][i2] = 0;
                }
            }
            n6 += n9;
            n2 += n9 * 4;
        }
    }

    public final void copyin(int n2, byte[] byArray, int n3) {
        int n4;
        int n5 = 1 << this.pageShift >>> 2;
        int n6 = n5 - 1;
        int n7 = 0;
        if (n3 == 0) {
            return;
        }
        if ((n2 & 3) != 0) {
            n4 = this.memRead(n2 & 0xFFFFFFFC);
            switch (n2 & 3) {
                case 1: {
                    byArray[n7++] = (byte)(n4 >>> 16 & 0xFF);
                    if (--n3 == 0) break;
                }
                case 2: {
                    byArray[n7++] = (byte)(n4 >>> 8 & 0xFF);
                    if (--n3 == 0) break;
                }
                case 3: {
                    byArray[n7++] = (byte)(n4 >>> 0 & 0xFF);
                    if (--n3 != 0) break;
                }
            }
            n2 = (n2 & 0xFFFFFFFC) + 4;
        }
        if ((n3 & 0xFFFFFFFC) != 0) {
            int n8;
            int n9 = n2 >>> 2;
            for (n4 = n3 >>> 2; n4 != 0; n4 -= n8) {
                int[] nArray = this.readPages[n9 >>> this.pageShift - 2];
                if (nArray == null) {
                    throw new ReadFaultException(n9 << 2);
                }
                int n10 = n9 & n6;
                n8 = Runtime.min(n4, n5 - n10);
                int n11 = 0;
                while (n11 < n8) {
                    int n12 = nArray[n10 + n11];
                    byArray[n7 + 0] = (byte)(n12 >>> 24 & 0xFF);
                    byArray[n7 + 1] = (byte)(n12 >>> 16 & 0xFF);
                    byArray[n7 + 2] = (byte)(n12 >>> 8 & 0xFF);
                    byArray[n7 + 3] = (byte)(n12 >>> 0 & 0xFF);
                    ++n11;
                    n7 += 4;
                }
                n9 += n8;
            }
            n2 = n9 << 2;
            n3 &= 3;
        }
        if (n3 != 0) {
            n4 = this.memRead(n2);
            switch (n3) {
                case 3: {
                    byArray[n7 + 2] = (byte)(n4 >>> 8 & 0xFF);
                }
                case 2: {
                    byArray[n7 + 1] = (byte)(n4 >>> 16 & 0xFF);
                }
                case 1: {
                    byArray[n7 + 0] = (byte)(n4 >>> 24 & 0xFF);
                }
            }
        }
    }

    public final void copyout(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = 1 << this.pageShift >>> 2;
        int n6 = n5 - 1;
        int n7 = 0;
        if (n3 == 0) {
            return;
        }
        if ((n2 & 3) != 0) {
            n4 = this.memRead(n2 & 0xFFFFFFFC);
            switch (n2 & 3) {
                case 1: {
                    n4 = n4 & 0xFF00FFFF | (byArray[n7++] & 0xFF) << 16;
                    if (--n3 == 0) break;
                }
                case 2: {
                    n4 = n4 & 0xFFFF00FF | (byArray[n7++] & 0xFF) << 8;
                    if (--n3 == 0) break;
                }
                case 3: {
                    n4 = n4 & 0xFFFFFF00 | (byArray[n7++] & 0xFF) << 0;
                    if (--n3 != 0) break;
                }
            }
            this.memWrite(n2 & 0xFFFFFFFC, n4);
            n2 += n7;
        }
        if ((n3 & 0xFFFFFFFC) != 0) {
            int n8;
            int n9 = n2 >>> 2;
            for (n4 = n3 >>> 2; n4 != 0; n4 -= n8) {
                int[] nArray = this.writePages[n9 >>> this.pageShift - 2];
                if (nArray == null) {
                    throw new WriteFaultException(n9 << 2);
                }
                int n10 = n9 & n6;
                n8 = Runtime.min(n4, n5 - n10);
                int n11 = 0;
                while (n11 < n8) {
                    nArray[n10 + n11] = (byArray[n7 + 0] & 0xFF) << 24 | (byArray[n7 + 1] & 0xFF) << 16 | (byArray[n7 + 2] & 0xFF) << 8 | (byArray[n7 + 3] & 0xFF) << 0;
                    ++n11;
                    n7 += 4;
                }
                n9 += n8;
            }
            n2 = n9 << 2;
            n3 &= 3;
        }
        if (n3 != 0) {
            n4 = this.memRead(n2);
            switch (n3) {
                case 1: {
                    n4 = n4 & 0xFFFFFF | (byArray[n7 + 0] & 0xFF) << 24;
                    break;
                }
                case 2: {
                    n4 = n4 & 0xFFFF | (byArray[n7 + 0] & 0xFF) << 24 | (byArray[n7 + 1] & 0xFF) << 16;
                    break;
                }
                case 3: {
                    n4 = n4 & 0xFF | (byArray[n7 + 0] & 0xFF) << 24 | (byArray[n7 + 1] & 0xFF) << 16 | (byArray[n7 + 2] & 0xFF) << 8;
                }
            }
            this.memWrite(n2, n4);
        }
    }

    public final void memcpy(int n2, int n3, int n4) {
        int n5 = 1 << this.pageShift >>> 2;
        int n6 = n5 - 1;
        if ((n2 & 3) == 0 && (n3 & 3) == 0) {
            int n7;
            int n8;
            if ((n4 & 0xFFFFFFFC) != 0) {
                int n9;
                n8 = n3 >>> 2;
                int n10 = n2 >>> 2;
                for (n7 = n4 >> 2; n7 != 0; n7 -= n9) {
                    int[] nArray = this.readPages[n8 >>> this.pageShift - 2];
                    if (nArray == null) {
                        throw new ReadFaultException(n8 << 2);
                    }
                    int[] nArray2 = this.writePages[n10 >>> this.pageShift - 2];
                    if (nArray2 == null) {
                        throw new WriteFaultException(n10 << 2);
                    }
                    int n11 = n8 & n6;
                    int n12 = n10 & n6;
                    n9 = Runtime.min(n7, n5 - Runtime.max(n11, n12));
                    System.arraycopy(nArray, n11, nArray2, n12, n9);
                    n8 += n9;
                    n10 += n9;
                }
                n3 = n8 << 2;
                n2 = n10 << 2;
                n4 &= 3;
            }
            if (n4 != 0) {
                n7 = this.memRead(n3);
                n8 = this.memRead(n2);
                switch (n4) {
                    case 1: {
                        this.memWrite(n2, n7 & 0xFF000000 | n8 & 0xFFFFFF);
                        break;
                    }
                    case 2: {
                        this.memWrite(n2, n7 & 0xFFFF0000 | n8 & 0xFFFF);
                        break;
                    }
                    case 3: {
                        this.memWrite(n2, n7 & 0xFFFFFF00 | n8 & 0xFF);
                    }
                }
            }
        } else {
            while (n4 > 0) {
                int n13 = Runtime.min(n4, 0xFFFC00);
                byte[] byArray = this.byteBuf(n13);
                this.copyin(n3, byArray, n13);
                this.copyout(byArray, n2, n13);
                n4 -= n13;
                n3 += n13;
                n2 += n13;
            }
        }
    }

    public final void memset(int n2, int n3, int n4) {
        int n5;
        int n6 = 1 << this.pageShift >>> 2;
        int n7 = n6 - 1;
        int n8 = (n3 & 0xFF) << 24 | (n3 & 0xFF) << 16 | (n3 & 0xFF) << 8 | (n3 & 0xFF) << 0;
        if ((n2 & 3) != 0) {
            n5 = this.memRead(n2 & 0xFFFFFFFC);
            switch (n2 & 3) {
                case 1: {
                    n5 = n5 & 0xFF00FFFF | (n3 & 0xFF) << 16;
                    if (--n4 == 0) break;
                }
                case 2: {
                    n5 = n5 & 0xFFFF00FF | (n3 & 0xFF) << 8;
                    if (--n4 == 0) break;
                }
                case 3: {
                    n5 = n5 & 0xFFFFFF00 | (n3 & 0xFF) << 0;
                    if (--n4 != 0) break;
                }
            }
            this.memWrite(n2 & 0xFFFFFFFC, n5);
            n2 = (n2 & 0xFFFFFFFC) + 4;
        }
        if ((n4 & 0xFFFFFFFC) != 0) {
            int n9;
            int n10 = n2 >>> 2;
            for (n5 = n4 >> 2; n5 != 0; n5 -= n9) {
                int[] nArray = this.readPages[n10 >>> this.pageShift - 2];
                if (nArray == null) {
                    throw new WriteFaultException(n10 << 2);
                }
                int n11 = n10 & n7;
                n9 = Runtime.min(n5, n6 - n11);
                for (int i2 = n11; i2 < n11 + n9; ++i2) {
                    nArray[i2] = n8;
                }
                n10 += n9;
            }
            n2 = n10 << 2;
            n4 &= 3;
        }
        if (n4 != 0) {
            n5 = this.memRead(n2);
            switch (n4) {
                case 1: {
                    n5 = n5 & 0xFFFFFF | n8 & 0xFF000000;
                    break;
                }
                case 2: {
                    n5 = n5 & 0xFFFF | n8 & 0xFFFF0000;
                    break;
                }
                case 3: {
                    n5 = n5 & 0xFF | n8 & 0xFFFFFF00;
                }
            }
            this.memWrite(n2, n5);
        }
    }

    public final int memRead(int n2) {
        if ((n2 & 3) != 0) {
            throw new ReadFaultException(n2);
        }
        return this.unsafeMemRead(n2);
    }

    protected final int unsafeMemRead(int n2) {
        int n3 = n2 >>> this.pageShift;
        int n4 = (n2 & (1 << this.pageShift) - 1) >> 2;
        try {
            return this.readPages[n3][n4];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n3 < 0 || n3 >= this.readPages.length) {
                throw new ReadFaultException(n2);
            }
            throw arrayIndexOutOfBoundsException;
        }
        catch (NullPointerException nullPointerException) {
            throw new ReadFaultException(n2);
        }
    }

    public final void memWrite(int n2, int n3) {
        if ((n2 & 3) != 0) {
            throw new WriteFaultException(n2);
        }
        this.unsafeMemWrite(n2, n3);
    }

    protected final void unsafeMemWrite(int n2, int n3) {
        int n4 = n2 >>> this.pageShift;
        int n5 = (n2 & (1 << this.pageShift) - 1) >> 2;
        try {
            this.writePages[n4][n5] = n3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n4 < 0 || n4 >= this.writePages.length) {
                throw new WriteFaultException(n2);
            }
            throw arrayIndexOutOfBoundsException;
        }
        catch (NullPointerException nullPointerException) {
            throw new WriteFaultException(n2);
        }
    }

    private final int[] initPage(int n2) {
        return this.initPage(n2, false);
    }

    private final int[] initPage(int n2, boolean bl2) {
        int[] nArray = new int[1 << this.pageShift >>> 2];
        this.writePages[n2] = bl2 ? null : nArray;
        this.readPages[n2] = nArray;
        return nArray;
    }

    public final int exitStatus() {
        if (this.state != 4) {
            throw new IllegalStateException("exitStatus() called in an inappropriate state");
        }
        return this.exitStatus;
    }

    private int addStringArray(String[] stringArray, int n2) {
        int n3;
        int n4 = stringArray.length;
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            n5 += stringArray[n3].length() + 1;
        }
        n3 = n2 - (n5 += (n4 + 1) * 4) & 0xFFFFFFFC;
        int n6 = n3 + (n4 + 1) * 4;
        int[] nArray = new int[n4 + 1];
        try {
            int n7;
            for (n7 = 0; n7 < n4; ++n7) {
                byte[] byArray = Runtime.getBytes(stringArray[n7]);
                nArray[n7] = n6;
                this.copyout(byArray, n6, byArray.length);
                this.memset(n6 + byArray.length, 0, 1);
                n6 += byArray.length + 1;
            }
            n6 = n3;
            for (n7 = 0; n7 < n4 + 1; ++n7) {
                this.memWrite(n6, nArray[n7]);
                n6 += 4;
            }
        }
        catch (FaultException faultException) {
            throw new RuntimeException(faultException.toString());
        }
        return n3;
    }

    String[] createEnv(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public void setUserInfo(int n2, int n3) {
        if (n2 < 0 || n2 >= this.userInfoSize() / 4) {
            throw new IndexOutOfBoundsException("setUserInfo called with index >= " + this.userInfoSize() / 4);
        }
        try {
            this.memWrite(this.userInfoBase() + n2 * 4, n3);
        }
        catch (FaultException faultException) {
            throw new RuntimeException(faultException.toString());
        }
    }

    public int getUserInfo(int n2) {
        if (n2 < 0 || n2 >= this.userInfoSize() / 4) {
            throw new IndexOutOfBoundsException("setUserInfo called with index >= " + this.userInfoSize() / 4);
        }
        try {
            return this.memRead(this.userInfoBase() + n2 * 4);
        }
        catch (FaultException faultException) {
            throw new RuntimeException(faultException.toString());
        }
    }

    private void __execute() {
        try {
            this._execute();
        }
        catch (FaultException faultException) {
            faultException.printStackTrace();
            this.exit(139, true);
            this.exitException = faultException;
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
            this.exit(132, true);
            this.exitException = executionException;
        }
    }

    public final boolean execute() {
        if (this.state != 2) {
            throw new IllegalStateException("execute() called in inappropriate state");
        }
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        this.state = 0;
        this.__execute();
        if (this.state != 2 && this.state != 4 && this.state != 5) {
            throw new IllegalStateException("execute() ended up in an inappropriate state (" + this.state + ")");
        }
        return this.state != 2;
    }

    static String[] concatArgv(String string, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        stringArray2[0] = string;
        return stringArray2;
    }

    public final int run() {
        return this.run(null);
    }

    public final int run(String string, String[] stringArray) {
        return this.run(Runtime.concatArgv(string, stringArray));
    }

    public final int run(String[] stringArray) {
        return this.run(stringArray, null);
    }

    public final int run(String[] stringArray, String[] stringArray2) {
        this.start(stringArray, stringArray2);
        while (!this.execute()) {
            System.err.println("WARNING: Pause requested while executing run()");
        }
        if (this.state == 5) {
            System.err.println("WARNING: Process exec()ed while being run under run()");
        }
        return this.state == 4 ? this.exitStatus() : 0;
    }

    public final void start() {
        this.start(null);
    }

    public final void start(String[] stringArray) {
        this.start(stringArray, null);
    }

    public final void start(String[] stringArray, String[] stringArray2) {
        int n2;
        int n3;
        int n4;
        if (this.state != 1) {
            throw new IllegalStateException("start() called in inappropriate state");
        }
        if (stringArray == null) {
            stringArray = new String[]{this.getClass().getName()};
        }
        int n5 = n4 = this.writePages.length * (1 << this.pageShift);
        try {
            n5 = n3 = this.addStringArray(stringArray, n5);
            n5 = n2 = this.addStringArray(this.createEnv(stringArray2), n5);
        }
        catch (FaultException faultException) {
            throw new IllegalArgumentException("args/environ too big");
        }
        if (n4 - (n5 &= 0xFFFFFFF0) > 65536) {
            throw new IllegalArgumentException("args/environ too big");
        }
        if (this.heapEnd == 0) {
            this.heapEnd = this.heapStart();
            if (this.heapEnd == 0) {
                throw new Error("heapEnd == 0");
            }
            int n6 = this.writePages.length == 1 ? 4096 : 1 << this.pageShift;
            this.heapEnd = this.heapEnd + n6 - 1 & ~(n6 - 1);
        }
        CPUState cPUState = new CPUState();
        cPUState.r[4] = n3;
        cPUState.r[5] = n2;
        cPUState.r[29] = n5;
        cPUState.r[31] = -559038737;
        cPUState.r[28] = this.gp();
        cPUState.pc = this.entryPoint();
        this.setCPUState(cPUState);
        this.state = 2;
        this._started();
    }

    public final void stop() {
        if (this.state != 0 && this.state != 2) {
            throw new IllegalStateException("stop() called in inappropriate state");
        }
        this.exit(0, false);
    }

    void _started() {
    }

    public final int call(String string, Object[] objectArray) {
        int n2;
        if (this.state != 2 && this.state != 3) {
            throw new IllegalStateException("call() called in inappropriate state");
        }
        if (objectArray.length > 7) {
            throw new IllegalArgumentException("args.length > 7");
        }
        CPUState cPUState = new CPUState();
        this.getCPUState(cPUState);
        int n3 = cPUState.r[29];
        int[] nArray = new int[objectArray.length];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            Object object = objectArray[n2];
            byte[] byArray = null;
            if (object instanceof String) {
                byArray = Runtime.getBytes((String)object);
            } else if (object instanceof byte[]) {
                byArray = (byte[])object;
            } else if (object instanceof Number) {
                nArray[n2] = ((Number)object).intValue();
            }
            if (byArray == null) continue;
            this.copyout(byArray, n3 -= byArray.length, byArray.length);
            nArray[n2] = n3;
        }
        n2 = cPUState.r[29];
        if (n2 == n3) {
            return this.call(string, nArray);
        }
        cPUState.r[29] = n3;
        this.setCPUState(cPUState);
        int n4 = this.call(string, nArray);
        cPUState.r[29] = n2;
        this.setCPUState(cPUState);
        return n4;
    }

    public final int call(String string) {
        return this.call(string, new int[0]);
    }

    public final int call(String string, int n2) {
        return this.call(string, new int[]{n2});
    }

    public final int call(String string, int n2, int n3) {
        return this.call(string, new int[]{n2, n3});
    }

    public final int call(String string, int[] nArray) {
        int n2 = this.lookupSymbol(string);
        if (n2 == -1) {
            throw new CallException(string + " not found");
        }
        int n3 = this.lookupSymbol("_call_helper");
        if (n3 == -1) {
            throw new CallException("_call_helper not found");
        }
        return this.call(n3, n2, nArray);
    }

    public final int call(int n2, int n3, int[] nArray) {
        if (nArray.length > 7) {
            throw new IllegalArgumentException("rest.length > 7");
        }
        if (this.state != 2 && this.state != 3) {
            throw new IllegalStateException("call() called in inappropriate state");
        }
        int n4 = this.state;
        CPUState cPUState = new CPUState();
        this.getCPUState(cPUState);
        CPUState cPUState2 = cPUState.dup();
        cPUState2.r[29] = cPUState2.r[29] & 0xFFFFFFF0;
        cPUState2.r[31] = -559038737;
        cPUState2.r[4] = n3;
        switch (nArray.length) {
            case 7: {
                cPUState2.r[19] = nArray[6];
            }
            case 6: {
                cPUState2.r[18] = nArray[5];
            }
            case 5: {
                cPUState2.r[17] = nArray[4];
            }
            case 4: {
                cPUState2.r[16] = nArray[3];
            }
            case 3: {
                cPUState2.r[7] = nArray[2];
            }
            case 2: {
                cPUState2.r[6] = nArray[1];
            }
            case 1: {
                cPUState2.r[5] = nArray[0];
            }
        }
        cPUState2.pc = n2;
        this.state = 0;
        this.setCPUState(cPUState2);
        this.__execute();
        this.getCPUState(cPUState2);
        this.setCPUState(cPUState);
        if (this.state != 2) {
            throw new CallException("Process exit()ed while servicing a call() request");
        }
        this.state = n4;
        return cPUState2.r[3];
    }

    public final int addFD(FD fD) {
        int n2;
        if (this.state == 4 || this.state == 5) {
            throw new IllegalStateException("addFD called in inappropriate state");
        }
        for (n2 = 0; n2 < 64 && this.fds[n2] != null; ++n2) {
        }
        if (n2 == 64) {
            return -1;
        }
        this.fds[n2] = fD;
        this.closeOnExec[n2] = false;
        return n2;
    }

    void _preCloseFD(FD fD) {
    }

    void _postCloseFD(FD fD) {
    }

    public final boolean closeFD(int n2) {
        if (this.state == 4 || this.state == 5) {
            throw new IllegalStateException("closeFD called in inappropriate state");
        }
        if (n2 < 0 || n2 >= 64) {
            return false;
        }
        if (this.fds[n2] == null) {
            return false;
        }
        this._preCloseFD(this.fds[n2]);
        this.fds[n2].close();
        this._postCloseFD(this.fds[n2]);
        this.fds[n2] = null;
        return true;
    }

    public final int dupFD(int n2) {
        int n3;
        if (n2 < 0 || n2 >= 64) {
            return -1;
        }
        if (this.fds[n2] == null) {
            return -1;
        }
        for (n3 = 0; n3 < 64 && this.fds[n3] != null; ++n3) {
        }
        if (n3 == 64) {
            return -1;
        }
        this.fds[n3] = this.fds[n2].dup();
        return n3;
    }

    FD hostFSOpen(File file, int n2, int n3, Object object) {
        Seekable.File file2;
        boolean bl2;
        block14: {
            if ((n2 & 0xFFFFF1F4) != 0) {
                System.err.println("WARNING: Unsupported flags passed to open(\"" + file + "\"): " + Runtime.toHex(n2 & 0xFFFFF1F4));
                throw new ErrnoException(134);
            }
            boolean bl3 = bl2 = (n2 & 3) != 0;
            if (this.sm != null && !(!bl2 ? this.sm.allowRead(file) : this.sm.allowWrite(file))) {
                throw new ErrnoException(13);
            }
            if ((n2 & 0xA00) == 2560) {
                try {
                    if (!Platform.atomicCreateFile(file)) {
                        throw new ErrnoException(17);
                    }
                    break block14;
                }
                catch (IOException iOException) {
                    throw new ErrnoException(5);
                }
            }
            if (!file.exists()) {
                if ((n2 & 0x200) == 0) {
                    return null;
                }
            } else if (file.isDirectory()) {
                return this.hostFSDirFD(file, object);
            }
        }
        try {
            file2 = new Seekable.File(file, bl2, (n2 & 0x400) != 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (fileNotFoundException.getMessage() != null && fileNotFoundException.getMessage().indexOf("Permission denied") >= 0) {
                throw new ErrnoException(13);
            }
            return null;
        }
        catch (IOException iOException) {
            throw new ErrnoException(5);
        }
        return new SeekableFD(this, file2, n2, file, file2, object){
            private final File val$f;
            private final Seekable.File val$sf;
            private final Object val$data;
            private final Runtime this$0;
            {
                this.this$0 = runtime;
                this.val$f = file;
                this.val$sf = file2;
                this.val$data = object;
            }

            protected FStat _fstat() {
                return this.this$0.hostFStat(this.val$f, this.val$sf, this.val$data);
            }
        };
    }

    FStat hostFStat(File file, Seekable.File file2, Object object) {
        return new HostFStat(file, file2);
    }

    FD hostFSDirFD(File file, Object object) {
        return null;
    }

    FD _open(String string, int n2, int n3) {
        return this.hostFSOpen(new File(string), n2, n3, null);
    }

    private int sys_open(int n2, int n3, int n4) {
        FD fD;
        String string = this.cstring(n2);
        if (string.length() == 1024 && this.getClass().getName().equals("tests.TeX")) {
            string = string.trim();
        }
        if ((fD = this._open(string, n3 &= 0xFFFF7FFF, n4)) == null) {
            return -2;
        }
        int n5 = this.addFD(fD);
        if (n5 == -1) {
            fD.close();
            return -23;
        }
        return n5;
    }

    private int sys_write(int n2, int n3, int n4) {
        n4 = Math.min(n4, 0xFFFC00);
        if (n2 < 0 || n2 >= 64) {
            return -81;
        }
        if (this.fds[n2] == null) {
            return -81;
        }
        byte[] byArray = this.byteBuf(n4);
        this.copyin(n3, byArray, n4);
        try {
            return this.fds[n2].write(byArray, 0, n4);
        }
        catch (ErrnoException errnoException) {
            if (errnoException.errno == 32) {
                this.sys_exit(141);
            }
            throw errnoException;
        }
    }

    private int sys_read(int n2, int n3, int n4) {
        n4 = Math.min(n4, 0xFFFC00);
        if (n2 < 0 || n2 >= 64) {
            return -81;
        }
        if (this.fds[n2] == null) {
            return -81;
        }
        byte[] byArray = this.byteBuf(n4);
        int n5 = this.fds[n2].read(byArray, 0, n4);
        this.copyout(byArray, n3, n5);
        return n5;
    }

    private int sys_ftruncate(int n2, long l2) {
        if (n2 < 0 || n2 >= 64) {
            return -81;
        }
        if (this.fds[n2] == null) {
            return -81;
        }
        Seekable seekable = this.fds[n2].seekable();
        if (l2 < 0L || seekable == null) {
            return -22;
        }
        try {
            seekable.resize(l2);
        }
        catch (IOException iOException) {
            return -5;
        }
        return 0;
    }

    private int sys_close(int n2) {
        return this.closeFD(n2) ? 0 : -81;
    }

    private int sys_lseek(int n2, int n3, int n4) {
        if (n2 < 0 || n2 >= 64) {
            return -81;
        }
        if (this.fds[n2] == null) {
            return -81;
        }
        if (n4 != 0 && n4 != 1 && n4 != 2) {
            return -22;
        }
        int n5 = this.fds[n2].seek(n3, n4);
        return n5 < 0 ? -29 : n5;
    }

    int stat(FStat fStat, int n2) {
        this.memWrite(n2 + 0, fStat.dev() << 16 | fStat.inode() & 0xFFFF);
        this.memWrite(n2 + 4, fStat.type() & 0xF000 | fStat.mode() & 0xFFF);
        this.memWrite(n2 + 8, fStat.nlink() << 16 | fStat.uid() & 0xFFFF);
        this.memWrite(n2 + 12, fStat.gid() << 16 | 0);
        this.memWrite(n2 + 16, fStat.size());
        this.memWrite(n2 + 20, fStat.atime());
        this.memWrite(n2 + 28, fStat.mtime());
        this.memWrite(n2 + 36, fStat.ctime());
        this.memWrite(n2 + 44, fStat.blksize());
        this.memWrite(n2 + 48, fStat.blocks());
        return 0;
    }

    private int sys_fstat(int n2, int n3) {
        if (n2 < 0 || n2 >= 64) {
            return -81;
        }
        if (this.fds[n2] == null) {
            return -81;
        }
        return this.stat(this.fds[n2].fstat(), n3);
    }

    private int sys_gettimeofday(int n2, int n3) {
        long l2 = System.currentTimeMillis();
        int n4 = (int)(l2 / 1000L);
        int n5 = (int)(l2 % 1000L * 1000L);
        this.memWrite(n2 + 0, n4);
        this.memWrite(n2 + 4, n5);
        return 0;
    }

    private int sys_sleep(int n2) {
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        try {
            Thread.sleep((long)n2 * 1000L);
            return 0;
        }
        catch (InterruptedException interruptedException) {
            return -1;
        }
    }

    private int sys_times(int n2) {
        long l2 = System.currentTimeMillis();
        int n3 = (int)((l2 - this.startTime) / 16L);
        int n4 = (int)((l2 - this.startTime) / 16L);
        try {
            if (n2 != 0) {
                this.memWrite(n2 + 0, n3);
                this.memWrite(n2 + 4, n4);
                this.memWrite(n2 + 8, n3);
                this.memWrite(n2 + 12, n4);
            }
        }
        catch (FaultException faultException) {
            return -14;
        }
        return (int)l2;
    }

    private int sys_sysconf(int n2) {
        switch (n2) {
            case 2: {
                return 1000;
            }
            case 8: {
                return this.writePages.length == 1 ? 4096 : 1 << this.pageShift;
            }
            case 11: {
                return this.writePages.length == 1 ? (1 << this.pageShift) / 4096 : this.writePages.length;
            }
        }
        System.err.println("WARNING: Attempted to use unknown sysconf key: " + n2);
        return -22;
    }

    public final int sbrk(int n2) {
        if (n2 < 0) {
            return -12;
        }
        if (n2 == 0) {
            return this.heapEnd;
        }
        int n3 = this.heapEnd;
        int n4 = n3 + (n2 = n2 + 3 & 0xFFFFFFFC);
        if (n4 >= this.stackBottom) {
            return -12;
        }
        if (this.writePages.length > 1) {
            int n5 = (1 << this.pageShift) - 1;
            int n6 = 1 << this.pageShift >>> 2;
            int n7 = n3 + n5 >>> this.pageShift;
            int n8 = n4 + n5 >>> this.pageShift;
            try {
                for (int i2 = n7; i2 < n8; ++i2) {
                    this.writePages[i2] = new int[n6];
                    this.readPages[i2] = this.writePages[i2];
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.err.println("WARNING: Caught OOM Exception in sbrk: " + outOfMemoryError);
                return -12;
            }
        }
        this.heapEnd = n4;
        return n3;
    }

    private int sys_getpid() {
        return this.getPid();
    }

    int getPid() {
        return 1;
    }

    private int sys_calljava(int n2, int n3, int n4, int n5) {
        if (this.state != 0) {
            throw new IllegalStateException("wound up calling sys_calljava while not in RUNNING");
        }
        if (this.callJavaCB != null) {
            int n6;
            this.state = 3;
            try {
                n6 = this.callJavaCB.call(n2, n3, n4, n5);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Error while executing callJavaCB");
                runtimeException.printStackTrace();
                n6 = 0;
            }
            this.state = 0;
            return n6;
        }
        System.err.println("WARNING: calljava syscall invoked without a calljava callback set");
        return 0;
    }

    private int sys_pause() {
        this.state = 2;
        return 0;
    }

    private int sys_getpagesize() {
        return this.writePages.length == 1 ? 4096 : 1 << this.pageShift;
    }

    void _exited() {
    }

    void exit(int n2, boolean bl2) {
        if (bl2 && this.fds[2] != null) {
            try {
                byte[] byArray = Runtime.getBytes("Process exited on signal " + (n2 - 128) + "\n");
                this.fds[2].write(byArray, 0, byArray.length);
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
        }
        this.exitStatus = n2;
        for (int i2 = 0; i2 < this.fds.length; ++i2) {
            if (this.fds[i2] == null) continue;
            this.closeFD(i2);
        }
        this.state = 4;
        this._exited();
    }

    private int sys_exit(int n2) {
        this.exit(n2, false);
        return 0;
    }

    final int sys_fcntl(int n2, int n3, int n4) {
        if (n2 < 0 || n2 >= 64) {
            return -81;
        }
        if (this.fds[n2] == null) {
            return -81;
        }
        FD fD = this.fds[n2];
        switch (n3) {
            case 0: {
                int n5;
                if (n4 < 0 || n4 >= 64) {
                    return -22;
                }
                for (n5 = n4; n5 < 64 && this.fds[n5] != null; ++n5) {
                }
                if (n5 == 64) {
                    return -24;
                }
                this.fds[n5] = fD.dup();
                return n5;
            }
            case 3: {
                return fD.flags();
            }
            case 2: {
                this.closeOnExec[n2] = n4 != 0;
                return 0;
            }
            case 1: {
                return this.closeOnExec[n2] ? 1 : 0;
            }
            case 7: 
            case 8: {
                System.err.println("WARNING: file locking requires UnixRuntime");
                return -88;
            }
        }
        System.err.println("WARNING: Unknown fcntl command: " + n3);
        return -88;
    }

    final int fsync(int n2) {
        if (n2 < 0 || n2 >= 64) {
            return -81;
        }
        if (this.fds[n2] == null) {
            return -81;
        }
        FD fD = this.fds[n2];
        Seekable seekable = fD.seekable();
        if (seekable == null) {
            return -22;
        }
        try {
            seekable.sync();
            return 0;
        }
        catch (IOException iOException) {
            return -5;
        }
    }

    protected final int syscall(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        try {
            int n9 = this._syscall(n2, n3, n4, n5, n6, n7, n8);
            return n9;
        }
        catch (ErrnoException errnoException) {
            return -errnoException.errno;
        }
        catch (FaultException faultException) {
            return -14;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw new Error("Internal Error in _syscall()");
        }
    }

    int _syscall(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        switch (n2) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.sys_exit(n3);
            }
            case 2: {
                return this.sys_pause();
            }
            case 6: {
                return this.sys_write(n3, n4, n5);
            }
            case 8: {
                return this.sys_fstat(n3, n4);
            }
            case 7: {
                return this.sbrk(n3);
            }
            case 3: {
                return this.sys_open(n3, n4, n5);
            }
            case 4: {
                return this.sys_close(n3);
            }
            case 5: {
                return this.sys_read(n3, n4, n5);
            }
            case 10: {
                return this.sys_lseek(n3, n4, n5);
            }
            case 44: {
                return this.sys_ftruncate(n3, n4);
            }
            case 12: {
                return this.sys_getpid();
            }
            case 13: {
                return this.sys_calljava(n3, n4, n5, n6);
            }
            case 15: {
                return this.sys_gettimeofday(n3, n4);
            }
            case 16: {
                return this.sys_sleep(n3);
            }
            case 17: {
                return this.sys_times(n3);
            }
            case 19: {
                return this.sys_getpagesize();
            }
            case 29: {
                return this.sys_fcntl(n3, n4, n5);
            }
            case 31: {
                return this.sys_sysconf(n3);
            }
            case 68: {
                return this.sys_getuid();
            }
            case 70: {
                return this.sys_geteuid();
            }
            case 69: {
                return this.sys_getgid();
            }
            case 71: {
                return this.sys_getegid();
            }
            case 91: {
                return this.fsync(n3);
            }
            case 37: {
                this.memcpy(n3, n4, n5);
                return n3;
            }
            case 38: {
                this.memset(n3, n4, n5);
                return n3;
            }
            case 11: 
            case 14: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                System.err.println("Attempted to use a UnixRuntime syscall in Runtime (" + n2 + ")");
                return -88;
            }
        }
        System.err.println("Attempted to use unknown syscall: " + n2);
        return -88;
    }

    private int sys_getuid() {
        return 0;
    }

    private int sys_geteuid() {
        return 0;
    }

    private int sys_getgid() {
        return 0;
    }

    private int sys_getegid() {
        return 0;
    }

    public int xmalloc(int n2) {
        int n3 = this.malloc(n2);
        if (n3 == 0) {
            throw new RuntimeException("malloc() failed");
        }
        return n3;
    }

    public int xrealloc(int n2, int n3) {
        int n4 = this.realloc(n2, n3);
        if (n4 == 0) {
            throw new RuntimeException("realloc() failed");
        }
        return n4;
    }

    public int realloc(int n2, int n3) {
        try {
            return this.call("realloc", n2, n3);
        }
        catch (CallException callException) {
            return 0;
        }
    }

    public int malloc(int n2) {
        try {
            return this.call("malloc", n2);
        }
        catch (CallException callException) {
            return 0;
        }
    }

    public void free(int n2) {
        try {
            if (n2 != 0) {
                this.call("free", n2);
            }
        }
        catch (CallException callException) {
            // empty catch block
        }
    }

    public int strdup(String string) {
        if (string == null) {
            string = "(null)";
        }
        byte[] byArray = Runtime.getBytes(string);
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int n2 = this.malloc(byArray2.length);
        if (n2 == 0) {
            return 0;
        }
        try {
            this.copyout(byArray2, n2, byArray2.length);
        }
        catch (FaultException faultException) {
            this.free(n2);
            return 0;
        }
        return n2;
    }

    public final String utfstring(int n2) {
        if (n2 == 0) {
            return null;
        }
        int n3 = n2;
        int n4 = 1;
        while (n4 != 0) {
            n4 = this.memRead(n3 & 0xFFFFFFFC);
            switch (n3 & 3) {
                case 0: {
                    n4 = n4 >>> 24 & 0xFF;
                    break;
                }
                case 1: {
                    n4 = n4 >>> 16 & 0xFF;
                    break;
                }
                case 2: {
                    n4 = n4 >>> 8 & 0xFF;
                    break;
                }
                case 3: {
                    n4 = n4 >>> 0 & 0xFF;
                }
            }
            ++n3;
        }
        if (n3 > n2) {
            --n3;
        }
        byte[] byArray = new byte[n3 - n2];
        this.copyin(n2, byArray, byArray.length);
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public final String cstring(int n2) {
        if (n2 == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n3 = this.memRead(n2 & 0xFFFFFFFC);
            switch (n2 & 3) {
                case 0: {
                    if ((n3 >>> 24 & 0xFF) == 0) {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append((char)(n3 >>> 24 & 0xFF));
                    ++n2;
                }
                case 1: {
                    if ((n3 >>> 16 & 0xFF) == 0) {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append((char)(n3 >>> 16 & 0xFF));
                    ++n2;
                }
                case 2: {
                    if ((n3 >>> 8 & 0xFF) == 0) {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append((char)(n3 >>> 8 & 0xFF));
                    ++n2;
                }
                case 3: {
                    if ((n3 >>> 0 & 0xFF) == 0) {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append((char)(n3 >>> 0 & 0xFF));
                    ++n2;
                }
            }
        }
    }

    protected final void nullPointerCheck(int n2) {
        if (n2 < 65536) {
            throw new ExecutionException("Attempted to dereference a null pointer " + Runtime.toHex(n2));
        }
    }

    byte[] byteBuf(int n2) {
        if (this._byteBuf == null) {
            this._byteBuf = new byte[n2];
        } else if (this._byteBuf.length < n2) {
            this._byteBuf = new byte[Runtime.min(Runtime.max(this._byteBuf.length * 2, n2), 0xFFFC00)];
        }
        return this._byteBuf;
    }

    protected static final int[] decodeData(String string, int n2) {
        if (string.length() % 8 != 0) {
            throw new IllegalArgumentException("string length must be a multiple of 8");
        }
        if (string.length() / 8 * 7 < n2 * 4) {
            throw new IllegalArgumentException("string isn't big enough");
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            long l2 = 0L;
            for (int i2 = 0; i2 < 8; ++i2) {
                l2 <<= 7;
                l2 |= (long)(string.charAt(n5 + i2) & 0x7F);
            }
            if (n4 > 0) {
                nArray[n6++] = n3 | (int)(l2 >>> 56 - n4);
            }
            if (n6 < n2) {
                nArray[n6++] = (int)(l2 >>> 24 - n4);
            }
            n4 = n4 + 8 & 0x1F;
            n3 = (int)(l2 << n4);
            n5 += 8;
        }
        return nArray;
    }

    static byte[] getBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    static byte[] getNullTerminatedBytes(String string) {
        byte[] byArray = Runtime.getBytes(string);
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    static final String toHex(int n2) {
        return "0x" + Long.toString((long)n2 & 0xFFFFFFFFL, 16);
    }

    static final int min(int n2, int n3) {
        return n2 < n3 ? n2 : n3;
    }

    static final int max(int n2, int n3) {
        return n2 > n3 ? n2 : n3;
    }

    static {
        String string = Platform.getProperty("os.name");
        String string2 = Platform.getProperty("nestedvm.win32hacks");
        win32Hacks = string2 != null ? Boolean.valueOf(string2) : string != null && string.toLowerCase().indexOf("windows") != -1;
    }

    public static class SecurityManager {
        public boolean allowRead(File file) {
            return true;
        }

        public boolean allowWrite(File file) {
            return true;
        }

        public boolean allowStat(File file) {
            return true;
        }

        public boolean allowUnlink(File file) {
            return true;
        }
    }

    protected static class CPUState {
        public int[] r = new int[32];
        public int[] f = new int[32];
        public int hi;
        public int lo;
        public int fcsr;
        public int pc;

        public CPUState dup() {
            CPUState cPUState = new CPUState();
            cPUState.hi = this.hi;
            cPUState.lo = this.lo;
            cPUState.fcsr = this.fcsr;
            cPUState.pc = this.pc;
            for (int i2 = 0; i2 < 32; ++i2) {
                cPUState.r[i2] = this.r[i2];
                cPUState.f[i2] = this.f[i2];
            }
            return cPUState;
        }
    }

    protected static class ErrnoException
    extends Exception {
        public int errno;

        public ErrnoException(int n2) {
            super("Errno: " + n2);
            this.errno = n2;
        }
    }

    public static class CallException
    extends Exception {
        public CallException(String string) {
            super(string);
        }
    }

    public static class ExecutionException
    extends Exception {
        private String message = "(null)";
        private String location = "(unknown)";

        public ExecutionException() {
        }

        public ExecutionException(String string) {
            if (string != null) {
                this.message = string;
            }
        }

        void setLocation(String string) {
            this.location = string == null ? "(unknown)" : string;
        }

        public final String getMessage() {
            return this.message + " at " + this.location;
        }
    }

    public static class FaultException
    extends ExecutionException {
        public final int addr;
        public final RuntimeException cause;

        public FaultException(int n2) {
            super("fault at: " + Runtime.toHex(n2));
            this.addr = n2;
            this.cause = null;
        }

        public FaultException(RuntimeException runtimeException) {
            super(runtimeException.toString());
            this.addr = -1;
            this.cause = runtimeException;
        }
    }

    public static class WriteFaultException
    extends FaultException {
        public WriteFaultException(int n2) {
            super(n2);
        }
    }

    public static class ReadFaultException
    extends FaultException {
        public ReadFaultException(int n2) {
            super(n2);
        }
    }

    static class HostFStat
    extends FStat {
        private final File f;
        private final Seekable.File sf;
        private final boolean executable;

        public HostFStat(File file, Seekable.File file2) {
            this(file, file2, false);
        }

        public HostFStat(File file, boolean bl2) {
            this(file, null, bl2);
        }

        public HostFStat(File file, Seekable.File file2, boolean bl2) {
            this.f = file;
            this.sf = file2;
            this.executable = bl2;
        }

        public int dev() {
            return 1;
        }

        public int inode() {
            return this.f.getAbsolutePath().hashCode() & Short.MAX_VALUE;
        }

        public int type() {
            return this.f.isDirectory() ? 16384 : 32768;
        }

        public int nlink() {
            return 1;
        }

        public int mode() {
            int n2 = 0;
            boolean bl2 = this.f.canRead();
            if (bl2 && (this.executable || this.f.isDirectory())) {
                n2 |= 0x49;
            }
            if (bl2) {
                n2 |= 0x124;
            }
            if (this.f.canWrite()) {
                n2 |= 0x92;
            }
            return n2;
        }

        public int size() {
            try {
                return this.sf != null ? this.sf.length() : (int)this.f.length();
            }
            catch (Exception exception) {
                return (int)this.f.length();
            }
        }

        public int mtime() {
            return (int)(this.f.lastModified() / 1000L);
        }
    }

    public static class SocketFStat
    extends FStat {
        public int dev() {
            return -1;
        }

        public int type() {
            return 49152;
        }

        public int inode() {
            return this.hashCode() & Short.MAX_VALUE;
        }
    }

    public static abstract class FStat {
        public static final int S_IFIFO = 4096;
        public static final int S_IFCHR = 8192;
        public static final int S_IFDIR = 16384;
        public static final int S_IFREG = 32768;
        public static final int S_IFSOCK = 49152;

        public int mode() {
            return 0;
        }

        public int nlink() {
            return 0;
        }

        public int uid() {
            return 0;
        }

        public int gid() {
            return 0;
        }

        public int size() {
            return 0;
        }

        public int atime() {
            return 0;
        }

        public int mtime() {
            return 0;
        }

        public int ctime() {
            return 0;
        }

        public int blksize() {
            return 512;
        }

        public int blocks() {
            return (this.size() + this.blksize() - 1) / this.blksize();
        }

        public abstract int dev();

        public abstract int type();

        public abstract int inode();
    }

    static class Win32ConsoleIS
    extends InputStream {
        private int pushedBack = -1;
        private final InputStream parent;

        public Win32ConsoleIS(InputStream inputStream) {
            this.parent = inputStream;
        }

        public int read() {
            if (this.pushedBack != -1) {
                int n2 = this.pushedBack;
                this.pushedBack = -1;
                return n2;
            }
            int n3 = this.parent.read();
            if (n3 == 13 && (n3 = this.parent.read()) != 10) {
                this.pushedBack = n3;
                return 13;
            }
            return n3;
        }

        public int read(byte[] byArray, int n2, int n3) {
            int n4;
            boolean bl2 = false;
            if (this.pushedBack != -1 && n3 > 0) {
                byArray[0] = (byte)this.pushedBack;
                this.pushedBack = -1;
                ++n2;
                --n3;
                bl2 = true;
            }
            if ((n4 = this.parent.read(byArray, n2, n3)) == -1) {
                return bl2 ? 1 : -1;
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                if (byArray[n2 + i2] != 13) continue;
                if (i2 == n4 - 1) {
                    int n5 = this.parent.read();
                    if (n5 == 10) {
                        byArray[n2 + i2] = 10;
                        continue;
                    }
                    this.pushedBack = n5;
                    continue;
                }
                if (byArray[n2 + i2 + 1] != 10) continue;
                System.arraycopy(byArray, n2 + i2 + 1, byArray, n2 + i2, n3 - i2 - 1);
                --n4;
            }
            return n4 + (bl2 ? 1 : 0);
        }
    }

    static class TerminalFD
    extends InputOutputStreamFD {
        public TerminalFD(InputStream inputStream) {
            this(inputStream, null);
        }

        public TerminalFD(OutputStream outputStream) {
            this(null, outputStream);
        }

        public TerminalFD(InputStream inputStream, OutputStream outputStream) {
            super(inputStream, outputStream);
        }

        public void _close() {
        }

        public FStat _fstat() {
            return new SocketFStat(this){
                private final TerminalFD this$0;
                {
                    this.this$0 = terminalFD;
                }

                public int type() {
                    return 8192;
                }

                public int mode() {
                    return 384;
                }
            };
        }
    }

    public static class InputOutputStreamFD
    extends FD {
        private final InputStream is;
        private final OutputStream os;

        public InputOutputStreamFD(InputStream inputStream) {
            this(inputStream, null);
        }

        public InputOutputStreamFD(OutputStream outputStream) {
            this(null, outputStream);
        }

        public InputOutputStreamFD(InputStream inputStream, OutputStream outputStream) {
            this.is = inputStream;
            this.os = outputStream;
            if (inputStream == null && outputStream == null) {
                throw new IllegalArgumentException("at least one stream must be supplied");
            }
        }

        public int flags() {
            if (this.is != null && this.os != null) {
                return 2;
            }
            if (this.is != null) {
                return 0;
            }
            if (this.os != null) {
                return 1;
            }
            throw new Error("should never happen");
        }

        public void _close() {
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.os != null) {
                try {
                    this.os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public int read(byte[] byArray, int n2, int n3) {
            if (this.is == null) {
                return super.read(byArray, n2, n3);
            }
            try {
                int n4 = this.is.read(byArray, n2, n3);
                return n4 < 0 ? 0 : n4;
            }
            catch (IOException iOException) {
                throw new ErrnoException(5);
            }
        }

        public int write(byte[] byArray, int n2, int n3) {
            if (this.os == null) {
                return super.write(byArray, n2, n3);
            }
            try {
                this.os.write(byArray, n2, n3);
                return n3;
            }
            catch (IOException iOException) {
                throw new ErrnoException(5);
            }
        }

        public FStat _fstat() {
            return new SocketFStat();
        }
    }

    public static abstract class SeekableFD
    extends FD {
        private final int flags;
        private final Seekable data;

        SeekableFD(Seekable seekable, int n2) {
            this.data = seekable;
            this.flags = n2;
        }

        protected abstract FStat _fstat();

        public int flags() {
            return this.flags;
        }

        Seekable seekable() {
            return this.data;
        }

        public int seek(int n2, int n3) {
            try {
                switch (n3) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        n2 += this.data.pos();
                        break;
                    }
                    case 2: {
                        n2 += this.data.length();
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
                this.data.seek(n2);
                return n2;
            }
            catch (IOException iOException) {
                throw new ErrnoException(29);
            }
        }

        public int write(byte[] byArray, int n2, int n3) {
            if ((this.flags & 3) == 0) {
                throw new ErrnoException(81);
            }
            if ((this.flags & 8) != 0) {
                this.seek(0, 2);
            }
            try {
                return this.data.write(byArray, n2, n3);
            }
            catch (IOException iOException) {
                throw new ErrnoException(5);
            }
        }

        public int read(byte[] byArray, int n2, int n3) {
            if ((this.flags & 3) == 1) {
                throw new ErrnoException(81);
            }
            try {
                int n4 = this.data.read(byArray, n2, n3);
                return n4 < 0 ? 0 : n4;
            }
            catch (IOException iOException) {
                throw new ErrnoException(5);
            }
        }

        protected void _close() {
            try {
                this.data.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static abstract class FD {
        private int refCount = 1;
        private String normalizedPath = null;
        private boolean deleteOnClose = false;
        private FStat cachedFStat = null;

        public void setNormalizedPath(String string) {
            this.normalizedPath = string;
        }

        public String getNormalizedPath() {
            return this.normalizedPath;
        }

        public void markDeleteOnClose() {
            this.deleteOnClose = true;
        }

        public boolean isMarkedForDeleteOnClose() {
            return this.deleteOnClose;
        }

        public int read(byte[] byArray, int n2, int n3) {
            throw new ErrnoException(81);
        }

        public int write(byte[] byArray, int n2, int n3) {
            throw new ErrnoException(81);
        }

        public int seek(int n2, int n3) {
            return -1;
        }

        public int getdents(byte[] byArray, int n2, int n3) {
            throw new ErrnoException(81);
        }

        Seekable seekable() {
            return null;
        }

        public final FStat fstat() {
            if (this.cachedFStat == null) {
                this.cachedFStat = this._fstat();
            }
            return this.cachedFStat;
        }

        protected abstract FStat _fstat();

        public abstract int flags();

        public final void close() {
            if (--this.refCount == 0) {
                this._close();
            }
        }

        protected void _close() {
        }

        FD dup() {
            ++this.refCount;
            return this;
        }
    }

    public static interface CallJavaCB {
        public int call(int var1, int var2, int var3, int var4);
    }
}

