/*
 * Decompiled with CFR 0.152.
 */
package org.ibex.nestedvm;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.ibex.nestedvm.Runtime;
import org.ibex.nestedvm.UnixRuntime;
import org.ibex.nestedvm.util.ELF;
import org.ibex.nestedvm.util.Seekable;

public class Interpreter
extends UnixRuntime
implements Cloneable {
    private int[] registers = new int[32];
    private int hi;
    private int lo;
    private int[] fpregs = new int[32];
    private int fcsr;
    private int pc;
    public String image;
    private ELF.Symtab symtab;
    private int gp;
    private ELF.Symbol userInfo;
    private int entryPoint;
    private int heapStart;
    private HashMap sourceLineCache;

    private final void setFC(boolean bl2) {
        this.fcsr = this.fcsr & 0xFF7FFFFF | (bl2 ? 0x800000 : 0);
    }

    private final int roundingMode() {
        return this.fcsr & 3;
    }

    private final double getDouble(int n2) {
        return Double.longBitsToDouble(((long)this.fpregs[n2 + 1] & 0xFFFFFFFFL) << 32 | (long)this.fpregs[n2] & 0xFFFFFFFFL);
    }

    private final void setDouble(int n2, double d2) {
        long l2 = Double.doubleToLongBits(d2);
        this.fpregs[n2 + 1] = (int)(l2 >>> 32);
        this.fpregs[n2] = (int)l2;
    }

    private final float getFloat(int n2) {
        return Float.intBitsToFloat(this.fpregs[n2]);
    }

    private final void setFloat(int n2, float f2) {
        this.fpregs[n2] = Float.floatToRawIntBits(f2);
    }

    protected void _execute() {
        try {
            this.runSome();
        }
        catch (Runtime.ExecutionException executionException) {
            executionException.setLocation(Interpreter.toHex(this.pc) + ": " + this.sourceLine(this.pc));
            throw executionException;
        }
    }

    protected Object clone() {
        Interpreter interpreter = (Interpreter)super.clone();
        interpreter.registers = (int[])this.registers.clone();
        interpreter.fpregs = (int[])this.fpregs.clone();
        return interpreter;
    }

    private final int runSome() {
        block222: {
            int n2 = 1 << this.pageShift >> 2;
            int[] nArray = this.registers;
            int[] nArray2 = this.fpregs;
            int n3 = this.pc;
            int n4 = n3 + 4;
            try {
                block211: while (true) {
                    int n5;
                    int n6;
                    try {
                        n6 = this.readPages[n3 >>> this.pageShift][n3 >>> 2 & n2 - 1];
                    }
                    catch (RuntimeException runtimeException) {
                        if (n3 == -559038737) {
                            throw new Error("fell off cpu: r2: " + nArray[2]);
                        }
                        n6 = this.memRead(n3);
                    }
                    int n7 = n6 >>> 26 & 0xFF;
                    int n8 = n6 >>> 21 & 0x1F;
                    int n9 = n6 >>> 16 & 0x1F;
                    int n10 = n6 >>> 16 & 0x1F;
                    int n11 = n6 >>> 11 & 0x1F;
                    int n12 = n6 >>> 11 & 0x1F;
                    int n13 = n6 >>> 6 & 0x1F;
                    int n14 = n6 >>> 6 & 0x1F;
                    int n15 = n6 & 0x3F;
                    int n16 = n6 & 0x3FFFFFF;
                    int n17 = n6 & 0xFFFF;
                    int n18 = n5 = n6 << 16 >> 16;
                    nArray[0] = 0;
                    block15 : switch (n7) {
                        case 0: {
                            int n19;
                            switch (n15) {
                                case 0: {
                                    if (n6 == 0) break block15;
                                    nArray[n11] = nArray[n9] << n13;
                                    break block15;
                                }
                                case 2: {
                                    nArray[n11] = nArray[n9] >>> n13;
                                    break block15;
                                }
                                case 3: {
                                    nArray[n11] = nArray[n9] >> n13;
                                    break block15;
                                }
                                case 4: {
                                    nArray[n11] = nArray[n9] << (nArray[n8] & 0x1F);
                                    break block15;
                                }
                                case 6: {
                                    nArray[n11] = nArray[n9] >>> (nArray[n8] & 0x1F);
                                    break block15;
                                }
                                case 7: {
                                    nArray[n11] = nArray[n9] >> (nArray[n8] & 0x1F);
                                    break block15;
                                }
                                case 8: {
                                    n19 = nArray[n8];
                                    n3 += 4;
                                    n4 = n19;
                                    continue block211;
                                }
                                case 9: {
                                    n19 = nArray[n8];
                                    nArray[n11] = (n3 += 4) + 4;
                                    n4 = n19;
                                    continue block211;
                                }
                                case 12: {
                                    this.pc = n3;
                                    nArray[2] = this.syscall(nArray[2], nArray[4], nArray[5], nArray[6], nArray[7], nArray[8], nArray[9]);
                                    if (this.state == 0) break block15;
                                    this.pc = n4;
                                    break block222;
                                }
                                case 13: {
                                    throw new Runtime.ExecutionException("Break");
                                }
                                case 16: {
                                    nArray[n11] = this.hi;
                                    break block15;
                                }
                                case 17: {
                                    this.hi = nArray[n8];
                                    break block15;
                                }
                                case 18: {
                                    nArray[n11] = this.lo;
                                    break block15;
                                }
                                case 19: {
                                    this.lo = nArray[n8];
                                    break block15;
                                }
                                case 24: {
                                    long l2 = (long)nArray[n8] * (long)nArray[n9];
                                    this.hi = (int)(l2 >>> 32);
                                    this.lo = (int)l2;
                                    break block15;
                                }
                                case 25: {
                                    long l3 = ((long)nArray[n8] & 0xFFFFFFFFL) * ((long)nArray[n9] & 0xFFFFFFFFL);
                                    this.hi = (int)(l3 >>> 32);
                                    this.lo = (int)l3;
                                    break block15;
                                }
                                case 26: {
                                    this.hi = nArray[n8] % nArray[n9];
                                    this.lo = nArray[n8] / nArray[n9];
                                    break block15;
                                }
                                case 27: {
                                    if (n9 == 0) break block15;
                                    this.hi = (int)(((long)nArray[n8] & 0xFFFFFFFFL) % ((long)nArray[n9] & 0xFFFFFFFFL));
                                    this.lo = (int)(((long)nArray[n8] & 0xFFFFFFFFL) / ((long)nArray[n9] & 0xFFFFFFFFL));
                                    break block15;
                                }
                                case 32: {
                                    throw new Runtime.ExecutionException("ADD (add with oveflow trap) not suported");
                                }
                                case 33: {
                                    nArray[n11] = nArray[n8] + nArray[n9];
                                    break block15;
                                }
                                case 34: {
                                    throw new Runtime.ExecutionException("SUB (sub with oveflow trap) not suported");
                                }
                                case 35: {
                                    nArray[n11] = nArray[n8] - nArray[n9];
                                    break block15;
                                }
                                case 36: {
                                    nArray[n11] = nArray[n8] & nArray[n9];
                                    break block15;
                                }
                                case 37: {
                                    nArray[n11] = nArray[n8] | nArray[n9];
                                    break block15;
                                }
                                case 38: {
                                    nArray[n11] = nArray[n8] ^ nArray[n9];
                                    break block15;
                                }
                                case 39: {
                                    nArray[n11] = ~(nArray[n8] | nArray[n9]);
                                    break block15;
                                }
                                case 42: {
                                    nArray[n11] = nArray[n8] < nArray[n9] ? 1 : 0;
                                    break block15;
                                }
                                case 43: {
                                    nArray[n11] = ((long)nArray[n8] & 0xFFFFFFFFL) < ((long)nArray[n9] & 0xFFFFFFFFL) ? 1 : 0;
                                    break block15;
                                }
                                default: {
                                    throw new Runtime.ExecutionException("Illegal instruction 0/" + n15);
                                }
                            }
                        }
                        case 1: {
                            int n19;
                            switch (n9) {
                                case 0: {
                                    if (nArray[n8] >= 0) break block15;
                                    n4 = n19 = (n3 += 4) + n18 * 4;
                                    continue block211;
                                }
                                case 1: {
                                    if (nArray[n8] < 0) break block15;
                                    n4 = n19 = (n3 += 4) + n18 * 4;
                                    continue block211;
                                }
                                case 16: {
                                    if (nArray[n8] >= 0) break block15;
                                    nArray[31] = (n3 += 4) + 4;
                                    n4 = n19 = n3 + n18 * 4;
                                    continue block211;
                                }
                                case 17: {
                                    if (nArray[n8] < 0) break block15;
                                    nArray[31] = (n3 += 4) + 4;
                                    n4 = n19 = n3 + n18 * 4;
                                    continue block211;
                                }
                                default: {
                                    throw new Runtime.ExecutionException("Illegal Instruction");
                                }
                            }
                        }
                        case 2: {
                            int n19 = n3 & 0xF0000000 | n16 << 2;
                            n3 += 4;
                            n4 = n19;
                            continue block211;
                        }
                        case 3: {
                            int n19 = n3 & 0xF0000000 | n16 << 2;
                            nArray[31] = (n3 += 4) + 4;
                            n4 = n19;
                            continue block211;
                        }
                        case 4: {
                            int n19;
                            if (nArray[n8] != nArray[n9]) break;
                            n4 = n19 = (n3 += 4) + n18 * 4;
                            continue block211;
                        }
                        case 5: {
                            int n19;
                            if (nArray[n8] == nArray[n9]) break;
                            n4 = n19 = (n3 += 4) + n18 * 4;
                            continue block211;
                        }
                        case 6: {
                            int n19;
                            if (nArray[n8] > 0) break;
                            n4 = n19 = (n3 += 4) + n18 * 4;
                            continue block211;
                        }
                        case 7: {
                            int n19;
                            if (nArray[n8] <= 0) break;
                            n4 = n19 = (n3 += 4) + n18 * 4;
                            continue block211;
                        }
                        case 8: {
                            nArray[n9] = nArray[n8] + n5;
                            break;
                        }
                        case 9: {
                            nArray[n9] = nArray[n8] + n5;
                            break;
                        }
                        case 10: {
                            nArray[n9] = nArray[n8] < n5 ? 1 : 0;
                            break;
                        }
                        case 11: {
                            nArray[n9] = ((long)nArray[n8] & 0xFFFFFFFFL) < ((long)n5 & 0xFFFFFFFFL) ? 1 : 0;
                            break;
                        }
                        case 12: {
                            nArray[n9] = nArray[n8] & n17;
                            break;
                        }
                        case 13: {
                            nArray[n9] = nArray[n8] | n17;
                            break;
                        }
                        case 14: {
                            nArray[n9] = nArray[n8] ^ n17;
                            break;
                        }
                        case 15: {
                            nArray[n9] = n17 << 16;
                            break;
                        }
                        case 16: {
                            throw new Runtime.ExecutionException("TLB/Exception support not implemented");
                        }
                        case 17: {
                            boolean bl2;
                            int n19;
                            boolean bl3 = false;
                            String string = bl3 ? this.sourceLine(n3) : "";
                            boolean bl4 = bl2 = bl3 && (string.indexOf("dtoa.c:51") >= 0 || string.indexOf("dtoa.c:52") >= 0 || string.indexOf("test.c") >= 0);
                            if (n8 > 8 && bl2) {
                                System.out.println("               FP Op: " + n7 + "/" + n8 + "/" + n15 + " " + string);
                            }
                            if (this.roundingMode() != 0 && n8 != 6 && (n8 != 16 && n8 != 17 || n15 != 36)) {
                                throw new Runtime.ExecutionException("Non-cvt.w.z operation attempted with roundingMode != round to nearest");
                            }
                            switch (n8) {
                                case 0: {
                                    nArray[n9] = nArray2[n11];
                                    break block15;
                                }
                                case 2: {
                                    if (n12 != 31) {
                                        throw new Runtime.ExecutionException("FCR " + n12 + " unavailable");
                                    }
                                    nArray[n9] = this.fcsr;
                                    break block15;
                                }
                                case 4: {
                                    nArray2[n11] = nArray[n9];
                                    break block15;
                                }
                                case 6: {
                                    if (n12 != 31) {
                                        throw new Runtime.ExecutionException("FCR " + n12 + " unavailable");
                                    }
                                    this.fcsr = nArray[n9];
                                    break block15;
                                }
                                case 8: {
                                    if ((this.fcsr & 0x800000) != 0 != ((n6 >>> 16 & 1) != 0)) break block15;
                                    n4 = n19 = (n3 += 4) + n18 * 4;
                                    continue block211;
                                }
                                case 16: {
                                    switch (n15) {
                                        case 0: {
                                            this.setFloat(n14, this.getFloat(n12) + this.getFloat(n10));
                                            break block15;
                                        }
                                        case 1: {
                                            this.setFloat(n14, this.getFloat(n12) - this.getFloat(n10));
                                            break block15;
                                        }
                                        case 2: {
                                            this.setFloat(n14, this.getFloat(n12) * this.getFloat(n10));
                                            break block15;
                                        }
                                        case 3: {
                                            this.setFloat(n14, this.getFloat(n12) / this.getFloat(n10));
                                            break block15;
                                        }
                                        case 5: {
                                            this.setFloat(n14, Math.abs(this.getFloat(n12)));
                                            break block15;
                                        }
                                        case 6: {
                                            nArray2[n14] = nArray2[n12];
                                            break block15;
                                        }
                                        case 7: {
                                            this.setFloat(n14, -this.getFloat(n12));
                                            break block15;
                                        }
                                        case 33: {
                                            this.setDouble(n14, this.getFloat(n12));
                                            break block15;
                                        }
                                        case 36: {
                                            switch (this.roundingMode()) {
                                                case 0: {
                                                    nArray2[n14] = (int)Math.floor(this.getFloat(n12) + 0.5f);
                                                    break;
                                                }
                                                case 1: {
                                                    nArray2[n14] = (int)this.getFloat(n12);
                                                    break;
                                                }
                                                case 2: {
                                                    nArray2[n14] = (int)Math.ceil(this.getFloat(n12));
                                                    break;
                                                }
                                                case 3: {
                                                    nArray2[n14] = (int)Math.floor(this.getFloat(n12));
                                                }
                                            }
                                            break block15;
                                        }
                                        case 50: {
                                            this.setFC(this.getFloat(n12) == this.getFloat(n10));
                                            break block15;
                                        }
                                        case 60: {
                                            this.setFC(this.getFloat(n12) < this.getFloat(n10));
                                            break block15;
                                        }
                                        case 62: {
                                            this.setFC(this.getFloat(n12) <= this.getFloat(n10));
                                            break block15;
                                        }
                                    }
                                    throw new Runtime.ExecutionException("Invalid Instruction 17/" + n8 + "/" + n15 + " at " + this.sourceLine(n3));
                                }
                                case 17: {
                                    switch (n15) {
                                        case 0: {
                                            this.setDouble(n14, this.getDouble(n12) + this.getDouble(n10));
                                            break block15;
                                        }
                                        case 1: {
                                            if (bl2) {
                                                System.out.println("f" + n14 + " = f" + n12 + " (" + this.getDouble(n12) + ") - f" + n10 + " (" + this.getDouble(n10) + ")");
                                            }
                                            this.setDouble(n14, this.getDouble(n12) - this.getDouble(n10));
                                            break block15;
                                        }
                                        case 2: {
                                            if (bl2) {
                                                System.out.println("f" + n14 + " = f" + n12 + " (" + this.getDouble(n12) + ") * f" + n10 + " (" + this.getDouble(n10) + ")");
                                            }
                                            this.setDouble(n14, this.getDouble(n12) * this.getDouble(n10));
                                            if (!bl2) break block15;
                                            System.out.println("f" + n14 + " = " + this.getDouble(n14));
                                            break block15;
                                        }
                                        case 3: {
                                            this.setDouble(n14, this.getDouble(n12) / this.getDouble(n10));
                                            break block15;
                                        }
                                        case 5: {
                                            this.setDouble(n14, Math.abs(this.getDouble(n12)));
                                            break block15;
                                        }
                                        case 6: {
                                            nArray2[n14] = nArray2[n12];
                                            nArray2[n14 + 1] = nArray2[n12 + 1];
                                            break block15;
                                        }
                                        case 7: {
                                            this.setDouble(n14, -this.getDouble(n12));
                                            break block15;
                                        }
                                        case 32: {
                                            this.setFloat(n14, (float)this.getDouble(n12));
                                            break block15;
                                        }
                                        case 36: {
                                            if (bl2) {
                                                System.out.println("CVT.W.D rm: " + this.roundingMode() + " f" + n12 + ":" + this.getDouble(n12));
                                            }
                                            switch (this.roundingMode()) {
                                                case 0: {
                                                    nArray2[n14] = (int)Math.floor(this.getDouble(n12) + 0.5);
                                                    break;
                                                }
                                                case 1: {
                                                    nArray2[n14] = (int)this.getDouble(n12);
                                                    break;
                                                }
                                                case 2: {
                                                    nArray2[n14] = (int)Math.ceil(this.getDouble(n12));
                                                    break;
                                                }
                                                case 3: {
                                                    nArray2[n14] = (int)Math.floor(this.getDouble(n12));
                                                }
                                            }
                                            if (!bl2) break block15;
                                            System.out.println("CVT.W.D: f" + n14 + ":" + nArray2[n14]);
                                            break block15;
                                        }
                                        case 50: {
                                            this.setFC(this.getDouble(n12) == this.getDouble(n10));
                                            break block15;
                                        }
                                        case 60: {
                                            this.setFC(this.getDouble(n12) < this.getDouble(n10));
                                            break block15;
                                        }
                                        case 62: {
                                            this.setFC(this.getDouble(n12) <= this.getDouble(n10));
                                            break block15;
                                        }
                                        default: {
                                            throw new Runtime.ExecutionException("Invalid Instruction 17/" + n8 + "/" + n15 + " at " + this.sourceLine(n3));
                                        }
                                    }
                                }
                                case 20: {
                                    switch (n15) {
                                        case 32: {
                                            this.setFloat(n14, nArray2[n12]);
                                            break block15;
                                        }
                                        case 33: {
                                            this.setDouble(n14, nArray2[n12]);
                                            break block15;
                                        }
                                    }
                                    throw new Runtime.ExecutionException("Invalid Instruction 17/" + n8 + "/" + n15 + " at " + this.sourceLine(n3));
                                }
                                default: {
                                    throw new Runtime.ExecutionException("Invalid Instruction 17/" + n8);
                                }
                            }
                        }
                        case 18: 
                        case 19: {
                            throw new Runtime.ExecutionException("No coprocessor installed");
                        }
                        case 32: {
                            int n19;
                            int n20 = nArray[n8] + n5;
                            try {
                                n19 = this.readPages[n20 >>> this.pageShift][n20 >>> 2 & n2 - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                n19 = this.memRead(n20 & 0xFFFFFFFC);
                            }
                            switch (n20 & 3) {
                                case 0: {
                                    n19 = n19 >>> 24 & 0xFF;
                                    break;
                                }
                                case 1: {
                                    n19 = n19 >>> 16 & 0xFF;
                                    break;
                                }
                                case 2: {
                                    n19 = n19 >>> 8 & 0xFF;
                                    break;
                                }
                                case 3: {
                                    n19 = n19 >>> 0 & 0xFF;
                                }
                            }
                            if ((n19 & 0x80) != 0) {
                                n19 |= 0xFFFFFF00;
                            }
                            nArray[n9] = n19;
                            break;
                        }
                        case 33: {
                            int n19;
                            int n20 = nArray[n8] + n5;
                            try {
                                n19 = this.readPages[n20 >>> this.pageShift][n20 >>> 2 & n2 - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                n19 = this.memRead(n20 & 0xFFFFFFFC);
                            }
                            switch (n20 & 3) {
                                case 0: {
                                    n19 = n19 >>> 16 & 0xFFFF;
                                    break;
                                }
                                case 2: {
                                    n19 = n19 >>> 0 & 0xFFFF;
                                    break;
                                }
                                default: {
                                    throw new Runtime.ReadFaultException(n20);
                                }
                            }
                            if ((n19 & 0x8000) != 0) {
                                n19 |= 0xFFFF0000;
                            }
                            nArray[n9] = n19;
                            break;
                        }
                        case 34: {
                            int n19;
                            int n20 = nArray[n8] + n5;
                            try {
                                n19 = this.readPages[n20 >>> this.pageShift][n20 >>> 2 & n2 - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                n19 = this.memRead(n20 & 0xFFFFFFFC);
                            }
                            switch (n20 & 3) {
                                case 0: {
                                    nArray[n9] = nArray[n9] & 0 | n19 << 0;
                                    break;
                                }
                                case 1: {
                                    nArray[n9] = nArray[n9] & 0xFF | n19 << 8;
                                    break;
                                }
                                case 2: {
                                    nArray[n9] = nArray[n9] & 0xFFFF | n19 << 16;
                                    break;
                                }
                                case 3: {
                                    nArray[n9] = nArray[n9] & 0xFFFFFF | n19 << 24;
                                }
                            }
                            break;
                        }
                        case 35: {
                            int n20 = nArray[n8] + n5;
                            try {
                                nArray[n9] = this.readPages[n20 >>> this.pageShift][n20 >>> 2 & n2 - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                nArray[n9] = this.memRead(n20);
                            }
                            break;
                        }
                        case 36: {
                            int n19;
                            int n20 = nArray[n8] + n5;
                            try {
                                n19 = this.readPages[n20 >>> this.pageShift][n20 >>> 2 & n2 - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                n19 = this.memRead(n20);
                            }
                            switch (n20 & 3) {
                                case 0: {
                                    nArray[n9] = n19 >>> 24 & 0xFF;
                                    break;
                                }
                                case 1: {
                                    nArray[n9] = n19 >>> 16 & 0xFF;
                                    break;
                                }
                                case 2: {
                                    nArray[n9] = n19 >>> 8 & 0xFF;
                                    break;
                                }
                                case 3: {
                                    nArray[n9] = n19 >>> 0 & 0xFF;
                                }
                            }
                            break;
                        }
                        case 37: {
                            int n19;
                            int n20 = nArray[n8] + n5;
                            try {
                                n19 = this.readPages[n20 >>> this.pageShift][n20 >>> 2 & n2 - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                n19 = this.memRead(n20 & 0xFFFFFFFC);
                            }
                            switch (n20 & 3) {
                                case 0: {
                                    nArray[n9] = n19 >>> 16 & 0xFFFF;
                                    break block15;
                                }
                                case 2: {
                                    nArray[n9] = n19 >>> 0 & 0xFFFF;
                                    break block15;
                                }
                            }
                            throw new Runtime.ReadFaultException(n20);
                        }
                        case 38: {
                            int n19;
                            int n20 = nArray[n8] + n5;
                            try {
                                n19 = this.readPages[n20 >>> this.pageShift][n20 >>> 2 & n2 - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                n19 = this.memRead(n20 & 0xFFFFFFFC);
                            }
                            switch (n20 & 3) {
                                case 0: {
                                    nArray[n9] = nArray[n9] & 0xFFFFFF00 | n19 >>> 24;
                                    break;
                                }
                                case 1: {
                                    nArray[n9] = nArray[n9] & 0xFFFF0000 | n19 >>> 16;
                                    break;
                                }
                                case 2: {
                                    nArray[n9] = nArray[n9] & 0xFF000000 | n19 >>> 8;
                                    break;
                                }
                                case 3: {
                                    nArray[n9] = nArray[n9] & 0 | n19 >>> 0;
                                }
                            }
                            break;
                        }
                        case 40: {
                            int n19;
                            int n20 = nArray[n8] + n5;
                            try {
                                n19 = this.readPages[n20 >>> this.pageShift][n20 >>> 2 & n2 - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                n19 = this.memRead(n20 & 0xFFFFFFFC);
                            }
                            switch (n20 & 3) {
                                case 0: {
                                    n19 = n19 & 0xFFFFFF | (nArray[n9] & 0xFF) << 24;
                                    break;
                                }
                                case 1: {
                                    n19 = n19 & 0xFF00FFFF | (nArray[n9] & 0xFF) << 16;
                                    break;
                                }
                                case 2: {
                                    n19 = n19 & 0xFFFF00FF | (nArray[n9] & 0xFF) << 8;
                                    break;
                                }
                                case 3: {
                                    n19 = n19 & 0xFFFFFF00 | (nArray[n9] & 0xFF) << 0;
                                }
                            }
                            try {
                                this.writePages[n20 >>> this.pageShift][n20 >>> 2 & n2 - 1] = n19;
                            }
                            catch (RuntimeException runtimeException) {
                                this.memWrite(n20 & 0xFFFFFFFC, n19);
                            }
                            break;
                        }
                        case 41: {
                            int n19;
                            int n20 = nArray[n8] + n5;
                            try {
                                n19 = this.readPages[n20 >>> this.pageShift][n20 >>> 2 & n2 - 1];
                            }
                            catch (RuntimeException runtimeException) {
                                n19 = this.memRead(n20 & 0xFFFFFFFC);
                            }
                            switch (n20 & 3) {
                                case 0: {
                                    n19 = n19 & 0xFFFF | (nArray[n9] & 0xFFFF) << 16;
                                    break;
                                }
                                case 2: {
                                    n19 = n19 & 0xFFFF0000 | (nArray[n9] & 0xFFFF) << 0;
                                    break;
                                }
                                default: {
                                    throw new Runtime.WriteFaultException(n20);
                                }
                            }
                            try {
                                this.writePages[n20 >>> this.pageShift][n20 >>> 2 & n2 - 1] = n19;
                            }
                            catch (RuntimeException runtimeException) {
                                this.memWrite(n20 & 0xFFFFFFFC, n19);
                            }
                            break;
                        }
                        case 42: {
                            int n20 = nArray[n8] + n5;
                            int n19 = this.memRead(n20 & 0xFFFFFFFC);
                            switch (n20 & 3) {
                                case 0: {
                                    n19 = n19 & 0 | nArray[n9] >>> 0;
                                    break;
                                }
                                case 1: {
                                    n19 = n19 & 0xFF000000 | nArray[n9] >>> 8;
                                    break;
                                }
                                case 2: {
                                    n19 = n19 & 0xFFFF0000 | nArray[n9] >>> 16;
                                    break;
                                }
                                case 3: {
                                    n19 = n19 & 0xFFFFFF00 | nArray[n9] >>> 24;
                                }
                            }
                            try {
                                this.writePages[n20 >>> this.pageShift][n20 >>> 2 & n2 - 1] = n19;
                            }
                            catch (RuntimeException runtimeException) {
                                this.memWrite(n20 & 0xFFFFFFFC, n19);
                            }
                            break;
                        }
                        case 43: {
                            int n20 = nArray[n8] + n5;
                            try {
                                this.writePages[n20 >>> this.pageShift][n20 >>> 2 & n2 - 1] = nArray[n9];
                            }
                            catch (RuntimeException runtimeException) {
                                this.memWrite(n20 & 0xFFFFFFFC, nArray[n9]);
                            }
                            break;
                        }
                        case 46: {
                            int n20 = nArray[n8] + n5;
                            int n19 = this.memRead(n20 & 0xFFFFFFFC);
                            switch (n20 & 3) {
                                case 0: {
                                    n19 = n19 & 0xFFFFFF | nArray[n9] << 24;
                                    break;
                                }
                                case 1: {
                                    n19 = n19 & 0xFFFF | nArray[n9] << 16;
                                    break;
                                }
                                case 2: {
                                    n19 = n19 & 0xFF | nArray[n9] << 8;
                                    break;
                                }
                                case 3: {
                                    n19 = n19 & 0 | nArray[n9] << 0;
                                }
                            }
                            this.memWrite(n20 & 0xFFFFFFFC, n19);
                            break;
                        }
                        case 48: {
                            nArray[n9] = this.memRead(nArray[n8] + n5);
                            break;
                        }
                        case 49: {
                            nArray2[n9] = this.memRead(nArray[n8] + n5);
                            break;
                        }
                        case 56: {
                            this.memWrite(nArray[n8] + n5, nArray[n9]);
                            nArray[n9] = 1;
                            break;
                        }
                        case 57: {
                            this.memWrite(nArray[n8] + n5, nArray2[n9]);
                            break;
                        }
                        default: {
                            throw new Runtime.ExecutionException("Invalid Instruction: " + n7);
                        }
                    }
                    n3 = n4;
                    n4 = n3 + 4;
                }
            }
            catch (Runtime.ExecutionException executionException) {
                this.pc = n3;
                throw executionException;
            }
        }
        return 0;
    }

    public int lookupSymbol(String string) {
        ELF.Symbol symbol = this.symtab.getGlobalSymbol(string);
        return symbol == null ? -1 : symbol.addr;
    }

    protected int gp() {
        return this.gp;
    }

    protected int userInfoBae() {
        return this.userInfo == null ? 0 : this.userInfo.addr;
    }

    protected int userInfoSize() {
        return this.userInfo == null ? 0 : this.userInfo.size;
    }

    protected int entryPoint() {
        return this.entryPoint;
    }

    protected int heapStart() {
        return this.heapStart;
    }

    private void loadImage(Seekable seekable) {
        ELF eLF = new ELF(seekable);
        this.symtab = eLF.getSymtab();
        if (eLF.header.type != 2) {
            throw new IOException("Binary is not an executable");
        }
        if (eLF.header.machine != 8) {
            throw new IOException("Binary is not for the MIPS I Architecture");
        }
        if (eLF.ident.data != 2) {
            throw new IOException("Binary is not big endian");
        }
        this.entryPoint = eLF.header.entry;
        ELF.Symtab symtab = eLF.getSymtab();
        if (symtab == null) {
            throw new IOException("No symtab in binary (did you strip it?)");
        }
        this.userInfo = symtab.getGlobalSymbol("user_info");
        ELF.Symbol symbol = symtab.getGlobalSymbol("_gp");
        if (symbol == null) {
            throw new IOException("NO _gp symbol!");
        }
        this.gp = symbol.addr;
        this.entryPoint = eLF.header.entry;
        ELF.PHeader[] pHeaderArray = eLF.pheaders;
        int n2 = 0;
        int n3 = 1 << this.pageShift;
        int n4 = 1 << this.pageShift >> 2;
        for (int i2 = 0; i2 < pHeaderArray.length; ++i2) {
            ELF.PHeader pHeader = pHeaderArray[i2];
            if (pHeader.type != 1) continue;
            int n5 = pHeader.memsz;
            int n6 = pHeader.filesz;
            if (n5 == 0) continue;
            if (n5 < 0) {
                throw new IOException("pheader size too large");
            }
            int n7 = pHeader.vaddr;
            if (n7 == 0) {
                throw new IOException("pheader vaddr == 0x0");
            }
            n2 = Interpreter.max(n7 + n5, n2);
            for (int i3 = 0; i3 < n5 + n3 - 1; i3 += n3) {
                int n8 = i3 + n7 >>> this.pageShift;
                if (this.readPages[n8] == null) {
                    this.readPages[n8] = new int[n4];
                }
                if (!pHeader.writable()) continue;
                this.writePages[n8] = this.readPages[n8];
            }
            if (n6 == 0) continue;
            n6 &= 0xFFFFFFFC;
            DataInputStream dataInputStream = new DataInputStream(pHeader.getInputStream());
            do {
                this.readPages[n7 >>> this.pageShift][n7 >>> 2 & n4 - 1] = dataInputStream.readInt();
                n7 += 4;
            } while ((n6 -= 4) > 0);
            dataInputStream.close();
        }
        this.heapStart = n2 + n3 - 1 & ~(n3 - 1);
    }

    protected void setCPUState(Runtime.CPUState cPUState) {
        int n2;
        for (n2 = 1; n2 < 32; ++n2) {
            this.registers[n2] = cPUState.r[n2];
        }
        for (n2 = 0; n2 < 32; ++n2) {
            this.fpregs[n2] = cPUState.f[n2];
        }
        this.hi = cPUState.hi;
        this.lo = cPUState.lo;
        this.fcsr = cPUState.fcsr;
        this.pc = cPUState.pc;
    }

    protected void getCPUState(Runtime.CPUState cPUState) {
        int n2;
        for (n2 = 1; n2 < 32; ++n2) {
            cPUState.r[n2] = this.registers[n2];
        }
        for (n2 = 0; n2 < 32; ++n2) {
            cPUState.f[n2] = this.fpregs[n2];
        }
        cPUState.hi = this.hi;
        cPUState.lo = this.lo;
        cPUState.fcsr = this.fcsr;
        cPUState.pc = this.pc;
    }

    public Interpreter(Seekable seekable) {
        super(4096, 65536);
        this.loadImage(seekable);
    }

    public Interpreter(String string) {
        this(new Seekable.File(string, false));
        this.image = string;
    }

    public Interpreter(InputStream inputStream) {
        this(new Seekable.InputStream(inputStream));
    }

    public String sourceLine(int n2) {
        String string = this.sourceLineCache == null ? null : this.sourceLineCache.get(new Integer(n2));
        if (string != null) {
            return string;
        }
        if (this.image == null) {
            return null;
        }
        try {
            Process process = java.lang.Runtime.getRuntime().exec(new String[]{"mips-unknown-elf-addr2line", "-e", this.image, Interpreter.toHex(n2)});
            string = new BufferedReader(new InputStreamReader(process.getInputStream())).readLine();
            if (string == null) {
                return null;
            }
            while (string.startsWith("../")) {
                string = string.substring(3);
            }
            if (this.sourceLineCache == null) {
                this.sourceLineCache = new HashMap();
            }
            this.sourceLineCache.put(new Integer(n2), string);
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        Interpreter interpreter = new Interpreter(string);
        java.lang.Runtime.getRuntime().addShutdownHook(new Thread(new DebugShutdownHook(interpreter)));
        int n2 = interpreter.run(stringArray);
        System.err.println("Exit status: " + n2);
        System.exit(n2);
    }

    static int access$000(Interpreter interpreter) {
        return interpreter.pc;
    }

    public class DebugShutdownHook
    implements Runnable {
        private final Interpreter this$0;

        public DebugShutdownHook(Interpreter interpreter) {
            this.this$0 = interpreter;
        }

        public void run() {
            int n2 = Interpreter.access$000(this.this$0);
            if (this.this$0.getState() == 0) {
                System.err.print("\nCPU Executing " + Runtime.toHex(n2) + ": " + this.this$0.sourceLine(n2) + "\n");
            }
        }
    }
}

