/*
 * Decompiled with CFR 0.152.
 */
package org.ibex.nestedvm;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.ibex.classgen.CGConst;
import org.ibex.classgen.ClassFile;
import org.ibex.classgen.MethodGen;
import org.ibex.classgen.Type;
import org.ibex.nestedvm.Compiler;
import org.ibex.nestedvm.util.ELF;
import org.ibex.nestedvm.util.Seekable;

public class ClassFileCompiler
extends Compiler
implements CGConst {
    private static final boolean OPTIMIZE_CP = true;
    private OutputStream os;
    private File outDir;
    private PrintStream warn = System.err;
    private final Type.Class me;
    private ClassFile cg;
    private MethodGen clinit;
    private MethodGen init;
    private static int initDataCount;
    private int startOfMethod = 0;
    private int endOfMethod = 0;
    private MethodGen.PhantomTarget returnTarget;
    private MethodGen.PhantomTarget defaultTarget;
    private MethodGen.PhantomTarget[] insnTargets;
    private MethodGen mg;
    private static final int UNREACHABLE = 1;
    private static final int SKIP_NEXT = 2;
    private boolean textDone;
    private static final Float POINT_5_F;
    private static final Double POINT_5_D;
    private static final Long FFFFFFFF;
    private static final int R = 0;
    private static final int F = 32;
    private static final int HI = 64;
    private static final int LO = 65;
    private static final int FCSR = 66;
    private static final int REG_COUNT = 67;
    private static final String[] regField;
    private static final int MAX_LOCALS = 4;
    private static final int LOAD_LENGTH = 3;
    private int[] regLocalMapping = new int[67];
    private boolean[] regLocalWritten = new boolean[67];
    private int nextAvailLocal;
    private int loadsStart;
    private int preSetRegStackPos;
    private int[] preSetRegStack = new int[8];
    private int memWriteStage;
    private boolean didPreMemRead;
    private boolean preMemReadDoPreWrite;

    public ClassFileCompiler(String string, String string2, OutputStream outputStream) {
        this((Seekable)new Seekable.File(string), string2, outputStream);
    }

    public ClassFileCompiler(Seekable seekable, String string, OutputStream outputStream) {
        this(seekable, string);
        if (outputStream == null) {
            throw new NullPointerException();
        }
        this.os = outputStream;
    }

    public ClassFileCompiler(Seekable seekable, String string, File file) {
        this(seekable, string);
        if (file == null) {
            throw new NullPointerException();
        }
        this.outDir = file;
    }

    private ClassFileCompiler(Seekable seekable, String string) {
        super(seekable, string);
        this.me = Type.Class.instance((String)this.fullClassName);
    }

    public void setWarnWriter(PrintStream printStream) {
        this.warn = printStream;
    }

    protected void _go() {
        try {
            this.__go();
        }
        catch (ClassFile.Exn exn) {
            exn.printStackTrace(this.warn);
            throw new Compiler.Exn("Class generation exception: " + exn.toString());
        }
    }

    private void __go() {
        int n2;
        MethodGen methodGen;
        ELF.Symbol[] symbolArray;
        int n3;
        if (!this.pruneCases) {
            throw new Compiler.Exn("-o prunecases MUST be enabled for ClassFileCompiler");
        }
        Type.Class clazz = Type.Class.instance((String)this.runtimeClass);
        this.cg = new ClassFile(this.me, clazz, 49);
        if (this.source != null) {
            this.cg.setSourceFile(this.source);
        }
        this.cg.addField("pc", Type.INT, 2);
        this.cg.addField("hi", Type.INT, 2);
        this.cg.addField("lo", Type.INT, 2);
        this.cg.addField("fcsr", Type.INT, 2);
        for (n3 = 1; n3 < 32; ++n3) {
            this.cg.addField("r" + n3, Type.INT, 2);
        }
        for (n3 = 0; n3 < 32; ++n3) {
            this.cg.addField("f" + n3, this.singleFloat ? Type.FLOAT : Type.INT, 2);
        }
        this.clinit = this.cg.addMethod("<clinit>", Type.VOID, Type.NO_ARGS, 10);
        this.init = this.cg.addMethod("<init>", Type.VOID, Type.NO_ARGS, 1);
        this.init.add((byte)42);
        this.init.add((byte)18, this.pageSize);
        this.init.add((byte)18, this.totalPages);
        this.init.add((byte)-73, (Object)this.me.method("<init>", Type.VOID, new Type[]{Type.INT, Type.INT}));
        this.init.add((byte)-79);
        this.init = this.cg.addMethod("<init>", Type.VOID, new Type[]{Type.BOOLEAN}, 1);
        this.init.add((byte)42);
        this.init.add((byte)18, this.pageSize);
        this.init.add((byte)18, this.totalPages);
        this.init.add((byte)27);
        this.init.add((byte)-73, (Object)this.me.method("<init>", Type.VOID, new Type[]{Type.INT, Type.INT, Type.BOOLEAN}));
        this.init.add((byte)-79);
        this.init = this.cg.addMethod("<init>", Type.VOID, new Type[]{Type.INT, Type.INT}, 1);
        this.init.add((byte)42);
        this.init.add((byte)27);
        this.init.add((byte)28);
        this.init.add((byte)3);
        this.init.add((byte)-73, (Object)this.me.method("<init>", Type.VOID, new Type[]{Type.INT, Type.INT, Type.BOOLEAN}));
        this.init.add((byte)-79);
        this.init = this.cg.addMethod("<init>", Type.VOID, new Type[]{Type.INT, Type.INT, Type.BOOLEAN}, 1);
        this.init.add((byte)42);
        this.init.add((byte)27);
        this.init.add((byte)28);
        this.init.add((byte)29);
        this.init.add((byte)-73, (Object)clazz.method("<init>", Type.VOID, new Type[]{Type.INT, Type.INT, Type.BOOLEAN}));
        if (this.onePage) {
            this.cg.addField("page", (Type)Type.INT.makeArray(), 18);
            this.init.add((byte)42);
            this.init.add((byte)89);
            this.init.add((byte)-76, (Object)this.me.field("readPages", (Type)Type.INT.makeArray(2)));
            this.init.add((byte)18, 0);
            this.init.add((byte)50);
            this.init.add((byte)-75, (Object)this.me.field("page", (Type)Type.INT.makeArray()));
        }
        if (this.supportCall) {
            this.cg.addField("symbols", (Type)Type.Class.instance((String)this.hashClass), 26);
        }
        n3 = 0;
        for (int i2 = 0; i2 < this.elf.sheaders.length; ++i2) {
            symbolArray = this.elf.sheaders[i2];
            String string = symbolArray.name;
            if (symbolArray.addr == 0) continue;
            n3 = Math.max(n3, symbolArray.addr + symbolArray.size);
            if (string.equals(".text")) {
                this.emitText(symbolArray.addr, new DataInputStream(symbolArray.getInputStream()), symbolArray.size);
                continue;
            }
            if (string.equals(".data") || string.equals(".sdata") || string.equals(".rodata") || string.equals(".ctors") || string.equals(".dtors")) {
                this.emitData(symbolArray.addr, new DataInputStream(symbolArray.getInputStream()), symbolArray.size, string.equals(".rodata"));
                continue;
            }
            if (string.equals(".bss") || string.equals(".sbss")) {
                this.emitBSS(symbolArray.addr, symbolArray.size);
                continue;
            }
            throw new Compiler.Exn("Unknown segment: " + string);
        }
        this.init.add((byte)-79);
        if (this.supportCall) {
            Type.Class clazz2 = Type.Class.instance((String)this.hashClass);
            this.clinit.add((byte)-69, (Object)clazz2);
            this.clinit.add((byte)89);
            this.clinit.add((byte)89);
            this.clinit.add((byte)-73, (Object)clazz2.method("<init>", Type.VOID, Type.NO_ARGS));
            this.clinit.add((byte)-77, (Object)this.me.field("symbols", (Type)clazz2));
            symbolArray = this.elf.getSymtab().symbols;
            for (int i3 = 0; i3 < symbolArray.length; ++i3) {
                ELF.Symbol symbol = symbolArray[i3];
                if (symbol.type != 2 || symbol.binding != 1 || !symbol.name.equals("_call_helper") && symbol.name.startsWith("_")) continue;
                this.clinit.add((byte)89);
                this.clinit.add((byte)18, (Object)symbol.name);
                this.clinit.add((byte)-69, (Object)Type.INTEGER_OBJECT);
                this.clinit.add((byte)89);
                this.clinit.add((byte)18, symbol.addr);
                this.clinit.add((byte)-73, (Object)Type.INTEGER_OBJECT.method("<init>", Type.VOID, new Type[]{Type.INT}));
                this.clinit.add((byte)-74, (Object)clazz2.method("put", (Type)Type.OBJECT, new Type[]{Type.OBJECT, Type.OBJECT}));
                this.clinit.add((byte)87);
            }
            this.clinit.add((byte)87);
        }
        this.clinit.add((byte)-79);
        ELF.SHeader sHeader = this.elf.sectionWithName(".text");
        symbolArray = this.cg.addMethod("trampoline", Type.VOID, Type.NO_ARGS, 2);
        int n4 = symbolArray.size();
        symbolArray.add((byte)42);
        symbolArray.add((byte)-76, (Object)this.me.field("state", Type.INT));
        symbolArray.add((byte)-103, symbolArray.size() + 2);
        symbolArray.add((byte)-79);
        symbolArray.add((byte)42);
        symbolArray.add((byte)42);
        symbolArray.add((byte)-76, (Object)this.me.field("pc", Type.INT));
        symbolArray.add((byte)18, this.methodShift);
        symbolArray.add((byte)124);
        int n5 = sHeader.addr >>> this.methodShift;
        int n6 = sHeader.addr + sHeader.size + this.maxBytesPerMethod - 1 >>> this.methodShift;
        MethodGen.Switch.Table table = new MethodGen.Switch.Table(n5, n6 - 1);
        symbolArray.add((byte)-86, (Object)table);
        for (int i4 = n5; i4 < n6; ++i4) {
            table.setTargetForVal(i4, symbolArray.size());
            symbolArray.add((byte)-73, (Object)this.me.method("run_" + ClassFileCompiler.toHex(i4 << this.methodShift), Type.VOID, Type.NO_ARGS));
            symbolArray.add((byte)-89, n4);
        }
        table.setDefaultTarget(symbolArray.size());
        symbolArray.add((byte)87);
        symbolArray.add((byte)-69, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException"));
        symbolArray.add((byte)89);
        symbolArray.add((byte)-69, (Object)Type.STRINGBUFFER);
        symbolArray.add((byte)89);
        symbolArray.add((byte)18, (Object)"Jumped to invalid address in trampoline (r2: ");
        symbolArray.add((byte)-73, (Object)Type.STRINGBUFFER.method("<init>", Type.VOID, new Type[]{Type.STRING}));
        symbolArray.add((byte)42);
        symbolArray.add((byte)-76, (Object)this.me.field("r2", Type.INT));
        symbolArray.add((byte)-74, (Object)Type.STRINGBUFFER.method("append", (Type)Type.STRINGBUFFER, new Type[]{Type.INT}));
        symbolArray.add((byte)18, (Object)" pc: ");
        symbolArray.add((byte)-74, (Object)Type.STRINGBUFFER.method("append", (Type)Type.STRINGBUFFER, new Type[]{Type.STRING}));
        symbolArray.add((byte)42);
        symbolArray.add((byte)-76, (Object)this.me.field("pc", Type.INT));
        symbolArray.add((byte)-74, (Object)Type.STRINGBUFFER.method("append", (Type)Type.STRINGBUFFER, new Type[]{Type.INT}));
        symbolArray.add((byte)18, (Object)")");
        symbolArray.add((byte)-74, (Object)Type.STRINGBUFFER.method("append", (Type)Type.STRINGBUFFER, new Type[]{Type.STRING}));
        symbolArray.add((byte)-74, (Object)Type.STRINGBUFFER.method("toString", (Type)Type.STRING, Type.NO_ARGS));
        symbolArray.add((byte)-73, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException").method("<init>", Type.VOID, new Type[]{Type.STRING}));
        symbolArray.add((byte)-65);
        this.addConstReturnMethod("gp", this.gp.addr);
        this.addConstReturnMethod("entryPoint", this.elf.header.entry);
        this.addConstReturnMethod("heapStart", n3);
        if (this.userInfo != null) {
            this.addConstReturnMethod("userInfoBase", this.userInfo.addr);
            this.addConstReturnMethod("userInfoSize", this.userInfo.size);
        }
        if (this.supportCall) {
            Type.Class clazz3 = Type.Class.instance((String)this.hashClass);
            methodGen = this.cg.addMethod("lookupSymbol", Type.INT, new Type[]{Type.STRING}, 4);
            methodGen.add((byte)-78, (Object)this.me.field("symbols", (Type)clazz3));
            methodGen.add((byte)43);
            methodGen.add((byte)-74, (Object)clazz3.method("get", (Type)Type.OBJECT, new Type[]{Type.OBJECT}));
            methodGen.add((byte)89);
            int n7 = methodGen.add((byte)-58);
            methodGen.add((byte)-64, (Object)Type.INTEGER_OBJECT);
            methodGen.add((byte)-74, (Object)Type.INTEGER_OBJECT.method("intValue", Type.INT, Type.NO_ARGS));
            methodGen.add((byte)-84);
            methodGen.setArg(n7, methodGen.size());
            methodGen.add((byte)87);
            methodGen.add((byte)2);
            methodGen.add((byte)-84);
        }
        Type.Class clazz4 = Type.Class.instance((String)"org.ibex.nestedvm.Runtime$CPUState");
        methodGen = this.cg.addMethod("setCPUState", Type.VOID, new Type[]{clazz4}, 4);
        MethodGen methodGen2 = this.cg.addMethod("getCPUState", Type.VOID, new Type[]{clazz4}, 4);
        methodGen.add((byte)43);
        methodGen2.add((byte)43);
        methodGen.add((byte)-76, (Object)clazz4.field("r", (Type)Type.INT.makeArray()));
        methodGen2.add((byte)-76, (Object)clazz4.field("r", (Type)Type.INT.makeArray()));
        methodGen.add((byte)77);
        methodGen2.add((byte)77);
        for (n2 = 1; n2 < 32; ++n2) {
            methodGen.add((byte)42);
            methodGen.add((byte)44);
            methodGen.add((byte)18, n2);
            methodGen.add((byte)46);
            methodGen.add((byte)-75, (Object)this.me.field("r" + n2, Type.INT));
            methodGen2.add((byte)44);
            methodGen2.add((byte)18, n2);
            methodGen2.add((byte)42);
            methodGen2.add((byte)-76, (Object)this.me.field("r" + n2, Type.INT));
            methodGen2.add((byte)79);
        }
        methodGen.add((byte)43);
        methodGen2.add((byte)43);
        methodGen.add((byte)-76, (Object)clazz4.field("f", (Type)Type.INT.makeArray()));
        methodGen2.add((byte)-76, (Object)clazz4.field("f", (Type)Type.INT.makeArray()));
        methodGen.add((byte)77);
        methodGen2.add((byte)77);
        for (n2 = 0; n2 < 32; ++n2) {
            methodGen.add((byte)42);
            methodGen.add((byte)44);
            methodGen.add((byte)18, n2);
            methodGen.add((byte)46);
            if (this.singleFloat) {
                methodGen.add((byte)-72, (Object)Type.FLOAT_OBJECT.method("intBitsToFloat", Type.FLOAT, new Type[]{Type.INT}));
            }
            methodGen.add((byte)-75, (Object)this.me.field("f" + n2, this.singleFloat ? Type.FLOAT : Type.INT));
            methodGen2.add((byte)44);
            methodGen2.add((byte)18, n2);
            methodGen2.add((byte)42);
            methodGen2.add((byte)-76, (Object)this.me.field("f" + n2, this.singleFloat ? Type.FLOAT : Type.INT));
            if (this.singleFloat) {
                methodGen2.add((byte)-72, (Object)Type.FLOAT_OBJECT.method("floatToIntBits", Type.INT, new Type[]{Type.FLOAT}));
            }
            methodGen2.add((byte)79);
        }
        String[] stringArray = new String[]{"hi", "lo", "fcsr", "pc"};
        for (int i5 = 0; i5 < stringArray.length; ++i5) {
            methodGen.add((byte)42);
            methodGen.add((byte)43);
            methodGen.add((byte)-76, (Object)clazz4.field(stringArray[i5], Type.INT));
            methodGen.add((byte)-75, (Object)this.me.field(stringArray[i5], Type.INT));
            methodGen2.add((byte)43);
            methodGen2.add((byte)42);
            methodGen2.add((byte)-76, (Object)this.me.field(stringArray[i5], Type.INT));
            methodGen2.add((byte)-75, (Object)clazz4.field(stringArray[i5], Type.INT));
        }
        methodGen.add((byte)-79);
        methodGen2.add((byte)-79);
        MethodGen methodGen3 = this.cg.addMethod("_execute", Type.VOID, Type.NO_ARGS, 4);
        int n8 = methodGen3.size();
        methodGen3.add((byte)42);
        methodGen3.add((byte)-73, (Object)this.me.method("trampoline", Type.VOID, Type.NO_ARGS));
        int n9 = methodGen3.size();
        methodGen3.add((byte)-79);
        int n10 = methodGen3.size();
        methodGen3.add((byte)76);
        methodGen3.add((byte)-69, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$FaultException"));
        methodGen3.add((byte)89);
        methodGen3.add((byte)43);
        methodGen3.add((byte)-73, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$FaultException").method("<init>", Type.VOID, new Type[]{Type.Class.instance((String)"java.lang.RuntimeException")}));
        methodGen3.add((byte)-65);
        methodGen3.addExceptionHandler(n8, n9, n10, Type.Class.instance((String)"java.lang.RuntimeException"));
        methodGen3.addThrow(Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException"));
        MethodGen methodGen4 = this.cg.addMethod("main", Type.VOID, new Type[]{Type.STRING.makeArray()}, 9);
        methodGen4.add((byte)-69, (Object)this.me);
        methodGen4.add((byte)89);
        methodGen4.add((byte)-73, (Object)this.me.method("<init>", Type.VOID, Type.NO_ARGS));
        methodGen4.add((byte)18, (Object)this.fullClassName);
        methodGen4.add((byte)42);
        if (this.unixRuntime) {
            Type.Class clazz5 = Type.Class.instance((String)"org.ibex.nestedvm.UnixRuntime");
            methodGen4.add((byte)-72, (Object)clazz5.method("runAndExec", Type.INT, new Type[]{clazz5, Type.STRING, Type.STRING.makeArray()}));
        } else {
            methodGen4.add((byte)-74, (Object)this.me.method("run", Type.INT, new Type[]{Type.STRING, Type.STRING.makeArray()}));
        }
        methodGen4.add((byte)-72, (Object)Type.Class.instance((String)"java.lang.System").method("exit", Type.VOID, new Type[]{Type.INT}));
        methodGen4.add((byte)-79);
        if (this.outDir != null) {
            if (!this.outDir.isDirectory()) {
                throw new IOException("" + this.outDir + " isn't a directory");
            }
            this.cg.dump(this.outDir);
        } else {
            this.cg.dump(this.os);
        }
    }

    private void addConstReturnMethod(String string, int n2) {
        MethodGen methodGen = this.cg.addMethod(string, Type.INT, Type.NO_ARGS, 4);
        methodGen.add((byte)18, n2);
        methodGen.add((byte)-84);
    }

    private void emitData(int n2, DataInputStream dataInputStream, int n3, boolean bl2) {
        if ((n2 & 3) != 0 || (n3 & 3) != 0) {
            throw new Compiler.Exn("Data section on weird boundaries");
        }
        int n4 = n2 + n3;
        while (n2 < n4) {
            int n5 = Math.min(n3, 28000);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < n5; i2 += 7) {
                int n6;
                long l2 = 0L;
                for (n6 = 0; n6 < 7; ++n6) {
                    l2 <<= 8;
                    byte by2 = i2 + n6 < n3 ? dataInputStream.readByte() : (byte)1;
                    l2 |= (long)by2 & 0xFFL;
                }
                for (n6 = 0; n6 < 8; ++n6) {
                    stringBuffer.append((char)(l2 >>> 7 * (7 - n6) & 0x7FL));
                }
            }
            String string = "_data" + ++initDataCount;
            this.cg.addField(string, (Type)Type.INT.makeArray(), 26);
            this.clinit.add((byte)18, (Object)stringBuffer.toString());
            this.clinit.add((byte)18, n5 / 4);
            this.clinit.add((byte)-72, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime").method("decodeData", (Type)Type.INT.makeArray(), new Type[]{Type.STRING, Type.INT}));
            this.clinit.add((byte)-77, (Object)this.me.field(string, (Type)Type.INT.makeArray()));
            this.init.add((byte)42);
            this.init.add((byte)-78, (Object)this.me.field(string, (Type)Type.INT.makeArray()));
            this.init.add((byte)18, n2);
            this.init.add((byte)18, bl2 ? 1 : 0);
            this.init.add((byte)-74, (Object)this.me.method("initPages", Type.VOID, new Type[]{Type.INT.makeArray(), Type.INT, Type.BOOLEAN}));
            n2 += n5;
            n3 -= n5;
        }
        dataInputStream.close();
    }

    private void emitBSS(int n2, int n3) {
        if ((n2 & 3) != 0) {
            throw new Compiler.Exn("BSS section on weird boundaries");
        }
        n3 = n3 + 3 & 0xFFFFFFFC;
        int n4 = n3 / 4;
        this.init.add((byte)42);
        this.init.add((byte)18, n2);
        this.init.add((byte)18, n4);
        this.init.add((byte)-74, (Object)this.me.method("clearPages", Type.VOID, new Type[]{Type.INT, Type.INT}));
    }

    private boolean jumpable(int n2) {
        return this.jumpableAddresses.get(new Integer(n2)) != null;
    }

    private void emitText(int n2, DataInputStream dataInputStream, int n3) {
        if (this.textDone) {
            throw new Compiler.Exn("Multiple text segments");
        }
        this.textDone = true;
        if ((n2 & 3) != 0 || (n3 & 3) != 0) {
            throw new Compiler.Exn("Section on weird boundaries");
        }
        int n4 = n3 / 4;
        int n5 = -1;
        boolean bl2 = true;
        boolean bl3 = false;
        int n6 = 0;
        while (n6 < n4) {
            block11: {
                int n7;
                block10: {
                    block9: {
                        n7 = bl2 ? dataInputStream.readInt() : n5;
                        int n8 = n5 = n6 == n4 - 1 ? -1 : dataInputStream.readInt();
                        if (n2 >= this.endOfMethod) {
                            this.endMethod(n2, bl3);
                            this.startMethod(n2);
                        }
                        if (this.insnTargets[n6 % this.maxInsnPerMethod] == null) break block9;
                        this.insnTargets[n6 % this.maxInsnPerMethod].setTarget(this.mg.size());
                        bl3 = false;
                        break block10;
                    }
                    if (bl3) break block11;
                }
                try {
                    int n9 = this.emitInstruction(n2, n7, n5);
                    bl3 = (n9 & 1) != 0;
                    bl2 = (n9 & 2) != 0;
                }
                catch (Compiler.Exn exn) {
                    exn.printStackTrace(this.warn);
                    this.warn.println("Exception at " + ClassFileCompiler.toHex(n2));
                    throw exn;
                }
                catch (RuntimeException runtimeException) {
                    this.warn.println("Exception at " + ClassFileCompiler.toHex(n2));
                    throw runtimeException;
                }
                if (bl2) {
                    n2 += 4;
                    ++n6;
                }
            }
            ++n6;
            n2 += 4;
        }
        this.endMethod(0, bl3);
        dataInputStream.close();
    }

    private void startMethod(int n2) {
        this.startOfMethod = n2 & this.methodMask;
        this.endOfMethod = this.startOfMethod + this.maxBytesPerMethod;
        this.mg = this.cg.addMethod("run_" + ClassFileCompiler.toHex(this.startOfMethod), Type.VOID, Type.NO_ARGS, 18);
        if (this.onePage) {
            this.mg.add((byte)42);
            this.mg.add((byte)-76, (Object)this.me.field("page", (Type)Type.INT.makeArray()));
            this.mg.add((byte)77);
        } else {
            this.mg.add((byte)42);
            this.mg.add((byte)-76, (Object)this.me.field("readPages", (Type)Type.INT.makeArray(2)));
            this.mg.add((byte)77);
            this.mg.add((byte)42);
            this.mg.add((byte)-76, (Object)this.me.field("writePages", (Type)Type.INT.makeArray(2)));
            this.mg.add((byte)78);
        }
        this.returnTarget = new MethodGen.PhantomTarget();
        this.insnTargets = new MethodGen.PhantomTarget[this.maxBytesPerMethod / 4];
        int[] nArray = new int[this.maxBytesPerMethod / 4];
        Object[] objectArray = new Object[this.maxBytesPerMethod / 4];
        int n3 = 0;
        for (int i2 = n2; i2 < this.endOfMethod; i2 += 4) {
            if (!this.jumpable(i2)) continue;
            MethodGen.PhantomTarget phantomTarget = new MethodGen.PhantomTarget();
            this.insnTargets[(i2 - this.startOfMethod) / 4] = phantomTarget;
            objectArray[n3] = phantomTarget;
            nArray[n3] = i2;
            ++n3;
        }
        MethodGen.Switch.Lookup lookup = new MethodGen.Switch.Lookup(n3);
        System.arraycopy(nArray, 0, lookup.vals, 0, n3);
        System.arraycopy(objectArray, 0, lookup.targets, 0, n3);
        this.defaultTarget = new MethodGen.PhantomTarget();
        lookup.setDefaultTarget((Object)this.defaultTarget);
        this.fixupRegsStart();
        this.mg.add((byte)42);
        this.mg.add((byte)-76, (Object)this.me.field("pc", Type.INT));
        this.mg.add((byte)-85, (Object)lookup);
    }

    private void endMethod(int n2, boolean bl2) {
        if (this.startOfMethod == 0) {
            return;
        }
        if (!bl2) {
            this.preSetPC();
            this.mg.add((byte)18, n2);
            this.setPC();
            this.jumpableAddresses.put(new Integer(n2), Boolean.TRUE);
        }
        this.returnTarget.setTarget(this.mg.size());
        this.fixupRegsEnd();
        this.mg.add((byte)-79);
        this.defaultTarget.setTarget(this.mg.size());
        if (this.debugCompiler) {
            this.mg.add((byte)-69, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException"));
            this.mg.add((byte)89);
            this.mg.add((byte)-69, (Object)Type.STRINGBUFFER);
            this.mg.add((byte)89);
            this.mg.add((byte)18, (Object)"Jumped to invalid address: ");
            this.mg.add((byte)-73, (Object)Type.STRINGBUFFER.method("<init>", Type.VOID, new Type[]{Type.STRING}));
            this.mg.add((byte)42);
            this.mg.add((byte)-76, (Object)this.me.field("pc", Type.INT));
            this.mg.add((byte)-74, (Object)Type.STRINGBUFFER.method("append", (Type)Type.STRINGBUFFER, new Type[]{Type.INT}));
            this.mg.add((byte)-74, (Object)Type.STRINGBUFFER.method("toString", (Type)Type.STRING, Type.NO_ARGS));
            this.mg.add((byte)-73, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException").method("<init>", Type.VOID, new Type[]{Type.STRING}));
            this.mg.add((byte)-65);
        } else {
            this.mg.add((byte)-69, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException"));
            this.mg.add((byte)89);
            this.mg.add((byte)18, (Object)"Jumped to invalid address");
            this.mg.add((byte)-73, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException").method("<init>", Type.VOID, new Type[]{Type.STRING}));
            this.mg.add((byte)-65);
        }
        this.startOfMethod = 0;
        this.endOfMethod = 0;
    }

    private void leaveMethod() {
        this.mg.add((byte)-89, (Object)this.returnTarget);
    }

    private void link(int n2) {
        this.preSetReg(31);
        if (this.lessConstants) {
            int n3 = n2 + 8 + 32768 & 0xFFFF0000;
            int n4 = n2 + 8 - n3;
            if (n4 < Short.MIN_VALUE || n4 > Short.MAX_VALUE) {
                throw new Error("should never happen " + n4);
            }
            this.mg.add((byte)18, n3);
            this.mg.add((byte)18, n4);
            this.mg.add((byte)96);
        } else {
            this.mg.add((byte)18, n2 + 8);
        }
        this.setReg();
    }

    private void branch(int n2, int n3) {
        if ((n2 & this.methodMask) == (n3 & this.methodMask)) {
            this.mg.add((byte)-89, (Object)this.insnTargets[(n3 - this.startOfMethod) / 4]);
        } else {
            this.preSetPC();
            this.mg.add((byte)18, n3);
            this.setPC();
            this.leaveMethod();
        }
    }

    private int doIfInstruction(byte by2, int n2, int n3, int n4) {
        int n5;
        this.emitInstruction(-1, n4, -1);
        if ((n3 & this.methodMask) == (n2 & this.methodMask)) {
            this.mg.add(by2, (Object)this.insnTargets[(n3 - this.startOfMethod) / 4]);
        } else {
            n5 = this.mg.add(MethodGen.negate((byte)by2));
            this.branch(n2, n3);
            this.mg.setArg(n5, this.mg.size());
        }
        if (!this.jumpable(n2 + 4)) {
            return 2;
        }
        if (n2 + 4 == this.endOfMethod) {
            this.jumpableAddresses.put(new Integer(n2 + 8), Boolean.TRUE);
            this.branch(n2, n2 + 8);
            return 1;
        }
        n5 = this.mg.add((byte)-89);
        this.insnTargets[(n2 + 4 - this.startOfMethod) / 4].setTarget(this.mg.size());
        this.emitInstruction(-1, n4, 1);
        this.mg.setArg(n5, this.mg.size());
        return 2;
    }

    private int emitInstruction(int n2, int n3, int n4) {
        int n5;
        MethodGen methodGen = this.mg;
        if (n3 == -1) {
            throw new Compiler.Exn("insn is -1");
        }
        int n6 = 0;
        int n7 = n3 >>> 26 & 0xFF;
        int n8 = n3 >>> 21 & 0x1F;
        int n9 = n3 >>> 16 & 0x1F;
        int n10 = n3 >>> 16 & 0x1F;
        int n11 = n3 >>> 11 & 0x1F;
        int n12 = n3 >>> 11 & 0x1F;
        int n13 = n3 >>> 6 & 0x1F;
        int n14 = n3 >>> 6 & 0x1F;
        int n15 = n3 & 0x3F;
        int n16 = n3 >>> 6 & 0xFFFFF;
        int n17 = n3 & 0x3FFFFFF;
        int n18 = n3 & 0xFFFF;
        int n19 = n5 = n3 << 16 >> 16;
        block0 : switch (n7) {
            case 0: {
                switch (n15) {
                    case 0: {
                        if (n3 == 0) break block0;
                        this.preSetReg(0 + n11);
                        this.pushRegWZ(0 + n9);
                        methodGen.add((byte)18, n13);
                        methodGen.add((byte)120);
                        this.setReg();
                        break block0;
                    }
                    case 2: {
                        this.preSetReg(0 + n11);
                        this.pushRegWZ(0 + n9);
                        methodGen.add((byte)18, n13);
                        methodGen.add((byte)124);
                        this.setReg();
                        break block0;
                    }
                    case 3: {
                        this.preSetReg(0 + n11);
                        this.pushRegWZ(0 + n9);
                        methodGen.add((byte)18, n13);
                        methodGen.add((byte)122);
                        this.setReg();
                        break block0;
                    }
                    case 4: {
                        this.preSetReg(0 + n11);
                        this.pushRegWZ(0 + n9);
                        this.pushRegWZ(0 + n8);
                        methodGen.add((byte)120);
                        this.setReg();
                        break block0;
                    }
                    case 6: {
                        this.preSetReg(0 + n11);
                        this.pushRegWZ(0 + n9);
                        this.pushRegWZ(0 + n8);
                        methodGen.add((byte)124);
                        this.setReg();
                        break block0;
                    }
                    case 7: {
                        this.preSetReg(0 + n11);
                        this.pushRegWZ(0 + n9);
                        this.pushRegWZ(0 + n8);
                        methodGen.add((byte)122);
                        this.setReg();
                        break block0;
                    }
                    case 8: {
                        if (n2 == -1) {
                            throw new Compiler.Exn("pc modifying insn in delay slot");
                        }
                        this.emitInstruction(-1, n4, -1);
                        this.preSetPC();
                        this.pushRegWZ(0 + n8);
                        this.setPC();
                        this.leaveMethod();
                        n6 |= 1;
                        break block0;
                    }
                    case 9: {
                        if (n2 == -1) {
                            throw new Compiler.Exn("pc modifying insn in delay slot");
                        }
                        this.emitInstruction(-1, n4, -1);
                        this.link(n2);
                        this.preSetPC();
                        this.pushRegWZ(0 + n8);
                        this.setPC();
                        this.leaveMethod();
                        n6 |= 1;
                        break block0;
                    }
                    case 12: {
                        this.preSetPC();
                        methodGen.add((byte)18, n2);
                        this.setPC();
                        this.restoreChangedRegs();
                        this.preSetReg(2);
                        methodGen.add((byte)42);
                        this.pushRegZ(2);
                        this.pushRegZ(4);
                        this.pushRegZ(5);
                        this.pushRegZ(6);
                        this.pushRegZ(7);
                        this.pushRegZ(8);
                        this.pushRegZ(9);
                        methodGen.add((byte)-74, (Object)this.me.method("syscall", Type.INT, new Type[]{Type.INT, Type.INT, Type.INT, Type.INT, Type.INT, Type.INT, Type.INT}));
                        this.setReg();
                        methodGen.add((byte)42);
                        methodGen.add((byte)-76, (Object)this.me.field("state", Type.INT));
                        int n20 = methodGen.add((byte)-103);
                        this.preSetPC();
                        methodGen.add((byte)18, n2 + 4);
                        this.setPC();
                        this.leaveMethod();
                        methodGen.setArg(n20, methodGen.size());
                        break block0;
                    }
                    case 13: {
                        methodGen.add((byte)-69, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException"));
                        methodGen.add((byte)89);
                        methodGen.add((byte)18, (Object)("BREAK Code " + ClassFileCompiler.toHex(n16)));
                        methodGen.add((byte)-73, (Object)Type.Class.instance((String)"org.ibex.nestedvm.Runtime$ExecutionException").method("<init>", Type.VOID, new Type[]{Type.STRING}));
                        methodGen.add((byte)-65);
                        n6 |= 1;
                        break block0;
                    }
                    case 16: {
                        this.preSetReg(0 + n11);
                        this.pushReg(64);
                        this.setReg();
                        break block0;
                    }
                    case 17: {
                        this.preSetReg(64);
                        this.pushRegZ(0 + n8);
                        this.setReg();
                        break block0;
                    }
                    case 18: {
                        this.preSetReg(0 + n11);
                        this.pushReg(65);
                        this.setReg();
                        break block0;
                    }
                    case 19: {
                        this.preSetReg(65);
                        this.pushRegZ(0 + n8);
                        this.setReg();
                        break block0;
                    }
                    case 24: {
                        this.pushRegWZ(0 + n8);
                        methodGen.add((byte)-123);
                        this.pushRegWZ(0 + n9);
                        methodGen.add((byte)-123);
                        methodGen.add((byte)105);
                        methodGen.add((byte)92);
                        methodGen.add((byte)-120);
                        if (this.preSetReg(65)) {
                            methodGen.add((byte)95);
                        }
                        this.setReg();
                        methodGen.add((byte)18, 32);
                        methodGen.add((byte)125);
                        methodGen.add((byte)-120);
                        if (this.preSetReg(64)) {
                            methodGen.add((byte)95);
                        }
                        this.setReg();
                        break block0;
                    }
                    case 25: {
                        this.pushRegWZ(0 + n8);
                        methodGen.add((byte)-123);
                        methodGen.add((byte)18, (Object)FFFFFFFF);
                        methodGen.add((byte)127);
                        this.pushRegWZ(0 + n9);
                        methodGen.add((byte)-123);
                        methodGen.add((byte)18, (Object)FFFFFFFF);
                        methodGen.add((byte)127);
                        methodGen.add((byte)105);
                        methodGen.add((byte)92);
                        methodGen.add((byte)-120);
                        if (this.preSetReg(65)) {
                            methodGen.add((byte)95);
                        }
                        this.setReg();
                        methodGen.add((byte)18, 32);
                        methodGen.add((byte)125);
                        methodGen.add((byte)-120);
                        if (this.preSetReg(64)) {
                            methodGen.add((byte)95);
                        }
                        this.setReg();
                        break block0;
                    }
                    case 26: {
                        this.pushRegWZ(0 + n8);
                        this.pushRegWZ(0 + n9);
                        methodGen.add((byte)92);
                        methodGen.add((byte)108);
                        if (this.preSetReg(65)) {
                            methodGen.add((byte)95);
                        }
                        this.setReg();
                        methodGen.add((byte)112);
                        if (this.preSetReg(64)) {
                            methodGen.add((byte)95);
                        }
                        this.setReg();
                        break block0;
                    }
                    case 27: {
                        this.pushRegWZ(0 + n9);
                        methodGen.add((byte)89);
                        this.setTmp();
                        int n21 = methodGen.add((byte)-103);
                        this.pushRegWZ(0 + n8);
                        methodGen.add((byte)-123);
                        methodGen.add((byte)18, (Object)FFFFFFFF);
                        methodGen.add((byte)127);
                        methodGen.add((byte)92);
                        this.pushTmp();
                        methodGen.add((byte)-123);
                        methodGen.add((byte)18, (Object)FFFFFFFF);
                        methodGen.add((byte)127);
                        methodGen.add((byte)94);
                        methodGen.add((byte)109);
                        methodGen.add((byte)-120);
                        if (this.preSetReg(65)) {
                            methodGen.add((byte)95);
                        }
                        this.setReg();
                        methodGen.add((byte)113);
                        methodGen.add((byte)-120);
                        if (this.preSetReg(64)) {
                            methodGen.add((byte)95);
                        }
                        this.setReg();
                        methodGen.setArg(n21, methodGen.size());
                        break block0;
                    }
                    case 32: {
                        throw new Compiler.Exn("ADD (add with oveflow trap) not suported");
                    }
                    case 33: {
                        this.preSetReg(0 + n11);
                        if (n9 != 0 && n8 != 0) {
                            this.pushReg(0 + n8);
                            this.pushReg(0 + n9);
                            methodGen.add((byte)96);
                        } else if (n8 != 0) {
                            this.pushReg(0 + n8);
                        } else {
                            this.pushRegZ(0 + n9);
                        }
                        this.setReg();
                        break block0;
                    }
                    case 34: {
                        throw new Compiler.Exn("SUB (add with oveflow trap) not suported");
                    }
                    case 35: {
                        this.preSetReg(0 + n11);
                        if (n9 != 0 && n8 != 0) {
                            this.pushReg(0 + n8);
                            this.pushReg(0 + n9);
                            methodGen.add((byte)100);
                        } else if (n9 != 0) {
                            this.pushReg(0 + n9);
                            methodGen.add((byte)116);
                        } else {
                            this.pushRegZ(0 + n8);
                        }
                        this.setReg();
                        break block0;
                    }
                    case 36: {
                        this.preSetReg(0 + n11);
                        this.pushRegWZ(0 + n8);
                        this.pushRegWZ(0 + n9);
                        methodGen.add((byte)126);
                        this.setReg();
                        break block0;
                    }
                    case 37: {
                        this.preSetReg(0 + n11);
                        this.pushRegWZ(0 + n8);
                        this.pushRegWZ(0 + n9);
                        methodGen.add((byte)-128);
                        this.setReg();
                        break block0;
                    }
                    case 38: {
                        this.preSetReg(0 + n11);
                        this.pushRegWZ(0 + n8);
                        this.pushRegWZ(0 + n9);
                        methodGen.add((byte)-126);
                        this.setReg();
                        break block0;
                    }
                    case 39: {
                        this.preSetReg(0 + n11);
                        if (n8 != 0 || n9 != 0) {
                            if (n8 != 0 && n9 != 0) {
                                this.pushReg(0 + n8);
                                this.pushReg(0 + n9);
                                methodGen.add((byte)-128);
                            } else if (n8 != 0) {
                                this.pushReg(0 + n8);
                            } else {
                                this.pushReg(0 + n9);
                            }
                            methodGen.add((byte)2);
                            methodGen.add((byte)-126);
                        } else {
                            methodGen.add((byte)18, -1);
                        }
                        this.setReg();
                        break block0;
                    }
                    case 42: {
                        this.preSetReg(0 + n11);
                        if (n8 != n9) {
                            this.pushRegZ(0 + n8);
                            this.pushRegZ(0 + n9);
                            int n22 = methodGen.add((byte)-95);
                            methodGen.add((byte)3);
                            int n23 = methodGen.add((byte)-89);
                            methodGen.setArg(n22, methodGen.add((byte)4));
                            methodGen.setArg(n23, methodGen.size());
                        } else {
                            methodGen.add((byte)18, 0);
                        }
                        this.setReg();
                        break block0;
                    }
                    case 43: {
                        this.preSetReg(0 + n11);
                        if (n8 != n9) {
                            int n24;
                            if (n8 != 0) {
                                this.pushReg(0 + n8);
                                methodGen.add((byte)-123);
                                methodGen.add((byte)18, (Object)FFFFFFFF);
                                methodGen.add((byte)127);
                                this.pushReg(0 + n9);
                                methodGen.add((byte)-123);
                                methodGen.add((byte)18, (Object)FFFFFFFF);
                                methodGen.add((byte)127);
                                methodGen.add((byte)-108);
                                n24 = methodGen.add((byte)-101);
                            } else {
                                this.pushReg(0 + n9);
                                n24 = methodGen.add((byte)-102);
                            }
                            methodGen.add((byte)3);
                            int n25 = methodGen.add((byte)-89);
                            methodGen.setArg(n24, methodGen.add((byte)4));
                            methodGen.setArg(n25, methodGen.size());
                        } else {
                            methodGen.add((byte)18, 0);
                        }
                        this.setReg();
                        break block0;
                    }
                    default: {
                        throw new Compiler.Exn("Illegal instruction 0/" + n15);
                    }
                }
            }
            case 1: {
                switch (n9) {
                    case 0: {
                        if (n2 == -1) {
                            throw new Compiler.Exn("pc modifying insn in delay slot");
                        }
                        this.pushRegWZ(0 + n8);
                        return this.doIfInstruction((byte)-101, n2, n2 + n19 * 4 + 4, n4);
                    }
                    case 1: {
                        if (n2 == -1) {
                            throw new Compiler.Exn("pc modifying insn in delay slot");
                        }
                        this.pushRegWZ(0 + n8);
                        return this.doIfInstruction((byte)-100, n2, n2 + n19 * 4 + 4, n4);
                    }
                    case 16: {
                        if (n2 == -1) {
                            throw new Compiler.Exn("pc modifying insn in delay slot");
                        }
                        this.pushRegWZ(0 + n8);
                        int n26 = methodGen.add((byte)-100);
                        this.emitInstruction(-1, n4, -1);
                        this.link(n2);
                        this.branch(n2, n2 + n19 * 4 + 4);
                        methodGen.setArg(n26, methodGen.size());
                        break block0;
                    }
                    case 17: {
                        if (n2 == -1) {
                            throw new Compiler.Exn("pc modifying insn in delay slot");
                        }
                        int n27 = -1;
                        if (n8 != 0) {
                            this.pushRegWZ(0 + n8);
                            n27 = methodGen.add((byte)-101);
                        }
                        this.emitInstruction(-1, n4, -1);
                        this.link(n2);
                        this.branch(n2, n2 + n19 * 4 + 4);
                        if (n27 != -1) {
                            methodGen.setArg(n27, methodGen.size());
                        }
                        if (n27 != -1) break block0;
                        n6 |= 1;
                        break block0;
                    }
                    default: {
                        throw new Compiler.Exn("Illegal Instruction 1/" + n9);
                    }
                }
            }
            case 2: {
                if (n2 == -1) {
                    throw new Compiler.Exn("pc modifying insn in delay slot");
                }
                this.emitInstruction(-1, n4, -1);
                this.branch(n2, n2 & 0xF0000000 | n17 << 2);
                n6 |= 1;
                break;
            }
            case 3: {
                if (n2 == -1) {
                    throw new Compiler.Exn("pc modifying insn in delay slot");
                }
                int n28 = n2 & 0xF0000000 | n17 << 2;
                this.emitInstruction(-1, n4, -1);
                this.link(n2);
                this.branch(n2, n28);
                n6 |= 1;
                break;
            }
            case 4: {
                if (n2 == -1) {
                    throw new Compiler.Exn("pc modifying insn in delay slot");
                }
                if (n8 == n9) {
                    this.emitInstruction(-1, n4, -1);
                    this.branch(n2, n2 + n19 * 4 + 4);
                    n6 |= 1;
                    break;
                }
                if (n8 == 0 || n9 == 0) {
                    this.pushReg(n9 == 0 ? 0 + n8 : 0 + n9);
                    return this.doIfInstruction((byte)-103, n2, n2 + n19 * 4 + 4, n4);
                }
                this.pushReg(0 + n8);
                this.pushReg(0 + n9);
                return this.doIfInstruction((byte)-97, n2, n2 + n19 * 4 + 4, n4);
            }
            case 5: {
                if (n2 == -1) {
                    throw new Compiler.Exn("pc modifying insn in delay slot");
                }
                this.pushRegWZ(0 + n8);
                if (n9 == 0) {
                    return this.doIfInstruction((byte)-102, n2, n2 + n19 * 4 + 4, n4);
                }
                this.pushReg(0 + n9);
                return this.doIfInstruction((byte)-96, n2, n2 + n19 * 4 + 4, n4);
            }
            case 6: {
                if (n2 == -1) {
                    throw new Compiler.Exn("pc modifying insn in delay slot");
                }
                this.pushRegWZ(0 + n8);
                return this.doIfInstruction((byte)-98, n2, n2 + n19 * 4 + 4, n4);
            }
            case 7: {
                if (n2 == -1) {
                    throw new Compiler.Exn("pc modifying insn in delay slot");
                }
                this.pushRegWZ(0 + n8);
                return this.doIfInstruction((byte)-99, n2, n2 + n19 * 4 + 4, n4);
            }
            case 8: {
                throw new Compiler.Exn("ADDI (add immediate with oveflow trap) not suported");
            }
            case 9: {
                if (n8 != 0 && n5 != 0 && n8 == n9 && this.doLocal(n9) && n5 >= Short.MIN_VALUE && n5 <= Short.MAX_VALUE) {
                    this.regLocalWritten[n9] = true;
                    methodGen.add((byte)-124, (Object)new MethodGen.Pair(this.getLocalForReg(n9), n5));
                    break;
                }
                this.preSetReg(0 + n9);
                this.addiu(n8, n5);
                this.setReg();
                break;
            }
            case 10: {
                this.preSetReg(0 + n9);
                this.pushRegWZ(0 + n8);
                methodGen.add((byte)18, n5);
                int n29 = methodGen.add((byte)-95);
                methodGen.add((byte)3);
                int n30 = methodGen.add((byte)-89);
                methodGen.setArg(n29, methodGen.add((byte)4));
                methodGen.setArg(n30, methodGen.size());
                this.setReg();
                break;
            }
            case 11: {
                this.preSetReg(0 + n9);
                this.pushRegWZ(0 + n8);
                methodGen.add((byte)-123);
                methodGen.add((byte)18, (Object)FFFFFFFF);
                methodGen.add((byte)127);
                methodGen.add((byte)18, (Object)new Long((long)n5 & 0xFFFFFFFFL));
                methodGen.add((byte)-108);
                int n31 = methodGen.add((byte)-101);
                methodGen.add((byte)3);
                int n32 = methodGen.add((byte)-89);
                methodGen.setArg(n31, methodGen.add((byte)4));
                methodGen.setArg(n32, methodGen.size());
                this.setReg();
                break;
            }
            case 12: {
                this.preSetReg(0 + n9);
                this.pushRegWZ(0 + n8);
                methodGen.add((byte)18, n18);
                methodGen.add((byte)126);
                this.setReg();
                break;
            }
            case 13: {
                this.preSetReg(0 + n9);
                if (n8 != 0 && n18 != 0) {
                    this.pushReg(0 + n8);
                    methodGen.add((byte)18, n18);
                    methodGen.add((byte)-128);
                } else if (n8 != 0) {
                    this.pushReg(0 + n8);
                } else {
                    methodGen.add((byte)18, n18);
                }
                this.setReg();
                break;
            }
            case 14: {
                this.preSetReg(0 + n9);
                this.pushRegWZ(0 + n8);
                methodGen.add((byte)18, n18);
                methodGen.add((byte)-126);
                this.setReg();
                break;
            }
            case 15: {
                this.preSetReg(0 + n9);
                methodGen.add((byte)18, n18 << 16);
                this.setReg();
                break;
            }
            case 16: {
                throw new Compiler.Exn("TLB/Exception support not implemented");
            }
            case 17: {
                switch (n8) {
                    case 0: {
                        this.preSetReg(0 + n9);
                        this.pushReg(32 + n11);
                        this.setReg();
                        break block0;
                    }
                    case 2: {
                        if (n12 != 31) {
                            throw new Compiler.Exn("FCR " + n12 + " unavailable");
                        }
                        this.preSetReg(0 + n9);
                        this.pushReg(66);
                        this.setReg();
                        break block0;
                    }
                    case 4: {
                        this.preSetReg(32 + n11);
                        if (n9 != 0) {
                            this.pushReg(0 + n9);
                        } else {
                            methodGen.add((byte)3);
                        }
                        this.setReg();
                        break block0;
                    }
                    case 6: {
                        if (n12 != 31) {
                            throw new Compiler.Exn("FCR " + n12 + " unavailable");
                        }
                        this.preSetReg(66);
                        this.pushReg(0 + n9);
                        this.setReg();
                        break block0;
                    }
                    case 8: {
                        this.pushReg(66);
                        methodGen.add((byte)18, 0x800000);
                        methodGen.add((byte)126);
                        return this.doIfInstruction((n3 >>> 16 & 1) == 0 ? (byte)-103 : -102, n2, n2 + n19 * 4 + 4, n4);
                    }
                    case 16: 
                    case 17: {
                        boolean bl2 = n8 == 17;
                        switch (n15) {
                            case 0: {
                                this.preSetDouble(32 + n14, bl2);
                                this.pushDouble(32 + n12, bl2);
                                this.pushDouble(32 + n10, bl2);
                                methodGen.add(bl2 ? (byte)99 : 98);
                                this.setDouble(bl2);
                                break block0;
                            }
                            case 1: {
                                this.preSetDouble(32 + n14, bl2);
                                this.pushDouble(32 + n12, bl2);
                                this.pushDouble(32 + n10, bl2);
                                methodGen.add(bl2 ? (byte)103 : 102);
                                this.setDouble(bl2);
                                break block0;
                            }
                            case 2: {
                                this.preSetDouble(32 + n14, bl2);
                                this.pushDouble(32 + n12, bl2);
                                this.pushDouble(32 + n10, bl2);
                                methodGen.add(bl2 ? (byte)107 : 106);
                                this.setDouble(bl2);
                                break block0;
                            }
                            case 3: {
                                this.preSetDouble(32 + n14, bl2);
                                this.pushDouble(32 + n12, bl2);
                                this.pushDouble(32 + n10, bl2);
                                methodGen.add(bl2 ? (byte)111 : 110);
                                this.setDouble(bl2);
                                break block0;
                            }
                            case 5: {
                                this.preSetDouble(32 + n14, bl2);
                                this.pushDouble(32 + n12, bl2);
                                methodGen.add(bl2 ? (byte)92 : 89);
                                methodGen.add(bl2 ? (byte)14 : 11);
                                methodGen.add(bl2 ? (byte)-104 : -106);
                                int n33 = methodGen.add((byte)-99);
                                methodGen.add(bl2 ? (byte)14 : 11);
                                if (bl2) {
                                    methodGen.add((byte)94);
                                    methodGen.add((byte)88);
                                } else {
                                    methodGen.add((byte)95);
                                }
                                methodGen.add(bl2 ? (byte)103 : 102);
                                methodGen.setArg(n33, methodGen.size());
                                this.setDouble(bl2);
                                break block0;
                            }
                            case 6: {
                                this.preSetReg(32 + n14);
                                this.pushReg(32 + n12);
                                this.setReg();
                                if (!bl2) break block0;
                                this.preSetReg(32 + n14 + 1);
                                this.pushReg(32 + n12 + 1);
                                this.setReg();
                                break block0;
                            }
                            case 7: {
                                this.preSetDouble(32 + n14, bl2);
                                this.pushDouble(32 + n12, bl2);
                                methodGen.add(bl2 ? (byte)119 : 118);
                                this.setDouble(bl2);
                                break block0;
                            }
                            case 32: {
                                this.preSetFloat(32 + n14);
                                this.pushDouble(32 + n12, bl2);
                                if (bl2) {
                                    methodGen.add((byte)-112);
                                }
                                this.setFloat();
                                break block0;
                            }
                            case 33: {
                                this.preSetDouble(32 + n14);
                                this.pushDouble(32 + n12, bl2);
                                if (!bl2) {
                                    methodGen.add((byte)-115);
                                }
                                this.setDouble();
                                break block0;
                            }
                            case 36: {
                                MethodGen.Switch.Table table = new MethodGen.Switch.Table(0, 3);
                                this.preSetReg(32 + n14);
                                this.pushDouble(32 + n12, bl2);
                                this.pushReg(66);
                                methodGen.add((byte)6);
                                methodGen.add((byte)126);
                                methodGen.add((byte)-86, (Object)table);
                                table.setTarget(2, methodGen.size());
                                if (!bl2) {
                                    methodGen.add((byte)-115);
                                }
                                methodGen.add((byte)-72, (Object)Type.Class.instance((String)"java.lang.Math").method("ceil", Type.DOUBLE, new Type[]{Type.DOUBLE}));
                                if (!bl2) {
                                    methodGen.add((byte)-112);
                                }
                                int n34 = methodGen.add((byte)-89);
                                table.setTarget(0, methodGen.size());
                                methodGen.add((byte)18, (Object)(bl2 ? (Number)POINT_5_D : (Number)POINT_5_F));
                                methodGen.add(bl2 ? (byte)99 : 98);
                                table.setTarget(3, methodGen.size());
                                if (!bl2) {
                                    methodGen.add((byte)-115);
                                }
                                methodGen.add((byte)-72, (Object)Type.Class.instance((String)"java.lang.Math").method("floor", Type.DOUBLE, new Type[]{Type.DOUBLE}));
                                if (!bl2) {
                                    methodGen.add((byte)-112);
                                }
                                table.setTarget(1, methodGen.size());
                                table.setDefaultTarget(methodGen.size());
                                methodGen.setArg(n34, methodGen.size());
                                methodGen.add(bl2 ? (byte)-114 : -117);
                                this.setReg();
                                break block0;
                            }
                            case 50: 
                            case 60: 
                            case 62: {
                                int n35;
                                this.preSetReg(66);
                                this.pushReg(66);
                                methodGen.add((byte)18, -8388609);
                                methodGen.add((byte)126);
                                this.pushDouble(32 + n12, bl2);
                                this.pushDouble(32 + n10, bl2);
                                methodGen.add(bl2 ? (byte)-104 : -106);
                                switch (n15) {
                                    case 50: {
                                        n35 = methodGen.add((byte)-102);
                                        break;
                                    }
                                    case 60: {
                                        n35 = methodGen.add((byte)-100);
                                        break;
                                    }
                                    case 62: {
                                        n35 = methodGen.add((byte)-99);
                                        break;
                                    }
                                    default: {
                                        n35 = -1;
                                    }
                                }
                                methodGen.add((byte)18, 0x800000);
                                methodGen.add((byte)-128);
                                methodGen.setArg(n35, methodGen.size());
                                this.setReg();
                                break block0;
                            }
                            default: {
                                throw new Compiler.Exn("Invalid Instruction 17/" + n8 + "/" + n15);
                            }
                        }
                    }
                    case 20: {
                        switch (n15) {
                            case 32: {
                                this.preSetFloat(32 + n14);
                                this.pushReg(32 + n12);
                                methodGen.add((byte)-122);
                                this.setFloat();
                                break block0;
                            }
                            case 33: {
                                this.preSetDouble(32 + n14);
                                this.pushReg(32 + n12);
                                methodGen.add((byte)-121);
                                this.setDouble();
                                break block0;
                            }
                        }
                        throw new Compiler.Exn("Invalid Instruction 17/" + n8 + "/" + n15);
                    }
                    default: {
                        throw new Compiler.Exn("Invalid Instruction 17/" + n8);
                    }
                }
            }
            case 18: 
            case 19: {
                throw new Compiler.Exn("coprocessor 2 and 3 instructions not available");
            }
            case 32: {
                this.preSetReg(0 + n9);
                this.addiu(0 + n8, n5);
                this.setTmp();
                this.preMemRead();
                this.pushTmp();
                this.memRead(true);
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)-111);
                this.setReg();
                break;
            }
            case 33: {
                this.preSetReg(0 + n9);
                this.addiu(0 + n8, n5);
                this.setTmp();
                this.preMemRead();
                this.pushTmp();
                this.memRead(true);
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)5);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)-109);
                this.setReg();
                break;
            }
            case 34: {
                this.preSetReg(0 + n9);
                this.addiu(0 + n8, n5);
                this.setTmp();
                this.pushRegWZ(0 + n9);
                methodGen.add((byte)18, 0xFFFFFF);
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)126);
                this.preMemRead();
                this.pushTmp();
                this.memRead(true);
                this.pushTmp();
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)120);
                methodGen.add((byte)-128);
                this.setReg();
                break;
            }
            case 35: {
                this.preSetReg(0 + n9);
                this.memRead(0 + n8, n5);
                this.setReg();
                break;
            }
            case 36: {
                this.preSetReg(0 + n9);
                this.addiu(0 + n8, n5);
                this.setTmp();
                this.preMemRead();
                this.pushTmp();
                this.memRead(true);
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)18, 255);
                methodGen.add((byte)126);
                this.setReg();
                break;
            }
            case 37: {
                this.preSetReg(0 + n9);
                this.addiu(0 + n8, n5);
                this.setTmp();
                this.preMemRead();
                this.pushTmp();
                this.memRead(true);
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)5);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)-110);
                this.setReg();
                break;
            }
            case 38: {
                this.preSetReg(0 + n9);
                this.addiu(0 + n8, n5);
                this.setTmp();
                this.pushRegWZ(0 + n9);
                methodGen.add((byte)18, -256);
                this.pushTmp();
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)120);
                methodGen.add((byte)126);
                this.preMemRead();
                this.pushTmp();
                this.memRead(true);
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)-128);
                this.setReg();
                break;
            }
            case 40: {
                this.addiu(0 + n8, n5);
                this.setTmp();
                this.preMemRead(true);
                this.pushTmp();
                this.memRead(true);
                methodGen.add((byte)18, -16777216);
                this.pushTmp();
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)126);
                if (n9 != 0) {
                    this.pushReg(0 + n9);
                    methodGen.add((byte)18, 255);
                    methodGen.add((byte)126);
                } else {
                    methodGen.add((byte)18, 0);
                }
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)120);
                methodGen.add((byte)-128);
                this.memWrite();
                break;
            }
            case 41: {
                this.addiu(0 + n8, n5);
                this.setTmp();
                this.preMemRead(true);
                this.pushTmp();
                this.memRead(true);
                methodGen.add((byte)18, 65535);
                this.pushTmp();
                methodGen.add((byte)5);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)120);
                methodGen.add((byte)126);
                if (n9 != 0) {
                    this.pushReg(0 + n9);
                    methodGen.add((byte)18, 65535);
                    methodGen.add((byte)126);
                } else {
                    methodGen.add((byte)18, 0);
                }
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)5);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)120);
                methodGen.add((byte)-128);
                this.memWrite();
                break;
            }
            case 42: {
                this.addiu(0 + n8, n5);
                this.setTmp();
                this.preMemRead(true);
                this.pushTmp();
                this.memRead(true);
                methodGen.add((byte)18, -256);
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)120);
                methodGen.add((byte)126);
                this.pushRegWZ(0 + n9);
                this.pushTmp();
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)-128);
                this.memWrite();
                break;
            }
            case 43: {
                this.preMemWrite1();
                this.preMemWrite2(0 + n8, n5);
                this.pushRegZ(0 + n9);
                this.memWrite();
                break;
            }
            case 46: {
                this.addiu(0 + n8, n5);
                this.setTmp();
                this.preMemRead(true);
                this.pushTmp();
                this.memRead(true);
                methodGen.add((byte)18, 0xFFFFFF);
                this.pushTmp();
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)124);
                methodGen.add((byte)126);
                this.pushRegWZ(0 + n9);
                this.pushTmp();
                methodGen.add((byte)2);
                methodGen.add((byte)-126);
                methodGen.add((byte)6);
                methodGen.add((byte)126);
                methodGen.add((byte)6);
                methodGen.add((byte)120);
                methodGen.add((byte)120);
                methodGen.add((byte)-128);
                this.memWrite();
                break;
            }
            case 48: {
                this.preSetReg(0 + n9);
                this.memRead(0 + n8, n5);
                this.setReg();
                break;
            }
            case 49: {
                this.preSetReg(32 + n9);
                this.memRead(0 + n8, n5);
                this.setReg();
                break;
            }
            case 56: {
                this.preSetReg(0 + n9);
                this.preMemWrite1();
                this.preMemWrite2(0 + n8, n5);
                this.pushReg(0 + n9);
                this.memWrite();
                methodGen.add((byte)18, 1);
                this.setReg();
                break;
            }
            case 57: {
                this.preMemWrite1();
                this.preMemWrite2(0 + n8, n5);
                this.pushReg(32 + n9);
                this.memWrite();
                break;
            }
            default: {
                throw new Compiler.Exn("Invalid Instruction: " + n7 + " at " + ClassFileCompiler.toHex(n2));
            }
        }
        return n6;
    }

    private boolean doLocal(int n2) {
        return n2 == 2 || n2 == 3 || n2 == 4 || n2 == 29;
    }

    private int getLocalForReg(int n2) {
        if (this.regLocalMapping[n2] != 0) {
            return this.regLocalMapping[n2];
        }
        ++this.nextAvailLocal;
        return this.regLocalMapping[n2];
    }

    private void fixupRegsStart() {
        int n2;
        for (n2 = 0; n2 < 67; ++n2) {
            this.regLocalMapping[n2] = 0;
            this.regLocalWritten[n2] = false;
        }
        this.nextAvailLocal = this.onePage ? 4 : 5;
        this.loadsStart = this.mg.size();
        for (n2 = 0; n2 < 12; ++n2) {
            this.mg.add((byte)0);
        }
    }

    private void fixupRegsEnd() {
        int n2 = this.loadsStart;
        for (int i2 = 0; i2 < 67; ++i2) {
            if (this.regLocalMapping[i2] == 0) continue;
            this.mg.set(n2++, (byte)42);
            this.mg.set(n2++, (byte)-76, (Object)this.me.field(regField[i2], Type.INT));
            this.mg.set(n2++, (byte)54, this.regLocalMapping[i2]);
            if (!this.regLocalWritten[i2]) continue;
            this.mg.add((byte)42);
            this.mg.add((byte)21, this.regLocalMapping[i2]);
            this.mg.add((byte)-75, (Object)this.me.field(regField[i2], Type.INT));
        }
    }

    private void restoreChangedRegs() {
        for (int i2 = 0; i2 < 67; ++i2) {
            if (!this.regLocalWritten[i2]) continue;
            this.mg.add((byte)42);
            this.mg.add((byte)21, this.regLocalMapping[i2]);
            this.mg.add((byte)-75, (Object)this.me.field(regField[i2], Type.INT));
        }
    }

    private int pushRegWZ(int n2) {
        if (n2 == 0) {
            this.warn.println("Warning: Pushing r0!");
            new Exception().printStackTrace(this.warn);
        }
        return this.pushRegZ(n2);
    }

    private int pushRegZ(int n2) {
        if (n2 == 0) {
            return this.mg.add((byte)3);
        }
        return this.pushReg(n2);
    }

    private int pushReg(int n2) {
        int n3 = this.mg.size();
        if (this.doLocal(n2)) {
            this.mg.add((byte)21, this.getLocalForReg(n2));
        } else if (n2 >= 32 && n2 <= 63 && this.singleFloat) {
            this.mg.add((byte)42);
            this.mg.add((byte)-76, (Object)this.me.field(regField[n2], Type.FLOAT));
            this.mg.add((byte)-72, (Object)Type.FLOAT_OBJECT.method("floatToIntBits", Type.INT, new Type[]{Type.FLOAT}));
        } else {
            this.mg.add((byte)42);
            this.mg.add((byte)-76, (Object)this.me.field(regField[n2], Type.INT));
        }
        return n3;
    }

    private boolean preSetReg(int n2) {
        this.preSetRegStack[this.preSetRegStackPos] = n2;
        ++this.preSetRegStackPos;
        if (this.doLocal(n2)) {
            return false;
        }
        this.mg.add((byte)42);
        return true;
    }

    private int setReg() {
        if (this.preSetRegStackPos == 0) {
            throw new RuntimeException("didn't do preSetReg");
        }
        --this.preSetRegStackPos;
        int n2 = this.preSetRegStack[this.preSetRegStackPos];
        int n3 = this.mg.size();
        if (this.doLocal(n2)) {
            this.mg.add((byte)54, this.getLocalForReg(n2));
            this.regLocalWritten[n2] = true;
        } else if (n2 >= 32 && n2 <= 63 && this.singleFloat) {
            this.mg.add((byte)-72, (Object)Type.FLOAT_OBJECT.method("intBitsToFloat", Type.FLOAT, new Type[]{Type.INT}));
            this.mg.add((byte)-75, (Object)this.me.field(regField[n2], Type.FLOAT));
        } else {
            this.mg.add((byte)-75, (Object)this.me.field(regField[n2], Type.INT));
        }
        return n3;
    }

    private int preSetPC() {
        return this.mg.add((byte)42);
    }

    private int setPC() {
        return this.mg.add((byte)-75, (Object)this.me.field("pc", Type.INT));
    }

    private int pushFloat(int n2) {
        return this.pushDouble(n2, false);
    }

    private int pushDouble(int n2, boolean bl2) {
        if (n2 < 32 || n2 >= 64) {
            throw new IllegalArgumentException("" + n2);
        }
        int n3 = this.mg.size();
        if (bl2) {
            if (this.singleFloat) {
                throw new Compiler.Exn("Double operations not supported when singleFloat is enabled");
            }
            if (n2 == 63) {
                throw new Compiler.Exn("Tried to use a double in f31");
            }
            this.pushReg(n2 + 1);
            this.mg.add((byte)-123);
            this.mg.add((byte)18, 32);
            this.mg.add((byte)121);
            this.pushReg(n2);
            this.mg.add((byte)-123);
            this.mg.add((byte)18, (Object)FFFFFFFF);
            this.mg.add((byte)127);
            this.mg.add((byte)-127);
            this.mg.add((byte)-72, (Object)Type.DOUBLE_OBJECT.method("longBitsToDouble", Type.DOUBLE, new Type[]{Type.LONG}));
        } else if (this.singleFloat) {
            this.mg.add((byte)42);
            this.mg.add((byte)-76, (Object)this.me.field(regField[n2], Type.FLOAT));
        } else {
            this.pushReg(n2);
            this.mg.add((byte)-72, (Object)Type.Class.instance((String)"java.lang.Float").method("intBitsToFloat", Type.FLOAT, new Type[]{Type.INT}));
        }
        return n3;
    }

    private void preSetFloat(int n2) {
        this.preSetDouble(n2, false);
    }

    private void preSetDouble(int n2) {
        this.preSetDouble(n2, true);
    }

    private void preSetDouble(int n2, boolean bl2) {
        this.preSetReg(n2);
    }

    private int setFloat() {
        return this.setDouble(false);
    }

    private int setDouble() {
        return this.setDouble(true);
    }

    private int setDouble(boolean bl2) {
        int n2 = this.preSetRegStack[this.preSetRegStackPos - 1];
        if (n2 < 32 || n2 >= 64) {
            throw new IllegalArgumentException("" + n2);
        }
        int n3 = this.mg.size();
        if (bl2) {
            if (this.singleFloat) {
                throw new Compiler.Exn("Double operations not supported when singleFloat is enabled");
            }
            if (n2 == 63) {
                throw new Compiler.Exn("Tried to use a double in f31");
            }
            this.mg.add((byte)-72, (Object)Type.DOUBLE_OBJECT.method("doubleToLongBits", Type.LONG, new Type[]{Type.DOUBLE}));
            this.mg.add((byte)92);
            this.mg.add((byte)18, 32);
            this.mg.add((byte)125);
            this.mg.add((byte)-120);
            if (this.preSetReg(n2 + 1)) {
                this.mg.add((byte)95);
            }
            this.setReg();
            this.mg.add((byte)-120);
            this.setReg();
        } else if (this.singleFloat) {
            --this.preSetRegStackPos;
            this.mg.add((byte)-75, (Object)this.me.field(regField[n2], Type.FLOAT));
        } else {
            this.mg.add((byte)-72, (Object)Type.FLOAT_OBJECT.method("floatToRawIntBits", Type.INT, new Type[]{Type.FLOAT}));
            this.setReg();
        }
        return n3;
    }

    private void pushTmp() {
        this.mg.add((byte)27);
    }

    private void setTmp() {
        this.mg.add((byte)60);
    }

    private void addiu(int n2, int n3) {
        if (n2 != 0 && n3 != 0) {
            this.pushReg(n2);
            this.mg.add((byte)18, n3);
            this.mg.add((byte)96);
        } else if (n2 != 0) {
            this.pushReg(n2);
        } else {
            this.mg.add((byte)18, n3);
        }
    }

    private void preMemWrite1() {
        if (this.memWriteStage != 0) {
            throw new Error("pending preMemWrite1/2");
        }
        this.memWriteStage = 1;
        if (this.onePage) {
            this.mg.add((byte)44);
        } else if (this.fastMem) {
            this.mg.add((byte)25, 3);
        } else {
            this.mg.add((byte)42);
        }
    }

    private void preMemWrite2(int n2, int n3) {
        this.addiu(n2, n3);
        this.preMemWrite2();
    }

    private void preMemWrite2() {
        this.preMemWrite2(false);
    }

    private void preMemWrite2(boolean bl2) {
        if (this.memWriteStage != 1) {
            throw new Error("pending preMemWrite2 or no preMemWrite1");
        }
        this.memWriteStage = 2;
        if (this.nullPointerCheck) {
            this.mg.add((byte)89);
            this.mg.add((byte)42);
            this.mg.add((byte)95);
            this.mg.add((byte)-74, (Object)this.me.method("nullPointerCheck", Type.VOID, new Type[]{Type.INT}));
        }
        if (this.onePage) {
            this.mg.add((byte)5);
            this.mg.add((byte)124);
        } else if (this.fastMem) {
            if (!bl2) {
                this.mg.add((byte)90);
            }
            this.mg.add((byte)18, this.pageShift);
            this.mg.add((byte)124);
            this.mg.add((byte)50);
            if (bl2) {
                this.pushTmp();
            } else {
                this.mg.add((byte)95);
            }
            this.mg.add((byte)5);
            this.mg.add((byte)124);
            this.mg.add((byte)18, (this.pageSize >> 2) - 1);
            this.mg.add((byte)126);
        }
    }

    private void memWrite() {
        if (this.memWriteStage != 2) {
            throw new Error("didn't do preMemWrite1 or preMemWrite2");
        }
        this.memWriteStage = 0;
        if (this.onePage) {
            this.mg.add((byte)79);
        } else if (this.fastMem) {
            this.mg.add((byte)79);
        } else {
            this.mg.add((byte)-74, (Object)this.me.method("unsafeMemWrite", Type.VOID, new Type[]{Type.INT, Type.INT}));
        }
    }

    private void memRead(int n2, int n3) {
        this.preMemRead();
        this.addiu(n2, n3);
        this.memRead();
    }

    private void preMemRead() {
        this.preMemRead(false);
    }

    private void preMemRead(boolean bl2) {
        if (this.didPreMemRead) {
            throw new Error("pending preMemRead");
        }
        this.didPreMemRead = true;
        this.preMemReadDoPreWrite = bl2;
        if (this.onePage) {
            this.mg.add((byte)44);
        } else if (this.fastMem) {
            this.mg.add((byte)25, bl2 ? 3 : 2);
        } else {
            this.mg.add((byte)42);
        }
    }

    private void memRead() {
        this.memRead(false);
    }

    private void memRead(boolean bl2) {
        if (!this.didPreMemRead) {
            throw new Error("didn't do preMemRead");
        }
        this.didPreMemRead = false;
        if (this.preMemReadDoPreWrite) {
            this.memWriteStage = 2;
        }
        if (this.nullPointerCheck) {
            this.mg.add((byte)89);
            this.mg.add((byte)42);
            this.mg.add((byte)95);
            this.mg.add((byte)-74, (Object)this.me.method("nullPointerCheck", Type.VOID, new Type[]{Type.INT}));
        }
        if (this.onePage) {
            this.mg.add((byte)5);
            this.mg.add((byte)124);
            if (this.preMemReadDoPreWrite) {
                this.mg.add((byte)92);
            }
            this.mg.add((byte)46);
        } else if (this.fastMem) {
            if (!bl2) {
                this.mg.add((byte)90);
            }
            this.mg.add((byte)18, this.pageShift);
            this.mg.add((byte)124);
            this.mg.add((byte)50);
            if (bl2) {
                this.pushTmp();
            } else {
                this.mg.add((byte)95);
            }
            this.mg.add((byte)5);
            this.mg.add((byte)124);
            this.mg.add((byte)18, (this.pageSize >> 2) - 1);
            this.mg.add((byte)126);
            if (this.preMemReadDoPreWrite) {
                this.mg.add((byte)92);
            }
            this.mg.add((byte)46);
        } else {
            if (this.preMemReadDoPreWrite) {
                this.mg.add((byte)92);
            }
            this.mg.add((byte)-74, (Object)this.me.method("unsafeMemRead", Type.INT, new Type[]{Type.INT}));
        }
    }

    static {
        POINT_5_F = new Float(0.5f);
        POINT_5_D = new Double(0.5);
        FFFFFFFF = new Long(0xFFFFFFFFL);
        regField = new String[]{"r0", "r1", "r2", "r3", "r4", "r5", "r6", "r7", "r8", "r9", "r10", "r11", "r12", "r13", "r14", "r15", "r16", "r17", "r18", "r19", "r20", "r21", "r22", "r23", "r24", "r25", "r26", "r27", "r28", "r29", "r30", "r31", "f0", "f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "f10", "f11", "f12", "f13", "f14", "f15", "f16", "f17", "f18", "f19", "f20", "f21", "f22", "f23", "f24", "f25", "f26", "f27", "f28", "f29", "f30", "f31", "hi", "lo", "fcsr"};
    }
}

