/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.signedness;

import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.checkerframework.checker.signedness.qual.Unsigned;

public final class SignednessUtil {
    private SignednessUtil() {
        throw new Error("Do not instantiate");
    }

    public static ByteBuffer wrapUnsigned(@Unsigned byte[] byArray) {
        return ByteBuffer.wrap(byArray);
    }

    public static ByteBuffer wrapUnsigned(@Unsigned byte[] byArray, int n2, int n3) {
        return ByteBuffer.wrap(byArray, n2, n3);
    }

    public static @Unsigned int getUnsignedInt(ByteBuffer byteBuffer) {
        return byteBuffer.getInt();
    }

    public static @Unsigned short getUnsignedShort(ByteBuffer byteBuffer) {
        return byteBuffer.getShort();
    }

    public static @Unsigned byte getUnsigned(ByteBuffer byteBuffer) {
        return byteBuffer.get();
    }

    public static @Unsigned byte getUnsigned(ByteBuffer byteBuffer, int n2) {
        return byteBuffer.get(n2);
    }

    public static ByteBuffer getUnsigned(ByteBuffer byteBuffer, byte[] byArray, int n2, int n3) {
        return byteBuffer.get(byArray, n2, n3);
    }

    public static ByteBuffer putUnsigned(ByteBuffer byteBuffer, @Unsigned byte by2) {
        return byteBuffer.put(by2);
    }

    public static ByteBuffer putUnsigned(ByteBuffer byteBuffer, int n2, @Unsigned byte by2) {
        return byteBuffer.put(n2, by2);
    }

    public static IntBuffer putUnsigned(IntBuffer intBuffer, @Unsigned int n2) {
        return intBuffer.put(n2);
    }

    public static IntBuffer putUnsigned(IntBuffer intBuffer, int n2, @Unsigned int n3) {
        return intBuffer.put(n2, n3);
    }

    public static IntBuffer putUnsigned(IntBuffer intBuffer, @Unsigned int[] nArray) {
        return intBuffer.put(nArray);
    }

    public static IntBuffer putUnsigned(IntBuffer intBuffer, @Unsigned int[] nArray, int n2, int n3) {
        return intBuffer.put(nArray, n2, n3);
    }

    public static @Unsigned int getUnsigned(IntBuffer intBuffer, int n2) {
        return intBuffer.get(n2);
    }

    public static ByteBuffer putUnsignedShort(ByteBuffer byteBuffer, @Unsigned short s2) {
        return byteBuffer.putShort(s2);
    }

    public static ByteBuffer putUnsignedShort(ByteBuffer byteBuffer, int n2, @Unsigned short s2) {
        return byteBuffer.putShort(n2, s2);
    }

    public static ByteBuffer putUnsignedInt(ByteBuffer byteBuffer, @Unsigned int n2) {
        return byteBuffer.putInt(n2);
    }

    public static ByteBuffer putUnsignedInt(ByteBuffer byteBuffer, int n2, @Unsigned int n3) {
        return byteBuffer.putInt(n2, n3);
    }

    public static ByteBuffer putUnsignedLong(ByteBuffer byteBuffer, int n2, @Unsigned long l2) {
        return byteBuffer.putLong(n2, l2);
    }

    public static @Unsigned byte readUnsignedByte(RandomAccessFile randomAccessFile) {
        return randomAccessFile.readByte();
    }

    public static @Unsigned char readUnsignedChar(RandomAccessFile randomAccessFile) {
        return randomAccessFile.readChar();
    }

    public static @Unsigned short readUnsignedShort(RandomAccessFile randomAccessFile) {
        return randomAccessFile.readShort();
    }

    public static @Unsigned int readUnsignedInt(RandomAccessFile randomAccessFile) {
        return randomAccessFile.readInt();
    }

    public static @Unsigned long readUnsignedLong(RandomAccessFile randomAccessFile) {
        return randomAccessFile.readLong();
    }

    public static int readUnsigned(RandomAccessFile randomAccessFile, @Unsigned byte[] byArray, int n2, int n3) {
        return randomAccessFile.read(byArray, n2, n3);
    }

    public static void readFullyUnsigned(RandomAccessFile randomAccessFile, @Unsigned byte[] byArray) {
        randomAccessFile.readFully(byArray);
    }

    public static void writeUnsigned(RandomAccessFile randomAccessFile, @Unsigned byte[] byArray, int n2, int n3) {
        randomAccessFile.write(byArray, n2, n3);
    }

    public static void writeUnsignedByte(RandomAccessFile randomAccessFile, @Unsigned byte by2) {
        randomAccessFile.writeByte(SignednessUtil.toUnsignedInt(by2));
    }

    public static void writeUnsignedChar(RandomAccessFile randomAccessFile, @Unsigned char c2) {
        randomAccessFile.writeChar(SignednessUtil.toUnsignedInt(c2));
    }

    public static void writeUnsignedShort(RandomAccessFile randomAccessFile, @Unsigned short s2) {
        randomAccessFile.writeShort(SignednessUtil.toUnsignedInt(s2));
    }

    public static void writeUnsignedInt(RandomAccessFile randomAccessFile, @Unsigned int n2) {
        randomAccessFile.writeInt(n2);
    }

    public static void writeUnsignedLong(RandomAccessFile randomAccessFile, @Unsigned long l2) {
        randomAccessFile.writeLong(l2);
    }

    public static void getUnsigned(ByteBuffer byteBuffer, @Unsigned byte[] byArray) {
        byteBuffer.get(byArray);
    }

    public static int compareUnsigned(@Unsigned long l2, @Unsigned long l3) {
        return Long.compare(l2 + Long.MIN_VALUE, l3 + Long.MIN_VALUE);
    }

    public static int compareUnsigned(@Unsigned int n2, @Unsigned int n3) {
        return Integer.compare(n2 + Integer.MIN_VALUE, n3 + Integer.MIN_VALUE);
    }

    public static int compareUnsigned(@Unsigned short s2, @Unsigned short s3) {
        return SignednessUtil.compareUnsigned(SignednessUtil.toUnsignedInt(s2), SignednessUtil.toUnsignedInt(s3));
    }

    public static int compareUnsigned(@Unsigned byte by2, @Unsigned byte by3) {
        return SignednessUtil.compareUnsigned(SignednessUtil.toUnsignedInt(by2), SignednessUtil.toUnsignedInt(by3));
    }

    public static String toUnsignedString(@Unsigned long l2) {
        return SignednessUtil.toUnsignedBigInteger(l2).toString();
    }

    public static String toUnsignedString(@Unsigned long l2, int n2) {
        return SignednessUtil.toUnsignedBigInteger(l2).toString(n2);
    }

    public static String toUnsignedString(@Unsigned int n2) {
        return Long.toString(SignednessUtil.toUnsignedLong(n2));
    }

    public static String toUnsignedString(@Unsigned int n2, int n3) {
        return Long.toString(SignednessUtil.toUnsignedLong(n2), n3);
    }

    public static String toUnsignedString(@Unsigned short s2) {
        return Long.toString(SignednessUtil.toUnsignedLong(s2));
    }

    public static String toUnsignedString(@Unsigned short s2, int n2) {
        return Long.toString(SignednessUtil.toUnsignedLong(s2), n2);
    }

    public static String toUnsignedString(@Unsigned byte by2) {
        return Long.toString(SignednessUtil.toUnsignedLong(by2));
    }

    public static String toUnsignedString(@Unsigned byte by2, int n2) {
        return Long.toString(SignednessUtil.toUnsignedLong(by2), n2);
    }

    private static @Unsigned BigInteger toUnsignedBigInteger(@Unsigned long l2) {
        if (l2 >= 0L) {
            return BigInteger.valueOf(l2);
        }
        int n2 = (int)(l2 >>> 32);
        int n3 = (int)l2;
        return BigInteger.valueOf(SignednessUtil.toUnsignedLong(n2)).shiftLeft(32).add(BigInteger.valueOf(SignednessUtil.toUnsignedLong(n3)));
    }

    public static @Unsigned long toUnsignedLong(@Unsigned int n2) {
        return (long)n2 & 0xFFFFFFFFL;
    }

    public static @Unsigned long toUnsignedLong(@Unsigned short s2) {
        return (long)s2 & 0xFFFFL;
    }

    public static @Unsigned int toUnsignedInt(@Unsigned short s2) {
        return s2 & 0xFFFF;
    }

    public static @Unsigned long toUnsignedLong(@Unsigned byte by2) {
        return (long)by2 & 0xFFL;
    }

    public static @Unsigned int toUnsignedInt(@Unsigned byte by2) {
        return by2 & 0xFF;
    }

    public static @Unsigned short toUnsignedShort(@Unsigned byte by2) {
        return (short)(by2 & 0xFF);
    }

    public static @Unsigned long toUnsignedLong(@Unsigned char c2) {
        return (long)c2 & 0xFFL;
    }

    public static @Unsigned int toUnsignedInt(@Unsigned char c2) {
        return c2 & 0xFF;
    }

    public static @Unsigned short toUnsignedShort(@Unsigned char c2) {
        return (short)(c2 & 0xFF);
    }

    public static float toFloat(@Unsigned byte by2) {
        return SignednessUtil.toUnsignedBigInteger(SignednessUtil.toUnsignedLong(by2)).floatValue();
    }

    public static float toFloat(@Unsigned short s2) {
        return SignednessUtil.toUnsignedBigInteger(SignednessUtil.toUnsignedLong(s2)).floatValue();
    }

    public static float toFloat(@Unsigned int n2) {
        return SignednessUtil.toUnsignedBigInteger(SignednessUtil.toUnsignedLong(n2)).floatValue();
    }

    public static float toFloat(@Unsigned long l2) {
        return SignednessUtil.toUnsignedBigInteger(l2).floatValue();
    }

    public static double toDouble(@Unsigned byte by2) {
        return SignednessUtil.toUnsignedBigInteger(SignednessUtil.toUnsignedLong(by2)).doubleValue();
    }

    public static double toDouble(@Unsigned short s2) {
        return SignednessUtil.toUnsignedBigInteger(SignednessUtil.toUnsignedLong(s2)).doubleValue();
    }

    public static double toDouble(@Unsigned int n2) {
        return SignednessUtil.toUnsignedBigInteger(SignednessUtil.toUnsignedLong(n2)).doubleValue();
    }

    public static double toDouble(@Unsigned long l2) {
        return SignednessUtil.toUnsignedBigInteger(l2).doubleValue();
    }

    public static @Unsigned byte byteFromFloat(float f2) {
        assert (f2 >= 0.0f);
        return (byte)f2;
    }

    public static @Unsigned short shortFromFloat(float f2) {
        assert (f2 >= 0.0f);
        return (short)f2;
    }

    public static @Unsigned int intFromFloat(float f2) {
        assert (f2 >= 0.0f);
        return (int)f2;
    }

    public static @Unsigned long longFromFloat(float f2) {
        assert (f2 >= 0.0f);
        return (long)f2;
    }

    public static @Unsigned byte byteFromDouble(double d2) {
        assert (d2 >= 0.0);
        return (byte)d2;
    }

    public static @Unsigned short shortFromDouble(double d2) {
        assert (d2 >= 0.0);
        return (short)d2;
    }

    public static @Unsigned int intFromDouble(double d2) {
        assert (d2 >= 0.0);
        return (int)d2;
    }

    public static @Unsigned long longFromDouble(double d2) {
        assert (d2 >= 0.0);
        return (long)d2;
    }
}

