/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.regex;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.regex.qual.Regex;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.EnsuresQualifierIf;

public final class RegexUtil {
    private RegexUtil() {
        throw new Error("do not instantiate");
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(String string) {
        return RegexUtil.isRegex(string, 0);
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(String string, int n2) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
        return RegexUtil.getGroupCount(pattern) >= n2;
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(char c2) {
        return RegexUtil.isRegex(Character.toString(c2));
    }

    @SideEffectFree
    public static @Nullable String regexError(String string) {
        return RegexUtil.regexError(string, 0);
    }

    @SideEffectFree
    public static @Nullable String regexError(String string, int n2) {
        try {
            Pattern pattern = Pattern.compile(string);
            int n3 = RegexUtil.getGroupCount(pattern);
            if (n3 < n2) {
                return RegexUtil.regexErrorMessage(string, n2, n3);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return patternSyntaxException.getMessage();
        }
        return null;
    }

    @SideEffectFree
    public static @Nullable PatternSyntaxException regexException(String string) {
        return RegexUtil.regexException(string, 0);
    }

    @SideEffectFree
    public static @Nullable PatternSyntaxException regexException(String string, int n2) {
        try {
            Pattern pattern = Pattern.compile(string);
            int n3 = RegexUtil.getGroupCount(pattern);
            if (n3 < n2) {
                return new PatternSyntaxException(RegexUtil.regexErrorMessage(string, n2, n3), string, -1);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return patternSyntaxException;
        }
        return null;
    }

    @SideEffectFree
    public static @Regex String asRegex(String string) {
        return RegexUtil.asRegex(string, 0);
    }

    @SideEffectFree
    public static @Regex String asRegex(String string, int n2) {
        try {
            Pattern pattern = Pattern.compile(string);
            int n3 = RegexUtil.getGroupCount(pattern);
            if (n3 < n2) {
                throw new Error(RegexUtil.regexErrorMessage(string, n2, n3));
            }
            return string;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new Error(patternSyntaxException);
        }
    }

    @SideEffectFree
    private static String regexErrorMessage(String string, int n2, int n3) {
        return "regex \"" + string + "\" has " + n3 + " groups, but " + n2 + " groups are needed.";
    }

    @Pure
    private static int getGroupCount(Pattern pattern) {
        return pattern.matcher("").groupCount();
    }

    public static class CheckedPatternSyntaxException
    extends Exception {
        private static final long serialVersionUID = 6266881831979001480L;
        private final PatternSyntaxException pse;

        public CheckedPatternSyntaxException(PatternSyntaxException patternSyntaxException) {
            this.pse = patternSyntaxException;
        }

        public CheckedPatternSyntaxException(String string, String string2, int n2) {
            this(new PatternSyntaxException(string, string2, n2));
        }

        public String getDescription() {
            return this.pse.getDescription();
        }

        public int getIndex() {
            return this.pse.getIndex();
        }

        @Override
        @Pure
        public String getMessage(@GuardSatisfied CheckedPatternSyntaxException this) {
            return this.pse.getMessage();
        }

        public String getPattern() {
            return this.pse.getPattern();
        }
    }
}

