/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Opt {
    private Opt() {
        throw new AssertionError((Object)"shouldn't be instantiated");
    }

    public static <T> @NonNull T get(T t2) {
        if (t2 == null) {
            throw new NoSuchElementException("No value present");
        }
        return t2;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    public static boolean isPresent(@Nullable Object object) {
        return object != null;
    }

    public static <T> void ifPresent(T t2, Consumer<@NonNull ? super @NonNull T> consumer) {
        if (t2 != null) {
            consumer.accept(t2);
        }
    }

    public static <T> @Nullable T filter(T t2, Predicate<@NonNull ? super @NonNull T> predicate) {
        if (t2 == null) {
            return null;
        }
        return (T)(predicate.test(t2) ? t2 : null);
    }

    public static <T, U> @Nullable U map(T t2, Function<@NonNull ? super @NonNull T, ? extends U> function) {
        if (t2 == null) {
            return null;
        }
        return function.apply(t2);
    }

    public static <T> @NonNull T orElse(T t2, @NonNull T t3) {
        return t2 != null ? t2 : t3;
    }

    public static <T> @NonNull T orElseGet(T t2, Supplier<? extends @NonNull T> supplier) {
        return t2 != null ? t2 : supplier.get();
    }

    public static <T, X extends Throwable> @NonNull T orElseThrow(T t2, Supplier<? extends @NonNull X> supplier) {
        if (t2 != null) {
            return t2;
        }
        throw (Throwable)supplier.get();
    }
}

