/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NullnessUtil {
    private NullnessUtil() {
        throw new AssertionError((Object)"shouldn't be instantiated");
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T castNonNull(@Nullable T t2) {
        assert (t2 != null) : "Misuse of castNonNull: called with a null argument";
        return t2;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [] castNonNullDeep(T @Nullable [] TArray) {
        return NullnessUtil.castNonNullArray(TArray);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][] castNonNullDeep(T @Nullable [] @Nullable [] TArray) {
        return (Object[][])NullnessUtil.castNonNullArray(TArray);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] TArray) {
        return (Object[][][])NullnessUtil.castNonNullArray(TArray);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] TArray) {
        return (Object[][][][])NullnessUtil.castNonNullArray(TArray);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] @Nullable [] TArray) {
        return (Object[][][][][])NullnessUtil.castNonNullArray(TArray);
    }

    private static <T> @NonNull T @NonNull [] castNonNullArray(T @Nullable [] TArray) {
        assert (TArray != null) : "Misuse of castNonNullArray: called with a null array argument";
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            assert (TArray[i2] != null) : "Misuse of castNonNull: called with a null array element";
            NullnessUtil.checkIfArray(TArray[i2]);
        }
        return TArray;
    }

    private static void checkIfArray(@NonNull Object object) {
        assert (object != null) : "Misuse of checkIfArray: called with a null argument";
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz != null && !clazz.isPrimitive()) {
            NullnessUtil.castNonNullArray((Object[])object);
        }
    }
}

