/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.i18nformatter.qual;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public enum I18nConversionCategory {
    UNUSED(null, null),
    GENERAL(null, null),
    DATE(new Class[]{Date.class, Number.class}, new String[]{"date", "time"}),
    NUMBER(new Class[]{Number.class}, new String[]{"number", "choice"});

    public final Class<? extends Object>[] types;
    public final String[] strings;
    static I18nConversionCategory[] namedCategories;

    private I18nConversionCategory(Class<? extends Object>[] classArray, String[] stringArray) {
        this.types = classArray;
        this.strings = stringArray;
    }

    public static I18nConversionCategory stringToI18nConversionCategory(String string) {
        string = string.toLowerCase();
        for (I18nConversionCategory i18nConversionCategory : namedCategories) {
            for (String string2 : i18nConversionCategory.strings) {
                if (!string2.equals(string)) continue;
                return i18nConversionCategory;
            }
        }
        throw new IllegalArgumentException("Invalid format type " + string);
    }

    private static <E> Set<E> arrayToSet(E[] EArray) {
        return new HashSet<E>(Arrays.asList(EArray));
    }

    public static boolean isSubsetOf(I18nConversionCategory i18nConversionCategory, I18nConversionCategory i18nConversionCategory2) {
        return I18nConversionCategory.intersect(i18nConversionCategory, i18nConversionCategory2) == i18nConversionCategory;
    }

    public static I18nConversionCategory intersect(I18nConversionCategory i18nConversionCategory, I18nConversionCategory i18nConversionCategory2) {
        if (i18nConversionCategory == UNUSED) {
            return i18nConversionCategory2;
        }
        if (i18nConversionCategory2 == UNUSED) {
            return i18nConversionCategory;
        }
        if (i18nConversionCategory == GENERAL) {
            return i18nConversionCategory2;
        }
        if (i18nConversionCategory2 == GENERAL) {
            return i18nConversionCategory;
        }
        Set<Class<? extends Object>> set = I18nConversionCategory.arrayToSet(i18nConversionCategory.types);
        Set<Class<? extends Object>> set2 = I18nConversionCategory.arrayToSet(i18nConversionCategory2.types);
        set.retainAll(set2);
        for (I18nConversionCategory i18nConversionCategory3 : new I18nConversionCategory[]{DATE, NUMBER}) {
            Set<Class<? extends Object>> set3 = I18nConversionCategory.arrayToSet(i18nConversionCategory3.types);
            if (!set3.equals(set)) continue;
            return i18nConversionCategory3;
        }
        throw new RuntimeException();
    }

    public static I18nConversionCategory union(I18nConversionCategory i18nConversionCategory, I18nConversionCategory i18nConversionCategory2) {
        if (i18nConversionCategory == UNUSED || i18nConversionCategory2 == UNUSED) {
            return UNUSED;
        }
        if (i18nConversionCategory == GENERAL || i18nConversionCategory2 == GENERAL) {
            return GENERAL;
        }
        if (i18nConversionCategory == DATE || i18nConversionCategory2 == DATE) {
            return DATE;
        }
        return NUMBER;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.name());
        if (this.types == null) {
            stringBuilder.append(" conversion category (all types)");
        } else {
            stringBuilder.append(" conversion category (one of: ");
            boolean bl2 = true;
            for (Class<? extends Object> clazz : this.types) {
                if (!bl2) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(clazz.getCanonicalName());
                bl2 = false;
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    static {
        namedCategories = new I18nConversionCategory[]{DATE, NUMBER};
    }
}

