/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.i18nformatter;

import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.i18nformatter.qual.I18nChecksFormat;
import org.checkerframework.checker.i18nformatter.qual.I18nConversionCategory;
import org.checkerframework.checker.i18nformatter.qual.I18nValidFormat;

public class I18nFormatUtil {
    public static void tryFormatSatisfiability(String string) {
        MessageFormat.format(string, null);
    }

    public static I18nConversionCategory[] formatParameterCategories(String string) {
        I18nFormatUtil.tryFormatSatisfiability(string);
        I18nConversion[] i18nConversionArray = MessageFormatParser.parse(string);
        int n2 = -1;
        HashMap<Integer, I18nConversionCategory> hashMap = new HashMap<Integer, I18nConversionCategory>();
        I18nConversion[] objectArray = i18nConversionArray;
        int n3 = objectArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            I18nConversion i18nConversion = objectArray[i2];
            int n4 = i18nConversion.index;
            hashMap.put(n4, I18nConversionCategory.intersect(i18nConversion.category, hashMap.containsKey(n4) ? (I18nConversionCategory)((Object)hashMap.get(n4)) : I18nConversionCategory.UNUSED));
            n2 = Math.max(n2, n4);
        }
        I18nConversionCategory[] i18nConversionCategoryArray = new I18nConversionCategory[n2 + 1];
        for (n3 = 0; n3 <= n2; ++n3) {
            i18nConversionCategoryArray[n3] = hashMap.containsKey(n3) ? (I18nConversionCategory)((Object)hashMap.get(n3)) : I18nConversionCategory.UNUSED;
        }
        return i18nConversionCategoryArray;
    }

    @I18nChecksFormat
    public static boolean hasFormat(String string, I18nConversionCategory ... i18nConversionCategoryArray) {
        I18nConversionCategory[] i18nConversionCategoryArray2 = I18nFormatUtil.formatParameterCategories(string);
        if (i18nConversionCategoryArray2.length != i18nConversionCategoryArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < i18nConversionCategoryArray.length; ++i2) {
            if (I18nConversionCategory.isSubsetOf(i18nConversionCategoryArray[i2], i18nConversionCategoryArray2[i2])) continue;
            return false;
        }
        return true;
    }

    @I18nValidFormat
    public static boolean isFormat(String string) {
        try {
            I18nFormatUtil.formatParameterCategories(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static class MessageFormatParser {
        public static int maxOffset;
        private static Locale locale;
        private static List<I18nConversionCategory> categories;
        private static List<Integer> argumentIndices;
        private static int numFormat;
        private static final int SEG_RAW = 0;
        private static final int SEG_INDEX = 1;
        private static final int SEG_TYPE = 2;
        private static final int SEG_MODIFIER = 3;
        private static final int TYPE_NULL = 0;
        private static final int TYPE_NUMBER = 1;
        private static final int TYPE_DATE = 2;
        private static final int TYPE_TIME = 3;
        private static final int TYPE_CHOICE = 4;
        private static final String[] TYPE_KEYWORDS;
        private static final int MODIFIER_DEFAULT = 0;
        private static final int MODIFIER_CURRENCY = 1;
        private static final int MODIFIER_PERCENT = 2;
        private static final int MODIFIER_INTEGER = 3;
        private static final String[] NUMBER_MODIFIER_KEYWORDS;
        private static final String[] DATE_TIME_MODIFIER_KEYWORDS;

        private MessageFormatParser() {
        }

        public static I18nConversion[] parse(String string) {
            categories = new ArrayList<I18nConversionCategory>();
            argumentIndices = new ArrayList<Integer>();
            locale = Locale.getDefault(Locale.Category.FORMAT);
            MessageFormatParser.applyPattern(string);
            I18nConversion[] i18nConversionArray = new I18nConversion[numFormat];
            for (int i2 = 0; i2 < numFormat; ++i2) {
                i18nConversionArray[i2] = new I18nConversion(argumentIndices.get(i2), categories.get(i2));
            }
            return i18nConversionArray;
        }

        private static void applyPattern(String string) {
            StringBuilder[] stringBuilderArray = new StringBuilder[4];
            stringBuilderArray[0] = new StringBuilder();
            int n2 = 0;
            numFormat = 0;
            boolean bl2 = false;
            int n3 = 0;
            maxOffset = -1;
            block7: for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (n2 == 0) {
                    if (c2 == '\'') {
                        if (i2 + 1 < string.length() && string.charAt(i2 + 1) == '\'') {
                            stringBuilderArray[n2].append(c2);
                            ++i2;
                            continue;
                        }
                        bl2 = !bl2;
                        continue;
                    }
                    if (c2 == '{' && !bl2) {
                        n2 = 1;
                        if (stringBuilderArray[1] != null) continue;
                        stringBuilderArray[1] = new StringBuilder();
                        continue;
                    }
                    stringBuilderArray[n2].append(c2);
                    continue;
                }
                if (bl2) {
                    stringBuilderArray[n2].append(c2);
                    if (c2 != '\'') continue;
                    bl2 = false;
                    continue;
                }
                switch (c2) {
                    case ',': {
                        if (n2 < 3) {
                            if (stringBuilderArray[++n2] != null) continue block7;
                            stringBuilderArray[n2] = new StringBuilder();
                            continue block7;
                        }
                        stringBuilderArray[n2].append(c2);
                        continue block7;
                    }
                    case '{': {
                        ++n3;
                        stringBuilderArray[n2].append(c2);
                        continue block7;
                    }
                    case '}': {
                        if (n3 == 0) {
                            n2 = 0;
                            MessageFormatParser.makeFormat(numFormat, stringBuilderArray);
                            ++numFormat;
                            stringBuilderArray[1] = null;
                            stringBuilderArray[2] = null;
                            stringBuilderArray[3] = null;
                            continue block7;
                        }
                        --n3;
                        stringBuilderArray[n2].append(c2);
                        continue block7;
                    }
                    case ' ': {
                        if (n2 == 2 && stringBuilderArray[2].length() <= 0) continue block7;
                        stringBuilderArray[n2].append(c2);
                        continue block7;
                    }
                    case '\'': {
                        bl2 = true;
                        stringBuilderArray[n2].append(c2);
                        continue block7;
                    }
                    default: {
                        stringBuilderArray[n2].append(c2);
                    }
                }
            }
            if (n3 == 0 && n2 != 0) {
                maxOffset = -1;
                throw new IllegalArgumentException("Unmatched braces in the pattern");
            }
        }

        private static void makeFormat(int n2, StringBuilder[] stringBuilderArray) {
            int n3;
            String[] stringArray = new String[stringBuilderArray.length];
            for (n3 = 0; n3 < stringBuilderArray.length; ++n3) {
                StringBuilder stringBuilder = stringBuilderArray[n3];
                stringArray[n3] = stringBuilder != null ? stringBuilder.toString() : "";
            }
            try {
                n3 = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("can't parse argument number: " + stringArray[1], numberFormatException);
            }
            if (n3 < 0) {
                throw new IllegalArgumentException("negative argument number: " + n3);
            }
            int n4 = maxOffset;
            maxOffset = n2;
            argumentIndices.add(n3);
            I18nConversionCategory i18nConversionCategory = null;
            if (stringArray[2].length() != 0) {
                int n5 = MessageFormatParser.findKeyword(stringArray[2], TYPE_KEYWORDS);
                switch (n5) {
                    case 0: {
                        i18nConversionCategory = I18nConversionCategory.GENERAL;
                        break;
                    }
                    case 1: {
                        switch (MessageFormatParser.findKeyword(stringArray[3], NUMBER_MODIFIER_KEYWORDS)) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                break;
                            }
                            default: {
                                try {
                                    new DecimalFormat(stringArray[3], DecimalFormatSymbols.getInstance(locale));
                                    break;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    maxOffset = n4;
                                    throw illegalArgumentException;
                                }
                            }
                        }
                        i18nConversionCategory = I18nConversionCategory.NUMBER;
                        break;
                    }
                    case 2: 
                    case 3: {
                        int n6 = MessageFormatParser.findKeyword(stringArray[3], DATE_TIME_MODIFIER_KEYWORDS);
                        if (n6 < 0 || n6 >= DATE_TIME_MODIFIER_KEYWORDS.length) {
                            try {
                                new SimpleDateFormat(stringArray[3], locale);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                maxOffset = n4;
                                throw illegalArgumentException;
                            }
                        }
                        i18nConversionCategory = I18nConversionCategory.DATE;
                        break;
                    }
                    case 4: {
                        if (stringArray[3].length() == 0) {
                            throw new IllegalArgumentException("Choice Pattern requires Subformat Pattern: " + stringArray[3]);
                        }
                        try {
                            new ChoiceFormat(stringArray[3]);
                        }
                        catch (Exception exception) {
                            maxOffset = n4;
                            throw new IllegalArgumentException("Choice Pattern incorrect: " + stringArray[3], exception);
                        }
                        i18nConversionCategory = I18nConversionCategory.NUMBER;
                        break;
                    }
                    default: {
                        maxOffset = n4;
                        throw new IllegalArgumentException("unknown format type: " + stringArray[2]);
                    }
                }
            } else {
                i18nConversionCategory = I18nConversionCategory.GENERAL;
            }
            categories.add(i18nConversionCategory);
        }

        private static final int findKeyword(String string, String[] stringArray) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!string.equals(stringArray[i2])) continue;
                return i2;
            }
            String string2 = string.trim().toLowerCase(Locale.ROOT);
            if (string2 != string) {
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    if (!string2.equals(stringArray[i3])) continue;
                    return i3;
                }
            }
            return -1;
        }

        static {
            TYPE_KEYWORDS = new String[]{"", "number", "date", "time", "choice"};
            NUMBER_MODIFIER_KEYWORDS = new String[]{"", "currency", "percent", "integer"};
            DATE_TIME_MODIFIER_KEYWORDS = new String[]{"", "short", "medium", "long", "full"};
        }
    }

    private static class I18nConversion {
        public int index;
        public I18nConversionCategory category;

        public I18nConversion(int n2, I18nConversionCategory i18nConversionCategory) {
            this.index = n2;
            this.category = i18nConversionCategory;
        }

        public String toString() {
            return this.category.toString() + "(index: " + this.index + ")";
        }
    }
}

