/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.formatter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllegalFormatConversionException;
import java.util.MissingFormatArgumentException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.formatter.qual.ConversionCategory;
import org.checkerframework.checker.formatter.qual.ReturnsFormat;

public class FormatUtil {
    private static final String formatSpecifier = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static Pattern fsPattern = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    @ReturnsFormat
    public static String asFormat(String string, ConversionCategory ... conversionCategoryArray) {
        ConversionCategory[] conversionCategoryArray2 = FormatUtil.formatParameterCategories(string);
        if (conversionCategoryArray2.length != conversionCategoryArray.length) {
            throw new ExcessiveOrMissingFormatArgumentException(conversionCategoryArray.length, conversionCategoryArray2.length);
        }
        for (int i2 = 0; i2 < conversionCategoryArray.length; ++i2) {
            if (conversionCategoryArray[i2] == conversionCategoryArray2[i2]) continue;
            throw new IllegalFormatConversionCategoryException(conversionCategoryArray[i2], conversionCategoryArray2[i2]);
        }
        return string;
    }

    public static void tryFormatSatisfiability(String string) {
        String string2 = String.format(string, (Object[])null);
    }

    public static ConversionCategory[] formatParameterCategories(String string) {
        FormatUtil.tryFormatSatisfiability(string);
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        Conversion[] conversionArray = FormatUtil.parse(string);
        HashMap<Integer, ConversionCategory> hashMap = new HashMap<Integer, ConversionCategory>();
        Conversion[] objectArray = conversionArray;
        int n5 = objectArray.length;
        for (int i2 = 0; i2 < n5; ++i2) {
            Conversion conversion = objectArray[i2];
            int n6 = conversion.index();
            switch (n6) {
                case -1: {
                    break;
                }
                case 0: {
                    n2 = ++n3;
                    break;
                }
                default: {
                    n2 = n6 - 1;
                }
            }
            n4 = Math.max(n4, n2);
            hashMap.put(n2, ConversionCategory.intersect(hashMap.containsKey(n2) ? (ConversionCategory)((Object)hashMap.get(n2)) : ConversionCategory.UNUSED, conversion.category()));
        }
        ConversionCategory[] conversionCategoryArray = new ConversionCategory[n4 + 1];
        for (n5 = 0; n5 <= n4; ++n5) {
            conversionCategoryArray[n5] = hashMap.containsKey(n5) ? (ConversionCategory)((Object)hashMap.get(n5)) : ConversionCategory.UNUSED;
        }
        return conversionCategoryArray;
    }

    private static int indexFromFormat(Matcher matcher) {
        String string = matcher.group(1);
        int n2 = string != null ? Integer.parseInt(string.substring(0, string.length() - 1)) : (matcher.group(2) != null && matcher.group(2).contains(String.valueOf('<')) ? -1 : 0);
        return n2;
    }

    private static char conversionCharFromFormat(Matcher matcher) {
        String string = matcher.group(5);
        if (string == null) {
            return matcher.group(6).charAt(0);
        }
        return string.charAt(0);
    }

    private static Conversion[] parse(String string) {
        ArrayList<Conversion> arrayList = new ArrayList<Conversion>();
        Matcher matcher = fsPattern.matcher(string);
        block3: while (matcher.find()) {
            char c2 = FormatUtil.conversionCharFromFormat(matcher);
            switch (c2) {
                case '%': 
                case 'n': {
                    continue block3;
                }
            }
            arrayList.add(new Conversion(c2, FormatUtil.indexFromFormat(matcher)));
        }
        return arrayList.toArray(new Conversion[arrayList.size()]);
    }

    public static class IllegalFormatConversionCategoryException
    extends IllegalFormatConversionException {
        private static final long serialVersionUID = 17000126L;
        private final ConversionCategory expected;
        private final ConversionCategory found;

        public IllegalFormatConversionCategoryException(ConversionCategory conversionCategory, ConversionCategory conversionCategory2) {
            super(conversionCategory.chars.length() == 0 ? (char)'-' : (char)conversionCategory.chars.charAt(0), conversionCategory2.types == null ? Object.class : conversionCategory2.types[0]);
            this.expected = conversionCategory;
            this.found = conversionCategory2;
        }

        public ConversionCategory getExpected() {
            return this.expected;
        }

        public ConversionCategory getFound() {
            return this.found;
        }

        @Override
        public String getMessage() {
            return String.format("Expected category %s but found %s.", new Object[]{this.expected, this.found});
        }
    }

    public static class ExcessiveOrMissingFormatArgumentException
    extends MissingFormatArgumentException {
        private static final long serialVersionUID = 17000126L;
        private final int expected;
        private final int found;

        public ExcessiveOrMissingFormatArgumentException(int n2, int n3) {
            super("-");
            this.expected = n2;
            this.found = n3;
        }

        public int getExpected() {
            return this.expected;
        }

        public int getFound() {
            return this.found;
        }

        @Override
        public String getMessage() {
            return String.format("Expected %d arguments but found %d.", this.expected, this.found);
        }
    }

    private static class Conversion {
        private final int index;
        private final ConversionCategory cath;

        public Conversion(char c2, int n2) {
            this.index = n2;
            this.cath = ConversionCategory.fromConversionChar(c2);
        }

        int index() {
            return this.index;
        }

        ConversionCategory category() {
            return this.cath;
        }
    }
}

