/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import java.util.Locale;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.objects.XMLStringFactoryImpl;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.xml.sax.ContentHandler;
import org.xml.sax.ext.LexicalHandler;

public class XString
extends XObject
implements XMLString {
    static final long serialVersionUID = 2020470518395094525L;
    public static final XString EMPTYSTRING = new XString("");

    protected XString(Object object) {
        super(object);
    }

    public XString(String string) {
        super(string);
    }

    public int getType() {
        return 3;
    }

    public String getTypeString() {
        return "#STRING";
    }

    public boolean hasString() {
        return true;
    }

    public double num() {
        return this.toDouble();
    }

    public double toDouble() {
        XMLString xMLString = this.trim();
        double d2 = Double.NaN;
        for (int i2 = 0; i2 < xMLString.length(); ++i2) {
            char c2 = xMLString.charAt(i2);
            if (c2 == '-' || c2 == '.' || c2 >= '0' && c2 <= '9') continue;
            return d2;
        }
        try {
            d2 = Double.parseDouble(xMLString.toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d2;
    }

    public boolean bool() {
        return this.str().length() > 0;
    }

    public XMLString xstr() {
        return this;
    }

    public String str() {
        return null != this.m_obj ? (String)this.m_obj : "";
    }

    public int rtf(XPathContext xPathContext) {
        DTM dTM = xPathContext.createDocumentFragment();
        dTM.appendTextChild(this.str());
        return dTM.getDocument();
    }

    public void dispatchCharactersEvents(ContentHandler contentHandler) {
        String string = this.str();
        contentHandler.characters(string.toCharArray(), 0, string.length());
    }

    public void dispatchAsComment(LexicalHandler lexicalHandler) {
        String string = this.str();
        lexicalHandler.comment(string.toCharArray(), 0, string.length());
    }

    public int length() {
        return this.str().length();
    }

    public char charAt(int n2) {
        return this.str().charAt(n2);
    }

    public void getChars(int n2, int n3, char[] cArray, int n4) {
        this.str().getChars(n2, n3, cArray, n4);
    }

    public boolean equals(XObject xObject) {
        int n2 = xObject.getType();
        try {
            if (4 == n2) {
                return xObject.equals(this);
            }
            if (1 == n2) {
                return xObject.bool() == this.bool();
            }
            if (2 == n2) {
                return xObject.num() == this.num();
            }
        }
        catch (TransformerException transformerException) {
            throw new WrappedRuntimeException(transformerException);
        }
        return this.xstr().equals(xObject.xstr());
    }

    public boolean equals(String string) {
        return this.str().equals(string);
    }

    public boolean equals(XMLString xMLString) {
        if (xMLString != null) {
            if (!xMLString.hasString()) {
                return xMLString.equals(this.str());
            }
            return this.str().equals(xMLString.toString());
        }
        return false;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (object instanceof XNodeSet) {
            return object.equals(this);
        }
        if (object instanceof XNumber) {
            return object.equals(this);
        }
        return this.str().equals(object.toString());
    }

    public boolean equalsIgnoreCase(String string) {
        return this.str().equalsIgnoreCase(string);
    }

    public int compareTo(XMLString xMLString) {
        int n2 = this.length();
        int n3 = xMLString.length();
        int n4 = Math.min(n2, n3);
        int n5 = 0;
        int n6 = 0;
        while (n4-- != 0) {
            char c2;
            char c3 = this.charAt(n5);
            if (c3 != (c2 = xMLString.charAt(n6))) {
                return c3 - c2;
            }
            ++n5;
            ++n6;
        }
        return n2 - n3;
    }

    public int compareToIgnoreCase(XMLString xMLString) {
        throw new WrappedRuntimeException(new NoSuchMethodException("Java 1.2 method, not yet implemented"));
    }

    public boolean startsWith(String string, int n2) {
        return this.str().startsWith(string, n2);
    }

    public boolean startsWith(String string) {
        return this.startsWith(string, 0);
    }

    public boolean startsWith(XMLString xMLString, int n2) {
        int n3 = n2;
        int n4 = this.length();
        int n5 = 0;
        int n6 = xMLString.length();
        if (n2 < 0 || n2 > n4 - n6) {
            return false;
        }
        while (--n6 >= 0) {
            if (this.charAt(n3) != xMLString.charAt(n5)) {
                return false;
            }
            ++n3;
            ++n5;
        }
        return true;
    }

    public boolean startsWith(XMLString xMLString) {
        return this.startsWith(xMLString, 0);
    }

    public boolean endsWith(String string) {
        return this.str().endsWith(string);
    }

    public int hashCode() {
        return this.str().hashCode();
    }

    public int indexOf(int n2) {
        return this.str().indexOf(n2);
    }

    public int indexOf(int n2, int n3) {
        return this.str().indexOf(n2, n3);
    }

    public int lastIndexOf(int n2) {
        return this.str().lastIndexOf(n2);
    }

    public int lastIndexOf(int n2, int n3) {
        return this.str().lastIndexOf(n2, n3);
    }

    public int indexOf(String string) {
        return this.str().indexOf(string);
    }

    public int indexOf(XMLString xMLString) {
        return this.str().indexOf(xMLString.toString());
    }

    public int indexOf(String string, int n2) {
        return this.str().indexOf(string, n2);
    }

    public int lastIndexOf(String string) {
        return this.str().lastIndexOf(string);
    }

    public int lastIndexOf(String string, int n2) {
        return this.str().lastIndexOf(string, n2);
    }

    public XMLString substring(int n2) {
        return new XString(this.str().substring(n2));
    }

    public XMLString substring(int n2, int n3) {
        return new XString(this.str().substring(n2, n3));
    }

    public XMLString concat(String string) {
        return new XString(this.str().concat(string));
    }

    public XMLString toLowerCase(Locale locale) {
        return new XString(this.str().toLowerCase(locale));
    }

    public XMLString toLowerCase() {
        return new XString(this.str().toLowerCase());
    }

    public XMLString toUpperCase(Locale locale) {
        return new XString(this.str().toUpperCase(locale));
    }

    public XMLString toUpperCase() {
        return new XString(this.str().toUpperCase());
    }

    public XMLString trim() {
        return new XString(this.str().trim());
    }

    private static boolean isSpace(char c2) {
        return XMLCharacterRecognizer.isWhiteSpace(c2);
    }

    public XMLString fixWhiteSpace(boolean bl2, boolean bl3, boolean bl4) {
        int n2;
        int n3;
        int n4 = this.length();
        char[] cArray = new char[n4];
        this.getChars(0, n4, cArray, 0);
        boolean bl5 = false;
        for (n3 = 0; n3 < n4 && !XString.isSpace(cArray[n3]); ++n3) {
        }
        int n5 = n3;
        boolean bl6 = false;
        while (n3 < n4) {
            n2 = cArray[n3];
            if (XString.isSpace((char)n2)) {
                if (!bl6) {
                    if (32 != n2) {
                        bl5 = true;
                    }
                    cArray[n5++] = 32;
                    if (bl4 && n3 != 0) {
                        char c2 = cArray[n3 - 1];
                        if (c2 != '.' && c2 != '!' && c2 != '?') {
                            bl6 = true;
                        }
                    } else {
                        bl6 = true;
                    }
                } else {
                    bl5 = true;
                    bl6 = true;
                }
            } else {
                cArray[n5++] = n2;
                bl6 = false;
            }
            ++n3;
        }
        if (bl3 && 1 <= n5 && ' ' == cArray[n5 - 1]) {
            bl5 = true;
            --n5;
        }
        n2 = 0;
        if (bl2 && 0 < n5 && ' ' == cArray[0]) {
            bl5 = true;
            ++n2;
        }
        XMLStringFactory xMLStringFactory = XMLStringFactoryImpl.getFactory();
        return bl5 ? xMLStringFactory.newstr(new String(cArray, n2, n5 - n2)) : this;
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        xPathVisitor.visitStringLiteral(expressionOwner, this);
    }
}

