/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.jaxp;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.jaxp.JAXPExtensionsProvider;
import org.apache.xpath.jaxp.JAXPPrefixResolver;
import org.apache.xpath.jaxp.JAXPVariableStack;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

public class XPathExpressionImpl
implements XPathExpression {
    private XPathFunctionResolver functionResolver;
    private XPathVariableResolver variableResolver;
    private JAXPPrefixResolver prefixResolver;
    private XPath xpath;
    private boolean featureSecureProcessing = false;
    static DocumentBuilderFactory dbf = null;
    static DocumentBuilder db = null;
    static Document d = null;

    protected XPathExpressionImpl() {
    }

    protected XPathExpressionImpl(XPath xPath, JAXPPrefixResolver jAXPPrefixResolver, XPathFunctionResolver xPathFunctionResolver, XPathVariableResolver xPathVariableResolver) {
        this.xpath = xPath;
        this.prefixResolver = jAXPPrefixResolver;
        this.functionResolver = xPathFunctionResolver;
        this.variableResolver = xPathVariableResolver;
        this.featureSecureProcessing = false;
    }

    protected XPathExpressionImpl(XPath xPath, JAXPPrefixResolver jAXPPrefixResolver, XPathFunctionResolver xPathFunctionResolver, XPathVariableResolver xPathVariableResolver, boolean bl2) {
        this.xpath = xPath;
        this.prefixResolver = jAXPPrefixResolver;
        this.functionResolver = xPathFunctionResolver;
        this.variableResolver = xPathVariableResolver;
        this.featureSecureProcessing = bl2;
    }

    public void setXPath(XPath xPath) {
        this.xpath = xPath;
    }

    public Object eval(Object object, QName qName) {
        XObject xObject = this.eval(object);
        return this.getResultAsType(xObject, qName);
    }

    private XObject eval(Object object) {
        Object object2;
        XPathContext xPathContext = null;
        if (this.functionResolver != null) {
            object2 = new JAXPExtensionsProvider(this.functionResolver, this.featureSecureProcessing);
            xPathContext = new XPathContext(object2, false);
        } else {
            xPathContext = new XPathContext(false);
        }
        xPathContext.setVarStack(new JAXPVariableStack(this.variableResolver));
        object2 = null;
        Node node = (Node)object;
        if (node == null) {
            node = XPathExpressionImpl.getDummyDocument();
        }
        object2 = this.xpath.execute(xPathContext, node, (PrefixResolver)this.prefixResolver);
        return object2;
    }

    public Object evaluate(Object object, QName qName) {
        if (qName == null) {
            String string = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"returnType"});
            throw new NullPointerException(string);
        }
        if (!this.isSupported(qName)) {
            String string = XSLMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{qName.toString()});
            throw new IllegalArgumentException(string);
        }
        try {
            return this.eval(object, qName);
        }
        catch (NullPointerException nullPointerException) {
            throw new XPathExpressionException(nullPointerException);
        }
        catch (TransformerException transformerException) {
            Throwable throwable = transformerException.getException();
            if (throwable instanceof XPathFunctionException) {
                throw (XPathFunctionException)throwable;
            }
            throw new XPathExpressionException(transformerException);
        }
    }

    public String evaluate(Object object) {
        return (String)this.evaluate(object, XPathConstants.STRING);
    }

    public Object evaluate(InputSource inputSource, QName qName) {
        if (inputSource == null || qName == null) {
            String string = XSLMessages.createXPATHMessage("ER_SOURCE_RETURN_TYPE_CANNOT_BE_NULL", null);
            throw new NullPointerException(string);
        }
        if (!this.isSupported(qName)) {
            String string = XSLMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{qName.toString()});
            throw new IllegalArgumentException(string);
        }
        try {
            if (dbf == null) {
                dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
            }
            db = dbf.newDocumentBuilder();
            Document document = db.parse(inputSource);
            return this.eval(document, qName);
        }
        catch (Exception exception) {
            throw new XPathExpressionException(exception);
        }
    }

    public String evaluate(InputSource inputSource) {
        return (String)this.evaluate(inputSource, XPathConstants.STRING);
    }

    private boolean isSupported(QName qName) {
        return qName.equals(XPathConstants.STRING) || qName.equals(XPathConstants.NUMBER) || qName.equals(XPathConstants.BOOLEAN) || qName.equals(XPathConstants.NODE) || qName.equals(XPathConstants.NODESET);
    }

    private Object getResultAsType(XObject xObject, QName qName) {
        if (qName.equals(XPathConstants.STRING)) {
            return xObject.str();
        }
        if (qName.equals(XPathConstants.NUMBER)) {
            return new Double(xObject.num());
        }
        if (qName.equals(XPathConstants.BOOLEAN)) {
            return xObject.bool() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (qName.equals(XPathConstants.NODESET)) {
            return xObject.nodelist();
        }
        if (qName.equals(XPathConstants.NODE)) {
            NodeIterator nodeIterator = xObject.nodeset();
            return nodeIterator.nextNode();
        }
        String string = XSLMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{qName.toString()});
        throw new IllegalArgumentException(string);
    }

    private static Document getDummyDocument() {
        try {
            if (dbf == null) {
                dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
            }
            db = dbf.newDocumentBuilder();
            DOMImplementation dOMImplementation = db.getDOMImplementation();
            d = dOMImplementation.createDocument("http://java.sun.com/jaxp/xpath", "dummyroot", null);
            return d;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

