/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.domapi;

import javax.xml.transform.TransformerException;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.domapi.XPathResultImpl;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.res.XPATHMessages;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathExpression;

class XPathExpressionImpl
implements XPathExpression {
    private final XPath m_xpath;
    private final Document m_doc;

    XPathExpressionImpl(XPath xPath, Document document) {
        this.m_xpath = xPath;
        this.m_doc = document;
    }

    public Object evaluate(Node node, short s2, Object object) {
        if (this.m_doc != null) {
            if (node != this.m_doc && !node.getOwnerDocument().equals(this.m_doc)) {
                String string = XPATHMessages.createXPATHMessage("ER_WRONG_DOCUMENT", null);
                throw new DOMException(4, string);
            }
            short s3 = node.getNodeType();
            if (s3 != 9 && s3 != 1 && s3 != 2 && s3 != 3 && s3 != 4 && s3 != 8 && s3 != 7 && s3 != 13) {
                String string = XPATHMessages.createXPATHMessage("ER_WRONG_NODETYPE", null);
                throw new DOMException(9, string);
            }
        }
        if (!XPathResultImpl.isValidType(s2)) {
            String string = XPATHMessages.createXPATHMessage("ER_INVALID_XPATH_TYPE", new Object[]{new Integer(s2)});
            throw new XPathException(52, string);
        }
        XPathContext xPathContext = new XPathContext(false);
        if (null != this.m_doc) {
            xPathContext.getDTMHandleFromNode(this.m_doc);
        }
        XObject xObject = null;
        try {
            xObject = this.m_xpath.execute(xPathContext, node, null);
        }
        catch (TransformerException transformerException) {
            throw new XPathException(51, transformerException.getMessageAndLocation());
        }
        return new XPathResultImpl(s2, xObject, node, this.m_xpath);
    }
}

