/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp;

import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.xmlgraphics.xmp.Metadata;

public final class XMPSerializer {
    private static final String DEFAULT_ENCODING = "UTF-8";

    private XMPSerializer() {
    }

    public static void writeXML(Metadata metadata, Result result) {
        XMPSerializer.writeXML(metadata, result, false, false);
    }

    public static void writeXMPPacket(Metadata metadata, OutputStream outputStream, boolean bl2) {
        StreamResult streamResult = new StreamResult(outputStream);
        XMPSerializer.writeXML(metadata, streamResult, true, bl2);
    }

    private static void writeXML(Metadata metadata, Result result, boolean bl2, boolean bl3) {
        SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
        Transformer transformer = transformerHandler.getTransformer();
        if (bl2) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setOutputProperty("encoding", DEFAULT_ENCODING);
        try {
            transformer.setOutputProperty("indent", "yes");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        transformerHandler.setResult(result);
        transformerHandler.startDocument();
        if (bl2) {
            transformerHandler.processingInstruction("xpacket", "begin=\"\ufeff\" id=\"W5M0MpCehiHzreSzNTczkc9d\"");
        }
        metadata.toSAX(transformerHandler);
        if (bl2) {
            if (bl3) {
                transformerHandler.processingInstruction("xpacket", "end=\"r\"");
            } else {
                StringBuffer stringBuffer = new StringBuffer(101);
                stringBuffer.append('\n');
                for (int i2 = 0; i2 < 100; ++i2) {
                    stringBuffer.append(" ");
                }
                char[] cArray = stringBuffer.toString().toCharArray();
                for (int i3 = 0; i3 < 40; ++i3) {
                    transformerHandler.characters(cArray, 0, cArray.length);
                }
                transformerHandler.characters(new char[]{'\n'}, 0, 1);
                transformerHandler.processingInstruction("xpacket", "end=\"w\"");
            }
        }
        transformerHandler.endDocument();
    }
}

