/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp;

import java.util.Date;
import java.util.TimeZone;
import org.apache.xmlgraphics.util.DateFormatUtil;
import org.apache.xmlgraphics.util.QName;
import org.apache.xmlgraphics.xmp.Metadata;
import org.apache.xmlgraphics.xmp.PropertyAccess;
import org.apache.xmlgraphics.xmp.XMPArray;
import org.apache.xmlgraphics.xmp.XMPArrayType;
import org.apache.xmlgraphics.xmp.XMPProperty;
import org.apache.xmlgraphics.xmp.XMPSchema;

public class XMPSchemaAdapter {
    protected Metadata meta;
    private XMPSchema schema;
    private boolean compact = true;

    public XMPSchemaAdapter(Metadata metadata, XMPSchema xMPSchema) {
        if (metadata == null) {
            throw new NullPointerException("Parameter meta must not be null");
        }
        if (xMPSchema == null) {
            throw new NullPointerException("Parameter schema must not be null");
        }
        this.meta = metadata;
        this.schema = xMPSchema;
    }

    public XMPSchema getSchema() {
        return this.schema;
    }

    protected QName getQName(String string) {
        return new QName(this.getSchema().getNamespace(), this.getSchema().getPreferredPrefix(), string);
    }

    private void addStringToArray(String string, String string2, XMPArrayType xMPArrayType) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("'" + string + "' value must not be empty");
        }
        this.addObjectToArray(string, string2, xMPArrayType);
    }

    protected void addObjectToArray(String string, Object object, XMPArrayType xMPArrayType) {
        if (object == null) {
            throw new IllegalArgumentException("'" + string + "' value must not be null");
        }
        QName qName = this.getQName(string);
        XMPProperty xMPProperty = this.meta.getProperty(qName);
        if (xMPProperty == null) {
            xMPProperty = new XMPProperty(qName, object);
            this.meta.setProperty(xMPProperty);
            if (!this.compact) {
                xMPProperty.convertSimpleValueToArray(xMPArrayType);
            }
        } else {
            xMPProperty.convertSimpleValueToArray(xMPArrayType);
            xMPProperty.getArrayValue().add(object);
        }
    }

    protected boolean removeStringFromArray(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        QName qName = this.getQName(string);
        XMPProperty xMPProperty = this.meta.getProperty(qName);
        if (xMPProperty != null) {
            if (xMPProperty.isArray()) {
                XMPArray xMPArray = xMPProperty.getArrayValue();
                boolean bl2 = xMPArray.remove(string2);
                if (xMPArray.isEmpty()) {
                    this.meta.removeProperty(qName);
                }
                return bl2;
            }
            Object object = xMPProperty.getValue();
            if (string2.equals(object)) {
                this.meta.removeProperty(qName);
                return true;
            }
        }
        return false;
    }

    protected void addStringToSeq(String string, String string2) {
        this.addStringToArray(string, string2, XMPArrayType.SEQ);
    }

    protected void addStringToBag(String string, String string2) {
        this.addStringToArray(string, string2, XMPArrayType.BAG);
    }

    public static String formatISO8601Date(Date date) {
        return XMPSchemaAdapter.formatISO8601Date(date, TimeZone.getDefault());
    }

    public static String formatISO8601Date(Date date, TimeZone timeZone) {
        return DateFormatUtil.formatISO8601(date, timeZone);
    }

    protected void addDateToSeq(String string, Date date) {
        String string2 = XMPSchemaAdapter.formatISO8601Date(date);
        this.addStringToSeq(string, string2);
    }

    protected void setDateValue(String string, Date date) {
        String string2 = XMPSchemaAdapter.formatISO8601Date(date);
        this.setValue(string, string2);
    }

    protected Date getDateValue(String string) {
        String string2 = this.getValue(string);
        if (string2 == null) {
            return null;
        }
        return DateFormatUtil.parseISO8601Date(string2);
    }

    protected void setLangAlt(String string, String string2, String string3) {
        QName qName;
        XMPProperty xMPProperty;
        if (string2 == null) {
            string2 = "x-default";
        }
        if ((xMPProperty = this.meta.getProperty(qName = this.getQName(string))) == null) {
            if (string3 != null && string3.length() > 0) {
                xMPProperty = new XMPProperty(qName, string3);
                xMPProperty.setXMLLang(string2);
                this.meta.setProperty(xMPProperty);
            }
        } else {
            xMPProperty.convertSimpleValueToArray(XMPArrayType.ALT);
            XMPArray xMPArray = xMPProperty.getArrayValue();
            xMPArray.removeLangValue(string2);
            if (string3 != null && string3.length() > 0) {
                xMPArray.add(string3, string2);
            } else if (xMPArray.isEmpty()) {
                this.meta.removeProperty(qName);
            }
        }
    }

    protected void setValue(String string, String string2) {
        QName qName = this.getQName(string);
        XMPProperty xMPProperty = this.meta.getProperty(qName);
        if (string2 != null && string2.length() > 0) {
            if (xMPProperty != null) {
                xMPProperty.setValue(string2);
            } else {
                xMPProperty = new XMPProperty(qName, string2);
                this.meta.setProperty(xMPProperty);
            }
        } else if (xMPProperty != null) {
            this.meta.removeProperty(qName);
        }
    }

    protected String getValue(String string) {
        QName qName = this.getQName(string);
        XMPProperty xMPProperty = this.meta.getProperty(qName);
        if (xMPProperty == null) {
            return null;
        }
        return xMPProperty.getValue().toString();
    }

    protected String removeLangAlt(String string, String string2) {
        QName qName = this.getQName(string2);
        XMPProperty xMPProperty = this.meta.getProperty(qName);
        if (xMPProperty != null && string != null) {
            XMPArray xMPArray = xMPProperty.getArrayValue();
            if (xMPArray != null) {
                String string3 = xMPArray.removeLangValue(string);
                if (xMPArray.isEmpty()) {
                    this.meta.removeProperty(qName);
                }
                return string3;
            }
            String string4 = xMPProperty.getValue().toString();
            if (string.equals(xMPProperty.getXMLLang())) {
                this.meta.removeProperty(qName);
            }
            return string4;
        }
        return null;
    }

    protected String getLangAlt(String string, String string2) {
        XMPProperty xMPProperty = this.meta.getProperty(this.getQName(string2));
        if (xMPProperty == null) {
            return null;
        }
        XMPArray xMPArray = xMPProperty.getArrayValue();
        if (xMPArray != null) {
            return xMPArray.getLangValue(string);
        }
        return xMPProperty.getValue().toString();
    }

    protected PropertyAccess findQualifiedStructure(String string, QName qName, String string2) {
        XMPProperty xMPProperty = this.meta.getProperty(this.getQName(string));
        if (xMPProperty != null) {
            PropertyAccess propertyAccess;
            XMPProperty xMPProperty2;
            XMPArray xMPArray = xMPProperty.getArrayValue();
            if (xMPArray != null) {
                int n2 = xMPArray.getSize();
                for (int i2 = 0; i2 < n2; ++i2) {
                    PropertyAccess propertyAccess2;
                    XMPProperty xMPProperty3;
                    Object object = xMPArray.getValue(i2);
                    if (!(object instanceof PropertyAccess) || (xMPProperty3 = (propertyAccess2 = (PropertyAccess)object).getProperty(qName)) == null || !xMPProperty3.getValue().equals(string2)) continue;
                    return propertyAccess2;
                }
            } else if (xMPProperty.getStructureValue() != null && (xMPProperty2 = (propertyAccess = xMPProperty.getStructureValue()).getProperty(qName)) != null && xMPProperty2.getValue().equals(string2)) {
                return propertyAccess;
            }
        }
        return null;
    }

    protected Object findQualifiedValue(String string, QName qName, String string2) {
        XMPProperty xMPProperty;
        PropertyAccess propertyAccess = this.findQualifiedStructure(string, qName, string2);
        if (propertyAccess != null && (xMPProperty = propertyAccess.getValueProperty()) != null) {
            return xMPProperty.getValue();
        }
        return null;
    }

    protected Object[] getObjectArray(String string) {
        XMPProperty xMPProperty = this.meta.getProperty(this.getQName(string));
        if (xMPProperty == null) {
            return null;
        }
        XMPArray xMPArray = xMPProperty.getArrayValue();
        if (xMPArray != null) {
            return xMPArray.toObjectArray();
        }
        return new Object[]{xMPProperty.getValue()};
    }

    protected String[] getStringArray(String string) {
        Object[] objectArray = this.getObjectArray(string);
        if (objectArray == null) {
            return null;
        }
        String[] stringArray = new String[objectArray.length];
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (object instanceof PropertyAccess) {
                XMPProperty xMPProperty = ((PropertyAccess)object).getValueProperty();
                stringArray[i2] = xMPProperty.getValue().toString();
                continue;
            }
            stringArray[i2] = object.toString();
        }
        return stringArray;
    }

    protected Date[] getDateArray(String string) {
        Object[] objectArray = this.getObjectArray(string);
        if (objectArray == null) {
            return null;
        }
        Date[] dateArray = new Date[objectArray.length];
        int n2 = dateArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            dateArray[i2] = object instanceof Date ? (Date)((Date)object).clone() : DateFormatUtil.parseISO8601Date(object.toString());
        }
        return dateArray;
    }

    public void setCompact(boolean bl2) {
        this.compact = bl2;
    }
}

