/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.xmlgraphics.xmp.Metadata;
import org.apache.xmlgraphics.xmp.XMPParser;

public final class XMPPacketParser {
    private static final byte[] PACKET_HEADER;
    private static final byte[] PACKET_HEADER_END;
    private static final byte[] PACKET_TRAILER;

    private XMPPacketParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Metadata parse(InputStream inputStream) {
        Metadata metadata;
        boolean bl2;
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(bl2 = XMPPacketParser.skipAfter(inputStream, PACKET_HEADER))) {
            return null;
        }
        if (!XMPPacketParser.skipAfter(inputStream, PACKET_HEADER_END)) {
            throw new IOException("Invalid XMP packet header!");
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            if (!XMPPacketParser.skipAfter(inputStream, PACKET_TRAILER, byteArrayOutputStream)) {
                throw new IOException("XMP packet not properly terminated!");
            }
            metadata = XMPParser.parseXMP(new StreamSource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
        }
        finally {
            IOUtils.closeQuietly(byteArrayOutputStream);
        }
        return metadata;
    }

    private static boolean skipAfter(InputStream inputStream, byte[] byArray) {
        return XMPPacketParser.skipAfter(inputStream, byArray, null);
    }

    private static boolean skipAfter(InputStream inputStream, byte[] byArray, OutputStream outputStream) {
        int n2;
        int n3 = 0;
        int n4 = byArray.length;
        while ((n2 = inputStream.read()) >= 0) {
            if (n2 == byArray[n3]) {
                if (++n3 != n4) continue;
                return true;
            }
            if (outputStream != null) {
                if (n3 > 0) {
                    outputStream.write(byArray, 0, n3);
                }
                outputStream.write(n2);
            }
            n3 = 0;
        }
        return false;
    }

    static {
        try {
            PACKET_HEADER = "<?xpacket begin=".getBytes("US-ASCII");
            PACKET_HEADER_END = "?>".getBytes("US-ASCII");
            PACKET_TRAILER = "<?xpacket".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Incompatible JVM! US-ASCII encoding not supported.");
        }
    }
}

