/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Stack;
import org.apache.xmlgraphics.util.QName;
import org.apache.xmlgraphics.xmp.Metadata;
import org.apache.xmlgraphics.xmp.PropertyAccess;
import org.apache.xmlgraphics.xmp.XMPArray;
import org.apache.xmlgraphics.xmp.XMPArrayType;
import org.apache.xmlgraphics.xmp.XMPComplexValue;
import org.apache.xmlgraphics.xmp.XMPProperty;
import org.apache.xmlgraphics.xmp.XMPStructure;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XMPHandler
extends DefaultHandler {
    private Metadata meta;
    private StringBuffer content = new StringBuffer();
    private Stack attributesStack = new Stack();
    private Stack nestingInfoStack = new Stack();
    private Stack contextStack = new Stack();

    public Metadata getMetadata() {
        return this.meta;
    }

    private boolean hasComplexContent() {
        Object e2 = this.contextStack.peek();
        return !(e2 instanceof QName);
    }

    private PropertyAccess getCurrentProperties() {
        Object e2 = this.contextStack.peek();
        if (e2 instanceof PropertyAccess) {
            return (PropertyAccess)e2;
        }
        return null;
    }

    private QName getCurrentPropName() {
        Object e2 = this.contextStack.peek();
        if (e2 instanceof QName) {
            return (QName)e2;
        }
        return null;
    }

    private QName popCurrentPropName() {
        Object e2 = this.contextStack.pop();
        this.nestingInfoStack.pop();
        if (e2 instanceof QName) {
            return (QName)e2;
        }
        throw new SAXException("Invalid XMP structure. Property name expected");
    }

    private XMPStructure getCurrentStructure() {
        Object e2 = this.contextStack.peek();
        if (e2 instanceof XMPStructure) {
            return (XMPStructure)e2;
        }
        return null;
    }

    private XMPArray getCurrentArray(boolean bl2) {
        Object e2 = this.contextStack.peek();
        if (e2 instanceof XMPArray) {
            return (XMPArray)e2;
        }
        if (bl2) {
            throw new SAXException("Invalid XMP structure. Not in array");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        super.startElement(string, string2, string3, attributes);
        this.content.setLength(0);
        this.attributesStack.push(new AttributesImpl(attributes));
        if ("adobe:ns:meta/".equals(string)) {
            if (!"xmpmeta".equals(string2)) {
                throw new SAXException("Expected x:xmpmeta element, not " + string3);
            }
            if (this.meta != null) {
                throw new SAXException("Invalid XMP document. Root already received earlier.");
            }
            this.meta = new Metadata();
            this.contextStack.push(this.meta);
            this.nestingInfoStack.push("metadata");
            return;
        } else if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(string)) {
            if ("RDF".equals(string2)) {
                if (this.meta != null) return;
                this.meta = new Metadata();
                this.contextStack.push(this.meta);
                this.nestingInfoStack.push("metadata");
                return;
            } else if ("Description".equals(string2)) {
                String string4 = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
                int n2 = attributes.getLength();
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string5 = attributes.getURI(i2);
                    if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(string5) || "http://www.w3.org/2000/xmlns/".equals(string5) || "".equals(string5)) continue;
                    String string6 = attributes.getQName(i2);
                    String string7 = attributes.getValue(i2);
                    XMPProperty xMPProperty = new XMPProperty(new QName(string5, string6), string7);
                    this.getCurrentProperties().setProperty(xMPProperty);
                }
                if (this.contextStack.peek().equals(this.meta)) return;
                if (string4 != null) {
                    throw new SAXException("Nested rdf:Description elements may not have an about property");
                }
                this.startStructure();
                return;
            } else if ("Seq".equals(string2)) {
                XMPArray xMPArray = new XMPArray(XMPArrayType.SEQ);
                this.contextStack.push(xMPArray);
                this.nestingInfoStack.push("Seq");
                return;
            } else if ("Bag".equals(string2)) {
                XMPArray xMPArray = new XMPArray(XMPArrayType.BAG);
                this.contextStack.push(xMPArray);
                this.nestingInfoStack.push("Bag");
                return;
            } else if ("Alt".equals(string2)) {
                XMPArray xMPArray = new XMPArray(XMPArrayType.ALT);
                this.contextStack.push(xMPArray);
                this.nestingInfoStack.push("Alt");
                return;
            } else {
                if ("li".equals(string2)) return;
                if (!"value".equals(string2)) throw new SAXException("Unexpected element in the RDF namespace: " + string2);
                QName qName = new QName(string, string3);
                this.contextStack.push(qName);
                this.nestingInfoStack.push("prop:" + qName);
            }
            return;
        } else {
            if (this.getCurrentPropName() != null) {
                this.startStructure();
            }
            QName qName = new QName(string, string3);
            this.contextStack.push(qName);
            this.nestingInfoStack.push("prop:" + qName);
        }
    }

    private void startStructure() {
        XMPStructure xMPStructure = new XMPStructure();
        this.contextStack.push(xMPStructure);
        this.nestingInfoStack.push("struct");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void endElement(String string, String string2, String string3) {
        Attributes attributes = (Attributes)this.attributesStack.pop();
        if (!"adobe:ns:meta/".equals(string)) {
            if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(string) && !"value".equals(string2)) {
                if ("li".equals(string2)) {
                    XMPStructure xMPStructure = this.getCurrentStructure();
                    if (xMPStructure != null) {
                        this.contextStack.pop();
                        this.nestingInfoStack.pop();
                        this.getCurrentArray(true).add(xMPStructure);
                    } else {
                        String string4 = this.content.toString().trim();
                        if (string4.length() > 0) {
                            String string5 = attributes.getValue("http://www.w3.org/XML/1998/namespace", "lang");
                            if (string5 != null) {
                                this.getCurrentArray(true).add(string4, string5);
                            } else {
                                this.getCurrentArray(true).add(string4);
                            }
                        } else {
                            String string6 = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
                            if (string6 != null) {
                                try {
                                    URI uRI = new URI(string6);
                                    this.getCurrentArray(true).add(uRI);
                                }
                                catch (URISyntaxException uRISyntaxException) {
                                    throw new SAXException("rdf:resource value is not a well-formed URI", uRISyntaxException);
                                }
                            }
                        }
                    }
                } else if ("Description".equals(string2)) {
                    // empty if block
                }
            } else {
                XMPProperty xMPProperty;
                if (this.hasComplexContent()) {
                    Object e2 = this.contextStack.pop();
                    this.nestingInfoStack.pop();
                    QName qName = this.popCurrentPropName();
                    if (!(e2 instanceof XMPComplexValue)) throw new UnsupportedOperationException("NYI");
                    XMPComplexValue xMPComplexValue = (XMPComplexValue)e2;
                    xMPProperty = new XMPProperty(qName, xMPComplexValue);
                } else {
                    QName qName = this.popCurrentPropName();
                    String string7 = this.content.toString().trim();
                    xMPProperty = new XMPProperty(qName, string7);
                    String string8 = attributes.getValue("http://www.w3.org/XML/1998/namespace", "lang");
                    String string9 = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
                    if (string8 != null) {
                        xMPProperty.setXMLLang(string8);
                    }
                    if (string9 != null) {
                        try {
                            URI uRI = new URI(string9);
                            xMPProperty.setValue(uRI);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            throw new SAXException("rdf:resource value is not a well-formed URI", uRISyntaxException);
                        }
                    }
                }
                if (xMPProperty.getName() == null) {
                    throw new IllegalStateException("No content in XMP property");
                }
                assert (this.getCurrentProperties() != null) : "no current property";
                this.getCurrentProperties().setProperty(xMPProperty);
            }
        }
        this.content.setLength(0);
        super.endElement(string, string2, string3);
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        this.content.append(cArray, n2, n3);
    }
}

