/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlgraphics.xmp.XMPArrayType;
import org.apache.xmlgraphics.xmp.XMPComplexValue;
import org.apache.xmlgraphics.xmp.XMPStructure;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class XMPArray
extends XMPComplexValue {
    private XMPArrayType type;
    private List values = new ArrayList();
    private List xmllang = new ArrayList();

    public XMPArray(XMPArrayType xMPArrayType) {
        this.type = xMPArrayType;
    }

    public XMPArrayType getType() {
        return this.type;
    }

    public Object getValue(int n2) {
        return this.values.get(n2);
    }

    public XMPStructure getStructure(int n2) {
        return (XMPStructure)this.values.get(n2);
    }

    @Override
    public Object getSimpleValue() {
        if (this.values.size() == 1) {
            return this.getValue(0);
        }
        if (this.values.size() > 1) {
            return this.getLangValue("x-default");
        }
        return null;
    }

    private String getParentLanguage(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(45);
        if (n2 > 0) {
            String string2 = string.substring(0, n2);
            return string2;
        }
        return null;
    }

    public String getLangValue(String string) {
        String string2 = null;
        String string3 = null;
        int n2 = this.values.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string4;
            String string5 = (String)this.xmllang.get(i2);
            if (string5 == null && string == null || string5 != null && string5.equals(string)) {
                string2 = this.values.get(i2).toString();
                break;
            }
            if (string5 == null || string == null || (string4 = this.getParentLanguage(string5)) == null || !string4.equals(string)) continue;
            string3 = this.values.get(i2).toString();
        }
        if (string != null && string2 == null && string3 != null) {
            string2 = string3;
        }
        if (string == null && string2 == null && (string2 = this.getLangValue("x-default")) == null && this.values.size() > 0) {
            string2 = this.getValue(0).toString();
        }
        return string2;
    }

    public String removeLangValue(String string) {
        if (string == null || "".equals(string)) {
            string = "x-default";
        }
        int n2 = this.values.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = (String)this.xmllang.get(i2);
            if ((!"x-default".equals(string) || string2 != null) && !string.equals(string2)) continue;
            String string3 = (String)this.values.remove(i2);
            this.xmllang.remove(i2);
            return string3;
        }
        return null;
    }

    public void add(Object object) {
        this.values.add(object);
        this.xmllang.add(null);
    }

    public boolean remove(String string) {
        int n2 = this.values.indexOf(string);
        if (n2 >= 0) {
            this.values.remove(n2);
            this.xmllang.remove(n2);
            return true;
        }
        return false;
    }

    public void add(String string, String string2) {
        this.values.add(string);
        this.xmllang.add(string2);
    }

    public int getSize() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public Object[] toObjectArray() {
        Object[] objectArray = new Object[this.getSize()];
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = this.getValue(i2);
        }
        return objectArray;
    }

    @Override
    public void toSAX(ContentHandler contentHandler) {
        AttributesImpl attributesImpl = new AttributesImpl();
        contentHandler.startElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", this.type.getName(), "rdf:" + this.type.getName(), attributesImpl);
        int n2 = this.values.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = (String)this.xmllang.get(i2);
            attributesImpl.clear();
            Object e2 = this.values.get(i2);
            if (string != null) {
                attributesImpl.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", string);
            }
            if (e2 instanceof URI) {
                attributesImpl.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", "rdf:resource", "CDATA", ((URI)e2).toString());
            }
            contentHandler.startElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "li", "rdf:li", attributesImpl);
            if (e2 instanceof XMPComplexValue) {
                ((XMPComplexValue)e2).toSAX(contentHandler);
            } else if (!(e2 instanceof URI)) {
                String string2 = (String)this.values.get(i2);
                char[] cArray = string2.toCharArray();
                contentHandler.characters(cArray, 0, cArray.length);
            }
            contentHandler.endElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "li", "rdf:li");
        }
        contentHandler.endElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", this.type.getName(), "rdf:" + this.type.getName());
    }

    public String toString() {
        return "XMP array: " + this.type + ", " + this.getSize();
    }
}

