/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util.uri;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.util.io.Base64DecodeStream;

public class DataURIResolver
implements URIResolver {
    private static final Log LOG = LogFactory.getLog(URIResolver.class);

    @Override
    public Source resolve(String string, String string2) {
        if (string.startsWith("data:")) {
            return this.parseDataURI(string);
        }
        return null;
    }

    private Source parseDataURI(String string) {
        int n2 = string.indexOf(44);
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        if (string2.endsWith(";base64")) {
            byte[] byArray = new byte[]{};
            try {
                byArray = string3.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Base64DecodeStream base64DecodeStream = new Base64DecodeStream(byteArrayInputStream);
            return new StreamSource(base64DecodeStream, string);
        }
        String string4 = "UTF-8";
        int n3 = string2.indexOf(";charset=");
        if (n3 > 0) {
            string4 = string2.substring(n3 + 9);
        }
        try {
            String string5 = URLDecoder.decode(string3, string4);
            return new StreamSource(new StringReader(string5), string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.warn(illegalArgumentException.getMessage());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.warn(unsupportedEncodingException.getMessage());
        }
        return null;
    }
}

