/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util.uri;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.xmlgraphics.util.Service;

public class CommonURIResolver
implements URIResolver {
    private final List uriResolvers = new LinkedList();

    public CommonURIResolver() {
        Iterator<Object> iterator = Service.providers(URIResolver.class);
        while (iterator.hasNext()) {
            URIResolver uRIResolver = (URIResolver)iterator.next();
            this.register(uRIResolver);
        }
    }

    public static CommonURIResolver getDefaultURIResolver() {
        return DefaultInstanceHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source resolve(String string, String string2) {
        List list = this.uriResolvers;
        synchronized (list) {
            for (Object e2 : this.uriResolvers) {
                URIResolver uRIResolver = (URIResolver)e2;
                try {
                    Source source = uRIResolver.resolve(string, string2);
                    if (source == null) continue;
                    return source;
                }
                catch (TransformerException transformerException) {
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(URIResolver uRIResolver) {
        List list = this.uriResolvers;
        synchronized (list) {
            this.uriResolvers.add(uRIResolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(URIResolver uRIResolver) {
        List list = this.uriResolvers;
        synchronized (list) {
            this.uriResolvers.remove(uRIResolver);
        }
    }

    private static final class DefaultInstanceHolder {
        private static final CommonURIResolver INSTANCE = new CommonURIResolver();

        private DefaultInstanceHolder() {
        }
    }
}

