/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util.io;

import java.io.FilterInputStream;
import java.io.InputStream;

public class SubInputStream
extends FilterInputStream {
    private long bytesToRead;
    private boolean closeUnderlying;

    public SubInputStream(InputStream inputStream, long l2, boolean bl2) {
        super(inputStream);
        this.bytesToRead = l2;
        this.closeUnderlying = bl2;
    }

    public SubInputStream(InputStream inputStream, long l2) {
        this(inputStream, l2, false);
    }

    @Override
    public int read() {
        if (this.bytesToRead > 0L) {
            int n2 = super.read();
            if (n2 >= 0) {
                --this.bytesToRead;
                return n2;
            }
            return -1;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (this.bytesToRead == 0L) {
            return -1;
        }
        int n4 = (int)Math.min(this.bytesToRead, (long)n3);
        int n5 = super.read(byArray, n2, n4);
        if (n5 >= 0) {
            this.bytesToRead -= (long)n5;
        }
        return n5;
    }

    @Override
    public long skip(long l2) {
        long l3 = Math.min(this.bytesToRead, l2);
        long l4 = super.skip(l3);
        this.bytesToRead -= l4;
        return l4;
    }

    @Override
    public void close() {
        this.bytesToRead = 0L;
        if (this.closeUnderlying) {
            super.close();
        }
    }
}

