/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util.io;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class Base64EncodeStream
extends OutputStream {
    private static final byte[] PEM_ARRAY = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    byte[] atom = new byte[3];
    int atomLen;
    byte[] encodeBuf = new byte[4];
    int lineLen;
    PrintStream out;
    boolean closeOutOnClose;

    public Base64EncodeStream(OutputStream outputStream) {
        try {
            this.out = new PrintStream(outputStream, false, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.closeOutOnClose = true;
    }

    public Base64EncodeStream(OutputStream outputStream, boolean bl2) {
        try {
            this.out = new PrintStream(outputStream, false, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.closeOutOnClose = bl2;
    }

    @Override
    public void close() {
        if (this.out != null) {
            this.encodeAtom();
            this.out.flush();
            if (this.closeOutOnClose) {
                this.out.close();
            }
            this.out = null;
        }
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void write(int n2) {
        this.atom[this.atomLen++] = (byte)n2;
        if (this.atomLen == 3) {
            this.encodeAtom();
        }
    }

    @Override
    public void write(byte[] byArray) {
        this.encodeFromArray(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.encodeFromArray(byArray, n2, n3);
    }

    void encodeAtom() {
        switch (this.atomLen) {
            case 0: {
                return;
            }
            case 1: {
                byte by2 = this.atom[0];
                this.encodeBuf[0] = PEM_ARRAY[by2 >>> 2 & 0x3F];
                this.encodeBuf[1] = PEM_ARRAY[by2 << 4 & 0x30];
                this.encodeBuf[3] = 61;
                this.encodeBuf[2] = 61;
                break;
            }
            case 2: {
                byte by3 = this.atom[0];
                byte by4 = this.atom[1];
                this.encodeBuf[0] = PEM_ARRAY[by3 >>> 2 & 0x3F];
                this.encodeBuf[1] = PEM_ARRAY[by3 << 4 & 0x30 | by4 >>> 4 & 0xF];
                this.encodeBuf[2] = PEM_ARRAY[by4 << 2 & 0x3C];
                this.encodeBuf[3] = 61;
                break;
            }
            default: {
                byte by5 = this.atom[0];
                byte by6 = this.atom[1];
                byte by7 = this.atom[2];
                this.encodeBuf[0] = PEM_ARRAY[by5 >>> 2 & 0x3F];
                this.encodeBuf[1] = PEM_ARRAY[by5 << 4 & 0x30 | by6 >>> 4 & 0xF];
                this.encodeBuf[2] = PEM_ARRAY[by6 << 2 & 0x3C | by7 >>> 6 & 3];
                this.encodeBuf[3] = PEM_ARRAY[by7 & 0x3F];
            }
        }
        if (this.lineLen == 64) {
            this.out.println();
            this.lineLen = 0;
        }
        this.out.write(this.encodeBuf);
        this.lineLen += 4;
        this.atomLen = 0;
    }

    void encodeFromArray(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (this.atomLen != 0) {
            switch (this.atomLen) {
                case 1: {
                    this.atom[1] = byArray[n2++];
                    ++this.atomLen;
                    if (--n3 == 0) {
                        return;
                    }
                    this.atom[2] = byArray[n2++];
                    --n3;
                    ++this.atomLen;
                    break;
                }
                case 2: {
                    this.atom[2] = byArray[n2++];
                    --n3;
                    ++this.atomLen;
                    break;
                }
            }
            this.encodeAtom();
        }
        while (n3 >= 3) {
            byte by2 = byArray[n2++];
            byte by3 = byArray[n2++];
            byte by4 = byArray[n2++];
            this.encodeBuf[0] = PEM_ARRAY[by2 >>> 2 & 0x3F];
            this.encodeBuf[1] = PEM_ARRAY[by2 << 4 & 0x30 | by3 >>> 4 & 0xF];
            this.encodeBuf[2] = PEM_ARRAY[by3 << 2 & 0x3C | by4 >>> 6 & 3];
            this.encodeBuf[3] = PEM_ARRAY[by4 & 0x3F];
            this.out.write(this.encodeBuf);
            this.lineLen += 4;
            if (this.lineLen == 64) {
                this.out.println();
                this.lineLen = 0;
            }
            n3 -= 3;
        }
        switch (n3) {
            case 1: {
                this.atom[0] = byArray[n2];
                break;
            }
            case 2: {
                this.atom[0] = byArray[n2];
                this.atom[1] = byArray[n2 + 1];
                break;
            }
        }
        this.atomLen = n3;
    }
}

