/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util.io;

import java.io.InputStream;

public class Base64DecodeStream
extends InputStream {
    InputStream src;
    private static final byte[] PEM_ARRAY;
    byte[] decodeBuffer = new byte[4];
    byte[] outBuffer = new byte[3];
    int outOffset = 3;
    boolean eof;

    public Base64DecodeStream(InputStream inputStream) {
        this.src = inputStream;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() {
        this.eof = true;
    }

    @Override
    public int available() {
        return 3 - this.outOffset;
    }

    @Override
    public int read() {
        if (this.outOffset == 3 && (this.eof || this.getNextAtom())) {
            this.eof = true;
            return -1;
        }
        return this.outBuffer[this.outOffset++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        for (n4 = 0; n4 < n3; ++n4) {
            if (this.outOffset == 3 && (this.eof || this.getNextAtom())) {
                this.eof = true;
                if (n4 == 0) {
                    return -1;
                }
                return n4;
            }
            byArray[n2 + n4] = this.outBuffer[this.outOffset++];
        }
        return n4;
    }

    final boolean getNextAtom() {
        int n2 = 0;
        while (n2 != 4) {
            int n3 = this.src.read(this.decodeBuffer, n2, 4 - n2);
            if (n3 == -1) {
                return true;
            }
            int n4 = n2;
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                if (this.decodeBuffer[i2] == 10 || this.decodeBuffer[i2] == 13 || this.decodeBuffer[i2] == 32) continue;
                this.decodeBuffer[n4++] = this.decodeBuffer[i2];
            }
            n2 = n4;
        }
        byte by2 = PEM_ARRAY[this.decodeBuffer[0] & 0xFF];
        byte by3 = PEM_ARRAY[this.decodeBuffer[1] & 0xFF];
        byte by4 = PEM_ARRAY[this.decodeBuffer[2] & 0xFF];
        byte by5 = PEM_ARRAY[this.decodeBuffer[3] & 0xFF];
        this.outBuffer[0] = (byte)(by2 << 2 | by3 >>> 4);
        this.outBuffer[1] = (byte)(by3 << 4 | by4 >>> 2);
        this.outBuffer[2] = (byte)(by4 << 6 | by5);
        if (this.decodeBuffer[3] != 61) {
            this.outOffset = 0;
        } else if (this.decodeBuffer[2] == 61) {
            this.outBuffer[2] = this.outBuffer[0];
            this.outOffset = 2;
            this.eof = true;
        } else {
            this.outBuffer[2] = this.outBuffer[1];
            this.outBuffer[1] = this.outBuffer[0];
            this.outOffset = 1;
            this.eof = true;
        }
        return false;
    }

    static {
        int n2;
        int n3;
        PEM_ARRAY = new byte[256];
        for (n3 = 0; n3 < PEM_ARRAY.length; ++n3) {
            Base64DecodeStream.PEM_ARRAY[n3] = -1;
        }
        n3 = 0;
        for (n2 = 65; n2 <= 90; n2 = (int)((char)(n2 + 1))) {
            Base64DecodeStream.PEM_ARRAY[n2] = (byte)n3++;
        }
        for (n2 = 97; n2 <= 122; n2 = (int)((char)(n2 + 1))) {
            Base64DecodeStream.PEM_ARRAY[n2] = (byte)n3++;
        }
        for (n2 = 48; n2 <= 57; n2 = (int)((char)(n2 + 1))) {
            Base64DecodeStream.PEM_ARRAY[n2] = (byte)n3++;
        }
        Base64DecodeStream.PEM_ARRAY[43] = (byte)n3++;
        Base64DecodeStream.PEM_ARRAY[47] = (byte)n3++;
    }
}

