/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util.io;

import java.io.FilterOutputStream;
import java.io.OutputStream;
import org.apache.xmlgraphics.util.io.Finalizable;

public class ASCIIHexOutputStream
extends FilterOutputStream
implements Finalizable {
    private static final int EOL = 10;
    private static final int EOD = 62;
    private static final int ZERO = 48;
    private static final int NINE = 57;
    private static final int A = 65;
    private static final int ADIFF = 7;
    private int posinline;

    public ASCIIHexOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void write(int n2) {
        int n3 = (((n2 &= 0xFF) & 0xF0) >> 4) + 48;
        if (n3 > 57) {
            n3 += 7;
        }
        this.out.write(n3);
        int n4 = (n2 & 0xF) + 48;
        if (n4 > 57) {
            n4 += 7;
        }
        this.out.write(n4);
        ++this.posinline;
        this.checkLineWrap();
    }

    private void checkLineWrap() {
        if (this.posinline >= 40) {
            this.out.write(10);
            this.posinline = 0;
        }
    }

    @Override
    public void finalizeStream() {
        this.checkLineWrap();
        super.write(62);
        this.flush();
        if (this.out instanceof Finalizable) {
            ((Finalizable)((Object)this.out)).finalizeStream();
        }
    }

    @Override
    public void close() {
        this.finalizeStream();
        super.close();
    }
}

