/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util.io;

import java.io.FilterOutputStream;
import java.io.OutputStream;
import org.apache.xmlgraphics.util.io.ASCII85Constants;
import org.apache.xmlgraphics.util.io.Finalizable;

public class ASCII85OutputStream
extends FilterOutputStream
implements ASCII85Constants,
Finalizable {
    private static final boolean DEBUG = false;
    private int pos;
    private long buffer;
    private int posinline;
    private int bw;

    public ASCII85OutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void write(int n2) {
        this.buffer = this.pos == 0 ? (this.buffer += (long)(n2 << 24) & 0xFF000000L) : (this.pos == 1 ? (this.buffer += (long)(n2 << 16) & 0xFF0000L) : (this.pos == 2 ? (this.buffer += (long)(n2 << 8) & 0xFF00L) : (this.buffer += (long)n2 & 0xFFL)));
        ++this.pos;
        if (this.pos > 3) {
            this.checkedWrite(this.convertWord(this.buffer));
            this.buffer = 0L;
            this.pos = 0;
        }
    }

    private void checkedWrite(byte[] byArray) {
        this.checkedWrite(byArray, byArray.length, false);
    }

    private void checkedWrite(byte[] byArray, boolean bl2) {
        this.checkedWrite(byArray, byArray.length, bl2);
    }

    private void checkedWrite(byte[] byArray, int n2) {
        this.checkedWrite(byArray, n2, false);
    }

    private void checkedWrite(byte[] byArray, int n2, boolean bl2) {
        if (this.posinline + n2 > 80) {
            int n3;
            int n4 = n3 = bl2 ? 0 : n2 - (this.posinline + n2 - 80);
            if (n3 > 0) {
                this.out.write(byArray, 0, n3);
            }
            this.out.write(10);
            ++this.bw;
            int n5 = n2 - n3;
            if (n5 > 0) {
                this.out.write(byArray, n3, n5);
            }
            this.posinline = n5;
        } else {
            this.out.write(byArray, 0, n2);
            this.posinline += n2;
        }
        this.bw += n2;
    }

    private byte[] convertWord(long l2) {
        if ((l2 &= 0xFFFFFFFFFFFFFFFFL) == 0L) {
            return ZERO_ARRAY;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        byte by2 = (byte)(l2 / POW85[0] & 0xFFL);
        byte by3 = (byte)((l2 - (long)by2 * POW85[0]) / POW85[1] & 0xFFL);
        byte by4 = (byte)((l2 - (long)by2 * POW85[0] - (long)by3 * POW85[1]) / POW85[2] & 0xFFL);
        byte by5 = (byte)((l2 - (long)by2 * POW85[0] - (long)by3 * POW85[1] - (long)by4 * POW85[2]) / POW85[3] & 0xFFL);
        byte by6 = (byte)(l2 - (long)by2 * POW85[0] - (long)by3 * POW85[1] - (long)by4 * POW85[2] - (long)by5 * POW85[3] & 0xFFL);
        byte[] byArray = new byte[]{(byte)(by2 + 33), (byte)(by3 + 33), (byte)(by4 + 33), (byte)(by5 + 33), (byte)(by6 + 33)};
        return byArray;
    }

    @Override
    public void finalizeStream() {
        if (this.pos > 0) {
            byte[] byArray;
            int n2 = this.pos;
            if (this.buffer != 0L) {
                byArray = this.convertWord(this.buffer);
            } else {
                byArray = new byte[5];
                for (int i2 = 0; i2 < 5; ++i2) {
                    byArray[i2] = 33;
                }
            }
            this.checkedWrite(byArray, n2 + 1);
        }
        this.checkedWrite(EOD, true);
        this.flush();
        if (this.out instanceof Finalizable) {
            ((Finalizable)((Object)this.out)).finalizeStream();
        }
    }

    @Override
    public void close() {
        this.finalizeStream();
        super.close();
    }
}

