/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.xmlgraphics.util.io.ASCII85Constants;

public class ASCII85InputStream
extends InputStream
implements ASCII85Constants {
    private InputStream in;
    private boolean eodReached;
    private int[] b = new int[4];
    private int bSize;
    private int bIndex;

    public ASCII85InputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    @Override
    public int read() {
        int n2;
        if (this.bIndex >= this.bSize) {
            if (this.eodReached) {
                return -1;
            }
            this.readNextTuple();
            if (this.bSize == 0) {
                if (!this.eodReached) {
                    throw new IllegalStateException("Internal error");
                }
                return -1;
            }
        }
        n2 = (n2 = this.b[this.bIndex]) < 0 ? 256 + n2 : n2;
        ++this.bIndex;
        return n2;
    }

    private int filteredRead() {
        int n2;
        block4: while (true) {
            n2 = this.in.read();
            switch (n2) {
                case 0: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    continue block4;
                }
                case 122: 
                case 126: {
                    return n2;
                }
            }
            break;
        }
        if (n2 >= 33 && n2 <= 117) {
            return n2;
        }
        throw new IOException("Illegal character detected: " + n2);
    }

    private void handleEOD() {
        int n2 = this.in.read();
        if (n2 != EOD[1]) {
            throw new IOException("'>' expected after '~' (EOD)");
        }
        this.eodReached = true;
        this.bSize = 0;
        this.bIndex = 0;
    }

    private void readNextTuple() {
        long l2 = 0L;
        int n2 = this.filteredRead();
        if (n2 == 122) {
            Arrays.fill(this.b, 0);
            this.bSize = 4;
            this.bIndex = 0;
        } else if (n2 == EOD[0]) {
            this.handleEOD();
        } else {
            int n3;
            int n4 = 0;
            l2 = (long)(n2 - 33) * POW85[n4];
            ++n4;
            while (n4 < 5) {
                n2 = this.filteredRead();
                if (n2 == EOD[0]) {
                    this.handleEOD();
                    break;
                }
                if (n2 == 122) {
                    throw new IOException("Illegal 'z' within tuple");
                }
                l2 += (long)(n2 - 33) * POW85[n4];
                ++n4;
            }
            if ((n3 = n4) == 1) {
                throw new IOException("Only one character in tuple");
            }
            while (n4 < 5) {
                l2 += POW85[n4 - 1];
                ++n4;
            }
            if (l2 > 0xFFFFFFFFL) {
                throw new IOException("Illegal tuple (> 2^32 - 1)");
            }
            this.b[0] = (byte)(l2 >> 24 & 0xFFL);
            this.b[1] = (byte)(l2 >> 16 & 0xFFL);
            this.b[2] = (byte)(l2 >> 8 & 0xFFL);
            this.b[3] = (byte)(l2 & 0xFFL);
            this.bSize = n3 - 1;
            this.bIndex = 0;
        }
    }
}

