/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util.dijkstra;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.xmlgraphics.util.dijkstra.Edge;
import org.apache.xmlgraphics.util.dijkstra.EdgeDirectory;
import org.apache.xmlgraphics.util.dijkstra.Vertex;

public class DefaultEdgeDirectory
implements EdgeDirectory {
    private Map edges = new HashMap();

    public void addEdge(Edge edge) {
        HashMap<Vertex, Edge> hashMap = (HashMap<Vertex, Edge>)this.edges.get(edge.getStart());
        if (hashMap == null) {
            hashMap = new HashMap<Vertex, Edge>();
            this.edges.put(edge.getStart(), hashMap);
        }
        hashMap.put(edge.getEnd(), edge);
    }

    @Override
    public int getPenalty(Vertex vertex, Vertex vertex2) {
        Edge edge;
        Map map = (Map)this.edges.get(vertex);
        if (map != null && (edge = (Edge)map.get(vertex2)) != null) {
            int n2 = edge.getPenalty();
            if (n2 < 0) {
                throw new IllegalStateException("Penalty must not be negative");
            }
            return n2;
        }
        return 0;
    }

    @Override
    public Iterator getDestinations(Vertex vertex) {
        Map map = (Map)this.edges.get(vertex);
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            return iterator;
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getEdges(Vertex vertex) {
        Map map = (Map)this.edges.get(vertex);
        if (map != null) {
            Iterator iterator = map.values().iterator();
            return iterator;
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Edge getBestEdge(Vertex vertex, Vertex vertex2) {
        Edge edge = null;
        Iterator iterator = this.getEdges(vertex);
        while (iterator.hasNext()) {
            Edge edge2 = (Edge)iterator.next();
            if (!edge2.getEnd().equals(vertex2) || edge != null && edge2.getPenalty() >= edge.getPenalty()) continue;
            edge = edge2;
        }
        return edge;
    }
}

