/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public final class Service {
    static Map<String, List<String>> classMap = new HashMap<String, List<String>>();
    static Map<String, List<Object>> instanceMap = new HashMap<String, List<Object>>();

    private Service() {
    }

    public static synchronized Iterator<Object> providers(Class<?> clazz) {
        String string = Service.getServiceFilename(clazz);
        List<Object> list = instanceMap.get(string);
        if (list != null) {
            return list.iterator();
        }
        list = new ArrayList<Object>();
        instanceMap.put(string, list);
        ClassLoader classLoader = Service.getClassLoader(clazz);
        if (classLoader != null) {
            List<String> list2 = Service.getProviderNames(clazz, classLoader);
            for (String string2 : list2) {
                try {
                    Object obj = classLoader.loadClass(string2).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    list.add(obj);
                }
                catch (Exception exception) {}
            }
        }
        return list.iterator();
    }

    public static synchronized Iterator<String> providerNames(Class<?> clazz) {
        String string = Service.getServiceFilename(clazz);
        List<String> list = classMap.get(string);
        if (list != null) {
            return list.iterator();
        }
        list = new ArrayList<String>();
        classMap.put(string, list);
        list.addAll(Service.getProviderNames(clazz));
        return list.iterator();
    }

    public static Iterator<?> providers(Class<?> clazz, boolean bl2) {
        return bl2 ? Service.providers(clazz) : Service.providerNames(clazz);
    }

    private static List<String> getProviderNames(Class<?> clazz) {
        return Service.getProviderNames(clazz, Service.getClassLoader(clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getProviderNames(Class<?> clazz, ClassLoader classLoader) {
        Enumeration<URL> enumeration;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (classLoader == null) {
            return arrayList;
        }
        try {
            enumeration = classLoader.getResources(Service.getServiceFilename(clazz));
        }
        catch (IOException iOException) {
            return arrayList;
        }
        while (enumeration.hasMoreElements()) {
            try {
                URL uRL = enumeration.nextElement();
                InputStream inputStream = uRL.openStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                try {
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        int n2 = string.indexOf(35);
                        if (n2 != -1) {
                            string = string.substring(0, n2);
                        }
                        if ((string = string.trim()).length() != 0) {
                            arrayList.add(string);
                        }
                        string = bufferedReader.readLine();
                    }
                }
                finally {
                    IOUtils.closeQuietly(bufferedReader);
                    IOUtils.closeQuietly(inputStream);
                }
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    private static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader classLoader = null;
        try {
            classLoader = clazz.getClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (classLoader == null) {
            classLoader = Service.class.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    private static String getServiceFilename(Class<?> clazz) {
        return "META-INF/services/" + clazz.getName();
    }
}

