/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util;

import javax.imageio.metadata.IIOMetadata;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public final class ImageIODebugUtil {
    private ImageIODebugUtil() {
    }

    public static void dumpMetadata(IIOMetadata iIOMetadata, boolean bl2) {
        String string = bl2 ? iIOMetadata.getNativeMetadataFormatName() : "javax_imageio_1.0";
        Node node = iIOMetadata.getAsTree(string);
        ImageIODebugUtil.dumpNode(node);
    }

    public static void dumpNode(Node node) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource dOMSource = new DOMSource(node);
            StreamResult streamResult = new StreamResult(System.out);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
    }
}

